/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.common.audio;

import android.util.SparseArray;
import androidx.media3.common.audio.AudioMixingUtil;
import androidx.media3.common.audio.AudioProcessor;
import androidx.media3.common.audio.BaseAudioProcessor;
import androidx.media3.common.audio.ChannelMixingMatrix;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.UnstableApi;
import java.nio.ByteBuffer;

@UnstableApi
public final class ChannelMixingAudioProcessor
extends BaseAudioProcessor {
    private final SparseArray<ChannelMixingMatrix> matrixByInputChannelCount = new SparseArray();

    public void putChannelMixingMatrix(ChannelMixingMatrix matrix) {
        int inputChannelCount = matrix.getInputChannelCount();
        this.matrixByInputChannelCount.put(inputChannelCount, (Object)matrix);
    }

    @Override
    protected AudioProcessor.AudioFormat onConfigure(AudioProcessor.AudioFormat inputAudioFormat) throws AudioProcessor.UnhandledAudioFormatException {
        if (inputAudioFormat.encoding != 2) {
            throw new AudioProcessor.UnhandledAudioFormatException(inputAudioFormat);
        }
        ChannelMixingMatrix channelMixingMatrix = (ChannelMixingMatrix)this.matrixByInputChannelCount.get(inputAudioFormat.channelCount);
        if (channelMixingMatrix == null) {
            throw new AudioProcessor.UnhandledAudioFormatException("No mixing matrix for input channel count", inputAudioFormat);
        }
        if (channelMixingMatrix.isIdentity()) {
            return AudioProcessor.AudioFormat.NOT_SET;
        }
        return new AudioProcessor.AudioFormat(inputAudioFormat.sampleRate, channelMixingMatrix.getOutputChannelCount(), 2);
    }

    @Override
    public void queueInput(ByteBuffer inputBuffer) {
        ChannelMixingMatrix channelMixingMatrix = Assertions.checkStateNotNull((ChannelMixingMatrix)this.matrixByInputChannelCount.get(this.inputAudioFormat.channelCount));
        int framesToMix = inputBuffer.remaining() / this.inputAudioFormat.bytesPerFrame;
        ByteBuffer outputBuffer = this.replaceOutputBuffer(framesToMix * this.outputAudioFormat.bytesPerFrame);
        AudioMixingUtil.mix(inputBuffer, this.inputAudioFormat, outputBuffer, this.outputAudioFormat, channelMixingMatrix, framesToMix, false);
        outputBuffer.flip();
    }
}

