/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.common.audio;

import androidx.media3.common.audio.AudioProcessor;
import androidx.media3.common.audio.ChannelMixingMatrix;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.common.util.Util;
import java.nio.ByteBuffer;

@UnstableApi
public final class AudioMixingUtil {
    private static final float FLOAT_PCM_MIN_VALUE = -1.0f;
    private static final float FLOAT_PCM_MAX_VALUE = 1.0f;

    public static boolean canMix(AudioProcessor.AudioFormat audioFormat) {
        if (audioFormat.sampleRate == -1) {
            return false;
        }
        if (audioFormat.channelCount == -1) {
            return false;
        }
        return audioFormat.encoding == 2 || audioFormat.encoding == 4;
    }

    public static boolean canMix(AudioProcessor.AudioFormat inputAudioFormat, AudioProcessor.AudioFormat outputAudioFormat) {
        if (inputAudioFormat.sampleRate != outputAudioFormat.sampleRate) {
            return false;
        }
        if (!AudioMixingUtil.canMix(inputAudioFormat)) {
            return false;
        }
        return AudioMixingUtil.canMix(outputAudioFormat);
    }

    public static ByteBuffer mix(ByteBuffer inputBuffer, AudioProcessor.AudioFormat inputAudioFormat, ByteBuffer mixingBuffer, AudioProcessor.AudioFormat mixingAudioFormat, ChannelMixingMatrix matrix, int framesToMix, boolean accumulate) {
        boolean int16Input = inputAudioFormat.encoding == 2;
        boolean int16Output = mixingAudioFormat.encoding == 2;
        int inputChannels = matrix.getInputChannelCount();
        int outputChannels = matrix.getOutputChannelCount();
        float[] inputFrame = new float[inputChannels];
        float[] outputFrame = new float[outputChannels];
        for (int i = 0; i < framesToMix; ++i) {
            if (accumulate) {
                int position = mixingBuffer.position();
                for (int outputChannel = 0; outputChannel < outputChannels; ++outputChannel) {
                    outputFrame[outputChannel] = AudioMixingUtil.getPcmSample(mixingBuffer, int16Output, int16Output);
                }
                mixingBuffer.position(position);
            }
            for (int inputChannel = 0; inputChannel < inputChannels; ++inputChannel) {
                inputFrame[inputChannel] = AudioMixingUtil.getPcmSample(inputBuffer, int16Input, int16Output);
            }
            for (int outputChannel = 0; outputChannel < outputChannels; ++outputChannel) {
                for (int inputChannel = 0; inputChannel < inputChannels; ++inputChannel) {
                    int n = outputChannel;
                    outputFrame[n] = outputFrame[n] + inputFrame[inputChannel] * matrix.getMixingCoefficient(inputChannel, outputChannel);
                }
                if (int16Output) {
                    mixingBuffer.putShort((short)Util.constrainValue(outputFrame[outputChannel], -32768.0f, 32767.0f));
                } else {
                    mixingBuffer.putFloat(Util.constrainValue(outputFrame[outputChannel], -1.0f, 1.0f));
                }
                outputFrame[outputChannel] = 0.0f;
            }
        }
        return mixingBuffer;
    }

    private static float getPcmSample(ByteBuffer buffer, boolean int16Buffer, boolean int16Output) {
        if (int16Output) {
            return int16Buffer ? (float)buffer.getShort() : AudioMixingUtil.floatSampleToInt16Pcm(buffer.getFloat());
        }
        return int16Buffer ? AudioMixingUtil.int16SampleToFloatPcm(buffer.getShort()) : buffer.getFloat();
    }

    private static float floatSampleToInt16Pcm(float floatPcmValue) {
        return Util.constrainValue(floatPcmValue * (float)(floatPcmValue < 0.0f ? 32768 : Short.MAX_VALUE), -32768.0f, 32767.0f);
    }

    private static float int16SampleToFloatPcm(short shortPcmValue) {
        return (float)shortPcmValue / (float)(shortPcmValue < 0 ? 32768 : Short.MAX_VALUE);
    }

    private AudioMixingUtil() {
    }
}

