/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.common;

import android.net.Uri;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.media3.common.MimeTypes;
import androidx.media3.common.util.UnstableApi;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.List;
import java.util.Map;

@UnstableApi
public final class FileTypes {
    public static final int UNKNOWN = -1;
    public static final int AC3 = 0;
    public static final int AC4 = 1;
    public static final int ADTS = 2;
    public static final int AMR = 3;
    public static final int FLAC = 4;
    public static final int FLV = 5;
    public static final int MATROSKA = 6;
    public static final int MP3 = 7;
    public static final int MP4 = 8;
    public static final int OGG = 9;
    public static final int PS = 10;
    public static final int TS = 11;
    public static final int WAV = 12;
    public static final int WEBVTT = 13;
    public static final int JPEG = 14;
    public static final int MIDI = 15;
    public static final int AVI = 16;
    public static final int PNG = 17;
    public static final int WEBP = 18;
    public static final int BMP = 19;
    public static final int HEIF = 20;
    @VisibleForTesting
    static final String HEADER_CONTENT_TYPE = "Content-Type";
    private static final String EXTENSION_AC3 = ".ac3";
    private static final String EXTENSION_EC3 = ".ec3";
    private static final String EXTENSION_AC4 = ".ac4";
    private static final String EXTENSION_ADTS = ".adts";
    private static final String EXTENSION_AAC = ".aac";
    private static final String EXTENSION_AMR = ".amr";
    private static final String EXTENSION_FLAC = ".flac";
    private static final String EXTENSION_FLV = ".flv";
    private static final String EXTENSION_MID = ".mid";
    private static final String EXTENSION_MIDI = ".midi";
    private static final String EXTENSION_SMF = ".smf";
    private static final String EXTENSION_PREFIX_MK = ".mk";
    private static final String EXTENSION_WEBM = ".webm";
    private static final String EXTENSION_PREFIX_OG = ".og";
    private static final String EXTENSION_OPUS = ".opus";
    private static final String EXTENSION_MP3 = ".mp3";
    private static final String EXTENSION_MP4 = ".mp4";
    private static final String EXTENSION_PREFIX_M4 = ".m4";
    private static final String EXTENSION_PREFIX_MP4 = ".mp4";
    private static final String EXTENSION_PREFIX_CMF = ".cmf";
    private static final String EXTENSION_PS = ".ps";
    private static final String EXTENSION_MPEG = ".mpeg";
    private static final String EXTENSION_MPG = ".mpg";
    private static final String EXTENSION_M2P = ".m2p";
    private static final String EXTENSION_TS = ".ts";
    private static final String EXTENSION_PREFIX_TS = ".ts";
    private static final String EXTENSION_WAV = ".wav";
    private static final String EXTENSION_WAVE = ".wave";
    private static final String EXTENSION_VTT = ".vtt";
    private static final String EXTENSION_WEBVTT = ".webvtt";
    private static final String EXTENSION_JPG = ".jpg";
    private static final String EXTENSION_JPEG = ".jpeg";
    private static final String EXTENSION_AVI = ".avi";
    private static final String EXTENSION_PNG = ".png";
    private static final String EXTENSION_WEBP = ".webp";
    private static final String EXTENSION_BMP = ".bmp";
    private static final String EXTENSION_DIB = ".dib";
    private static final String EXTENSION_HEIC = ".heic";

    private FileTypes() {
    }

    public static int inferFileTypeFromResponseHeaders(Map<String, List<String>> responseHeaders) {
        List<String> contentTypes = responseHeaders.get(HEADER_CONTENT_TYPE);
        String mimeType = contentTypes == null || contentTypes.isEmpty() ? null : contentTypes.get(0);
        return FileTypes.inferFileTypeFromMimeType(mimeType);
    }

    public static int inferFileTypeFromMimeType(@Nullable String mimeType) {
        if (mimeType == null) {
            return -1;
        }
        switch (mimeType = MimeTypes.normalizeMimeType(mimeType)) {
            case "audio/ac3": 
            case "audio/eac3": 
            case "audio/eac3-joc": {
                return 0;
            }
            case "audio/ac4": {
                return 1;
            }
            case "audio/amr": 
            case "audio/3gpp": 
            case "audio/amr-wb": {
                return 3;
            }
            case "audio/flac": {
                return 4;
            }
            case "video/x-flv": {
                return 5;
            }
            case "audio/midi": {
                return 15;
            }
            case "video/x-matroska": 
            case "audio/x-matroska": 
            case "video/webm": 
            case "audio/webm": 
            case "application/webm": {
                return 6;
            }
            case "audio/mpeg": {
                return 7;
            }
            case "video/mp4": 
            case "audio/mp4": 
            case "application/mp4": {
                return 8;
            }
            case "audio/ogg": {
                return 9;
            }
            case "video/mp2p": {
                return 10;
            }
            case "video/mp2t": {
                return 11;
            }
            case "audio/wav": {
                return 12;
            }
            case "text/vtt": {
                return 13;
            }
            case "image/jpeg": {
                return 14;
            }
            case "video/x-msvideo": {
                return 16;
            }
            case "image/png": {
                return 17;
            }
            case "image/webp": {
                return 18;
            }
            case "image/bmp": {
                return 19;
            }
            case "image/heif": {
                return 20;
            }
        }
        return -1;
    }

    public static int inferFileTypeFromUri(Uri uri) {
        String filename = uri.getLastPathSegment();
        if (filename == null) {
            return -1;
        }
        if (filename.endsWith(EXTENSION_AC3) || filename.endsWith(EXTENSION_EC3)) {
            return 0;
        }
        if (filename.endsWith(EXTENSION_AC4)) {
            return 1;
        }
        if (filename.endsWith(EXTENSION_ADTS) || filename.endsWith(EXTENSION_AAC)) {
            return 2;
        }
        if (filename.endsWith(EXTENSION_AMR)) {
            return 3;
        }
        if (filename.endsWith(EXTENSION_FLAC)) {
            return 4;
        }
        if (filename.endsWith(EXTENSION_FLV)) {
            return 5;
        }
        if (filename.endsWith(EXTENSION_MID) || filename.endsWith(EXTENSION_MIDI) || filename.endsWith(EXTENSION_SMF)) {
            return 15;
        }
        if (filename.startsWith(EXTENSION_PREFIX_MK, filename.length() - (EXTENSION_PREFIX_MK.length() + 1)) || filename.endsWith(EXTENSION_WEBM)) {
            return 6;
        }
        if (filename.endsWith(EXTENSION_MP3)) {
            return 7;
        }
        if (filename.endsWith(".mp4") || filename.startsWith(EXTENSION_PREFIX_M4, filename.length() - (EXTENSION_PREFIX_M4.length() + 1)) || filename.startsWith(".mp4", filename.length() - (".mp4".length() + 1)) || filename.startsWith(EXTENSION_PREFIX_CMF, filename.length() - (EXTENSION_PREFIX_CMF.length() + 1))) {
            return 8;
        }
        if (filename.startsWith(EXTENSION_PREFIX_OG, filename.length() - (EXTENSION_PREFIX_OG.length() + 1)) || filename.endsWith(EXTENSION_OPUS)) {
            return 9;
        }
        if (filename.endsWith(EXTENSION_PS) || filename.endsWith(EXTENSION_MPEG) || filename.endsWith(EXTENSION_MPG) || filename.endsWith(EXTENSION_M2P)) {
            return 10;
        }
        if (filename.endsWith(".ts") || filename.startsWith(".ts", filename.length() - (".ts".length() + 1))) {
            return 11;
        }
        if (filename.endsWith(EXTENSION_WAV) || filename.endsWith(EXTENSION_WAVE)) {
            return 12;
        }
        if (filename.endsWith(EXTENSION_VTT) || filename.endsWith(EXTENSION_WEBVTT)) {
            return 13;
        }
        if (filename.endsWith(EXTENSION_JPG) || filename.endsWith(EXTENSION_JPEG)) {
            return 14;
        }
        if (filename.endsWith(EXTENSION_AVI)) {
            return 16;
        }
        if (filename.endsWith(EXTENSION_PNG)) {
            return 17;
        }
        if (filename.endsWith(EXTENSION_WEBP)) {
            return 18;
        }
        if (filename.endsWith(EXTENSION_BMP) || filename.endsWith(EXTENSION_DIB)) {
            return 19;
        }
        if (filename.endsWith(EXTENSION_HEIC)) {
            return 20;
        }
        return -1;
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.TYPE_USE})
    public static @interface Type {
    }
}

