/*
 * Decompiled with CFR 0.152.
 */
package androidx.lifecycle;

import android.os.Binder;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.Size;
import android.util.SizeF;
import android.util.SparseArray;
import androidx.annotation.MainThread;
import androidx.annotation.RestrictTo;
import androidx.core.os.BundleKt;
import androidx.lifecycle.MutableLiveData;
import androidx.savedstate.SavedStateRegistry;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\t\u0018\u0000 *2\u00020\u0001:\u0002*+B\u001d\b\u0016\u0012\u0014\u0010\u0002\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0003\u00a2\u0006\u0002\u0010\u0005B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0004H\u0007J\u0011\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0012\u001a\u00020\u0004H\u0087\u0002J\u001e\u0010\u0015\u001a\u0004\u0018\u0001H\u0016\"\u0004\b\u0000\u0010\u00162\u0006\u0010\u0012\u001a\u00020\u0004H\u0087\u0002\u00a2\u0006\u0002\u0010\u0017J\u001c\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H\u00160\u0019\"\u0004\b\u0000\u0010\u00162\u0006\u0010\u0012\u001a\u00020\u0004H\u0007J)\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H\u00160\u0019\"\u0004\b\u0000\u0010\u00162\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u0002H\u0016H\u0007\u00a2\u0006\u0002\u0010\u001bJ1\u0010\u001c\u001a\b\u0012\u0004\u0012\u0002H\u00160\u0019\"\u0004\b\u0000\u0010\u00162\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u0002H\u0016H\u0002\u00a2\u0006\u0002\u0010\u001eJ)\u0010\u001f\u001a\b\u0012\u0004\u0012\u0002H\u00160 \"\u0004\b\u0000\u0010\u00162\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u0002H\u0016H\u0007\u00a2\u0006\u0002\u0010!J\u000e\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00040#H\u0007J\u001d\u0010$\u001a\u0004\u0018\u0001H\u0016\"\u0004\b\u0000\u0010\u00162\u0006\u0010\u0012\u001a\u00020\u0004H\u0007\u00a2\u0006\u0002\u0010\u0017J\b\u0010\r\u001a\u00020\u000eH\u0007J&\u0010%\u001a\u00020\u0011\"\u0004\b\u0000\u0010\u00162\u0006\u0010\u0012\u001a\u00020\u00042\b\u0010&\u001a\u0004\u0018\u0001H\u0016H\u0087\u0002\u00a2\u0006\u0002\u0010'J\u0018\u0010(\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010)\u001a\u00020\u000eH\u0007R\"\u0010\u0007\u001a\u0016\u0012\u0004\u0012\u00020\u0004\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\n\u001a\u0012\u0012\u0004\u0012\u00020\u0004\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\f\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u000e0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Landroidx/lifecycle/SavedStateHandle;", "", "initialState", "", "", "(Ljava/util/Map;)V", "()V", "flows", "", "Lkotlinx/coroutines/flow/MutableStateFlow;", "liveDatas", "Landroidx/lifecycle/SavedStateHandle$SavingStateLiveData;", "regular", "savedStateProvider", "Landroidx/savedstate/SavedStateRegistry$SavedStateProvider;", "savedStateProviders", "clearSavedStateProvider", "", "key", "contains", "", "get", "T", "(Ljava/lang/String;)Ljava/lang/Object;", "getLiveData", "Landroidx/lifecycle/MutableLiveData;", "initialValue", "(Ljava/lang/String;Ljava/lang/Object;)Landroidx/lifecycle/MutableLiveData;", "getLiveDataInternal", "hasInitialValue", "(Ljava/lang/String;ZLjava/lang/Object;)Landroidx/lifecycle/MutableLiveData;", "getStateFlow", "Lkotlinx/coroutines/flow/StateFlow;", "(Ljava/lang/String;Ljava/lang/Object;)Lkotlinx/coroutines/flow/StateFlow;", "keys", "", "remove", "set", "value", "(Ljava/lang/String;Ljava/lang/Object;)V", "setSavedStateProvider", "provider", "Companion", "SavingStateLiveData", "lifecycle-viewmodel-savedstate_release"})
@SourceDebugExtension(value={"SMAP\nSavedStateHandle.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SavedStateHandle.kt\nandroidx/lifecycle/SavedStateHandle\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,447:1\n361#2,3:448\n364#2,4:452\n1#3:451\n*S KotlinDebug\n*F\n+ 1 SavedStateHandle.kt\nandroidx/lifecycle/SavedStateHandle\n*L\n198#1:448,3\n198#1:452,4\n*E\n"})
public final class SavedStateHandle {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<String, Object> regular;
    @NotNull
    private final Map<String, SavedStateRegistry.SavedStateProvider> savedStateProviders;
    @NotNull
    private final Map<String, SavingStateLiveData<?>> liveDatas;
    @NotNull
    private final Map<String, MutableStateFlow<Object>> flows;
    @NotNull
    private final SavedStateRegistry.SavedStateProvider savedStateProvider;
    @NotNull
    private static final String VALUES = "values";
    @NotNull
    private static final String KEYS = "keys";
    @NotNull
    private static final Class<? extends Object>[] ACCEPTABLE_CLASSES;

    public SavedStateHandle(@NotNull Map<String, ? extends Object> initialState) {
        Intrinsics.checkNotNullParameter(initialState, (String)"initialState");
        this.regular = new LinkedHashMap();
        this.savedStateProviders = new LinkedHashMap();
        this.liveDatas = new LinkedHashMap();
        this.flows = new LinkedHashMap();
        this.savedStateProvider = () -> SavedStateHandle.savedStateProvider$lambda$0(this);
        this.regular.putAll(initialState);
    }

    public SavedStateHandle() {
        this.regular = new LinkedHashMap();
        this.savedStateProviders = new LinkedHashMap();
        this.liveDatas = new LinkedHashMap();
        this.flows = new LinkedHashMap();
        this.savedStateProvider = () -> SavedStateHandle.savedStateProvider$lambda$0(this);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NotNull
    public final SavedStateRegistry.SavedStateProvider savedStateProvider() {
        return this.savedStateProvider;
    }

    @MainThread
    public final boolean contains(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.regular.containsKey(key);
    }

    @MainThread
    @NotNull
    public final <T> MutableLiveData<T> getLiveData(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        MutableLiveData<Object> mutableLiveData = this.getLiveDataInternal(key, false, null);
        Intrinsics.checkNotNull(mutableLiveData, (String)"null cannot be cast to non-null type androidx.lifecycle.MutableLiveData<T of androidx.lifecycle.SavedStateHandle.getLiveData>");
        return mutableLiveData;
    }

    @MainThread
    @NotNull
    public final <T> MutableLiveData<T> getLiveData(@NotNull String key, T initialValue) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.getLiveDataInternal(key, true, initialValue);
    }

    private final <T> MutableLiveData<T> getLiveDataInternal(String key, boolean hasInitialValue, T initialValue) {
        SavingStateLiveData<T> savingStateLiveData;
        MutableLiveData liveData;
        SavingStateLiveData<?> savingStateLiveData2 = this.liveDatas.get(key);
        MutableLiveData mutableLiveData = liveData = savingStateLiveData2 instanceof MutableLiveData ? (MutableLiveData)savingStateLiveData2 : null;
        if (liveData != null) {
            return liveData;
        }
        if (this.regular.containsKey(key)) {
            savingStateLiveData = new SavingStateLiveData<T>(this, key, this.regular.get(key));
        } else if (hasInitialValue) {
            this.regular.put(key, initialValue);
            savingStateLiveData = new SavingStateLiveData<T>(this, key, initialValue);
        } else {
            savingStateLiveData = new SavingStateLiveData(this, key);
        }
        SavingStateLiveData<T> mutableLd = savingStateLiveData;
        this.liveDatas.put(key, mutableLd);
        return mutableLd;
    }

    @MainThread
    @NotNull
    public final <T> StateFlow<T> getStateFlow(@NotNull String key, T initialValue) {
        MutableStateFlow mutableStateFlow;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Map<String, MutableStateFlow<Object>> $this$getOrPut$iv = this.flows;
        boolean $i$f$getOrPut = false;
        MutableStateFlow value$iv = $this$getOrPut$iv.get(key);
        if (value$iv == null) {
            MutableStateFlow mutableStateFlow2;
            boolean bl = false;
            if (!this.regular.containsKey(key)) {
                this.regular.put(key, initialValue);
            }
            MutableStateFlow $this$getStateFlow_u24lambda_u242_u24lambda_u241 = mutableStateFlow2 = StateFlowKt.MutableStateFlow((Object)this.regular.get(key));
            boolean bl2 = false;
            this.flows.put(key, (MutableStateFlow<Object>)$this$getStateFlow_u24lambda_u242_u24lambda_u241);
            MutableStateFlow answer$iv = mutableStateFlow2;
            $this$getOrPut$iv.put(key, (MutableStateFlow<Object>)answer$iv);
            mutableStateFlow = answer$iv;
        } else {
            mutableStateFlow = value$iv;
        }
        StateFlow stateFlow = FlowKt.asStateFlow(mutableStateFlow);
        Intrinsics.checkNotNull((Object)stateFlow, (String)"null cannot be cast to non-null type kotlinx.coroutines.flow.StateFlow<T of androidx.lifecycle.SavedStateHandle.getStateFlow>");
        return stateFlow;
    }

    @MainThread
    @NotNull
    public final Set<String> keys() {
        return SetsKt.plus((Set)SetsKt.plus(this.regular.keySet(), (Iterable)this.savedStateProviders.keySet()), (Iterable)this.liveDatas.keySet());
    }

    @MainThread
    @Nullable
    public final <T> T get(@NotNull String key) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        try {
            object = this.regular.get(key);
        }
        catch (ClassCastException e) {
            this.remove(key);
            object = null;
        }
        return (T)object;
    }

    @MainThread
    public final <T> void set(@NotNull String key, @Nullable T value) {
        MutableLiveData mutableLiveData;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        if (!Companion.validateValue(value)) {
            StringBuilder stringBuilder = new StringBuilder().append("Can't put value with type ");
            T t = value;
            Intrinsics.checkNotNull(t);
            throw new IllegalArgumentException(stringBuilder.append(t.getClass()).append(" into saved state").toString());
        }
        SavingStateLiveData<?> savingStateLiveData = this.liveDatas.get(key);
        MutableLiveData mutableLiveData2 = mutableLiveData = savingStateLiveData instanceof MutableLiveData ? (MutableLiveData)savingStateLiveData : null;
        if (mutableLiveData != null) {
            mutableLiveData.setValue(value);
        } else {
            this.regular.put(key, value);
        }
        MutableStateFlow<Object> mutableStateFlow = this.flows.get(key);
        if (mutableStateFlow != null) {
            mutableStateFlow.setValue(value);
        }
    }

    @MainThread
    @Nullable
    public final <T> T remove(@NotNull String key) {
        SavingStateLiveData<?> liveData;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Object latestValue = this.regular.remove(key);
        SavingStateLiveData<?> savingStateLiveData = liveData = this.liveDatas.remove(key);
        if (savingStateLiveData != null) {
            savingStateLiveData.detach();
        }
        this.flows.remove(key);
        return (T)latestValue;
    }

    @MainThread
    public final void setSavedStateProvider(@NotNull String key, @NotNull SavedStateRegistry.SavedStateProvider provider) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        this.savedStateProviders.put(key, provider);
    }

    @MainThread
    public final void clearSavedStateProvider(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.savedStateProviders.remove(key);
    }

    private static final Bundle savedStateProvider$lambda$0(SavedStateHandle this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Map map = MapsKt.toMap(this$0.savedStateProviders);
        for (Map.Entry entry : map.entrySet()) {
            String key = (String)entry.getKey();
            SavedStateRegistry.SavedStateProvider value = (SavedStateRegistry.SavedStateProvider)entry.getValue();
            Bundle savedState = value.saveState();
            this$0.set(key, savedState);
        }
        Set<String> keySet = this$0.regular.keySet();
        ArrayList<String> keys = new ArrayList<String>(keySet.size());
        ArrayList<Object> value = new ArrayList<Object>(keys.size());
        for (String key : keySet) {
            keys.add(key);
            value.add(this$0.regular.get(key));
        }
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)KEYS, keys), TuplesKt.to((Object)VALUES, value)};
        return BundleKt.bundleOf((Pair[])pairArray);
    }

    @JvmStatic
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NotNull
    public static final SavedStateHandle createHandle(@Nullable Bundle restoredState, @Nullable Bundle defaultState) {
        return Companion.createHandle(restoredState, defaultState);
    }

    static {
        Class[] classArray = new Class[]{Boolean.TYPE, boolean[].class, Double.TYPE, double[].class, Integer.TYPE, int[].class, Long.TYPE, long[].class, String.class, String[].class, Binder.class, Bundle.class, Byte.TYPE, byte[].class, Character.TYPE, char[].class, CharSequence.class, CharSequence[].class, ArrayList.class, Float.TYPE, float[].class, Parcelable.class, Parcelable[].class, Serializable.class, Short.TYPE, short[].class, SparseArray.class, Build.VERSION.SDK_INT >= 21 ? Size.class : Integer.TYPE, Build.VERSION.SDK_INT >= 21 ? SizeF.class : Integer.TYPE};
        ACCEPTABLE_CLASSES = classArray;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\rH\u0007J\u0012\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u0007R \u0010\u0003\u001a\u0012\u0012\u000e\u0012\f\u0012\u0006\b\u0001\u0012\u00020\u0001\u0018\u00010\u00050\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Landroidx/lifecycle/SavedStateHandle$Companion;", "", "()V", "ACCEPTABLE_CLASSES", "", "Ljava/lang/Class;", "[Ljava/lang/Class;", "KEYS", "", "VALUES", "createHandle", "Landroidx/lifecycle/SavedStateHandle;", "restoredState", "Landroid/os/Bundle;", "defaultState", "validateValue", "", "value", "lifecycle-viewmodel-savedstate_release"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NotNull
        public final SavedStateHandle createHandle(@Nullable Bundle restoredState, @Nullable Bundle defaultState) {
            if (restoredState == null) {
                SavedStateHandle savedStateHandle;
                if (defaultState == null) {
                    savedStateHandle = new SavedStateHandle();
                } else {
                    Map state = new HashMap();
                    for (String key : defaultState.keySet()) {
                        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"key");
                        state.put(key, defaultState.get(key));
                    }
                    savedStateHandle = new SavedStateHandle(state);
                }
                return savedStateHandle;
            }
            ArrayList keys = restoredState.getParcelableArrayList(SavedStateHandle.KEYS);
            ArrayList values = restoredState.getParcelableArrayList(SavedStateHandle.VALUES);
            if (!(keys != null && values != null && keys.size() == values.size())) {
                boolean $i$a$-check-SavedStateHandle$Companion$createHandle$22 = false;
                String $i$a$-check-SavedStateHandle$Companion$createHandle$22 = "Invalid bundle passed as restored state";
                throw new IllegalStateException($i$a$-check-SavedStateHandle$Companion$createHandle$22.toString());
            }
            Map state = new LinkedHashMap();
            int n = keys.size();
            for (int i = 0; i < n; ++i) {
                Map map = state;
                Object e = keys.get(i);
                Intrinsics.checkNotNull(e, (String)"null cannot be cast to non-null type kotlin.String");
                String string = (String)e;
                Object e2 = values.get(i);
                map.put(string, e2);
            }
            return new SavedStateHandle(state);
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public final boolean validateValue(@Nullable Object value) {
            if (value == null) {
                return true;
            }
            Class[] classArray = ACCEPTABLE_CLASSES;
            int n = classArray.length;
            for (int i = 0; i < n; ++i) {
                Class cl;
                Class clazz = cl = classArray[i];
                Intrinsics.checkNotNull((Object)clazz);
                if (!clazz.isInstance(value)) continue;
                return true;
            }
            return false;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B!\b\u0016\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\bB\u0019\b\u0016\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\tJ\u0006\u0010\n\u001a\u00020\u000bJ\u0015\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\rR\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Landroidx/lifecycle/SavedStateHandle$SavingStateLiveData;", "T", "Landroidx/lifecycle/MutableLiveData;", "handle", "Landroidx/lifecycle/SavedStateHandle;", "key", "", "value", "(Landroidx/lifecycle/SavedStateHandle;Ljava/lang/String;Ljava/lang/Object;)V", "(Landroidx/lifecycle/SavedStateHandle;Ljava/lang/String;)V", "detach", "", "setValue", "(Ljava/lang/Object;)V", "lifecycle-viewmodel-savedstate_release"})
    public static final class SavingStateLiveData<T>
    extends MutableLiveData<T> {
        @NotNull
        private String key;
        @Nullable
        private SavedStateHandle handle;

        public SavingStateLiveData(@Nullable SavedStateHandle handle, @NotNull String key, T value) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            super(value);
            this.key = key;
            this.handle = handle;
        }

        public SavingStateLiveData(@Nullable SavedStateHandle handle, @NotNull String key) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            this.key = key;
            this.handle = handle;
        }

        public void setValue(T value) {
            SavedStateHandle savedStateHandle = this.handle;
            if (savedStateHandle != null) {
                SavedStateHandle it = savedStateHandle;
                boolean bl = false;
                it.regular.put(this.key, value);
                MutableStateFlow mutableStateFlow = (MutableStateFlow)it.flows.get(this.key);
                if (mutableStateFlow != null) {
                    mutableStateFlow.setValue(value);
                }
            }
            super.setValue(value);
        }

        public final void detach() {
            this.handle = null;
        }
    }
}

