/*
 * Decompiled with CFR 0.152.
 */
package androidx.lifecycle;

import android.app.Activity;
import android.app.Application;
import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import androidx.lifecycle.AbstractSavedStateVMFactory;
import androidx.lifecycle.AndroidViewModel;
import androidx.lifecycle.SavedStateHandle;
import androidx.lifecycle.ViewModel;
import androidx.lifecycle.ViewModelProvider;
import androidx.savedstate.SavedStateRegistryOwner;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;

public final class SavedStateVMFactory
extends AbstractSavedStateVMFactory {
    private final Application mApplication;
    private final ViewModelProvider.AndroidViewModelFactory mFactory;
    private static final Class<?>[] ANDROID_VIEWMODEL_SIGNATURE = new Class[]{Application.class, SavedStateHandle.class};
    private static final Class<?>[] VIEWMODEL_SIGNATURE = new Class[]{SavedStateHandle.class};

    public SavedStateVMFactory(@NonNull Fragment fragment) {
        this(fragment, null);
    }

    public SavedStateVMFactory(@NonNull Fragment fragment, @Nullable Bundle defaultArgs) {
        this(SavedStateVMFactory.checkApplication(SavedStateVMFactory.checkActivity(fragment)), (SavedStateRegistryOwner)fragment, defaultArgs);
    }

    public SavedStateVMFactory(@NonNull FragmentActivity activity) {
        this(activity, null);
    }

    public SavedStateVMFactory(@NonNull FragmentActivity activity, @Nullable Bundle defaultArgs) {
        this(SavedStateVMFactory.checkApplication((Activity)activity), (SavedStateRegistryOwner)activity, defaultArgs);
    }

    public SavedStateVMFactory(@NonNull Application application, @NonNull SavedStateRegistryOwner owner, @Nullable Bundle defaultArgs) {
        super(owner, defaultArgs);
        this.mApplication = application;
        this.mFactory = ViewModelProvider.AndroidViewModelFactory.getInstance((Application)application);
    }

    @Override
    @NonNull
    protected <T extends ViewModel> T create(@NonNull String key, @NonNull Class<T> modelClass, @NonNull SavedStateHandle handle) {
        boolean isAndroidViewModel = AndroidViewModel.class.isAssignableFrom(modelClass);
        Constructor<T> constructor = isAndroidViewModel ? SavedStateVMFactory.findMatchingConstructor(modelClass, ANDROID_VIEWMODEL_SIGNATURE) : SavedStateVMFactory.findMatchingConstructor(modelClass, VIEWMODEL_SIGNATURE);
        if (constructor == null) {
            return (T)this.mFactory.create(modelClass);
        }
        try {
            if (isAndroidViewModel) {
                return (T)((ViewModel)constructor.newInstance(this.mApplication, handle));
            }
            return (T)((ViewModel)constructor.newInstance(handle));
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Failed to access " + modelClass, e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException("A " + modelClass + " cannot be instantiated.", e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("An exception happened in constructor of " + modelClass, e.getCause());
        }
    }

    private static <T> Constructor<T> findMatchingConstructor(Class<T> modelClass, Class<?>[] signature) {
        for (Constructor<?> constructor : modelClass.getConstructors()) {
            Object[] parameterTypes = constructor.getParameterTypes();
            if (!Arrays.equals(signature, parameterTypes)) continue;
            return constructor;
        }
        return null;
    }

    private static Application checkApplication(Activity activity) {
        Application application = activity.getApplication();
        if (application == null) {
            throw new IllegalStateException("Your activity/fragment is not yet attached to Application. You can't request ViewModelsWithStateFactory before onCreate call.");
        }
        return application;
    }

    private static Activity checkActivity(Fragment fragment) {
        FragmentActivity activity = fragment.getActivity();
        if (activity == null) {
            throw new IllegalStateException("Can't create ViewModelsWithStateFactory for detached fragment");
        }
        return activity;
    }
}

