/*
 * Decompiled with CFR 0.152.
 */
package androidx.lifecycle.lint;

import androidx.lifecycle.lint.LifecycleWhenChecksKt;
import androidx.lifecycle.lint.LifecycleWhenVisitor;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.psi.PsiMethod;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.ULambdaExpression;
import org.jetbrains.uast.visitor.UastVisitor;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u00012\u00020\u0002:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u0010"}, d2={"Landroidx/lifecycle/lint/LifecycleWhenChecks;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "getApplicableMethodNames", "", "", "visitMethodCall", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "node", "Lorg/jetbrains/uast/UCallExpression;", "method", "Lcom/intellij/psi/PsiMethod;", "Companion", "lifecycle-runtime-ktx-lint"})
public final class LifecycleWhenChecks
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Issue ISSUE;

    @NotNull
    public List<String> getApplicableMethodNames() {
        return LifecycleWhenChecksKt.access$getLIFECYCLE_WHEN_APPLICABLE_METHOD_NAMES$p();
    }

    public void visitMethodCall(@NotNull JavaContext context, @NotNull UCallExpression node, @NotNull PsiMethod method) {
        block1: {
            ULambdaExpression uLambdaExpression;
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)method, (String)"method");
            List valueArguments = node.getValueArguments();
            if (valueArguments.size() != 1 || !LifecycleWhenChecksKt.access$isLifecycleWhenExtension(method, context)) {
                return;
            }
            Object object = valueArguments.get(0);
            ULambdaExpression uLambdaExpression2 = uLambdaExpression = object instanceof ULambdaExpression ? (ULambdaExpression)object : null;
            if (uLambdaExpression == null || (object = uLambdaExpression.getBody()) == null) break block1;
            String string = method.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"method.name");
            object.accept((UastVisitor)new LifecycleWhenVisitor(context, string));
        }
    }

    static {
        Issue.Companion companion = Issue.Companion;
        Category category = Category.CORRECTNESS;
        Severity severity = Severity.ERROR;
        Implementation implementation = new Implementation(LifecycleWhenChecks.class, Scope.JAVA_FILE_SCOPE);
        ISSUE = Issue.Companion.create$default((Issue.Companion)companion, (String)"UnsafeLifecycleWhenUsage", (String)"Unsafe UI operation in finally/catch of Lifecycle.whenStarted of similar method", (String)"If the `Lifecycle` is destroyed within the block of \\\n                    `Lifecycle.whenStarted` or any similar `Lifecycle.when` method is suspended, \\\n                    the block will be cancelled, which will also cancel any child coroutine \\\n                    launched inside the block. As as a result, If you have a try finally block \\\n                    in your code, the finally might run after the Lifecycle moves outside \\\n                    the desired state. It is recommended to check the `Lifecycle.isAtLeast` \\\n                    before accessing UI in finally block. Similarly, \\\n                    if you have a catch statement that might catch `CancellationException`, \\\n                    you should check the `Lifecycle.isAtLeast` before accessing the UI. See \\\n                    documentation of `Lifecycle.whenStateAtLeast` for more details", (Implementation)implementation, null, (Category)category, (int)0, (Severity)severity, (boolean)false, (Boolean)true, null, null, (int)3408, null);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Landroidx/lifecycle/lint/LifecycleWhenChecks$Companion;", "", "()V", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "getISSUE", "()Lcom/android/tools/lint/detector/api/Issue;", "lifecycle-runtime-ktx-lint"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Issue getISSUE() {
            return ISSUE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

