/*
 * Decompiled with CFR 0.152.
 */
package androidx.lifecycle.lint;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.visitor.UastVisitor;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Landroidx/lifecycle/lint/RecursiveVisitHelper;", "", "()V", "depth", "", "maxInspectionDepth", "visitedMethods", "", "Lorg/jetbrains/uast/UMethod;", "visitIfNeeded", "", "psiMethod", "Lcom/intellij/psi/PsiMethod;", "visitor", "Lorg/jetbrains/uast/visitor/UastVisitor;", "lifecycle-runtime-ktx-lint"})
public final class RecursiveVisitHelper {
    private final int maxInspectionDepth;
    private final Set<UMethod> visitedMethods;
    private int depth;

    public final void visitIfNeeded(@Nullable PsiMethod psiMethod, @NotNull UastVisitor visitor) {
        UMethod method;
        Intrinsics.checkNotNullParameter((Object)visitor, (String)"visitor");
        PsiMethod psiMethod2 = psiMethod;
        Object object = psiMethod2 != null ? UastContextKt.toUElement((PsiElement)((PsiElement)psiMethod2)) : null;
        if (!(object instanceof UMethod)) {
            object = null;
        }
        if ((method = (UMethod)object) != null && !this.visitedMethods.contains(method)) {
            this.visitedMethods.add(method);
            if (this.depth < this.maxInspectionDepth) {
                int n = this.depth;
                this.depth = n + 1;
                UExpression uExpression = method.getUastBody();
                if (uExpression != null) {
                    uExpression.accept(visitor);
                }
                n = this.depth;
                this.depth = n + -1;
            }
        }
    }

    public RecursiveVisitHelper() {
        this.maxInspectionDepth = 3;
        boolean bl = false;
        this.visitedMethods = new LinkedHashSet();
    }
}

