/*
 * Decompiled with CFR 0.152.
 */
package androidx.lifecycle;

import androidx.annotation.CallSuper;
import androidx.annotation.MainThread;
import androidx.arch.core.internal.SafeIterableMap;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.MutableLiveData;
import androidx.lifecycle.Observer;
import java.util.Map;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class MediatorLiveData<T>
extends MutableLiveData<T> {
    private SafeIterableMap<LiveData<?>, Source<?>> mSources = new SafeIterableMap();

    public MediatorLiveData() {
    }

    public MediatorLiveData(T value) {
        super(value);
    }

    @MainThread
    public <S> void addSource(@NonNull LiveData<S> source, @NonNull Observer<? super S> onChanged2) {
        if (source == null) {
            throw new NullPointerException("source cannot be null");
        }
        Source<S> e = new Source<S>(source, onChanged2);
        Source existing = (Source)this.mSources.putIfAbsent(source, e);
        if (existing != null && existing.mObserver != onChanged2) {
            throw new IllegalArgumentException("This source was already added with the different observer");
        }
        if (existing != null) {
            return;
        }
        if (this.hasActiveObservers()) {
            e.plug();
        }
    }

    @MainThread
    public <S> void removeSource(@NonNull LiveData<S> toRemote) {
        Source source = (Source)this.mSources.remove(toRemote);
        if (source != null) {
            source.unplug();
        }
    }

    @CallSuper
    protected void onActive() {
        for (Map.Entry source : this.mSources) {
            ((Source)source.getValue()).plug();
        }
    }

    @CallSuper
    protected void onInactive() {
        for (Map.Entry source : this.mSources) {
            ((Source)source.getValue()).unplug();
        }
    }

    private static class Source<V>
    implements Observer<V> {
        final LiveData<V> mLiveData;
        final Observer<? super V> mObserver;
        int mVersion = -1;

        Source(LiveData<V> liveData, Observer<? super V> observer) {
            this.mLiveData = liveData;
            this.mObserver = observer;
        }

        void plug() {
            this.mLiveData.observeForever((Observer)this);
        }

        void unplug() {
            this.mLiveData.removeObserver((Observer)this);
        }

        public void onChanged(@Nullable V v) {
            if (this.mVersion != this.mLiveData.getVersion()) {
                this.mVersion = this.mLiveData.getVersion();
                this.mObserver.onChanged(v);
            }
        }
    }
}

