/*
 * Decompiled with CFR 0.152.
 */
package androidx.lifecycle;

import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import androidx.arch.core.executor.ArchTaskExecutor;
import androidx.lifecycle.LiveData;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\b'\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u0011\b\u0007\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\r\u0010\u0019\u001a\u00028\u0000H%\u00a2\u0006\u0002\u0010\u001aJ\b\u0010\u001b\u001a\u00020\u001cH\u0016R\u0016\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\tX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000bR\u0016\u0010\u0010\u001a\u00020\u00118\u0000X\u0081\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0012\u0010\u0013R\u001c\u0010\u0014\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0016\u0010\u0017\u001a\u00020\u00118\u0000X\u0081\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0018\u0010\u0013\u00a8\u0006\u001d"}, d2={"Landroidx/lifecycle/ComputableLiveData;", "T", "", "executor", "Ljava/util/concurrent/Executor;", "(Ljava/util/concurrent/Executor;)V", "_liveData", "Landroidx/lifecycle/LiveData;", "computing", "Ljava/util/concurrent/atomic/AtomicBoolean;", "getComputing$lifecycle_livedata_release", "()Ljava/util/concurrent/atomic/AtomicBoolean;", "getExecutor$lifecycle_livedata_release", "()Ljava/util/concurrent/Executor;", "invalid", "getInvalid$lifecycle_livedata_release", "invalidationRunnable", "Ljava/lang/Runnable;", "getInvalidationRunnable$lifecycle_livedata_release$annotations", "()V", "liveData", "getLiveData", "()Landroidx/lifecycle/LiveData;", "refreshRunnable", "getRefreshRunnable$lifecycle_livedata_release$annotations", "compute", "()Ljava/lang/Object;", "invalidate", "", "lifecycle-livedata_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
public abstract class ComputableLiveData<T> {
    @NotNull
    private final Executor executor;
    @NotNull
    private final LiveData<T> _liveData;
    @NotNull
    private final LiveData<T> liveData;
    @NotNull
    private final AtomicBoolean invalid;
    @NotNull
    private final AtomicBoolean computing;
    @JvmField
    @NotNull
    public final Runnable refreshRunnable;
    @JvmField
    @NotNull
    public final Runnable invalidationRunnable;

    @JvmOverloads
    public ComputableLiveData(@NotNull Executor executor) {
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        this.executor = executor;
        this._liveData = new LiveData<T>(this){
            final /* synthetic */ ComputableLiveData<T> this$0;
            {
                this.this$0 = $receiver;
            }

            protected void onActive() {
                this.this$0.getExecutor$lifecycle_livedata_release().execute(this.this$0.refreshRunnable);
            }
        };
        this.liveData = this._liveData;
        this.invalid = new AtomicBoolean(true);
        this.computing = new AtomicBoolean(false);
        this.refreshRunnable = () -> ComputableLiveData.refreshRunnable$lambda$0(this);
        this.invalidationRunnable = () -> ComputableLiveData.invalidationRunnable$lambda$1(this);
    }

    public /* synthetic */ ComputableLiveData(Executor executor, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            Executor executor2 = ArchTaskExecutor.getIOThreadExecutor();
            Intrinsics.checkNotNullExpressionValue((Object)executor2, (String)"getIOThreadExecutor()");
            executor = executor2;
        }
        this(executor);
    }

    @NotNull
    public final Executor getExecutor$lifecycle_livedata_release() {
        return this.executor;
    }

    @NotNull
    public LiveData<T> getLiveData() {
        return this.liveData;
    }

    @NotNull
    public final AtomicBoolean getInvalid$lifecycle_livedata_release() {
        return this.invalid;
    }

    @NotNull
    public final AtomicBoolean getComputing$lifecycle_livedata_release() {
        return this.computing;
    }

    @VisibleForTesting
    public static /* synthetic */ void getRefreshRunnable$lifecycle_livedata_release$annotations() {
    }

    @VisibleForTesting
    public static /* synthetic */ void getInvalidationRunnable$lifecycle_livedata_release$annotations() {
    }

    public void invalidate() {
        ArchTaskExecutor.getInstance().executeOnMainThread(this.invalidationRunnable);
    }

    @WorkerThread
    protected abstract T compute();

    @JvmOverloads
    public ComputableLiveData() {
        this(null, 1, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void refreshRunnable$lambda$0(ComputableLiveData this$0) {
        boolean computed = false;
        do {
            computed = false;
            if (!this$0.computing.compareAndSet(false, true)) continue;
            try {
                Object value = null;
                while (this$0.invalid.compareAndSet(true, false)) {
                    computed = true;
                    value = this$0.compute();
                }
                if (!computed) continue;
                this$0.getLiveData().postValue(value);
            }
            finally {
                this$0.computing.set(false);
            }
        } while (computed && this$0.invalid.get());
    }

    private static final void invalidationRunnable$lambda$1(ComputableLiveData this$0) {
        boolean isActive = this$0.getLiveData().hasActiveObservers();
        if (this$0.invalid.compareAndSet(false, true) && isActive) {
            this$0.executor.execute(this$0.refreshRunnable);
        }
    }
}

