/*
 * Decompiled with CFR 0.152.
 */
package androidx.lifecycle;

import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import androidx.arch.core.executor.ArchTaskExecutor;
import androidx.lifecycle.LiveData;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
public abstract class ComputableLiveData<T> {
    final Executor mExecutor;
    final LiveData<T> mLiveData;
    final AtomicBoolean mInvalid = new AtomicBoolean(true);
    final AtomicBoolean mComputing = new AtomicBoolean(false);
    @VisibleForTesting
    final Runnable mRefreshRunnable = new Runnable(){

        @Override
        @WorkerThread
        public void run() {
            boolean computed;
            do {
                computed = false;
                if (!ComputableLiveData.this.mComputing.compareAndSet(false, true)) continue;
                try {
                    Object value = null;
                    while (ComputableLiveData.this.mInvalid.compareAndSet(true, false)) {
                        computed = true;
                        value = ComputableLiveData.this.compute();
                    }
                    if (!computed) continue;
                    ComputableLiveData.this.mLiveData.postValue(value);
                }
                finally {
                    ComputableLiveData.this.mComputing.set(false);
                }
            } while (computed && ComputableLiveData.this.mInvalid.get());
        }
    };
    @VisibleForTesting
    final Runnable mInvalidationRunnable = new Runnable(){

        @Override
        @MainThread
        public void run() {
            boolean isActive = ComputableLiveData.this.mLiveData.hasActiveObservers();
            if (ComputableLiveData.this.mInvalid.compareAndSet(false, true) && isActive) {
                ComputableLiveData.this.mExecutor.execute(ComputableLiveData.this.mRefreshRunnable);
            }
        }
    };

    public ComputableLiveData() {
        this(ArchTaskExecutor.getIOThreadExecutor());
    }

    public ComputableLiveData(@NonNull Executor executor) {
        this.mExecutor = executor;
        this.mLiveData = new LiveData<T>(){

            protected void onActive() {
                ComputableLiveData.this.mExecutor.execute(ComputableLiveData.this.mRefreshRunnable);
            }
        };
    }

    @NonNull
    public LiveData<T> getLiveData() {
        return this.mLiveData;
    }

    public void invalidate() {
        ArchTaskExecutor.getInstance().executeOnMainThread(this.mInvalidationRunnable);
    }

    @WorkerThread
    protected abstract T compute();
}

