/*
 * Decompiled with CFR 0.152.
 */
package androidx.lifecycle;

import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.arch.core.util.Function;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.MediatorLiveData;
import androidx.lifecycle.Observer;

public class Transformations {
    private Transformations() {
    }

    @MainThread
    public static <X, Y> LiveData<Y> map(@NonNull LiveData<X> source, final @NonNull Function<X, Y> mapFunction) {
        final MediatorLiveData result = new MediatorLiveData();
        result.addSource(source, new Observer<X>(){

            public void onChanged(@Nullable X x) {
                result.setValue(mapFunction.apply(x));
            }
        });
        return result;
    }

    @MainThread
    public static <X, Y> LiveData<Y> switchMap(@NonNull LiveData<X> source, final @NonNull Function<X, LiveData<Y>> switchMapFunction) {
        final MediatorLiveData result = new MediatorLiveData();
        result.addSource(source, new Observer<X>(){
            LiveData<Y> mSource;

            public void onChanged(@Nullable X x) {
                LiveData newLiveData = (LiveData)switchMapFunction.apply(x);
                if (this.mSource == newLiveData) {
                    return;
                }
                if (this.mSource != null) {
                    result.removeSource(this.mSource);
                }
                this.mSource = newLiveData;
                if (this.mSource != null) {
                    result.addSource(this.mSource, new Observer<Y>(){

                        public void onChanged(@Nullable Y y) {
                            result.setValue(y);
                        }
                    });
                }
            }
        });
        return result;
    }
}

