/*
 * Decompiled with CFR 0.152.
 */
package androidx.lifecycle.lint;

import androidx.lifecycle.lint.NonNullableMutableLiveDataDetectorKt;
import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.client.api.UElementHandler;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.UastLintUtils;
import com.intellij.lang.jvm.types.JvmReferenceType;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.source.PsiImmediateClassType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.elements.KtLightTypeParameter;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtNullableType;
import org.jetbrains.kotlin.psi.KtTypeElement;
import org.jetbrains.kotlin.psi.KtTypeProjection;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UTypeReferenceExpression;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastLiteralUtils;
import org.jetbrains.uast.kotlin.KotlinUField;
import org.jetbrains.uast.kotlin.KotlinUSimpleReferenceExpression;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 $2\u00020\u00012\u00020\u0002:\u0001$B\u0005\u00a2\u0006\u0002\u0010\u0003J.\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00062\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u0005H\u0002J\u001e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u001aJ\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010\u001d\u001a\u0012\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00140\u001e\u0018\u00010\u0005H\u0016J\u0012\u0010\u001f\u001a\u0004\u0018\u00010\u000b2\b\u0010 \u001a\u0004\u0018\u00010!J\f\u0010\"\u001a\u00020#*\u00020\u001aH\u0002R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR-\u0010\t\u001a\u001e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000b0\nj\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000b`\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006%"}, d2={"Landroidx/lifecycle/lint/NonNullableMutableLiveDataDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/Detector$UastScanner;", "()V", "methods", "", "", "getMethods", "()Ljava/util/List;", "typesMap", "Ljava/util/HashMap;", "Lorg/jetbrains/kotlin/psi/KtTypeReference;", "Lkotlin/collections/HashMap;", "getTypesMap", "()Ljava/util/HashMap;", "checkNullability", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "element", "Lorg/jetbrains/uast/UElement;", "message", "fixes", "Lcom/android/tools/lint/detector/api/LintFix;", "liveDataType", "node", "Lorg/jetbrains/uast/UCallExpression;", "createUastHandler", "Lcom/android/tools/lint/client/api/UElementHandler;", "getApplicableUastTypes", "Ljava/lang/Class;", "getTypeArg", "classType", "Lcom/intellij/psi/PsiClassType;", "isGenericTypeDefinition", "", "Companion", "lifecycle-livedata-core-ktx-lint"})
public final class NonNullableMutableLiveDataDetector
extends Detector
implements Detector.UastScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final HashMap<String, KtTypeReference> typesMap = new HashMap();
    @NotNull
    private final List<String> methods;
    @NotNull
    private static final Issue ISSUE;

    public NonNullableMutableLiveDataDetector() {
        Object[] objectArray = new String[]{"setValue", "postValue"};
        this.methods = CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public final HashMap<String, KtTypeReference> getTypesMap() {
        return this.typesMap;
    }

    @NotNull
    public final List<String> getMethods() {
        return this.methods;
    }

    @Nullable
    public List<Class<? extends UElement>> getApplicableUastTypes() {
        Object[] objectArray = new Class[]{UCallExpression.class, UClass.class};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @Nullable
    public UElementHandler createUastHandler(@NotNull JavaContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return new UElementHandler(this, context){
            final /* synthetic */ NonNullableMutableLiveDataDetector this$0;
            final /* synthetic */ JavaContext $context;
            {
                this.this$0 = $receiver;
                this.$context = $context;
            }

            public void visitClass(@NotNull UClass node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                for (UDeclaration element : node.getUastDeclarations()) {
                    KtTypeReference ktTypeReference;
                    if (!(element instanceof KotlinUField) || (ktTypeReference = this.getFieldTypeReference((KotlinUField)element)) == null) continue;
                    KtTypeReference ktTypeReference2 = ktTypeReference;
                    NonNullableMutableLiveDataDetector nonNullableMutableLiveDataDetector = this.this$0;
                    boolean bl = false;
                    boolean bl2 = false;
                    KtTypeReference it = ktTypeReference2;
                    boolean bl3 = false;
                    nonNullableMutableLiveDataDetector.getTypesMap().put(((KotlinUField)element).getName(), it);
                }
            }

            /*
             * WARNING - void declaration
             */
            private final KtTypeReference getFieldTypeReference(KotlinUField element) {
                Object v3;
                KtTypeReference ktTypeReference;
                Object object;
                block12: {
                    KtTypeReference typeArgument;
                    KtTypeReference typeReference;
                    PsiElement[] psiElementArray;
                    Object v0;
                    KtElement ktElement;
                    block11: {
                        ktElement = element.getSourcePsi();
                        if (ktElement == null) {
                            v0 = null;
                        } else {
                            object = ktElement.getChildren();
                            if (object == null) {
                                v0 = null;
                            } else {
                                void $this$firstOrNull$iv;
                                ktTypeReference = object;
                                boolean $i$f$firstOrNull = false;
                                psiElementArray = $this$firstOrNull$iv;
                                int n = psiElementArray.length;
                                for (int i = 0; i < n; ++i) {
                                    void element$iv;
                                    void it = element$iv = psiElementArray[i];
                                    boolean bl = false;
                                    if (!(it instanceof KtTypeReference)) continue;
                                    v0 = element$iv;
                                    break block11;
                                }
                                v0 = null;
                            }
                        }
                    }
                    Object var3_17 = v0;
                    object = typeReference = var3_17 instanceof KtTypeReference ? (KtTypeReference)var3_17 : null;
                    KtTypeElement ktTypeElement = ktElement = object == null ? null : object.getTypeElement();
                    KtTypeReference ktTypeReference2 = ktElement == null ? null : (typeArgument = (object = ktElement.getTypeArgumentsAsTypes()) == null ? null : (KtTypeReference)CollectionsKt.singleOrNull((List)object));
                    if (typeArgument != null) {
                        return typeArgument;
                    }
                    ktTypeReference = element.getSourcePsi();
                    if (ktTypeReference == null) {
                        v3 = null;
                    } else {
                        PsiElement[] psiElementArray2 = ktTypeReference.getChildren();
                        if (psiElementArray2 == null) {
                            v3 = null;
                        } else {
                            void $this$firstOrNull$iv;
                            psiElementArray = psiElementArray2;
                            boolean $i$f$firstOrNull = false;
                            void var10_10 = $this$firstOrNull$iv;
                            int n = ((void)var10_10).length;
                            for (int i = 0; i < n; ++i) {
                                void element$iv;
                                void it = element$iv = var10_10[i];
                                boolean bl = false;
                                if (!(it instanceof KtCallExpression)) continue;
                                v3 = element$iv;
                                break block12;
                            }
                            v3 = null;
                        }
                    }
                }
                object = v3;
                KtCallExpression expression = object instanceof KtCallExpression ? (KtCallExpression)object : null;
                ktTypeReference = expression;
                List list = object = ktTypeReference == null ? null : ktTypeReference.getTypeArguments();
                return object == null ? null : ((ktTypeReference = (KtTypeProjection)CollectionsKt.singleOrNull((List)object)) == null ? null : ktTypeReference.getTypeReference());
            }

            public void visitCallExpression(@NotNull UCallExpression node) {
                KtTypeReference liveDataType;
                Object object;
                Object object2;
                Object object3;
                PsiClassType receiverType;
                block10: {
                    block9: {
                        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                        if (!Lint.isKotlin((PsiElement)node.getSourcePsi()) || !CollectionsKt.contains((Iterable)this.this$0.getMethods(), (Object)node.getMethodName())) break block9;
                        JavaEvaluator javaEvaluator = this.$context.getEvaluator();
                        PsiMethod psiMethod = node.resolve();
                        Intrinsics.checkNotNull((Object)psiMethod);
                        if (javaEvaluator.isMemberInSubClassOf((PsiMember)psiMethod, "androidx.lifecycle.LiveData", false)) break block10;
                    }
                    return;
                }
                PsiType psiType = node.getReceiverType();
                PsiClassType psiClassType = receiverType = psiType instanceof PsiClassType ? (PsiClassType)psiType : null;
                if (receiverType != null && receiverType.hasParameters()) {
                    UExpression assignment;
                    Object object4;
                    UExpression uExpression;
                    object3 = node.getReceiver();
                    object2 = object3 instanceof KotlinUSimpleReferenceExpression ? (KotlinUSimpleReferenceExpression)object3 : null;
                    PsiElement receiver = object2 == null ? null : object2.resolve();
                    PsiVariable variable = receiver instanceof PsiVariable ? (PsiVariable)receiver : null;
                    PsiVariable psiVariable = variable;
                    if (psiVariable == null) {
                        uExpression = null;
                    } else {
                        object4 = psiVariable;
                        boolean bl = false;
                        boolean bl2 = false;
                        PsiVariable it = object4;
                        boolean bl3 = false;
                        uExpression = UastLintUtils.findLastAssignment((PsiVariable)it, (UElement)((UElement)node));
                    }
                    UExpression uExpression2 = assignment = uExpression;
                    object4 = uExpression2 == null ? null : uExpression2.getSourcePsi();
                    KtCallExpression constructorExpression = object4 instanceof KtCallExpression ? (KtCallExpression)object4 : null;
                    uExpression2 = constructorExpression;
                    List list = object4 = uExpression2 == null ? null : uExpression2.getTypeArguments();
                    object = object4 == null ? null : ((uExpression2 = (KtTypeProjection)CollectionsKt.singleOrNull((List)object4)) == null ? null : uExpression2.getTypeReference());
                } else {
                    object = liveDataType = this.this$0.getTypeArg(receiverType);
                }
                if (liveDataType == null) {
                    object2 = this.this$0.getTypesMap();
                    object3 = this.getVariableName(node);
                    boolean bl = false;
                    KtTypeReference ktTypeReference = (KtTypeReference)object2.get(object3);
                    if (ktTypeReference == null) {
                        return;
                    }
                    liveDataType = ktTypeReference;
                }
                this.this$0.checkNullability(liveDataType, this.$context, node);
            }

            private final String getVariableName(UCallExpression node) {
                PsiElement psiElement;
                PsiElement variable;
                PsiElement psiElement2 = node.getSourcePsi();
                PsiElement dot = psiElement2 == null ? null : psiElement2.getPrevSibling();
                PsiElement psiElement3 = dot;
                psiElement3 = variable = psiElement3 == null ? null : ((psiElement = psiElement3.getPrevSibling()) == null ? null : psiElement.getFirstChild());
                return psiElement3 == null ? null : psiElement3.getText();
            }
        };
    }

    @Nullable
    public final KtTypeReference getTypeArg(@Nullable PsiClassType classType) {
        boolean strict$iv;
        if (classType == null) {
            return null;
        }
        PsiElement $receiver$iv = (PsiElement)classType.resolve();
        UClass cls = (UClass)UastContextKt.getUastParentOfType((PsiElement)$receiver$iv, UClass.class, (boolean)(strict$iv = false));
        UClass $i$f$getUastParentOfType = cls;
        JvmReferenceType jvmReferenceType = strict$iv = $i$f$getUastParentOfType == null ? null : $i$f$getUastParentOfType.getSuperClassType();
        if (strict$iv == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.psi.PsiClassType");
        }
        PsiClassType parentPsiType = (PsiClassType)strict$iv;
        if (parentPsiType.hasParameters()) {
            UTypeReferenceExpression parentTypeReference = (UTypeReferenceExpression)cls.getUastSuperTypes().get(0);
            PsiElement psiElement = parentTypeReference.getSourcePsi();
            if (psiElement == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtTypeReference");
            }
            KtTypeElement superType = ((KtTypeReference)psiElement).getTypeElement();
            Intrinsics.checkNotNull((Object)superType);
            return (KtTypeReference)superType.getTypeArgumentsAsTypes().get(0);
        }
        return this.getTypeArg(parentPsiType);
    }

    public final void checkNullability(@NotNull KtTypeReference liveDataType, @NotNull JavaContext context, @NotNull UCallExpression node) {
        Intrinsics.checkNotNullParameter((Object)liveDataType, (String)"liveDataType");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (this.isGenericTypeDefinition(node)) {
            return;
        }
        if (!(liveDataType.getTypeElement() instanceof KtNullableType)) {
            UExpression argument;
            boolean bl = false;
            List fixes = new ArrayList();
            if (Intrinsics.areEqual((Object)context.getLocation((PsiElement)liveDataType).getFile(), (Object)context.file)) {
                LintFix lintFix = this.fix().name("Change `LiveData` type to nullable").replace().with("?").range(context.getLocation((PsiElement)liveDataType)).end().build();
                Intrinsics.checkNotNullExpressionValue((Object)lintFix, (String)"fix().name(\"Change `LiveData` type to nullable\")\n                        .replace().with(\"?\").range(context.getLocation(liveDataType)).end().build()");
                fixes.add(lintFix);
            }
            if (UastLiteralUtils.isNullLiteral((UElement)((UElement)(argument = (UExpression)node.getValueArguments().get(0))))) {
                this.checkNullability(context, (UElement)argument, "Cannot set non-nullable LiveData value to `null`", fixes);
            } else if (NonNullableMutableLiveDataDetectorKt.isNullable((UElement)argument)) {
                LintFix lintFix = this.fix().name("Add non-null asserted (!!) call").replace().with("!!").range(context.getLocation((UElement)argument)).end().build();
                Intrinsics.checkNotNullExpressionValue((Object)lintFix, (String)"fix().name(\"Add non-null asserted (!!) call\")\n                        .replace().with(\"!!\").range(context.getLocation(argument)).end().build()");
                fixes.add(lintFix);
                this.checkNullability(context, (UElement)argument, "Expected non-nullable value", fixes);
            }
        }
    }

    private final boolean isGenericTypeDefinition(UCallExpression $this$isGenericTypeDefinition) {
        PsiImmediateClassType classType;
        Object object = CollectionsKt.singleOrNull((List)$this$isGenericTypeDefinition.getTypeArguments());
        PsiImmediateClassType psiImmediateClassType = classType = object instanceof PsiImmediateClassType ? (PsiImmediateClassType)object : null;
        PsiClassType.ClassResolveResult resolveGenerics = psiImmediateClassType == null ? null : psiImmediateClassType.resolveGenerics();
        psiImmediateClassType = resolveGenerics;
        return (psiImmediateClassType == null ? null : psiImmediateClassType.getElement()) instanceof KtLightTypeParameter;
    }

    private final void checkNullability(JavaContext context, UElement element, String message, List<? extends LintFix> fixes) {
        if (fixes.isEmpty()) {
            Context.report$default((Context)((Context)context), (Issue)ISSUE, (Location)context.getLocation(element), (String)message, null, (int)8, null);
        } else {
            Collection $this$toTypedArray$iv = fixes;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            LintFix[] lintFixArray = thisCollection$iv.toArray(new LintFix[0]);
            if (lintFixArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            LintFix[] lintFixArray2 = lintFixArray;
            context.report(ISSUE, context.getLocation(element), message, this.fix().alternatives(Arrays.copyOf(lintFixArray2, lintFixArray2.length)));
        }
    }

    static {
        Category category = Category.INTEROPERABILITY_KOTLIN;
        Severity severity = Severity.FATAL;
        Implementation implementation = new Implementation(NonNullableMutableLiveDataDetector.class, Scope.JAVA_FILE_SCOPE);
        ISSUE = Issue.Companion.create$default((Issue.Companion)Issue.Companion, (String)"NullSafeMutableLiveData", (String)"LiveData value assignment nullability mismatch", (String)"This check ensures that LiveData values are not null when explicitly \\\n                declared as non-nullable.\n\n                Kotlin interoperability does not support enforcing explicit null-safety when using \\\n                generic Java type parameters. Since LiveData is a Java class its value can always \\\n                be null even when its type is explicitly declared as non-nullable. This can lead \\\n                to runtime exceptions from reading a null LiveData value that is assumed to be \\\n                non-nullable.", (Implementation)implementation, null, (Category)category, (int)0, (Severity)severity, (boolean)false, (Boolean)true, null, null, (int)3408, null);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Landroidx/lifecycle/lint/NonNullableMutableLiveDataDetector$Companion;", "", "()V", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "getISSUE", "()Lcom/android/tools/lint/detector/api/Issue;", "lifecycle-livedata-core-ktx-lint"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Issue getISSUE() {
            return ISSUE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

