/*
 * Decompiled with CFR 0.152.
 */
package androidx.lifecycle.lint;

import androidx.lifecycle.lint.NonNullableMutableLiveDataDetectorKt;
import com.android.tools.lint.checks.DataFlowAnalyzer;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.UastLintUtils;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtNullableType;
import org.jetbrains.kotlin.psi.KtTypeElement;
import org.jetbrains.kotlin.psi.KtTypeProjection;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UTypeReferenceExpression;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastLiteralUtils;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.kotlin.KotlinUField;
import org.jetbrains.uast.kotlin.KotlinUSimpleReferenceExpression;
import org.jetbrains.uast.visitor.UastVisitor;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00192\u00020\u00012\u00020\u0002:\u0001\u0019B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J.\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00062\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u0005H\u0002J \u0010\u0014\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016\u00a8\u0006\u001a"}, d2={"Landroidx/lifecycle/lint/NonNullableMutableLiveDataDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "getApplicableMethodNames", "", "", "getTypeArg", "Lorg/jetbrains/kotlin/psi/KtTypeReference;", "classType", "Lcom/intellij/psi/PsiClassType;", "report", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "element", "Lorg/jetbrains/uast/UElement;", "message", "fixes", "Lcom/android/tools/lint/detector/api/LintFix;", "visitMethodCall", "node", "Lorg/jetbrains/uast/UCallExpression;", "method", "Lcom/intellij/psi/PsiMethod;", "Companion", "lifecycle-livedata-core-ktx-lint"})
public final class NonNullableMutableLiveDataDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    private static final Issue ISSUE;
    public static final Companion Companion;

    @Nullable
    public List<String> getApplicableMethodNames() {
        return CollectionsKt.listOf((Object[])new String[]{"setValue", "postValue"});
    }

    public void visitMethodCall(@NotNull JavaContext context, @NotNull UCallExpression node, @NotNull PsiMethod method) {
        KtTypeReference liveDataType;
        KtTypeReference ktTypeReference;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        Intrinsics.checkParameterIsNotNull((Object)method, (String)"method");
        if (!Lint.isKotlin((PsiElement)node.getSourcePsi()) || !context.getEvaluator().isMemberInSubClassOf((PsiMember)method, "androidx.lifecycle.LiveData", false)) {
            return;
        }
        boolean bl = false;
        List fieldTypes = new ArrayList();
        UClass uClass = (UClass)UastUtils.getParentOfType((UElement)((UElement)node), UClass.class, (boolean)true);
        if (uClass == null) {
            return;
        }
        UClass analyzer = uClass;
        analyzer.accept((UastVisitor)new DataFlowAnalyzer(fieldTypes, node, CollectionsKt.listOf((Object)node)){
            final /* synthetic */ List $fieldTypes;
            final /* synthetic */ UCallExpression $node;

            public boolean visitClass(@NotNull UClass node) {
                Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                for (UDeclaration element : node.getUastDeclarations()) {
                    Object object;
                    PsiElement psiElement;
                    if (!(element instanceof KotlinUField)) continue;
                    PsiElement[] psiElementArray = ((KotlinUField)element).getSourcePsi();
                    if (!((psiElementArray != null && (psiElementArray = psiElementArray.getChildren()) != null ? psiElementArray[0] : (psiElement = null)) instanceof KtCallExpression)) {
                        psiElement = null;
                    }
                    if ((object = (KtCallExpression)psiElement) == null || (object = object.getTypeArguments()) == null || (object = (KtTypeProjection)CollectionsKt.singleOrNull((List)object)) == null || (object = object.getTypeReference()) == null) continue;
                    Object object2 = object;
                    boolean bl = false;
                    boolean bl2 = false;
                    Object it = object2;
                    boolean bl3 = false;
                    Object object3 = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)object3, (String)"it");
                    this.$fieldTypes.add(object3);
                }
                return super.visitClass(node);
            }
            {
                this.$fieldTypes = $captured_local_variable$0;
                this.$node = $captured_local_variable$1;
                super($super_call_param$2, null, 2, null);
            }
        });
        PsiType psiType = node.getReceiverType();
        if (psiType == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.psi.PsiClassType");
        }
        PsiClassType receiverType = (PsiClassType)psiType;
        Collection collection = fieldTypes;
        boolean bl2 = false;
        boolean bl3 = false;
        if (collection.isEmpty()) {
            Object object;
            if (receiverType.hasParameters()) {
                KtCallExpression constructorExpression;
                Object object2;
                KotlinUSimpleReferenceExpression kotlinUSimpleReferenceExpression;
                UExpression uExpression = node.getReceiver();
                if (!(uExpression instanceof KotlinUSimpleReferenceExpression)) {
                    uExpression = null;
                }
                if ((kotlinUSimpleReferenceExpression = (KotlinUSimpleReferenceExpression)uExpression) == null || (kotlinUSimpleReferenceExpression = kotlinUSimpleReferenceExpression.resolve()) == null) {
                    return;
                }
                KotlinUSimpleReferenceExpression receiver = kotlinUSimpleReferenceExpression;
                KotlinUSimpleReferenceExpression kotlinUSimpleReferenceExpression2 = receiver;
                if (!(kotlinUSimpleReferenceExpression2 instanceof PsiVariable)) {
                    kotlinUSimpleReferenceExpression2 = null;
                }
                PsiVariable psiVariable = (PsiVariable)kotlinUSimpleReferenceExpression2;
                if (psiVariable == null) {
                    return;
                }
                PsiVariable variable = psiVariable;
                UExpression uExpression2 = UastLintUtils.findLastAssignment((PsiVariable)variable, (UElement)((UElement)node));
                if (uExpression2 == null) {
                    return;
                }
                UExpression assignment = uExpression2;
                PsiElement psiElement = assignment.getSourcePsi();
                if (!(psiElement instanceof KtCallExpression)) {
                    psiElement = null;
                }
                object = (object2 = (constructorExpression = (KtCallExpression)psiElement)) != null && (object2 = object2.getTypeArguments()) != null && (object2 = (KtTypeProjection)CollectionsKt.singleOrNull((List)object2)) != null ? object2.getTypeReference() : null;
            } else {
                object = ktTypeReference = this.getTypeArg(receiverType);
            }
            if (object == null) {
                return;
            }
        } else {
            ktTypeReference = liveDataType = (KtTypeReference)fieldTypes.get(0);
        }
        if (!(liveDataType.getTypeElement() instanceof KtNullableType)) {
            UExpression argument;
            boolean variable = false;
            List fixes = new ArrayList();
            if (Intrinsics.areEqual((Object)context.getLocation((PsiElement)liveDataType).getFile(), (Object)context.file)) {
                LintFix lintFix = this.fix().name("Change `LiveData` type to nullable").replace().with("?").range(context.getLocation((PsiElement)liveDataType)).end().build();
                Intrinsics.checkExpressionValueIsNotNull((Object)lintFix, (String)"fix()\n                  \u2026                 .build()");
                fixes.add(lintFix);
            }
            if (UastLiteralUtils.isNullLiteral((UElement)((UElement)(argument = (UExpression)node.getValueArguments().get(0))))) {
                this.report(context, (UElement)argument, "Cannot set non-nullable LiveData value to `null`", fixes);
            } else if (NonNullableMutableLiveDataDetectorKt.isNullable((UElement)argument)) {
                LintFix lintFix = this.fix().name("Add non-null asserted (!!) call").replace().with("!!").range(context.getLocation((UElement)argument)).end().build();
                Intrinsics.checkExpressionValueIsNotNull((Object)lintFix, (String)"fix()\n                  \u2026                 .build()");
                fixes.add(lintFix);
                this.report(context, (UElement)argument, "Expected non-nullable value", fixes);
            }
        }
    }

    private final KtTypeReference getTypeArg(PsiClassType classType) {
        UClass cls;
        PsiElement $receiver$iv = (PsiElement)classType.resolve();
        boolean strict$iv = false;
        UClass uClass = cls = (UClass)UastContextKt.getUastParentOfType((PsiElement)$receiver$iv, UClass.class, (boolean)strict$iv);
        Object object = uClass != null ? uClass.getSuperClassType() : null;
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.psi.PsiClassType");
        }
        PsiClassType parentPsiType = (PsiClassType)object;
        if (parentPsiType.hasParameters()) {
            KtTypeElement superType;
            UTypeReferenceExpression parentTypeReference = (UTypeReferenceExpression)cls.getUastSuperTypes().get(0);
            PsiElement psiElement = parentTypeReference.getSourcePsi();
            if (psiElement == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtTypeReference");
            }
            KtTypeElement ktTypeElement = superType = ((KtTypeReference)psiElement).getTypeElement();
            if (ktTypeElement == null) {
                Intrinsics.throwNpe();
            }
            Object e = ktTypeElement.getTypeArgumentsAsTypes().get(0);
            Intrinsics.checkExpressionValueIsNotNull(e, (String)"superType!!.typeArgumentsAsTypes[0]");
            return (KtTypeReference)e;
        }
        return this.getTypeArg(parentPsiType);
    }

    /*
     * WARNING - void declaration
     */
    private final void report(JavaContext context, UElement element, String message, List<? extends LintFix> fixes) {
        if (fixes.isEmpty()) {
            Context.report$default((Context)context, (Issue)ISSUE, (Location)context.getLocation(element), (String)message, null, (int)8, null);
        } else {
            LintFix[] lintFixArray;
            void $this$toTypedArray$iv;
            Collection collection = fixes;
            LintFix.Builder builder = this.fix();
            String string = message;
            Location location = context.getLocation(element);
            Issue issue = ISSUE;
            JavaContext javaContext = context;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            LintFix[] lintFixArray2 = thisCollection$iv.toArray(new LintFix[0]);
            if (lintFixArray2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            LintFix[] lintFixArray3 = lintFixArray = lintFixArray2;
            javaContext.report(issue, location, string, builder.alternatives(Arrays.copyOf(lintFixArray3, lintFixArray3.length)));
        }
    }

    static {
        Companion = new Companion(null);
        Collection collection = null;
        EnumSet enumSet = null;
        Boolean bl = true;
        boolean bl2 = false;
        Implementation implementation = new Implementation(NonNullableMutableLiveDataDetector.class, Scope.JAVA_FILE_SCOPE);
        int n = 0;
        Severity severity = Severity.FATAL;
        String string = null;
        Category category = Category.INTEROPERABILITY_KOTLIN;
        ISSUE = Issue.Companion.create$default((Issue.Companion)Issue.Companion, (String)"NullSafeMutableLiveData", (String)"LiveData value assignment nullability mismatch", (String)"This check ensures that LiveData values are not null when explicitly \\\n                declared as non-nullable.\n\n                Kotlin interoperability does not support enforcing explicit null-safety when using \\\n                generic Java type parameters. Since LiveData is a Java class its value can always \\\n                be null even when its type is explicitly declared as non-nullable. This can lead \\\n                to runtime exceptions from reading a null LiveData value that is assumed to be \\\n                non-nullable.", (Implementation)implementation, string, (Category)category, (int)n, (Severity)severity, (boolean)bl2, (Boolean)bl, enumSet, collection, (int)3408, null);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Landroidx/lifecycle/lint/NonNullableMutableLiveDataDetector$Companion;", "", "()V", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "getISSUE", "()Lcom/android/tools/lint/detector/api/Issue;", "lifecycle-livedata-core-ktx-lint"})
    public static final class Companion {
        @NotNull
        public final Issue getISSUE() {
            return ISSUE;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

