/*
 * Decompiled with CFR 0.152.
 */
package androidx.lifecycle;

import androidx.lifecycle.Elements_extKt;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.OnLifecycleEvent;
import androidx.lifecycle.Validator;
import androidx.lifecycle.model.AdapterClassKt;
import androidx.lifecycle.model.EventMethod;
import androidx.lifecycle.model.LifecycleObserverInfo;
import com.google.auto.common.MoreElements;
import com.google.auto.common.MoreTypes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u001c\u001a\u00020\u000fJ \u0010\u001d\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u001e\u001a\u00020\u000f2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00100 H\u0002J\u0016\u0010!\u001a\n\u0012\u0004\u0012\u00020\"\u0018\u00010 2\u0006\u0010\u001c\u001a\u00020\u000fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001d\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006#"}, d2={"Landroidx/lifecycle/ObserversCollector;", "", "processingEnv", "Ljavax/annotation/processing/ProcessingEnvironment;", "(Ljavax/annotation/processing/ProcessingEnvironment;)V", "elementUtils", "Ljavax/lang/model/util/Elements;", "getElementUtils", "()Ljavax/lang/model/util/Elements;", "lifecycleObserverTypeMirror", "Ljavax/lang/model/type/TypeMirror;", "getLifecycleObserverTypeMirror", "()Ljavax/lang/model/type/TypeMirror;", "observers", "", "Ljavax/lang/model/element/TypeElement;", "Landroidx/lifecycle/model/LifecycleObserverInfo;", "getObservers", "()Ljava/util/Map;", "typeUtils", "Ljavax/lang/model/util/Types;", "getTypeUtils", "()Ljavax/lang/model/util/Types;", "validator", "Landroidx/lifecycle/Validator;", "getValidator", "()Landroidx/lifecycle/Validator;", "collect", "type", "createObserverInfo", "typeElement", "parents", "", "generatedAdapterInfoFor", "Ljavax/lang/model/element/ExecutableElement;", "lifecycle-compiler"})
public final class ObserversCollector {
    @NotNull
    private final Types typeUtils;
    @NotNull
    private final Elements elementUtils;
    @NotNull
    private final TypeMirror lifecycleObserverTypeMirror;
    @NotNull
    private final Validator validator;
    @NotNull
    private final Map<TypeElement, LifecycleObserverInfo> observers;

    @NotNull
    public final Types getTypeUtils() {
        return this.typeUtils;
    }

    @NotNull
    public final Elements getElementUtils() {
        return this.elementUtils;
    }

    @NotNull
    public final TypeMirror getLifecycleObserverTypeMirror() {
        return this.lifecycleObserverTypeMirror;
    }

    @NotNull
    public final Validator getValidator() {
        return this.validator;
    }

    @NotNull
    public final Map<TypeElement, LifecycleObserverInfo> getObservers() {
        return this.observers;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final LifecycleObserverInfo collect(@NotNull TypeElement type) {
        void $this$mapTo$iv$iv;
        Iterable $this$filterNotTo$iv$iv;
        TypeMirror it;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Map<TypeElement, LifecycleObserverInfo> map = this.observers;
        boolean bl = false;
        Map<TypeElement, LifecycleObserverInfo> map2 = map;
        boolean bl2 = false;
        if (map2.containsKey(type)) {
            return this.observers.get(type);
        }
        Collection collection = CollectionsKt.listOf((Object)type.getSuperclass());
        List<? extends TypeMirror> list = type.getInterfaces();
        Intrinsics.checkNotNullExpressionValue(list, (String)"type.interfaces");
        Iterable $this$filter$iv = CollectionsKt.plus((Collection)collection, (Iterable)list);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (TypeMirror)element$iv$iv;
            boolean bl3 = false;
            if (!this.typeUtils.isAssignable(it, this.lifecycleObserverTypeMirror)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$filterNot$iv = (List)destination$iv$iv;
        boolean $i$f$filterNot = false;
        $this$filterTo$iv$iv = $this$filterNot$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            it = (TypeMirror)element$iv$iv;
            boolean bl4 = false;
            if (this.typeUtils.isSameType(it, this.lifecycleObserverTypeMirror)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterNotTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (TypeMirror)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl5 = false;
            TypeElement typeElement = MoreTypes.asTypeElement((TypeMirror)it);
            Intrinsics.checkNotNullExpressionValue((Object)typeElement, (String)"MoreTypes.asTypeElement(it)");
            LifecycleObserverInfo lifecycleObserverInfo = this.collect(typeElement);
            collection2.add(lifecycleObserverInfo);
        }
        List parents = CollectionsKt.filterNotNull((Iterable)((List)destination$iv$iv));
        LifecycleObserverInfo info = this.createObserverInfo(type, parents);
        if (info != null) {
            this.observers.put(type, info);
        }
        return info;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final List<ExecutableElement> generatedAdapterInfoFor(@NotNull TypeElement type) {
        List list;
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        CharSequence charSequence = Elements_extKt.getPackageQName(type);
        boolean bl = false;
        String packageName = charSequence.length() == 0 ? "" : Elements_extKt.getPackageQName(type) + '.';
        TypeElement adapterType = this.elementUtils.getTypeElement(packageName + AdapterClassKt.getAdapterName(type));
        Object object = adapterType;
        if (object != null && (object = Elements_extKt.methods((TypeElement)object)) != null) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = (Iterable)object;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                ExecutableElement executable = (ExecutableElement)element$iv$iv;
                boolean bl2 = false;
                if (!Elements_extKt.isSyntheticMethod(executable)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list = (List)destination$iv$iv;
        } else {
            list = null;
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    private final LifecycleObserverInfo createObserverInfo(TypeElement typeElement, List<LifecycleObserverInfo> parents) {
        void $this$mapTo$iv$iv;
        ExecutableElement executable;
        Iterable $this$filterTo$iv$iv;
        if (!this.validator.validateClass(typeElement)) {
            return null;
        }
        Iterable $this$filter$iv = Elements_extKt.methods(typeElement);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            executable = (ExecutableElement)element$iv$iv;
            boolean bl = false;
            if (!MoreElements.isAnnotationPresent((Element)executable, OnLifecycleEvent.class)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            EventMethod eventMethod;
            executable = (ExecutableElement)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            OnLifecycleEvent onState = executable.getAnnotation(OnLifecycleEvent.class);
            if (this.validator.validateMethod(executable, onState.value())) {
                OnLifecycleEvent onLifecycleEvent = onState;
                Intrinsics.checkNotNullExpressionValue((Object)onLifecycleEvent, (String)"onState");
                eventMethod = new EventMethod(executable, onLifecycleEvent, typeElement);
            } else {
                eventMethod = null;
            }
            EventMethod eventMethod2 = eventMethod;
            collection.add(eventMethod2);
        }
        List methods = CollectionsKt.filterNotNull((Iterable)((List)destination$iv$iv));
        return new LifecycleObserverInfo(typeElement, methods, parents);
    }

    public ObserversCollector(@NotNull ProcessingEnvironment processingEnv) {
        Intrinsics.checkNotNullParameter((Object)processingEnv, (String)"processingEnv");
        Types types = processingEnv.getTypeUtils();
        Intrinsics.checkNotNullExpressionValue((Object)types, (String)"processingEnv.typeUtils");
        this.typeUtils = types;
        Elements elements = processingEnv.getElementUtils();
        Intrinsics.checkNotNullExpressionValue((Object)elements, (String)"processingEnv.elementUtils");
        this.elementUtils = elements;
        TypeMirror typeMirror = this.elementUtils.getTypeElement(LifecycleObserver.class.getCanonicalName()).asType();
        Intrinsics.checkNotNullExpressionValue((Object)typeMirror, (String)"elementUtils.getTypeElem\u2026a.canonicalName).asType()");
        this.lifecycleObserverTypeMirror = typeMirror;
        this.validator = new Validator(processingEnv);
        boolean bl = false;
        this.observers = new LinkedHashMap();
    }
}

