/*
 * Decompiled with CFR 0.152.
 */
package androidx.lifecycle;

import androidx.lifecycle.FullLifecycleObserver;
import androidx.lifecycle.GenericLifecycleObserver;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleOwner;

class FullLifecycleObserverAdapter
implements GenericLifecycleObserver {
    private final FullLifecycleObserver mObserver;

    FullLifecycleObserverAdapter(FullLifecycleObserver observer) {
        this.mObserver = observer;
    }

    @Override
    public void onStateChanged(LifecycleOwner source, Lifecycle.Event event) {
        switch (event) {
            case ON_CREATE: {
                this.mObserver.onCreate(source);
                break;
            }
            case ON_START: {
                this.mObserver.onStart(source);
                break;
            }
            case ON_RESUME: {
                this.mObserver.onResume(source);
                break;
            }
            case ON_PAUSE: {
                this.mObserver.onPause(source);
                break;
            }
            case ON_STOP: {
                this.mObserver.onStop(source);
                break;
            }
            case ON_DESTROY: {
                this.mObserver.onDestroy(source);
                break;
            }
            case ON_ANY: {
                throw new IllegalArgumentException("ON_ANY must not been send by anybody");
            }
        }
    }
}

