/*
 * Decompiled with CFR 0.152.
 */
package androidx.graphics.path;

import android.graphics.PointF;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0018B%\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016R\u0019\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\n\n\u0002\u0010\f\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0019"}, d2={"Landroidx/graphics/path/PathSegment;", "", "type", "Landroidx/graphics/path/PathSegment$Type;", "points", "", "Landroid/graphics/PointF;", "weight", "", "(Landroidx/graphics/path/PathSegment$Type;[Landroid/graphics/PointF;F)V", "getPoints", "()[Landroid/graphics/PointF;", "[Landroid/graphics/PointF;", "getType", "()Landroidx/graphics/path/PathSegment$Type;", "getWeight", "()F", "equals", "", "other", "hashCode", "", "toString", "", "Type", "graphics-path_release"})
public final class PathSegment {
    @NotNull
    private final Type type;
    @NotNull
    private final PointF[] points;
    private final float weight;

    public PathSegment(@NotNull Type type, @NotNull PointF[] points, float weight) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)points, (String)"points");
        this.type = type;
        this.points = points;
        this.weight = weight;
    }

    @NotNull
    public final Type getType() {
        return this.type;
    }

    @NotNull
    public final PointF[] getPoints() {
        return this.points;
    }

    public final float getWeight() {
        return this.weight;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type androidx.graphics.path.PathSegment");
        PathSegment cfr_ignored_0 = (PathSegment)other;
        if (this.type != ((PathSegment)other).type) {
            return false;
        }
        if (!Arrays.equals(this.points, ((PathSegment)other).points)) {
            return false;
        }
        return this.weight == ((PathSegment)other).weight;
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = 31 * result + Arrays.hashCode(this.points);
        result = 31 * result + Float.hashCode(this.weight);
        return result;
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder().append("PathSegment(type=").append((Object)this.type).append(", points=");
        String string = Arrays.toString(this.points);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(this)");
        return stringBuilder.append(string).append(", weight=").append(this.weight).append(')').toString();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\t\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\t\u00a8\u0006\n"}, d2={"Landroidx/graphics/path/PathSegment$Type;", "", "(Ljava/lang/String;I)V", "Move", "Line", "Quadratic", "Conic", "Cubic", "Close", "Done", "graphics-path_release"})
    public static final class Type
    extends Enum<Type> {
        public static final /* enum */ Type Move = new Type();
        public static final /* enum */ Type Line = new Type();
        public static final /* enum */ Type Quadratic = new Type();
        public static final /* enum */ Type Conic = new Type();
        public static final /* enum */ Type Cubic = new Type();
        public static final /* enum */ Type Close = new Type();
        public static final /* enum */ Type Done = new Type();
        private static final /* synthetic */ Type[] $VALUES;

        public static Type[] values() {
            return (Type[])$VALUES.clone();
        }

        public static Type valueOf(String value) {
            return Enum.valueOf(Type.class, value);
        }

        static {
            $VALUES = typeArray = new Type[]{Type.Move, Type.Line, Type.Quadratic, Type.Conic, Type.Cubic, Type.Close, Type.Done};
        }
    }
}

