/*
 * Decompiled with CFR 0.152.
 */
package androidx.databinding;

import androidx.databinding.ListChangeRegistry;
import androidx.databinding.ObservableList;
import java.util.ArrayList;
import java.util.Collection;

public class ObservableArrayList<T>
extends ArrayList<T>
implements ObservableList<T> {
    private transient ListChangeRegistry mListeners = new ListChangeRegistry();

    public void addOnListChangedCallback(ObservableList.OnListChangedCallback listener) {
        if (this.mListeners == null) {
            this.mListeners = new ListChangeRegistry();
        }
        this.mListeners.add(listener);
    }

    public void removeOnListChangedCallback(ObservableList.OnListChangedCallback listener) {
        if (this.mListeners != null) {
            this.mListeners.remove(listener);
        }
    }

    @Override
    public boolean add(T object) {
        super.add(object);
        this.notifyAdd(this.size() - 1, 1);
        return true;
    }

    @Override
    public void add(int index, T object) {
        super.add(index, object);
        this.notifyAdd(index, 1);
    }

    @Override
    public boolean addAll(Collection<? extends T> collection) {
        int oldSize = this.size();
        boolean added = super.addAll(collection);
        if (added) {
            this.notifyAdd(oldSize, this.size() - oldSize);
        }
        return added;
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> collection) {
        boolean added = super.addAll(index, collection);
        if (added) {
            this.notifyAdd(index, collection.size());
        }
        return added;
    }

    @Override
    public void clear() {
        int oldSize = this.size();
        super.clear();
        if (oldSize != 0) {
            this.notifyRemove(0, oldSize);
        }
    }

    @Override
    public T remove(int index) {
        Object val = super.remove(index);
        this.notifyRemove(index, 1);
        return (T)val;
    }

    @Override
    public boolean remove(Object object) {
        int index = this.indexOf(object);
        if (index >= 0) {
            this.remove(index);
            return true;
        }
        return false;
    }

    @Override
    public T set(int index, T object) {
        T val = super.set(index, object);
        if (this.mListeners != null) {
            this.mListeners.notifyChanged(this, index, 1);
        }
        return val;
    }

    @Override
    protected void removeRange(int fromIndex, int toIndex) {
        super.removeRange(fromIndex, toIndex);
        this.notifyRemove(fromIndex, toIndex - fromIndex);
    }

    private void notifyAdd(int start, int count) {
        if (this.mListeners != null) {
            this.mListeners.notifyInserted(this, start, count);
        }
    }

    private void notifyRemove(int start, int count) {
        if (this.mListeners != null) {
            this.mListeners.notifyRemoved(this, start, count);
        }
    }
}

