/*
 * Decompiled with CFR 0.152.
 */
package android.databinding.tool.expr;

import android.databinding.tool.expr.Dependency;
import android.databinding.tool.expr.Expr;
import android.databinding.tool.expr.ExprModel;
import android.databinding.tool.reflection.ModelAnalyzer;
import android.databinding.tool.reflection.ModelClass;
import android.databinding.tool.writer.KCode;
import java.util.List;

public class BitShiftExpr
extends Expr {
    final String mOp;

    BitShiftExpr(Expr left, String op, Expr right) {
        super(left, right);
        this.mOp = op;
    }

    @Override
    protected String computeUniqueKey() {
        return BitShiftExpr.join(this.getLeft(), this.mOp, this.getRight());
    }

    @Override
    protected ModelClass resolveType(ModelAnalyzer modelAnalyzer) {
        return this.getLeft().getResolvedType();
    }

    @Override
    protected List<Dependency> constructDependencies() {
        return this.constructDynamicChildrenDependencies();
    }

    @Override
    public void injectSafeUnboxing(ModelAnalyzer modelAnalyzer, ExprModel model) {
        Expr right;
        Expr left = this.getLeft();
        if (left.getResolvedType().isNullable()) {
            this.safeUnboxChild(model, left);
        }
        if ((right = this.getRight()).getResolvedType().isNullable()) {
            this.safeUnboxChild(model, right);
        }
    }

    public String getOp() {
        return this.mOp;
    }

    public Expr getLeft() {
        return this.getChildren().get(0);
    }

    public Expr getRight() {
        return this.getChildren().get(1);
    }

    @Override
    protected KCode generateCode() {
        return new KCode().app("", this.getLeft().toCode()).app(this.getOp()).app("", this.getRight().toCode());
    }

    @Override
    public Expr cloneToModel(ExprModel model) {
        return model.bitshift(this.getLeft().cloneToModel(model), this.mOp, this.getRight().cloneToModel(model));
    }

    @Override
    public String getInvertibleError() {
        return "Bit shift operators cannot be inverted in two-way binding";
    }

    @Override
    public String toString() {
        return this.getLeft().toString() + ' ' + this.mOp + ' ' + this.getRight().toString();
    }
}

