/*
 * Decompiled with CFR 0.152.
 */
package androidx.credentials.playservices.controllers.CreatePublicKeyCredential;

import android.util.Base64;
import android.util.Log;
import androidx.credentials.CreatePublicKeyCredentialRequest;
import androidx.credentials.GetPublicKeyCredentialOption;
import androidx.credentials.exceptions.CreateCredentialCancellationException;
import androidx.credentials.exceptions.CreateCredentialException;
import androidx.credentials.exceptions.GetCredentialCancellationException;
import androidx.credentials.exceptions.GetCredentialException;
import androidx.credentials.exceptions.GetCredentialUnknownException;
import androidx.credentials.exceptions.domerrors.AbortError;
import androidx.credentials.exceptions.domerrors.ConstraintError;
import androidx.credentials.exceptions.domerrors.DataError;
import androidx.credentials.exceptions.domerrors.DomError;
import androidx.credentials.exceptions.domerrors.EncodingError;
import androidx.credentials.exceptions.domerrors.InvalidStateError;
import androidx.credentials.exceptions.domerrors.NetworkError;
import androidx.credentials.exceptions.domerrors.NotAllowedError;
import androidx.credentials.exceptions.domerrors.NotReadableError;
import androidx.credentials.exceptions.domerrors.NotSupportedError;
import androidx.credentials.exceptions.domerrors.SecurityError;
import androidx.credentials.exceptions.domerrors.TimeoutError;
import androidx.credentials.exceptions.domerrors.UnknownError;
import androidx.credentials.exceptions.publickeycredential.CreatePublicKeyCredentialDomException;
import androidx.credentials.exceptions.publickeycredential.GetPublicKeyCredentialDomException;
import com.google.android.gms.auth.api.identity.BeginSignInRequest;
import com.google.android.gms.auth.api.identity.SignInCredential;
import com.google.android.gms.fido.common.Transport;
import com.google.android.gms.fido.fido2.api.common.Attachment;
import com.google.android.gms.fido.fido2.api.common.AttestationConveyancePreference;
import com.google.android.gms.fido.fido2.api.common.AuthenticationExtensions;
import com.google.android.gms.fido.fido2.api.common.AuthenticatorAssertionResponse;
import com.google.android.gms.fido.fido2.api.common.AuthenticatorErrorResponse;
import com.google.android.gms.fido.fido2.api.common.AuthenticatorResponse;
import com.google.android.gms.fido.fido2.api.common.AuthenticatorSelectionCriteria;
import com.google.android.gms.fido.fido2.api.common.COSEAlgorithmIdentifier;
import com.google.android.gms.fido.fido2.api.common.ErrorCode;
import com.google.android.gms.fido.fido2.api.common.FidoAppIdExtension;
import com.google.android.gms.fido.fido2.api.common.GoogleThirdPartyPaymentExtension;
import com.google.android.gms.fido.fido2.api.common.PublicKeyCredential;
import com.google.android.gms.fido.fido2.api.common.PublicKeyCredentialCreationOptions;
import com.google.android.gms.fido.fido2.api.common.PublicKeyCredentialDescriptor;
import com.google.android.gms.fido.fido2.api.common.PublicKeyCredentialParameters;
import com.google.android.gms.fido.fido2.api.common.PublicKeyCredentialRpEntity;
import com.google.android.gms.fido.fido2.api.common.PublicKeyCredentialUserEntity;
import com.google.android.gms.fido.fido2.api.common.ResidentKeyRequirement;
import com.google.android.gms.fido.fido2.api.common.UserVerificationMethodExtension;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Landroidx/credentials/playservices/controllers/CreatePublicKeyCredential/PublicKeyCredentialControllerUtility;", "", "()V", "Companion", "credentials-play-services-auth_release"})
public final class PublicKeyCredentialControllerUtility {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String JSON_KEY_CLIENT_DATA = "clientDataJSON";
    @NotNull
    private static final String JSON_KEY_ATTESTATION_OBJ = "attestationObject";
    @NotNull
    private static final String JSON_KEY_AUTH_DATA = "authenticatorData";
    @NotNull
    private static final String JSON_KEY_SIGNATURE = "signature";
    @NotNull
    private static final String JSON_KEY_USER_HANDLE = "userHandle";
    @NotNull
    private static final String JSON_KEY_RESPONSE = "response";
    @NotNull
    private static final String JSON_KEY_ID = "id";
    @NotNull
    private static final String JSON_KEY_RAW_ID = "rawId";
    @NotNull
    private static final String JSON_KEY_TYPE = "type";
    @NotNull
    private static final String JSON_KEY_RPID = "rpId";
    @NotNull
    private static final String JSON_KEY_CHALLENGE = "challenge";
    @NotNull
    private static final String JSON_KEY_APPID = "appid";
    @NotNull
    private static final String JSON_KEY_THIRD_PARTY_PAYMENT = "thirdPartyPayment";
    @NotNull
    private static final String JSON_KEY_AUTH_SELECTION = "authenticatorSelection";
    @NotNull
    private static final String JSON_KEY_REQUIRE_RES_KEY = "requireResidentKey";
    @NotNull
    private static final String JSON_KEY_RES_KEY = "residentKey";
    @NotNull
    private static final String JSON_KEY_AUTH_ATTACHMENT = "authenticatorAttachment";
    @NotNull
    private static final String JSON_KEY_TIMEOUT = "timeout";
    @NotNull
    private static final String JSON_KEY_EXCLUDE_CREDENTIALS = "excludeCredentials";
    @NotNull
    private static final String JSON_KEY_TRANSPORTS = "transports";
    @NotNull
    private static final String JSON_KEY_RP = "rp";
    @NotNull
    private static final String JSON_KEY_NAME = "name";
    @NotNull
    private static final String JSON_KEY_ICON = "icon";
    @NotNull
    private static final String JSON_KEY_ALG = "alg";
    @NotNull
    private static final String JSON_KEY_USER = "user";
    @NotNull
    private static final String JSON_KEY_DISPLAY_NAME = "displayName";
    @NotNull
    private static final String JSON_KEY_USER_VERIFICATION_METHOD = "userVerificationMethod";
    @NotNull
    private static final String JSON_KEY_KEY_PROTECTION_TYPE = "keyProtectionType";
    @NotNull
    private static final String JSON_KEY_MATCHER_PROTECTION_TYPE = "matcherProtectionType";
    @NotNull
    private static final String JSON_KEY_EXTENSTIONS = "extensions";
    @NotNull
    private static final String JSON_KEY_ATTESTATION = "attestation";
    @NotNull
    private static final String JSON_KEY_PUB_KEY_CRED_PARAMS = "pubKeyCredParams";
    @NotNull
    private static final String JSON_KEY_CLIENT_EXTENSION_RESULTS = "clientExtensionResults";
    @NotNull
    private static final String JSON_KEY_RK = "rk";
    @NotNull
    private static final String JSON_KEY_CRED_PROPS = "credProps";
    private static final int FLAGS = 11;
    @NotNull
    private static final String TAG = "PublicKeyUtility";
    @NotNull
    private static final LinkedHashMap<ErrorCode, DomError> orderedErrorCodeToExceptions;

    @JvmStatic
    @NotNull
    public static final PublicKeyCredentialCreationOptions convert(@NotNull CreatePublicKeyCredentialRequest request) {
        return Companion.convert(request);
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)ErrorCode.UNKNOWN_ERR, (Object)new UnknownError()), TuplesKt.to((Object)ErrorCode.ABORT_ERR, (Object)new AbortError()), TuplesKt.to((Object)ErrorCode.ATTESTATION_NOT_PRIVATE_ERR, (Object)new NotReadableError()), TuplesKt.to((Object)ErrorCode.CONSTRAINT_ERR, (Object)new ConstraintError()), TuplesKt.to((Object)ErrorCode.DATA_ERR, (Object)new DataError()), TuplesKt.to((Object)ErrorCode.INVALID_STATE_ERR, (Object)new InvalidStateError()), TuplesKt.to((Object)ErrorCode.ENCODING_ERR, (Object)new EncodingError()), TuplesKt.to((Object)ErrorCode.NETWORK_ERR, (Object)new NetworkError()), TuplesKt.to((Object)ErrorCode.NOT_ALLOWED_ERR, (Object)new NotAllowedError()), TuplesKt.to((Object)ErrorCode.NOT_SUPPORTED_ERR, (Object)new NotSupportedError()), TuplesKt.to((Object)ErrorCode.SECURITY_ERR, (Object)new SecurityError()), TuplesKt.to((Object)ErrorCode.TIMEOUT_ERR, (Object)new TimeoutError())};
        orderedErrorCodeToExceptions = MapsKt.linkedMapOf((Pair[])pairArray);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\bH\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J7\u0010U\u001a\u00020V2\u0006\u0010W\u001a\u00020X2\u0006\u0010Y\u001a\u00020X2\u000e\u0010Z\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060[2\u0006\u0010\\\u001a\u00020]H\u0000\u00a2\u0006\u0004\b^\u0010_J\u000e\u0010`\u001a\u00020X2\u0006\u0010a\u001a\u00020\u0006J\u000e\u0010b\u001a\u00020\u00062\u0006\u0010c\u001a\u00020XJ\u001f\u0010d\u001a\u00020e2\u0006\u0010f\u001a\u00020P2\b\u0010g\u001a\u0004\u0018\u00010\u0006H\u0000\u00a2\u0006\u0002\bhJ\u000e\u0010i\u001a\u00020j2\u0006\u0010k\u001a\u00020\u0004J\u0010\u0010l\u001a\u00020m2\u0006\u0010n\u001a\u00020oH\u0007J\u0015\u0010p\u001a\u00020m2\u0006\u0010\\\u001a\u00020]H\u0000\u00a2\u0006\u0002\bqJ\u000e\u0010r\u001a\u00020s2\u0006\u0010t\u001a\u00020uJ\u0010\u0010v\u001a\u00020w2\u0006\u0010t\u001a\u00020uH\u0007J\u0010\u0010x\u001a\u00020X2\u0006\u0010\\\u001a\u00020]H\u0002J\u001d\u0010y\u001a\u00020V2\u0006\u0010\\\u001a\u00020]2\u0006\u0010z\u001a\u00020{H\u0000\u00a2\u0006\u0002\b|J\u001d\u0010}\u001a\u00020V2\u0006\u0010\\\u001a\u00020]2\u0006\u0010z\u001a\u00020{H\u0000\u00a2\u0006\u0002\b~J\u001e\u0010\u007f\u001a\u00020V2\u0006\u0010\\\u001a\u00020]2\u0006\u0010z\u001a\u00020{H\u0000\u00a2\u0006\u0003\b\u0080\u0001J\u001f\u0010\u0081\u0001\u001a\u00020V2\u0006\u0010\\\u001a\u00020]2\u0006\u0010z\u001a\u00020{H\u0000\u00a2\u0006\u0003\b\u0082\u0001J\u001f\u0010\u0083\u0001\u001a\u00020V2\u0006\u0010\\\u001a\u00020]2\u0006\u0010z\u001a\u00020{H\u0000\u00a2\u0006\u0003\b\u0084\u0001J\u001f\u0010\u0085\u0001\u001a\u00020V2\u0006\u0010\\\u001a\u00020]2\u0006\u0010z\u001a\u00020{H\u0000\u00a2\u0006\u0003\b\u0086\u0001J\u0014\u0010\u0087\u0001\u001a\u0005\u0018\u00010\u0088\u00012\b\u0010\u0089\u0001\u001a\u00030\u008a\u0001J\u0011\u0010\u008b\u0001\u001a\u00020\u00062\b\u0010\u0089\u0001\u001a\u00030\u008c\u0001R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0080D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\u0006X\u0080D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u0014\u0010\u000b\u001a\u00020\u0006X\u0080D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\bR\u0014\u0010\r\u001a\u00020\u0006X\u0080D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\bR\u0014\u0010\u000f\u001a\u00020\u0006X\u0080D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\bR\u0014\u0010\u0011\u001a\u00020\u0006X\u0080D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\bR\u0014\u0010\u0013\u001a\u00020\u0006X\u0080D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\bR\u0014\u0010\u0015\u001a\u00020\u0006X\u0080D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\bR\u0014\u0010\u0017\u001a\u00020\u0006X\u0080D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\bR\u0014\u0010\u0019\u001a\u00020\u0006X\u0080D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\bR\u0014\u0010\u001b\u001a\u00020\u0006X\u0080D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\bR\u0014\u0010\u001d\u001a\u00020\u0006X\u0080D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\bR\u0014\u0010\u001f\u001a\u00020\u0006X\u0080D\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\bR\u0014\u0010!\u001a\u00020\u0006X\u0080D\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\bR\u0014\u0010#\u001a\u00020\u0006X\u0080D\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\bR\u0014\u0010%\u001a\u00020\u0006X\u0080D\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010\bR\u0014\u0010'\u001a\u00020\u0006X\u0080D\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010\bR\u0014\u0010)\u001a\u00020\u0006X\u0080D\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010\bR\u0014\u0010+\u001a\u00020\u0006X\u0080D\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010\bR\u0014\u0010-\u001a\u00020\u0006X\u0080D\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010\bR\u0014\u0010/\u001a\u00020\u0006X\u0080D\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u0010\bR\u0014\u00101\u001a\u00020\u0006X\u0080D\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u0010\bR\u0014\u00103\u001a\u00020\u0006X\u0080D\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u0010\bR\u0014\u00105\u001a\u00020\u0006X\u0080D\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u0010\bR\u0014\u00107\u001a\u00020\u0006X\u0080D\u00a2\u0006\b\n\u0000\u001a\u0004\b8\u0010\bR\u0014\u00109\u001a\u00020\u0006X\u0080D\u00a2\u0006\b\n\u0000\u001a\u0004\b:\u0010\bR\u0014\u0010;\u001a\u00020\u0006X\u0080D\u00a2\u0006\b\n\u0000\u001a\u0004\b<\u0010\bR\u0014\u0010=\u001a\u00020\u0006X\u0080D\u00a2\u0006\b\n\u0000\u001a\u0004\b>\u0010\bR\u0014\u0010?\u001a\u00020\u0006X\u0080D\u00a2\u0006\b\n\u0000\u001a\u0004\b@\u0010\bR\u0014\u0010A\u001a\u00020\u0006X\u0080D\u00a2\u0006\b\n\u0000\u001a\u0004\bB\u0010\bR\u0014\u0010C\u001a\u00020\u0006X\u0080D\u00a2\u0006\b\n\u0000\u001a\u0004\bD\u0010\bR\u0014\u0010E\u001a\u00020\u0006X\u0080D\u00a2\u0006\b\n\u0000\u001a\u0004\bF\u0010\bR\u0014\u0010G\u001a\u00020\u0006X\u0080D\u00a2\u0006\b\n\u0000\u001a\u0004\bH\u0010\bR\u0014\u0010I\u001a\u00020\u0006X\u0080D\u00a2\u0006\b\n\u0000\u001a\u0004\bJ\u0010\bR\u0014\u0010K\u001a\u00020\u0006X\u0080D\u00a2\u0006\b\n\u0000\u001a\u0004\bL\u0010\bR\u000e\u0010M\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R0\u0010N\u001a\u001e\u0012\u0004\u0012\u00020P\u0012\u0004\u0012\u00020Q0Oj\u000e\u0012\u0004\u0012\u00020P\u0012\u0004\u0012\u00020Q`RX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bS\u0010T\u00a8\u0006\u008d\u0001"}, d2={"Landroidx/credentials/playservices/controllers/CreatePublicKeyCredential/PublicKeyCredentialControllerUtility$Companion;", "", "()V", "FLAGS", "", "JSON_KEY_ALG", "", "getJSON_KEY_ALG$credentials_play_services_auth_release", "()Ljava/lang/String;", "JSON_KEY_APPID", "getJSON_KEY_APPID$credentials_play_services_auth_release", "JSON_KEY_ATTESTATION", "getJSON_KEY_ATTESTATION$credentials_play_services_auth_release", "JSON_KEY_ATTESTATION_OBJ", "getJSON_KEY_ATTESTATION_OBJ$credentials_play_services_auth_release", "JSON_KEY_AUTH_ATTACHMENT", "getJSON_KEY_AUTH_ATTACHMENT$credentials_play_services_auth_release", "JSON_KEY_AUTH_DATA", "getJSON_KEY_AUTH_DATA$credentials_play_services_auth_release", "JSON_KEY_AUTH_SELECTION", "getJSON_KEY_AUTH_SELECTION$credentials_play_services_auth_release", "JSON_KEY_CHALLENGE", "getJSON_KEY_CHALLENGE$credentials_play_services_auth_release", "JSON_KEY_CLIENT_DATA", "getJSON_KEY_CLIENT_DATA$credentials_play_services_auth_release", "JSON_KEY_CLIENT_EXTENSION_RESULTS", "getJSON_KEY_CLIENT_EXTENSION_RESULTS$credentials_play_services_auth_release", "JSON_KEY_CRED_PROPS", "getJSON_KEY_CRED_PROPS$credentials_play_services_auth_release", "JSON_KEY_DISPLAY_NAME", "getJSON_KEY_DISPLAY_NAME$credentials_play_services_auth_release", "JSON_KEY_EXCLUDE_CREDENTIALS", "getJSON_KEY_EXCLUDE_CREDENTIALS$credentials_play_services_auth_release", "JSON_KEY_EXTENSTIONS", "getJSON_KEY_EXTENSTIONS$credentials_play_services_auth_release", "JSON_KEY_ICON", "getJSON_KEY_ICON$credentials_play_services_auth_release", "JSON_KEY_ID", "getJSON_KEY_ID$credentials_play_services_auth_release", "JSON_KEY_KEY_PROTECTION_TYPE", "getJSON_KEY_KEY_PROTECTION_TYPE$credentials_play_services_auth_release", "JSON_KEY_MATCHER_PROTECTION_TYPE", "getJSON_KEY_MATCHER_PROTECTION_TYPE$credentials_play_services_auth_release", "JSON_KEY_NAME", "getJSON_KEY_NAME$credentials_play_services_auth_release", "JSON_KEY_PUB_KEY_CRED_PARAMS", "getJSON_KEY_PUB_KEY_CRED_PARAMS$credentials_play_services_auth_release", "JSON_KEY_RAW_ID", "getJSON_KEY_RAW_ID$credentials_play_services_auth_release", "JSON_KEY_REQUIRE_RES_KEY", "getJSON_KEY_REQUIRE_RES_KEY$credentials_play_services_auth_release", "JSON_KEY_RESPONSE", "getJSON_KEY_RESPONSE$credentials_play_services_auth_release", "JSON_KEY_RES_KEY", "getJSON_KEY_RES_KEY$credentials_play_services_auth_release", "JSON_KEY_RK", "getJSON_KEY_RK$credentials_play_services_auth_release", "JSON_KEY_RP", "getJSON_KEY_RP$credentials_play_services_auth_release", "JSON_KEY_RPID", "getJSON_KEY_RPID$credentials_play_services_auth_release", "JSON_KEY_SIGNATURE", "getJSON_KEY_SIGNATURE$credentials_play_services_auth_release", "JSON_KEY_THIRD_PARTY_PAYMENT", "getJSON_KEY_THIRD_PARTY_PAYMENT$credentials_play_services_auth_release", "JSON_KEY_TIMEOUT", "getJSON_KEY_TIMEOUT$credentials_play_services_auth_release", "JSON_KEY_TRANSPORTS", "getJSON_KEY_TRANSPORTS$credentials_play_services_auth_release", "JSON_KEY_TYPE", "getJSON_KEY_TYPE$credentials_play_services_auth_release", "JSON_KEY_USER", "getJSON_KEY_USER$credentials_play_services_auth_release", "JSON_KEY_USER_HANDLE", "getJSON_KEY_USER_HANDLE$credentials_play_services_auth_release", "JSON_KEY_USER_VERIFICATION_METHOD", "getJSON_KEY_USER_VERIFICATION_METHOD$credentials_play_services_auth_release", "TAG", "orderedErrorCodeToExceptions", "Ljava/util/LinkedHashMap;", "Lcom/google/android/gms/fido/fido2/api/common/ErrorCode;", "Landroidx/credentials/exceptions/domerrors/DomError;", "Lkotlin/collections/LinkedHashMap;", "getOrderedErrorCodeToExceptions$credentials_play_services_auth_release", "()Ljava/util/LinkedHashMap;", "addAuthenticatorAttestationResponse", "", "clientDataJSON", "", "attestationObject", "transportArray", "", "json", "Lorg/json/JSONObject;", "addAuthenticatorAttestationResponse$credentials_play_services_auth_release", "([B[B[Ljava/lang/String;Lorg/json/JSONObject;)V", "b64Decode", "str", "b64Encode", "data", "beginSignInPublicKeyCredentialResponseContainsError", "Landroidx/credentials/exceptions/GetCredentialException;", "code", "msg", "beginSignInPublicKeyCredentialResponseContainsError$credentials_play_services_auth_release", "checkAlgSupported", "", "alg", "convert", "Lcom/google/android/gms/fido/fido2/api/common/PublicKeyCredentialCreationOptions;", "request", "Landroidx/credentials/CreatePublicKeyCredentialRequest;", "convertJSON", "convertJSON$credentials_play_services_auth_release", "convertToPlayAuthPasskeyJsonRequest", "Lcom/google/android/gms/auth/api/identity/BeginSignInRequest$PasskeyJsonRequestOptions;", "option", "Landroidx/credentials/GetPublicKeyCredentialOption;", "convertToPlayAuthPasskeyRequest", "Lcom/google/android/gms/auth/api/identity/BeginSignInRequest$PasskeysRequestOptions;", "getChallenge", "parseOptionalAuthenticatorSelection", "builder", "Lcom/google/android/gms/fido/fido2/api/common/PublicKeyCredentialCreationOptions$Builder;", "parseOptionalAuthenticatorSelection$credentials_play_services_auth_release", "parseOptionalExtensions", "parseOptionalExtensions$credentials_play_services_auth_release", "parseOptionalTimeout", "parseOptionalTimeout$credentials_play_services_auth_release", "parseOptionalWithRequiredDefaultsAttestationAndExcludeCredentials", "parseOptionalWithRequiredDefaultsAttestationAndExcludeCredentials$credentials_play_services_auth_release", "parseRequiredChallengeAndUser", "parseRequiredChallengeAndUser$credentials_play_services_auth_release", "parseRequiredRpAndParams", "parseRequiredRpAndParams$credentials_play_services_auth_release", "publicKeyCredentialResponseContainsError", "Landroidx/credentials/exceptions/CreateCredentialException;", "cred", "Lcom/google/android/gms/fido/fido2/api/common/PublicKeyCredential;", "toAssertPasskeyResponse", "Lcom/google/android/gms/auth/api/identity/SignInCredential;", "credentials-play-services-auth_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getJSON_KEY_CLIENT_DATA$credentials_play_services_auth_release() {
            return JSON_KEY_CLIENT_DATA;
        }

        @NotNull
        public final String getJSON_KEY_ATTESTATION_OBJ$credentials_play_services_auth_release() {
            return JSON_KEY_ATTESTATION_OBJ;
        }

        @NotNull
        public final String getJSON_KEY_AUTH_DATA$credentials_play_services_auth_release() {
            return JSON_KEY_AUTH_DATA;
        }

        @NotNull
        public final String getJSON_KEY_SIGNATURE$credentials_play_services_auth_release() {
            return JSON_KEY_SIGNATURE;
        }

        @NotNull
        public final String getJSON_KEY_USER_HANDLE$credentials_play_services_auth_release() {
            return JSON_KEY_USER_HANDLE;
        }

        @NotNull
        public final String getJSON_KEY_RESPONSE$credentials_play_services_auth_release() {
            return JSON_KEY_RESPONSE;
        }

        @NotNull
        public final String getJSON_KEY_ID$credentials_play_services_auth_release() {
            return JSON_KEY_ID;
        }

        @NotNull
        public final String getJSON_KEY_RAW_ID$credentials_play_services_auth_release() {
            return JSON_KEY_RAW_ID;
        }

        @NotNull
        public final String getJSON_KEY_TYPE$credentials_play_services_auth_release() {
            return JSON_KEY_TYPE;
        }

        @NotNull
        public final String getJSON_KEY_RPID$credentials_play_services_auth_release() {
            return JSON_KEY_RPID;
        }

        @NotNull
        public final String getJSON_KEY_CHALLENGE$credentials_play_services_auth_release() {
            return JSON_KEY_CHALLENGE;
        }

        @NotNull
        public final String getJSON_KEY_APPID$credentials_play_services_auth_release() {
            return JSON_KEY_APPID;
        }

        @NotNull
        public final String getJSON_KEY_THIRD_PARTY_PAYMENT$credentials_play_services_auth_release() {
            return JSON_KEY_THIRD_PARTY_PAYMENT;
        }

        @NotNull
        public final String getJSON_KEY_AUTH_SELECTION$credentials_play_services_auth_release() {
            return JSON_KEY_AUTH_SELECTION;
        }

        @NotNull
        public final String getJSON_KEY_REQUIRE_RES_KEY$credentials_play_services_auth_release() {
            return JSON_KEY_REQUIRE_RES_KEY;
        }

        @NotNull
        public final String getJSON_KEY_RES_KEY$credentials_play_services_auth_release() {
            return JSON_KEY_RES_KEY;
        }

        @NotNull
        public final String getJSON_KEY_AUTH_ATTACHMENT$credentials_play_services_auth_release() {
            return JSON_KEY_AUTH_ATTACHMENT;
        }

        @NotNull
        public final String getJSON_KEY_TIMEOUT$credentials_play_services_auth_release() {
            return JSON_KEY_TIMEOUT;
        }

        @NotNull
        public final String getJSON_KEY_EXCLUDE_CREDENTIALS$credentials_play_services_auth_release() {
            return JSON_KEY_EXCLUDE_CREDENTIALS;
        }

        @NotNull
        public final String getJSON_KEY_TRANSPORTS$credentials_play_services_auth_release() {
            return JSON_KEY_TRANSPORTS;
        }

        @NotNull
        public final String getJSON_KEY_RP$credentials_play_services_auth_release() {
            return JSON_KEY_RP;
        }

        @NotNull
        public final String getJSON_KEY_NAME$credentials_play_services_auth_release() {
            return JSON_KEY_NAME;
        }

        @NotNull
        public final String getJSON_KEY_ICON$credentials_play_services_auth_release() {
            return JSON_KEY_ICON;
        }

        @NotNull
        public final String getJSON_KEY_ALG$credentials_play_services_auth_release() {
            return JSON_KEY_ALG;
        }

        @NotNull
        public final String getJSON_KEY_USER$credentials_play_services_auth_release() {
            return JSON_KEY_USER;
        }

        @NotNull
        public final String getJSON_KEY_DISPLAY_NAME$credentials_play_services_auth_release() {
            return JSON_KEY_DISPLAY_NAME;
        }

        @NotNull
        public final String getJSON_KEY_USER_VERIFICATION_METHOD$credentials_play_services_auth_release() {
            return JSON_KEY_USER_VERIFICATION_METHOD;
        }

        @NotNull
        public final String getJSON_KEY_KEY_PROTECTION_TYPE$credentials_play_services_auth_release() {
            return JSON_KEY_KEY_PROTECTION_TYPE;
        }

        @NotNull
        public final String getJSON_KEY_MATCHER_PROTECTION_TYPE$credentials_play_services_auth_release() {
            return JSON_KEY_MATCHER_PROTECTION_TYPE;
        }

        @NotNull
        public final String getJSON_KEY_EXTENSTIONS$credentials_play_services_auth_release() {
            return JSON_KEY_EXTENSTIONS;
        }

        @NotNull
        public final String getJSON_KEY_ATTESTATION$credentials_play_services_auth_release() {
            return JSON_KEY_ATTESTATION;
        }

        @NotNull
        public final String getJSON_KEY_PUB_KEY_CRED_PARAMS$credentials_play_services_auth_release() {
            return JSON_KEY_PUB_KEY_CRED_PARAMS;
        }

        @NotNull
        public final String getJSON_KEY_CLIENT_EXTENSION_RESULTS$credentials_play_services_auth_release() {
            return JSON_KEY_CLIENT_EXTENSION_RESULTS;
        }

        @NotNull
        public final String getJSON_KEY_RK$credentials_play_services_auth_release() {
            return JSON_KEY_RK;
        }

        @NotNull
        public final String getJSON_KEY_CRED_PROPS$credentials_play_services_auth_release() {
            return JSON_KEY_CRED_PROPS;
        }

        @JvmStatic
        @NotNull
        public final PublicKeyCredentialCreationOptions convert(@NotNull CreatePublicKeyCredentialRequest request) {
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            return this.convertJSON$credentials_play_services_auth_release(new JSONObject(request.getRequestJson()));
        }

        @NotNull
        public final PublicKeyCredentialCreationOptions convertJSON$credentials_play_services_auth_release(@NotNull JSONObject json) {
            Intrinsics.checkNotNullParameter((Object)json, (String)"json");
            PublicKeyCredentialCreationOptions.Builder builder = new PublicKeyCredentialCreationOptions.Builder();
            this.parseRequiredChallengeAndUser$credentials_play_services_auth_release(json, builder);
            this.parseRequiredRpAndParams$credentials_play_services_auth_release(json, builder);
            this.parseOptionalWithRequiredDefaultsAttestationAndExcludeCredentials$credentials_play_services_auth_release(json, builder);
            this.parseOptionalTimeout$credentials_play_services_auth_release(json, builder);
            this.parseOptionalAuthenticatorSelection$credentials_play_services_auth_release(json, builder);
            this.parseOptionalExtensions$credentials_play_services_auth_release(json, builder);
            PublicKeyCredentialCreationOptions publicKeyCredentialCreationOptions = builder.build();
            Intrinsics.checkNotNullExpressionValue((Object)publicKeyCredentialCreationOptions, (String)"builder.build()");
            return publicKeyCredentialCreationOptions;
        }

        public final void addAuthenticatorAttestationResponse$credentials_play_services_auth_release(@NotNull byte[] clientDataJSON, @NotNull byte[] attestationObject, @NotNull String[] transportArray, @NotNull JSONObject json) {
            Intrinsics.checkNotNullParameter((Object)clientDataJSON, (String)"clientDataJSON");
            Intrinsics.checkNotNullParameter((Object)attestationObject, (String)"attestationObject");
            Intrinsics.checkNotNullParameter((Object)transportArray, (String)"transportArray");
            Intrinsics.checkNotNullParameter((Object)json, (String)"json");
            JSONObject responseJson = new JSONObject();
            responseJson.put(this.getJSON_KEY_CLIENT_DATA$credentials_play_services_auth_release(), (Object)this.b64Encode(clientDataJSON));
            responseJson.put(this.getJSON_KEY_ATTESTATION_OBJ$credentials_play_services_auth_release(), (Object)this.b64Encode(attestationObject));
            responseJson.put(this.getJSON_KEY_TRANSPORTS$credentials_play_services_auth_release(), (Object)new JSONArray((Object)transportArray));
            json.put(this.getJSON_KEY_RESPONSE$credentials_play_services_auth_release(), (Object)responseJson);
        }

        @NotNull
        public final String toAssertPasskeyResponse(@NotNull SignInCredential cred) {
            PublicKeyCredential publicKeyCred;
            Intrinsics.checkNotNullParameter((Object)cred, (String)"cred");
            JSONObject json = new JSONObject();
            PublicKeyCredential publicKeyCredential = publicKeyCred = cred.getPublicKeyCredential();
            Object object = publicKeyCredential != null ? publicKeyCredential.getResponse() : null;
            Intrinsics.checkNotNull((Object)object);
            AuthenticatorResponse authenticatorResponse = object;
            if (authenticatorResponse instanceof AuthenticatorErrorResponse) {
                ErrorCode errorCode = ((AuthenticatorErrorResponse)authenticatorResponse).getErrorCode();
                Intrinsics.checkNotNullExpressionValue((Object)errorCode, (String)"authenticatorResponse.errorCode");
                throw this.beginSignInPublicKeyCredentialResponseContainsError$credentials_play_services_auth_release(errorCode, ((AuthenticatorErrorResponse)authenticatorResponse).getErrorMessage());
            }
            if (authenticatorResponse instanceof AuthenticatorAssertionResponse) {
                try {
                    String string = publicKeyCred.toJson();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"publicKeyCred.toJson()");
                    return string;
                }
                catch (Throwable t) {
                    throw new GetCredentialUnknownException((CharSequence)("The PublicKeyCredential response json had an unexpected exception when parsing: " + t.getMessage()));
                }
            }
            Log.e((String)PublicKeyCredentialControllerUtility.TAG, (String)("AuthenticatorResponse expected assertion response but got: " + authenticatorResponse.getClass().getName()));
            String string = json.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"json.toString()");
            return string;
        }

        @NotNull
        public final BeginSignInRequest.PasskeyJsonRequestOptions convertToPlayAuthPasskeyJsonRequest(@NotNull GetPublicKeyCredentialOption option) {
            Intrinsics.checkNotNullParameter((Object)option, (String)"option");
            BeginSignInRequest.PasskeyJsonRequestOptions passkeyJsonRequestOptions = new BeginSignInRequest.PasskeyJsonRequestOptions.Builder().setSupported(true).setRequestJson(option.getRequestJson()).build();
            Intrinsics.checkNotNullExpressionValue((Object)passkeyJsonRequestOptions, (String)"Builder()\n        .setSu\u2026estJson)\n        .build()");
            return passkeyJsonRequestOptions;
        }

        @Deprecated(message="Upgrade GMS version so 'convertToPlayAuthPasskeyJsonRequest' is used")
        @NotNull
        public final BeginSignInRequest.PasskeysRequestOptions convertToPlayAuthPasskeyRequest(@NotNull GetPublicKeyCredentialOption option) {
            Intrinsics.checkNotNullParameter((Object)option, (String)"option");
            JSONObject json = new JSONObject(option.getRequestJson());
            String rpId = json.optString(this.getJSON_KEY_RPID$credentials_play_services_auth_release(), "");
            Intrinsics.checkNotNullExpressionValue((Object)rpId, (String)"rpId");
            if (((CharSequence)rpId).length() == 0) {
                throw new JSONException("GetPublicKeyCredentialOption - rpId not specified in the request or is unexpectedly empty");
            }
            byte[] challenge = this.getChallenge(json);
            BeginSignInRequest.PasskeysRequestOptions passkeysRequestOptions = new BeginSignInRequest.PasskeysRequestOptions.Builder().setSupported(true).setRpId(rpId).setChallenge(challenge).build();
            Intrinsics.checkNotNullExpressionValue((Object)passkeysRequestOptions, (String)"Builder()\n        .setSu\u2026allenge)\n        .build()");
            return passkeysRequestOptions;
        }

        private final byte[] getChallenge(JSONObject json) {
            String challengeB64 = json.optString(this.getJSON_KEY_CHALLENGE$credentials_play_services_auth_release(), "");
            Intrinsics.checkNotNullExpressionValue((Object)challengeB64, (String)"challengeB64");
            if (((CharSequence)challengeB64).length() == 0) {
                throw new JSONException("Challenge not found in request or is unexpectedly empty");
            }
            return this.b64Decode(challengeB64);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Nullable
        public final CreateCredentialException publicKeyCredentialResponseContainsError(@NotNull PublicKeyCredential cred) {
            Intrinsics.checkNotNullParameter((Object)cred, (String)"cred");
            AuthenticatorResponse authenticatorResponse = cred.getResponse();
            Intrinsics.checkNotNullExpressionValue((Object)authenticatorResponse, (String)"cred.response");
            AuthenticatorResponse authenticatorResponse2 = authenticatorResponse;
            if (!(authenticatorResponse2 instanceof AuthenticatorErrorResponse)) return null;
            ErrorCode errorCode = ((AuthenticatorErrorResponse)authenticatorResponse2).getErrorCode();
            Intrinsics.checkNotNullExpressionValue((Object)errorCode, (String)"authenticatorResponse.errorCode");
            ErrorCode code = errorCode;
            DomError exceptionError = this.getOrderedErrorCodeToExceptions$credentials_play_services_auth_release().get(code);
            String msg = ((AuthenticatorErrorResponse)authenticatorResponse2).getErrorMessage();
            CreateCredentialException exception = null;
            if (exceptionError == null) {
                return (CreateCredentialException)new CreatePublicKeyCredentialDomException((DomError)new UnknownError(), (CharSequence)("unknown fido gms exception - " + msg));
            }
            if (code != ErrorCode.CONSTRAINT_ERR) return (CreateCredentialException)new CreatePublicKeyCredentialDomException(exceptionError, (CharSequence)msg);
            String string = msg;
            if (!(string != null ? StringsKt.contains$default((CharSequence)string, (CharSequence)"Unable to get sync account", (boolean)false, (int)2, null) : false)) return (CreateCredentialException)new CreatePublicKeyCredentialDomException(exceptionError, (CharSequence)msg);
            return (CreateCredentialException)new CreateCredentialCancellationException((CharSequence)"Passkey registration was cancelled by the user.");
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @NotNull
        public final GetCredentialException beginSignInPublicKeyCredentialResponseContainsError$credentials_play_services_auth_release(@NotNull ErrorCode code, @Nullable String msg) {
            Intrinsics.checkNotNullParameter((Object)code, (String)"code");
            DomError exceptionError = this.getOrderedErrorCodeToExceptions$credentials_play_services_auth_release().get(code);
            GetCredentialException exception = null;
            if (exceptionError == null) {
                return (GetCredentialException)new GetPublicKeyCredentialDomException((DomError)new UnknownError(), (CharSequence)("unknown fido gms exception - " + msg));
            }
            if (code != ErrorCode.CONSTRAINT_ERR) return (GetCredentialException)new GetPublicKeyCredentialDomException(exceptionError, (CharSequence)msg);
            String string = msg;
            if (!(string != null ? StringsKt.contains$default((CharSequence)string, (CharSequence)"Unable to get sync account", (boolean)false, (int)2, null) : false)) return (GetCredentialException)new GetPublicKeyCredentialDomException(exceptionError, (CharSequence)msg);
            return (GetCredentialException)new GetCredentialCancellationException((CharSequence)"Passkey retrieval was cancelled by the user.");
        }

        public final void parseOptionalExtensions$credentials_play_services_auth_release(@NotNull JSONObject json, @NotNull PublicKeyCredentialCreationOptions.Builder builder) {
            Intrinsics.checkNotNullParameter((Object)json, (String)"json");
            Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
            if (json.has(this.getJSON_KEY_EXTENSTIONS$credentials_play_services_auth_release())) {
                boolean uvmStatus;
                boolean thirdPartyPaymentExtension;
                JSONObject extensions = json.getJSONObject(this.getJSON_KEY_EXTENSTIONS$credentials_play_services_auth_release());
                AuthenticationExtensions.Builder extensionBuilder = new AuthenticationExtensions.Builder();
                String appIdExtension = extensions.optString(this.getJSON_KEY_APPID$credentials_play_services_auth_release(), "");
                Intrinsics.checkNotNullExpressionValue((Object)appIdExtension, (String)"appIdExtension");
                if (((CharSequence)appIdExtension).length() > 0) {
                    extensionBuilder.setFido2Extension(new FidoAppIdExtension(appIdExtension));
                }
                if (thirdPartyPaymentExtension = extensions.optBoolean(this.getJSON_KEY_THIRD_PARTY_PAYMENT$credentials_play_services_auth_release(), false)) {
                    extensionBuilder.setGoogleThirdPartyPaymentExtension(new GoogleThirdPartyPaymentExtension(true));
                }
                if (uvmStatus = extensions.optBoolean("uvm", false)) {
                    extensionBuilder.setUserVerificationMethodExtension(new UserVerificationMethodExtension(true));
                }
                builder.setAuthenticationExtensions(extensionBuilder.build());
            }
        }

        public final void parseOptionalAuthenticatorSelection$credentials_play_services_auth_release(@NotNull JSONObject json, @NotNull PublicKeyCredentialCreationOptions.Builder builder) {
            Intrinsics.checkNotNullParameter((Object)json, (String)"json");
            Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
            if (json.has(this.getJSON_KEY_AUTH_SELECTION$credentials_play_services_auth_release())) {
                JSONObject authenticatorSelection = json.getJSONObject(this.getJSON_KEY_AUTH_SELECTION$credentials_play_services_auth_release());
                AuthenticatorSelectionCriteria.Builder authSelectionBuilder = new AuthenticatorSelectionCriteria.Builder();
                boolean requireResidentKey = authenticatorSelection.optBoolean(this.getJSON_KEY_REQUIRE_RES_KEY$credentials_play_services_auth_release(), false);
                String residentKey = authenticatorSelection.optString(this.getJSON_KEY_RES_KEY$credentials_play_services_auth_release(), "");
                ResidentKeyRequirement residentKeyRequirement = null;
                Intrinsics.checkNotNullExpressionValue((Object)residentKey, (String)"residentKey");
                if (((CharSequence)residentKey).length() > 0) {
                    residentKeyRequirement = ResidentKeyRequirement.fromString((String)residentKey);
                }
                authSelectionBuilder.setRequireResidentKey(Boolean.valueOf(requireResidentKey)).setResidentKeyRequirement(residentKeyRequirement);
                String authenticatorAttachmentString = authenticatorSelection.optString(this.getJSON_KEY_AUTH_ATTACHMENT$credentials_play_services_auth_release(), "");
                Intrinsics.checkNotNullExpressionValue((Object)authenticatorAttachmentString, (String)"authenticatorAttachmentString");
                if (((CharSequence)authenticatorAttachmentString).length() > 0) {
                    authSelectionBuilder.setAttachment(Attachment.fromString((String)authenticatorAttachmentString));
                }
                builder.setAuthenticatorSelection(authSelectionBuilder.build());
            }
        }

        public final void parseOptionalTimeout$credentials_play_services_auth_release(@NotNull JSONObject json, @NotNull PublicKeyCredentialCreationOptions.Builder builder) {
            Intrinsics.checkNotNullParameter((Object)json, (String)"json");
            Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
            if (json.has(this.getJSON_KEY_TIMEOUT$credentials_play_services_auth_release())) {
                double timeout = (double)json.getLong(this.getJSON_KEY_TIMEOUT$credentials_play_services_auth_release()) / (double)1000;
                builder.setTimeoutSeconds(Double.valueOf(timeout));
            }
        }

        public final void parseOptionalWithRequiredDefaultsAttestationAndExcludeCredentials$credentials_play_services_auth_release(@NotNull JSONObject json, @NotNull PublicKeyCredentialCreationOptions.Builder builder) {
            String attestationString;
            Intrinsics.checkNotNullParameter((Object)json, (String)"json");
            Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
            List excludeCredentialsList = new ArrayList();
            if (json.has(this.getJSON_KEY_EXCLUDE_CREDENTIALS$credentials_play_services_auth_release())) {
                JSONArray pubKeyDescriptorJSONs = json.getJSONArray(this.getJSON_KEY_EXCLUDE_CREDENTIALS$credentials_play_services_auth_release());
                int n = pubKeyDescriptorJSONs.length();
                for (int i = 0; i < n; ++i) {
                    JSONObject descriptorJSON = pubKeyDescriptorJSONs.getJSONObject(i);
                    String string = descriptorJSON.getString(this.getJSON_KEY_ID$credentials_play_services_auth_release());
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"descriptorJSON.getString(JSON_KEY_ID)");
                    byte[] descriptorId = this.b64Decode(string);
                    String descriptorType = descriptorJSON.getString(this.getJSON_KEY_TYPE$credentials_play_services_auth_release());
                    Intrinsics.checkNotNullExpressionValue((Object)descriptorType, (String)"descriptorType");
                    if (((CharSequence)descriptorType).length() == 0) {
                        throw new JSONException("PublicKeyCredentialDescriptor type value is not found or unexpectedly empty");
                    }
                    if (descriptorId.length == 0) {
                        throw new JSONException("PublicKeyCredentialDescriptor id value is not found or unexpectedly empty");
                    }
                    List transports = null;
                    if (descriptorJSON.has(this.getJSON_KEY_TRANSPORTS$credentials_play_services_auth_release())) {
                        transports = new ArrayList();
                        JSONArray descriptorTransports = descriptorJSON.getJSONArray(this.getJSON_KEY_TRANSPORTS$credentials_play_services_auth_release());
                        int n2 = descriptorTransports.length();
                        for (int j = 0; j < n2; ++j) {
                            try {
                                ArrayList arrayList = (ArrayList)transports;
                                Transport transport = Transport.fromString((String)descriptorTransports.getString(j));
                                Intrinsics.checkNotNullExpressionValue((Object)transport, (String)"fromString(descriptorTransports.getString(j))");
                                arrayList.add(transport);
                                continue;
                            }
                            catch (Transport.UnsupportedTransportException e) {
                                throw new CreatePublicKeyCredentialDomException((DomError)new EncodingError(), (CharSequence)e.getMessage());
                            }
                        }
                    }
                    excludeCredentialsList.add(new PublicKeyCredentialDescriptor(descriptorType, descriptorId, transports));
                }
            }
            builder.setExcludeList(excludeCredentialsList);
            String string = attestationString = json.optString(this.getJSON_KEY_ATTESTATION$credentials_play_services_auth_release(), "none");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"attestationString");
            if (((CharSequence)string).length() == 0) {
                attestationString = "none";
            }
            builder.setAttestationConveyancePreference(AttestationConveyancePreference.fromString((String)attestationString));
        }

        public final void parseRequiredRpAndParams$credentials_play_services_auth_release(@NotNull JSONObject json, @NotNull PublicKeyCredentialCreationOptions.Builder builder) {
            String rpIcon;
            Intrinsics.checkNotNullParameter((Object)json, (String)"json");
            Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
            JSONObject rp = json.getJSONObject(this.getJSON_KEY_RP$credentials_play_services_auth_release());
            String rpId = rp.getString(this.getJSON_KEY_ID$credentials_play_services_auth_release());
            String rpName = rp.optString(this.getJSON_KEY_NAME$credentials_play_services_auth_release(), "");
            String string = rpIcon = rp.optString(this.getJSON_KEY_ICON$credentials_play_services_auth_release(), "");
            Intrinsics.checkNotNull((Object)string);
            if (((CharSequence)string).length() == 0) {
                rpIcon = null;
            }
            Intrinsics.checkNotNullExpressionValue((Object)rpName, (String)"rpName");
            if (((CharSequence)rpName).length() == 0) {
                throw new JSONException("PublicKeyCredentialCreationOptions rp name is missing or unexpectedly empty");
            }
            Intrinsics.checkNotNullExpressionValue((Object)rpId, (String)"rpId");
            if (((CharSequence)rpId).length() == 0) {
                throw new JSONException("PublicKeyCredentialCreationOptions rp ID is missing or unexpectedly empty");
            }
            builder.setRp(new PublicKeyCredentialRpEntity(rpId, rpName, rpIcon));
            JSONArray pubKeyCredParams = json.getJSONArray(this.getJSON_KEY_PUB_KEY_CRED_PARAMS$credentials_play_services_auth_release());
            List paramsList = new ArrayList();
            int n = pubKeyCredParams.length();
            for (int i = 0; i < n; ++i) {
                JSONObject param = pubKeyCredParams.getJSONObject(i);
                int paramAlg = (int)param.getLong(this.getJSON_KEY_ALG$credentials_play_services_auth_release());
                String typeParam = param.optString(this.getJSON_KEY_TYPE$credentials_play_services_auth_release(), "");
                Intrinsics.checkNotNullExpressionValue((Object)typeParam, (String)"typeParam");
                if (((CharSequence)typeParam).length() == 0) {
                    throw new JSONException("PublicKeyCredentialCreationOptions PublicKeyCredentialParameter type missing or unexpectedly empty");
                }
                if (!this.checkAlgSupported(paramAlg)) continue;
                paramsList.add(new PublicKeyCredentialParameters(typeParam, paramAlg));
            }
            builder.setParameters(paramsList);
        }

        public final void parseRequiredChallengeAndUser$credentials_play_services_auth_release(@NotNull JSONObject json, @NotNull PublicKeyCredentialCreationOptions.Builder builder) {
            Intrinsics.checkNotNullParameter((Object)json, (String)"json");
            Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
            byte[] challenge = this.getChallenge(json);
            builder.setChallenge(challenge);
            JSONObject user = json.getJSONObject(this.getJSON_KEY_USER$credentials_play_services_auth_release());
            String string = user.getString(this.getJSON_KEY_ID$credentials_play_services_auth_release());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"user.getString(JSON_KEY_ID)");
            byte[] userId = this.b64Decode(string);
            String userName = user.getString(this.getJSON_KEY_NAME$credentials_play_services_auth_release());
            String displayName = user.getString(this.getJSON_KEY_DISPLAY_NAME$credentials_play_services_auth_release());
            String userIcon = user.optString(this.getJSON_KEY_ICON$credentials_play_services_auth_release(), "");
            Intrinsics.checkNotNullExpressionValue((Object)displayName, (String)"displayName");
            if (((CharSequence)displayName).length() == 0) {
                throw new JSONException("PublicKeyCredentialCreationOptions UserEntity missing displayName or they are unexpectedly empty");
            }
            if (userId.length == 0) {
                throw new JSONException("PublicKeyCredentialCreationOptions UserEntity missing user id or they are unexpectedly empty");
            }
            Intrinsics.checkNotNullExpressionValue((Object)userName, (String)"userName");
            if (((CharSequence)userName).length() == 0) {
                throw new JSONException("PublicKeyCredentialCreationOptions UserEntity missing user name or they are unexpectedly empty");
            }
            builder.setUser(new PublicKeyCredentialUserEntity(userId, userName, userIcon, displayName));
        }

        @NotNull
        public final byte[] b64Decode(@NotNull String str) {
            Intrinsics.checkNotNullParameter((Object)str, (String)"str");
            byte[] byArray = Base64.decode((String)str, (int)11);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"decode(str, FLAGS)");
            return byArray;
        }

        @NotNull
        public final String b64Encode(@NotNull byte[] data) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            String string = Base64.encodeToString((byte[])data, (int)11);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"encodeToString(data, FLAGS)");
            return string;
        }

        public final boolean checkAlgSupported(int alg) {
            try {
                COSEAlgorithmIdentifier.fromCoseValue((int)alg);
                return true;
            }
            catch (Throwable throwable) {
                return false;
            }
        }

        @NotNull
        public final LinkedHashMap<ErrorCode, DomError> getOrderedErrorCodeToExceptions$credentials_play_services_auth_release() {
            return orderedErrorCodeToExceptions;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

