/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.splashscreen;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.res.Resources;
import android.os.Build;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.WindowInsets;
import android.widget.ImageView;
import android.window.SplashScreen;
import android.window.SplashScreenView;
import androidx.annotation.MainThread;
import androidx.annotation.RequiresApi;
import androidx.core.splashscreen.R;
import androidx.core.splashscreen.SplashScreen;
import androidx.core.splashscreen.SplashScreenViewProvider;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0007\u0018\u0000 \u000f2\u00020\u0001:\u0006\u000f\u0010\u0011\u0012\u0013\u0014B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0002J\u000e\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eR\u0010\u0010\u0005\u001a\u00020\u00068\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Landroidx/core/splashscreen/SplashScreen;", "", "activity", "Landroid/app/Activity;", "(Landroid/app/Activity;)V", "impl", "Landroidx/core/splashscreen/SplashScreen$Impl;", "install", "", "setKeepVisibleCondition", "condition", "Landroidx/core/splashscreen/SplashScreen$KeepOnScreenCondition;", "setOnExitAnimationListener", "listener", "Landroidx/core/splashscreen/SplashScreen$OnExitAnimationListener;", "Companion", "Impl", "Impl23", "Impl31", "KeepOnScreenCondition", "OnExitAnimationListener", "core-splashscreen_release"})
@SuppressLint(value={"CustomSplashScreen"})
public final class SplashScreen {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @SuppressLint(value={"NewApi"})
    @NotNull
    private final Impl impl;

    private SplashScreen(Activity activity) {
        this.impl = Build.VERSION.SDK_INT >= 31 ? (Impl)new Impl31(activity) : (Build.VERSION.SDK_INT == 30 && Build.VERSION.PREVIEW_SDK_INT > 0 ? (Impl)new Impl31(activity) : (Build.VERSION.SDK_INT >= 23 ? (Impl)new Impl23(activity) : new Impl(activity)));
    }

    public final void setKeepVisibleCondition(@NotNull KeepOnScreenCondition condition) {
        Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
        this.impl.setKeepVisibleCondition(condition);
    }

    public final void setOnExitAnimationListener(@NotNull OnExitAnimationListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.impl.setOnExitAnimationListener(listener);
    }

    private final void install() {
        this.impl.install();
    }

    @JvmStatic
    @NotNull
    public static final SplashScreen installSplashScreen(@NotNull Activity $this$installSplashScreen) {
        return Companion.installSplashScreen($this$installSplashScreen);
    }

    public /* synthetic */ SplashScreen(Activity activity, DefaultConstructorMarker $constructor_marker) {
        this(activity);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\f\u0010\u0003\u001a\u00020\u0004*\u00020\u0005H\u0007\u00a8\u0006\u0006"}, d2={"Landroidx/core/splashscreen/SplashScreen$Companion;", "", "()V", "installSplashScreen", "Landroidx/core/splashscreen/SplashScreen;", "Landroid/app/Activity;", "core-splashscreen_release"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final SplashScreen installSplashScreen(@NotNull Activity $this$installSplashScreen) {
            Intrinsics.checkNotNullParameter((Object)$this$installSplashScreen, (String)"<this>");
            SplashScreen splashScreen = new SplashScreen($this$installSplashScreen, null);
            splashScreen.install();
            return splashScreen;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H'\u00a8\u0006\u0006"}, d2={"Landroidx/core/splashscreen/SplashScreen$OnExitAnimationListener;", "", "onSplashScreenExit", "", "splashScreenViewProvider", "Landroidx/core/splashscreen/SplashScreenViewProvider;", "core-splashscreen_release"})
    public static interface OnExitAnimationListener {
        @MainThread
        public void onSplashScreenExit(@NotNull SplashScreenViewProvider var1);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H'\u00a8\u0006\u0004"}, d2={"Landroidx/core/splashscreen/SplashScreen$KeepOnScreenCondition;", "", "shouldKeepOnScreen", "", "core-splashscreen_release"})
    public static interface KeepOnScreenCondition {
        @MainThread
        public boolean shouldKeepOnScreen();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0012\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u001cH\u0016J\u000e\u0010(\u001a\u00020$2\u0006\u0010'\u001a\u00020\u001cJ\b\u0010)\u001a\u00020$H\u0016J\u0010\u0010*\u001a\u00020$2\u0006\u0010+\u001a\u00020\u001eH\u0016J\u0010\u0010,\u001a\u00020$2\u0006\u0010-\u001a\u00020\bH\u0016J\u001c\u0010.\u001a\u00020$2\n\u0010/\u001a\u000600R\u0002012\u0006\u00102\u001a\u000203H\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\t\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u000f\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001e\u0010\u0010\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u000f\u001a\u0004\b\u0011\u0010\f\"\u0004\b\u0012\u0010\u000eR\u001a\u0010\u0013\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0015\"\u0004\b\u001a\u0010\u0017R\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001d\u001a\u00020\u001eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"\u00a8\u00064"}, d2={"Landroidx/core/splashscreen/SplashScreen$Impl;", "", "activity", "Landroid/app/Activity;", "(Landroid/app/Activity;)V", "getActivity", "()Landroid/app/Activity;", "animationListener", "Landroidx/core/splashscreen/SplashScreen$OnExitAnimationListener;", "backgroundColor", "", "getBackgroundColor", "()Ljava/lang/Integer;", "setBackgroundColor", "(Ljava/lang/Integer;)V", "Ljava/lang/Integer;", "backgroundResId", "getBackgroundResId", "setBackgroundResId", "finalThemeId", "getFinalThemeId", "()I", "setFinalThemeId", "(I)V", "icon", "getIcon", "setIcon", "mSplashScreenViewProvider", "Landroidx/core/splashscreen/SplashScreenViewProvider;", "splashScreenWaitPredicate", "Landroidx/core/splashscreen/SplashScreen$KeepOnScreenCondition;", "getSplashScreenWaitPredicate", "()Landroidx/core/splashscreen/SplashScreen$KeepOnScreenCondition;", "setSplashScreenWaitPredicate", "(Landroidx/core/splashscreen/SplashScreen$KeepOnScreenCondition;)V", "adjustInsets", "", "view", "Landroid/view/View;", "splashScreenViewProvider", "dispatchOnExitAnimation", "install", "setKeepVisibleCondition", "keepOnScreenCondition", "setOnExitAnimationListener", "exitAnimationListener", "setPostSplashScreenTheme", "currentTheme", "Landroid/content/res/Resources$Theme;", "Landroid/content/res/Resources;", "typedValue", "Landroid/util/TypedValue;", "core-splashscreen_release"})
    private static class Impl {
        @NotNull
        private final Activity activity;
        private int finalThemeId;
        @Nullable
        private Integer backgroundResId;
        @Nullable
        private Integer backgroundColor;
        private int icon;
        @NotNull
        private KeepOnScreenCondition splashScreenWaitPredicate;
        @Nullable
        private OnExitAnimationListener animationListener;
        @Nullable
        private SplashScreenViewProvider mSplashScreenViewProvider;

        public Impl(@NotNull Activity activity) {
            Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
            this.activity = activity;
            this.splashScreenWaitPredicate = splashScreenWaitPredicate.1.INSTANCE;
        }

        @NotNull
        public final Activity getActivity() {
            return this.activity;
        }

        public final int getFinalThemeId() {
            return this.finalThemeId;
        }

        public final void setFinalThemeId(int n) {
            this.finalThemeId = n;
        }

        @Nullable
        public final Integer getBackgroundResId() {
            return this.backgroundResId;
        }

        public final void setBackgroundResId(@Nullable Integer n) {
            this.backgroundResId = n;
        }

        @Nullable
        public final Integer getBackgroundColor() {
            return this.backgroundColor;
        }

        public final void setBackgroundColor(@Nullable Integer n) {
            this.backgroundColor = n;
        }

        public final int getIcon() {
            return this.icon;
        }

        public final void setIcon(int n) {
            this.icon = n;
        }

        @NotNull
        public final KeepOnScreenCondition getSplashScreenWaitPredicate() {
            return this.splashScreenWaitPredicate;
        }

        public final void setSplashScreenWaitPredicate(@NotNull KeepOnScreenCondition keepOnScreenCondition) {
            Intrinsics.checkNotNullParameter((Object)keepOnScreenCondition, (String)"<set-?>");
            this.splashScreenWaitPredicate = keepOnScreenCondition;
        }

        public void install() {
            TypedValue typedValue = new TypedValue();
            Resources.Theme currentTheme = this.activity.getTheme();
            if (currentTheme.resolveAttribute(R.attr.windowSplashScreenBackground, typedValue, true)) {
                this.backgroundResId = typedValue.resourceId;
                this.backgroundColor = typedValue.data;
            }
            if (currentTheme.resolveAttribute(R.attr.windowSplashScreenAnimatedIcon, typedValue, true)) {
                this.icon = typedValue.resourceId;
            }
            Intrinsics.checkNotNullExpressionValue((Object)currentTheme, (String)"currentTheme");
            this.setPostSplashScreenTheme(currentTheme, typedValue);
        }

        protected final void setPostSplashScreenTheme(@NotNull Resources.Theme currentTheme, @NotNull TypedValue typedValue) {
            Intrinsics.checkNotNullParameter((Object)currentTheme, (String)"currentTheme");
            Intrinsics.checkNotNullParameter((Object)typedValue, (String)"typedValue");
            if (currentTheme.resolveAttribute(R.attr.postSplashScreenTheme, typedValue, true)) {
                this.finalThemeId = typedValue.resourceId;
                if (this.finalThemeId != 0) {
                    this.activity.setTheme(this.finalThemeId);
                }
            } else {
                throw new Resources.NotFoundException(Intrinsics.stringPlus((String)"Cannot set AppTheme. No theme value defined for attribute ", (Object)this.activity.getResources().getResourceName(R.attr.postSplashScreenTheme)));
            }
        }

        public void setKeepVisibleCondition(@NotNull KeepOnScreenCondition keepOnScreenCondition) {
            Intrinsics.checkNotNullParameter((Object)keepOnScreenCondition, (String)"keepOnScreenCondition");
            this.splashScreenWaitPredicate = keepOnScreenCondition;
            View contentView = this.activity.findViewById(0x1020002);
            ViewTreeObserver observer = contentView.getViewTreeObserver();
            observer.addOnPreDrawListener(new ViewTreeObserver.OnPreDrawListener(this, contentView){
                final /* synthetic */ Impl this$0;
                final /* synthetic */ View $contentView;
                {
                    this.this$0 = $receiver;
                    this.$contentView = $contentView;
                }

                public boolean onPreDraw() {
                    if (this.this$0.getSplashScreenWaitPredicate().shouldKeepOnScreen()) {
                        return false;
                    }
                    this.$contentView.getViewTreeObserver().removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
                    SplashScreenViewProvider splashScreenViewProvider = Impl.access$getMSplashScreenViewProvider$p(this.this$0);
                    if (splashScreenViewProvider != null) {
                        SplashScreenViewProvider splashScreenViewProvider2 = splashScreenViewProvider;
                        Impl impl = this.this$0;
                        boolean bl = false;
                        boolean bl2 = false;
                        SplashScreenViewProvider p0 = splashScreenViewProvider2;
                        boolean bl3 = false;
                        impl.dispatchOnExitAnimation(p0);
                    }
                    return true;
                }
            });
        }

        /*
         * Unable to fully structure code
         */
        public void setOnExitAnimationListener(@NotNull OnExitAnimationListener exitAnimationListener) {
            Intrinsics.checkNotNullParameter((Object)exitAnimationListener, (String)"exitAnimationListener");
            this.animationListener = exitAnimationListener;
            splashScreenViewProvider = new SplashScreenViewProvider(this.activity);
            finalBackgroundResId = this.backgroundResId;
            finalBackgroundColor = this.backgroundColor;
            if (finalBackgroundResId == null) ** GOTO lbl-1000
            var5_5 = false;
            if (finalBackgroundResId != 0) {
                splashScreenViewProvider.getView().setBackgroundResource(finalBackgroundResId.intValue());
            } else if (finalBackgroundColor != null) {
                splashScreenViewProvider.getView().setBackgroundColor(finalBackgroundColor.intValue());
            } else {
                splashScreenViewProvider.getView().setBackground(this.activity.getWindow().getDecorView().getBackground());
            }
            ((ImageView)splashScreenViewProvider.getView().findViewById(R.id.splashscreen_icon_view)).setBackgroundResource(this.icon);
            splashScreenViewProvider.getView().addOnLayoutChangeListener(new View.OnLayoutChangeListener(this, splashScreenViewProvider){
                final /* synthetic */ Impl this$0;
                final /* synthetic */ SplashScreenViewProvider $splashScreenViewProvider;
                {
                    this.this$0 = $receiver;
                    this.$splashScreenViewProvider = $splashScreenViewProvider;
                }

                public void onLayoutChange(@NotNull View view, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
                    Intrinsics.checkNotNullParameter((Object)view, (String)"view");
                    this.this$0.adjustInsets(view, this.$splashScreenViewProvider);
                    if (!view.isAttachedToWindow()) {
                        return;
                    }
                    view.removeOnLayoutChangeListener((View.OnLayoutChangeListener)this);
                    if (!this.this$0.getSplashScreenWaitPredicate().shouldKeepOnScreen()) {
                        this.this$0.dispatchOnExitAnimation(this.$splashScreenViewProvider);
                    } else {
                        Impl.access$setMSplashScreenViewProvider$p(this.this$0, this.$splashScreenViewProvider);
                    }
                }
            });
        }

        public final void dispatchOnExitAnimation(@NotNull SplashScreenViewProvider splashScreenViewProvider) {
            Intrinsics.checkNotNullParameter((Object)splashScreenViewProvider, (String)"splashScreenViewProvider");
            OnExitAnimationListener onExitAnimationListener = this.animationListener;
            if (onExitAnimationListener == null) {
                return;
            }
            OnExitAnimationListener finalListener = onExitAnimationListener;
            this.animationListener = null;
            splashScreenViewProvider.getView().postOnAnimation(new Runnable(finalListener, splashScreenViewProvider){
                final /* synthetic */ OnExitAnimationListener $finalListener;
                final /* synthetic */ SplashScreenViewProvider $splashScreenViewProvider;
                {
                    this.$finalListener = $finalListener;
                    this.$splashScreenViewProvider = $splashScreenViewProvider;
                }

                public final void run() {
                    this.$finalListener.onSplashScreenExit(this.$splashScreenViewProvider);
                }
            });
        }

        public void adjustInsets(@NotNull View view, @NotNull SplashScreenViewProvider splashScreenViewProvider) {
            Intrinsics.checkNotNullParameter((Object)view, (String)"view");
            Intrinsics.checkNotNullParameter((Object)splashScreenViewProvider, (String)"splashScreenViewProvider");
        }

        public static final /* synthetic */ SplashScreenViewProvider access$getMSplashScreenViewProvider$p(Impl $this) {
            return $this.mSplashScreenViewProvider;
        }

        public static final /* synthetic */ void access$setMSplashScreenViewProvider$p(Impl $this, SplashScreenViewProvider splashScreenViewProvider) {
            $this.mSplashScreenViewProvider = splashScreenViewProvider;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Landroidx/core/splashscreen/SplashScreen$Impl23;", "Landroidx/core/splashscreen/SplashScreen$Impl;", "activity", "Landroid/app/Activity;", "(Landroid/app/Activity;)V", "adjustInsets", "", "view", "Landroid/view/View;", "splashScreenViewProvider", "Landroidx/core/splashscreen/SplashScreenViewProvider;", "core-splashscreen_release"})
    @RequiresApi(value=23)
    private static final class Impl23
    extends Impl {
        public Impl23(@NotNull Activity activity) {
            Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
            super(activity);
        }

        @Override
        public void adjustInsets(@NotNull View view, @NotNull SplashScreenViewProvider splashScreenViewProvider) {
            Intrinsics.checkNotNullParameter((Object)view, (String)"view");
            Intrinsics.checkNotNullParameter((Object)splashScreenViewProvider, (String)"splashScreenViewProvider");
            WindowInsets rootWindowInsets = view.getRootWindowInsets();
            int ty = rootWindowInsets.getSystemWindowInsetTop() - rootWindowInsets.getSystemWindowInsetBottom();
            splashScreenViewProvider.getIconView().setTranslationY(-((float)ty) / 2.0f);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\n\u00a8\u0006\u0013"}, d2={"Landroidx/core/splashscreen/SplashScreen$Impl31;", "Landroidx/core/splashscreen/SplashScreen$Impl;", "activity", "Landroid/app/Activity;", "(Landroid/app/Activity;)V", "preDrawListener", "Landroid/view/ViewTreeObserver$OnPreDrawListener;", "getPreDrawListener", "()Landroid/view/ViewTreeObserver$OnPreDrawListener;", "setPreDrawListener", "(Landroid/view/ViewTreeObserver$OnPreDrawListener;)V", "install", "", "setKeepVisibleCondition", "keepOnScreenCondition", "Landroidx/core/splashscreen/SplashScreen$KeepOnScreenCondition;", "setOnExitAnimationListener", "exitAnimationListener", "Landroidx/core/splashscreen/SplashScreen$OnExitAnimationListener;", "core-splashscreen_release"})
    @RequiresApi(value=31)
    private static final class Impl31
    extends Impl {
        @Nullable
        private ViewTreeObserver.OnPreDrawListener preDrawListener;

        public Impl31(@NotNull Activity activity) {
            Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
            super(activity);
        }

        @Nullable
        public final ViewTreeObserver.OnPreDrawListener getPreDrawListener() {
            return this.preDrawListener;
        }

        public final void setPreDrawListener(@Nullable ViewTreeObserver.OnPreDrawListener onPreDrawListener) {
            this.preDrawListener = onPreDrawListener;
        }

        @Override
        public void install() {
            Resources.Theme theme = this.getActivity().getTheme();
            Intrinsics.checkNotNullExpressionValue((Object)theme, (String)"activity.theme");
            this.setPostSplashScreenTheme(theme, new TypedValue());
        }

        @Override
        public void setKeepVisibleCondition(@NotNull KeepOnScreenCondition keepOnScreenCondition) {
            Intrinsics.checkNotNullParameter((Object)keepOnScreenCondition, (String)"keepOnScreenCondition");
            this.setSplashScreenWaitPredicate(keepOnScreenCondition);
            View contentView = this.getActivity().findViewById(0x1020002);
            ViewTreeObserver observer = contentView.getViewTreeObserver();
            if (this.preDrawListener != null && observer.isAlive()) {
                observer.removeOnPreDrawListener(this.preDrawListener);
            }
            this.preDrawListener = new ViewTreeObserver.OnPreDrawListener(this, contentView){
                final /* synthetic */ Impl31 this$0;
                final /* synthetic */ View $contentView;
                {
                    this.this$0 = $receiver;
                    this.$contentView = $contentView;
                }

                public boolean onPreDraw() {
                    if (this.this$0.getSplashScreenWaitPredicate().shouldKeepOnScreen()) {
                        return false;
                    }
                    this.$contentView.getViewTreeObserver().removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
                    return true;
                }
            };
            observer.addOnPreDrawListener(this.preDrawListener);
        }

        @Override
        public void setOnExitAnimationListener(@NotNull OnExitAnimationListener exitAnimationListener) {
            Intrinsics.checkNotNullParameter((Object)exitAnimationListener, (String)"exitAnimationListener");
            this.getActivity().getSplashScreen().setOnExitAnimationListener(new SplashScreen.OnExitAnimationListener(this, exitAnimationListener){
                final /* synthetic */ Impl31 this$0;
                final /* synthetic */ OnExitAnimationListener $exitAnimationListener;
                {
                    this.this$0 = $receiver;
                    this.$exitAnimationListener = $exitAnimationListener;
                }

                public final void onSplashScreenExit(@NotNull SplashScreenView it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    SplashScreenViewProvider splashScreenViewProvider = new SplashScreenViewProvider(it, this.this$0.getActivity());
                    this.$exitAnimationListener.onSplashScreenExit(splashScreenViewProvider);
                }
            });
        }
    }
}

