/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.os;

import android.os.Build;
import android.os.Bundle;
import android.os.IBinder;
import android.os.Parcelable;
import android.util.Size;
import android.util.SizeF;
import java.io.Serializable;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0002\u001a;\u0010\u0000\u001a\u00020\u00012.\u0010\u0002\u001a\u0018\u0012\u0014\b\u0001\u0012\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00040\u0003\"\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"bundleOf", "Landroid/os/Bundle;", "pairs", "", "Lkotlin/Pair;", "", "", "([Lkotlin/Pair;)Landroid/os/Bundle;", "core-ktx_release"})
public final class BundleKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Bundle bundleOf(Pair<String, ? extends Object> ... pairs) {
        Intrinsics.checkParameterIsNotNull(pairs, (String)"pairs");
        Bundle bundle = new Bundle(pairs.length);
        boolean bl = false;
        boolean bl2 = false;
        Bundle $this$apply = bundle;
        boolean bl3 = false;
        for (Pair<String, ? extends Object> pair : pairs) {
            void key;
            String string = (String)pair.component1();
            Object value = pair.component2();
            Object object = value;
            if (object == null) {
                $this$apply.putString((String)key, null);
                continue;
            }
            if (object instanceof Boolean) {
                $this$apply.putBoolean((String)key, ((Boolean)value).booleanValue());
                continue;
            }
            if (object instanceof Byte) {
                $this$apply.putByte((String)key, ((Number)value).byteValue());
                continue;
            }
            if (object instanceof Character) {
                $this$apply.putChar((String)key, ((Character)value).charValue());
                continue;
            }
            if (object instanceof Double) {
                $this$apply.putDouble((String)key, ((Number)value).doubleValue());
                continue;
            }
            if (object instanceof Float) {
                $this$apply.putFloat((String)key, ((Number)value).floatValue());
                continue;
            }
            if (object instanceof Integer) {
                $this$apply.putInt((String)key, ((Number)value).intValue());
                continue;
            }
            if (object instanceof Long) {
                $this$apply.putLong((String)key, ((Number)value).longValue());
                continue;
            }
            if (object instanceof Short) {
                $this$apply.putShort((String)key, ((Number)value).shortValue());
                continue;
            }
            if (object instanceof Bundle) {
                $this$apply.putBundle((String)key, (Bundle)value);
                continue;
            }
            if (object instanceof CharSequence) {
                $this$apply.putCharSequence((String)key, (CharSequence)value);
                continue;
            }
            if (object instanceof Parcelable) {
                $this$apply.putParcelable((String)key, (Parcelable)value);
                continue;
            }
            if (object instanceof boolean[]) {
                $this$apply.putBooleanArray((String)key, (boolean[])value);
                continue;
            }
            if (object instanceof byte[]) {
                $this$apply.putByteArray((String)key, (byte[])value);
                continue;
            }
            if (object instanceof char[]) {
                $this$apply.putCharArray((String)key, (char[])value);
                continue;
            }
            if (object instanceof double[]) {
                $this$apply.putDoubleArray((String)key, (double[])value);
                continue;
            }
            if (object instanceof float[]) {
                $this$apply.putFloatArray((String)key, (float[])value);
                continue;
            }
            if (object instanceof int[]) {
                $this$apply.putIntArray((String)key, (int[])value);
                continue;
            }
            if (object instanceof long[]) {
                $this$apply.putLongArray((String)key, (long[])value);
                continue;
            }
            if (object instanceof short[]) {
                $this$apply.putShortArray((String)key, (short[])value);
                continue;
            }
            if (object instanceof Object[]) {
                Class<?> componentType;
                if (value.getClass().getComponentType() == null) {
                    Intrinsics.throwNpe();
                }
                Intrinsics.checkExpressionValueIsNotNull(componentType, (String)"value::class.java.componentType!!");
                if (Parcelable.class.isAssignableFrom(componentType)) {
                    Object object2 = value;
                    if (object2 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<android.os.Parcelable>");
                    }
                    $this$apply.putParcelableArray((String)key, (Parcelable[])object2);
                    continue;
                }
                if (String.class.isAssignableFrom(componentType)) {
                    Object object3 = value;
                    if (object3 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<kotlin.String>");
                    }
                    $this$apply.putStringArray((String)key, (String[])object3);
                    continue;
                }
                if (CharSequence.class.isAssignableFrom(componentType)) {
                    Object object4 = value;
                    if (object4 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<kotlin.CharSequence>");
                    }
                    $this$apply.putCharSequenceArray((String)key, (CharSequence[])object4);
                    continue;
                }
                if (Serializable.class.isAssignableFrom(componentType)) {
                    $this$apply.putSerializable((String)key, (Serializable)value);
                    continue;
                }
                String valueType = componentType.getCanonicalName();
                throw (Throwable)new IllegalArgumentException("Illegal value array type " + valueType + " for key \"" + (String)key + '\"');
            }
            if (object instanceof Serializable) {
                $this$apply.putSerializable((String)key, (Serializable)value);
                continue;
            }
            if (Build.VERSION.SDK_INT >= 18 && value instanceof IBinder) {
                $this$apply.putBinder((String)key, (IBinder)value);
                continue;
            }
            if (Build.VERSION.SDK_INT >= 21 && value instanceof Size) {
                $this$apply.putSize((String)key, (Size)value);
                continue;
            }
            if (Build.VERSION.SDK_INT >= 21 && value instanceof SizeF) {
                $this$apply.putSizeF((String)key, (SizeF)value);
                continue;
            }
            String valueType = value.getClass().getCanonicalName();
            throw (Throwable)new IllegalArgumentException("Illegal value type " + valueType + " for key \"" + (String)key + '\"');
        }
        return bundle;
    }
}

