/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.view;

import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.Px;
import androidx.core.view.TreeIterator;
import androidx.core.view.ViewGroupKt;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000T\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010)\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\u001a\u0015\u0010\u0010\u001a\u00020\u0011*\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0002H\u0086\n\u001a0\u0010\u0013\u001a\u00020\u0014*\u00020\u00032!\u0010\u0015\u001a\u001d\u0012\u0013\u0012\u00110\u0002\u00a2\u0006\f\b\u0017\u0012\b\b\u0018\u0012\u0004\b\b(\u0012\u0012\u0004\u0012\u00020\u00140\u0016H\u0086\b\u001aE\u0010\u0019\u001a\u00020\u0014*\u00020\u000326\u0010\u0015\u001a2\u0012\u0013\u0012\u00110\r\u00a2\u0006\f\b\u0017\u0012\b\b\u0018\u0012\u0004\b\b(\u001b\u0012\u0013\u0012\u00110\u0002\u00a2\u0006\f\b\u0017\u0012\b\b\u0018\u0012\u0004\b\b(\u0012\u0012\u0004\u0012\u00020\u00140\u001aH\u0086\b\u001a\u0015\u0010\u001c\u001a\u00020\u0002*\u00020\u00032\u0006\u0010\u001b\u001a\u00020\rH\u0086\u0002\u001a\r\u0010\u001d\u001a\u00020\u0011*\u00020\u0003H\u0086\b\u001a\r\u0010\u001e\u001a\u00020\u0011*\u00020\u0003H\u0086\b\u001a\u0013\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00020 *\u00020\u0003H\u0086\u0002\u001a\u0015\u0010!\u001a\u00020\u0014*\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0002H\u0086\n\u001a\u0015\u0010\"\u001a\u00020\u0014*\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0002H\u0086\n\u001a\u0017\u0010#\u001a\u00020\u0014*\u00020$2\b\b\u0001\u0010\f\u001a\u00020\rH\u0086\b\u001a5\u0010%\u001a\u00020\u0014*\u00020$2\b\b\u0003\u0010&\u001a\u00020\r2\b\b\u0003\u0010'\u001a\u00020\r2\b\b\u0003\u0010(\u001a\u00020\r2\b\b\u0003\u0010)\u001a\u00020\rH\u0086\b\u001a5\u0010*\u001a\u00020\u0014*\u00020$2\b\b\u0003\u0010+\u001a\u00020\r2\b\b\u0003\u0010'\u001a\u00020\r2\b\b\u0003\u0010,\u001a\u00020\r2\b\b\u0003\u0010)\u001a\u00020\rH\u0086\b\"\u001b\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\"\u001b\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\u0005\"\u0016\u0010\b\u001a\u00020\t*\u00020\u00038\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\"\u0016\u0010\f\u001a\u00020\r*\u00020\u00038\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006-"}, d2={"children", "Lkotlin/sequences/Sequence;", "Landroid/view/View;", "Landroid/view/ViewGroup;", "getChildren", "(Landroid/view/ViewGroup;)Lkotlin/sequences/Sequence;", "descendants", "getDescendants", "indices", "Lkotlin/ranges/IntRange;", "getIndices", "(Landroid/view/ViewGroup;)Lkotlin/ranges/IntRange;", "size", "", "getSize", "(Landroid/view/ViewGroup;)I", "contains", "", "view", "forEach", "", "action", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "forEachIndexed", "Lkotlin/Function2;", "index", "get", "isEmpty", "isNotEmpty", "iterator", "", "minusAssign", "plusAssign", "setMargins", "Landroid/view/ViewGroup$MarginLayoutParams;", "updateMargins", "left", "top", "right", "bottom", "updateMarginsRelative", "start", "end", "core-ktx_release"})
public final class ViewGroupKt {
    @NotNull
    public static final View get(@NotNull ViewGroup $this$get, int index) {
        View view = $this$get.getChildAt(index);
        if (view == null) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + $this$get.getChildCount());
        }
        return view;
    }

    public static final boolean contains(@NotNull ViewGroup $this$contains, @NotNull View view) {
        boolean $i$f$contains = false;
        return $this$contains.indexOfChild(view) != -1;
    }

    public static final void plusAssign(@NotNull ViewGroup $this$plusAssign, @NotNull View view) {
        boolean $i$f$plusAssign = false;
        $this$plusAssign.addView(view);
    }

    public static final void minusAssign(@NotNull ViewGroup $this$minusAssign, @NotNull View view) {
        boolean $i$f$minusAssign = false;
        $this$minusAssign.removeView(view);
    }

    public static final int getSize(@NotNull ViewGroup $this$size) {
        boolean $i$f$getSize = false;
        return $this$size.getChildCount();
    }

    public static final boolean isEmpty(@NotNull ViewGroup $this$isEmpty) {
        boolean $i$f$isEmpty = false;
        return $this$isEmpty.getChildCount() == 0;
    }

    public static final boolean isNotEmpty(@NotNull ViewGroup $this$isNotEmpty) {
        boolean $i$f$isNotEmpty = false;
        return $this$isNotEmpty.getChildCount() != 0;
    }

    public static final void forEach(@NotNull ViewGroup $this$forEach, @NotNull Function1<? super View, Unit> action) {
        boolean $i$f$forEach = false;
        int n = $this$forEach.getChildCount();
        for (int index = 0; index < n; ++index) {
            action.invoke((Object)$this$forEach.getChildAt(index));
        }
    }

    public static final void forEachIndexed(@NotNull ViewGroup $this$forEachIndexed, @NotNull Function2<? super Integer, ? super View, Unit> action) {
        boolean $i$f$forEachIndexed = false;
        int n = $this$forEachIndexed.getChildCount();
        for (int index = 0; index < n; ++index) {
            action.invoke((Object)index, (Object)$this$forEachIndexed.getChildAt(index));
        }
    }

    @NotNull
    public static final IntRange getIndices(@NotNull ViewGroup $this$indices) {
        boolean $i$f$getIndices = false;
        return RangesKt.until((int)0, (int)$this$indices.getChildCount());
    }

    @NotNull
    public static final Iterator<View> iterator(@NotNull ViewGroup $this$iterator) {
        return new Iterator<View>($this$iterator){
            private int index;
            final /* synthetic */ ViewGroup $this_iterator;
            {
                this.$this_iterator = $receiver;
            }

            public boolean hasNext() {
                return this.index < this.$this_iterator.getChildCount();
            }

            @NotNull
            public View next() {
                int n = this.index;
                this.index = n + 1;
                View view = this.$this_iterator.getChildAt(n);
                if (view == null) {
                    throw new IndexOutOfBoundsException();
                }
                return view;
            }

            public void remove() {
                this.index += -1;
                this.$this_iterator.removeViewAt(this.index);
            }
        };
    }

    @NotNull
    public static final Sequence<View> getChildren(@NotNull ViewGroup $this$children) {
        return (Sequence)new Sequence<View>($this$children){
            final /* synthetic */ ViewGroup $this_children;
            {
                this.$this_children = $receiver;
            }

            @NotNull
            public Iterator<View> iterator() {
                return ViewGroupKt.iterator(this.$this_children);
            }
        };
    }

    @NotNull
    public static final Sequence<View> getDescendants(@NotNull ViewGroup $this$descendants) {
        return (Sequence)new Sequence<View>($this$descendants){
            final /* synthetic */ ViewGroup $this_descendants$inlined;
            {
                this.$this_descendants$inlined = viewGroup;
            }

            @NotNull
            public Iterator<View> iterator() {
                boolean bl = false;
                return new TreeIterator<T>(ViewGroupKt.getChildren(this.$this_descendants$inlined).iterator(), descendants.1.1.INSTANCE);
            }
        };
    }

    public static final void setMargins(@NotNull ViewGroup.MarginLayoutParams $this$setMargins, @Px int size) {
        boolean $i$f$setMargins = false;
        $this$setMargins.setMargins(size, size, size, size);
    }

    public static final void updateMargins(@NotNull ViewGroup.MarginLayoutParams $this$updateMargins, @Px int left, @Px int top, @Px int right, @Px int bottom) {
        boolean $i$f$updateMargins = false;
        $this$updateMargins.setMargins(left, top, right, bottom);
    }

    public static /* synthetic */ void updateMargins$default(ViewGroup.MarginLayoutParams $this$updateMargins_u24default, int left, int top, int right, int bottom, int n, Object object) {
        if ((n & 1) != 0) {
            left = $this$updateMargins_u24default.leftMargin;
        }
        if ((n & 2) != 0) {
            top = $this$updateMargins_u24default.topMargin;
        }
        if ((n & 4) != 0) {
            right = $this$updateMargins_u24default.rightMargin;
        }
        if ((n & 8) != 0) {
            bottom = $this$updateMargins_u24default.bottomMargin;
        }
        boolean $i$f$updateMargins = false;
        $this$updateMargins_u24default.setMargins(left, top, right, bottom);
    }

    public static final void updateMarginsRelative(@NotNull ViewGroup.MarginLayoutParams $this$updateMarginsRelative, @Px int start, @Px int top, @Px int end, @Px int bottom) {
        boolean $i$f$updateMarginsRelative = false;
        $this$updateMarginsRelative.setMarginStart(start);
        $this$updateMarginsRelative.topMargin = top;
        $this$updateMarginsRelative.setMarginEnd(end);
        $this$updateMarginsRelative.bottomMargin = bottom;
    }

    public static /* synthetic */ void updateMarginsRelative$default(ViewGroup.MarginLayoutParams $this$updateMarginsRelative_u24default, int start, int top, int end, int bottom, int n, Object object) {
        if ((n & 1) != 0) {
            start = $this$updateMarginsRelative_u24default.getMarginStart();
        }
        if ((n & 2) != 0) {
            top = $this$updateMarginsRelative_u24default.topMargin;
        }
        if ((n & 4) != 0) {
            end = $this$updateMarginsRelative_u24default.getMarginEnd();
        }
        if ((n & 8) != 0) {
            bottom = $this$updateMarginsRelative_u24default.bottomMargin;
        }
        boolean $i$f$updateMarginsRelative = false;
        $this$updateMarginsRelative_u24default.setMarginStart(start);
        $this$updateMarginsRelative_u24default.topMargin = top;
        $this$updateMarginsRelative_u24default.setMarginEnd(end);
        $this$updateMarginsRelative_u24default.bottomMargin = bottom;
    }
}

