/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.content.res;

import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.support.annotation.AnyRes;
import android.support.annotation.ColorInt;
import android.support.annotation.Dimension;
import android.support.annotation.RequiresApi;
import android.support.annotation.StyleableRes;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u0000R\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\r\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0016\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\b\b\u0001\u0010\u0003\u001a\u00020\u0004H\u0002\u001a\u0014\u0010\u0005\u001a\u00020\u0006*\u00020\u00022\b\b\u0001\u0010\u0003\u001a\u00020\u0004\u001a\u0016\u0010\u0007\u001a\u00020\u0004*\u00020\u00022\b\b\u0001\u0010\u0003\u001a\u00020\u0004H\u0007\u001a\u0014\u0010\b\u001a\u00020\t*\u00020\u00022\b\b\u0001\u0010\u0003\u001a\u00020\u0004\u001a\u0014\u0010\n\u001a\u00020\u000b*\u00020\u00022\b\b\u0001\u0010\u0003\u001a\u00020\u0004\u001a\u0016\u0010\f\u001a\u00020\u0004*\u00020\u00022\b\b\u0001\u0010\u0003\u001a\u00020\u0004H\u0007\u001a\u0016\u0010\r\u001a\u00020\u0004*\u00020\u00022\b\b\u0001\u0010\u0003\u001a\u00020\u0004H\u0007\u001a\u0014\u0010\u000e\u001a\u00020\u000f*\u00020\u00022\b\b\u0001\u0010\u0003\u001a\u00020\u0004\u001a\u0014\u0010\u0010\u001a\u00020\u000b*\u00020\u00022\b\b\u0001\u0010\u0003\u001a\u00020\u0004\u001a\u0016\u0010\u0011\u001a\u00020\u0012*\u00020\u00022\b\b\u0001\u0010\u0003\u001a\u00020\u0004H\u0007\u001a\u0014\u0010\u0013\u001a\u00020\u0004*\u00020\u00022\b\b\u0001\u0010\u0003\u001a\u00020\u0004\u001a\u0014\u0010\u0014\u001a\u00020\u0004*\u00020\u00022\b\b\u0001\u0010\u0003\u001a\u00020\u0004\u001a\u0016\u0010\u0015\u001a\u00020\u0004*\u00020\u00022\b\b\u0001\u0010\u0003\u001a\u00020\u0004H\u0007\u001a\u0014\u0010\u0016\u001a\u00020\u0017*\u00020\u00022\b\b\u0001\u0010\u0003\u001a\u00020\u0004\u001a\u001f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019*\u00020\u00022\b\b\u0001\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u001b\u001a\u0014\u0010\u001c\u001a\u00020\u001a*\u00020\u00022\b\b\u0001\u0010\u0003\u001a\u00020\u0004\u001a,\u0010\u001d\u001a\u0002H\u001e\"\u0004\b\u0000\u0010\u001e*\u00020\u00022\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u0002H\u001e0 H\u0086\b\u00a2\u0006\u0002\u0010!\u00a8\u0006\""}, d2={"checkAttribute", "", "Landroid/content/res/TypedArray;", "index", "", "getBooleanOrThrow", "", "getColorOrThrow", "getColorStateListOrThrow", "Landroid/content/res/ColorStateList;", "getDimensionOrThrow", "", "getDimensionPixelOffsetOrThrow", "getDimensionPixelSizeOrThrow", "getDrawableOrThrow", "Landroid/graphics/drawable/Drawable;", "getFloatOrThrow", "getFontOrThrow", "Landroid/graphics/Typeface;", "getIntOrThrow", "getIntegerOrThrow", "getResourceIdOrThrow", "getStringOrThrow", "", "getTextArrayOrThrow", "", "", "(Landroid/content/res/TypedArray;I)[Ljava/lang/CharSequence;", "getTextOrThrow", "use", "R", "block", "Lkotlin/Function1;", "(Landroid/content/res/TypedArray;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "core-ktx_release"})
public final class TypedArrayKt {
    private static final void checkAttribute(@NotNull TypedArray $receiver, @StyleableRes int index) {
        if (!$receiver.hasValue(index)) {
            throw (Throwable)new IllegalArgumentException("Attribute not defined in set.");
        }
    }

    public static final boolean getBooleanOrThrow(@NotNull TypedArray $receiver, @StyleableRes int index) {
        TypedArrayKt.checkAttribute($receiver, index);
        return $receiver.getBoolean(index, false);
    }

    @ColorInt
    public static final int getColorOrThrow(@NotNull TypedArray $receiver, @StyleableRes int index) {
        TypedArrayKt.checkAttribute($receiver, index);
        return $receiver.getColor(index, 0);
    }

    @NotNull
    public static final ColorStateList getColorStateListOrThrow(@NotNull TypedArray $receiver, @StyleableRes int index) {
        TypedArrayKt.checkAttribute($receiver, index);
        ColorStateList colorStateList = $receiver.getColorStateList(index);
        if (colorStateList == null) {
            String string = "Attribute value was not a color or color state list.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return colorStateList;
    }

    public static final float getDimensionOrThrow(@NotNull TypedArray $receiver, @StyleableRes int index) {
        TypedArrayKt.checkAttribute($receiver, index);
        return $receiver.getDimension(index, 0.0f);
    }

    @Dimension
    public static final int getDimensionPixelOffsetOrThrow(@NotNull TypedArray $receiver, @StyleableRes int index) {
        TypedArrayKt.checkAttribute($receiver, index);
        return $receiver.getDimensionPixelOffset(index, 0);
    }

    @Dimension
    public static final int getDimensionPixelSizeOrThrow(@NotNull TypedArray $receiver, @StyleableRes int index) {
        TypedArrayKt.checkAttribute($receiver, index);
        return $receiver.getDimensionPixelSize(index, 0);
    }

    @NotNull
    public static final Drawable getDrawableOrThrow(@NotNull TypedArray $receiver, @StyleableRes int index) {
        TypedArrayKt.checkAttribute($receiver, index);
        Drawable drawable = $receiver.getDrawable(index);
        Intrinsics.checkExpressionValueIsNotNull((Object)drawable, (String)"getDrawable(index)");
        return drawable;
    }

    public static final float getFloatOrThrow(@NotNull TypedArray $receiver, @StyleableRes int index) {
        TypedArrayKt.checkAttribute($receiver, index);
        return $receiver.getFloat(index, 0.0f);
    }

    @RequiresApi(value=26)
    @NotNull
    public static final Typeface getFontOrThrow(@NotNull TypedArray $receiver, @StyleableRes int index) {
        TypedArrayKt.checkAttribute($receiver, index);
        Typeface typeface = $receiver.getFont(index);
        Intrinsics.checkExpressionValueIsNotNull((Object)typeface, (String)"getFont(index)");
        return typeface;
    }

    public static final int getIntOrThrow(@NotNull TypedArray $receiver, @StyleableRes int index) {
        TypedArrayKt.checkAttribute($receiver, index);
        return $receiver.getInt(index, 0);
    }

    public static final int getIntegerOrThrow(@NotNull TypedArray $receiver, @StyleableRes int index) {
        TypedArrayKt.checkAttribute($receiver, index);
        return $receiver.getInteger(index, 0);
    }

    @AnyRes
    public static final int getResourceIdOrThrow(@NotNull TypedArray $receiver, @StyleableRes int index) {
        TypedArrayKt.checkAttribute($receiver, index);
        return $receiver.getResourceId(index, 0);
    }

    @NotNull
    public static final String getStringOrThrow(@NotNull TypedArray $receiver, @StyleableRes int index) {
        TypedArrayKt.checkAttribute($receiver, index);
        String string = $receiver.getString(index);
        if (string == null) {
            String string2 = "Attribute value could not be coerced to String.";
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        return string;
    }

    @NotNull
    public static final CharSequence getTextOrThrow(@NotNull TypedArray $receiver, @StyleableRes int index) {
        TypedArrayKt.checkAttribute($receiver, index);
        CharSequence charSequence = $receiver.getText(index);
        if (charSequence == null) {
            String string = "Attribute value could not be coerced to CharSequence.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return charSequence;
    }

    @NotNull
    public static final CharSequence[] getTextArrayOrThrow(@NotNull TypedArray $receiver, @StyleableRes int index) {
        TypedArrayKt.checkAttribute($receiver, index);
        CharSequence[] charSequenceArray = $receiver.getTextArray(index);
        Intrinsics.checkExpressionValueIsNotNull((Object)charSequenceArray, (String)"getTextArray(index)");
        return charSequenceArray;
    }

    public static final <R> R use(@NotNull TypedArray $receiver, @NotNull Function1<? super TypedArray, ? extends R> block) {
        Object object;
        Object it = object = block.invoke((Object)$receiver);
        $receiver.recycle();
        return (R)object;
    }
}

