/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.solver.widgets;

import androidx.constraintlayout.solver.LinearSystem;
import androidx.constraintlayout.solver.SolverVariable;
import androidx.constraintlayout.solver.widgets.ConstraintAnchor;
import androidx.constraintlayout.solver.widgets.ConstraintWidget;
import androidx.constraintlayout.solver.widgets.ConstraintWidgetContainer;
import java.util.HashMap;

public class Guideline
extends ConstraintWidget {
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    public static final int RELATIVE_PERCENT = 0;
    public static final int RELATIVE_BEGIN = 1;
    public static final int RELATIVE_END = 2;
    public static final int RELATIVE_UNKNWON = -1;
    protected float mRelativePercent = -1.0f;
    protected int mRelativeBegin = -1;
    protected int mRelativeEnd = -1;
    private ConstraintAnchor mAnchor = this.mTop;
    private int mOrientation = 0;
    private int mMinimumPosition = 0;
    private boolean resolved;

    public Guideline() {
        this.mAnchors.clear();
        this.mAnchors.add(this.mAnchor);
        int count = this.mListAnchors.length;
        for (int i = 0; i < count; ++i) {
            this.mListAnchors[i] = this.mAnchor;
        }
    }

    @Override
    public void copy(ConstraintWidget src, HashMap<ConstraintWidget, ConstraintWidget> map) {
        super.copy(src, map);
        Guideline srcGuideline = (Guideline)src;
        this.mRelativePercent = srcGuideline.mRelativePercent;
        this.mRelativeBegin = srcGuideline.mRelativeBegin;
        this.mRelativeEnd = srcGuideline.mRelativeEnd;
        this.setOrientation(srcGuideline.mOrientation);
    }

    @Override
    public boolean allowedInBarrier() {
        return true;
    }

    public int getRelativeBehaviour() {
        if (this.mRelativePercent != -1.0f) {
            return 0;
        }
        if (this.mRelativeBegin != -1) {
            return 1;
        }
        if (this.mRelativeEnd != -1) {
            return 2;
        }
        return -1;
    }

    public void setOrientation(int orientation) {
        if (this.mOrientation == orientation) {
            return;
        }
        this.mOrientation = orientation;
        this.mAnchors.clear();
        this.mAnchor = this.mOrientation == 1 ? this.mLeft : this.mTop;
        this.mAnchors.add(this.mAnchor);
        int count = this.mListAnchors.length;
        for (int i = 0; i < count; ++i) {
            this.mListAnchors[i] = this.mAnchor;
        }
    }

    public ConstraintAnchor getAnchor() {
        return this.mAnchor;
    }

    @Override
    public String getType() {
        return "Guideline";
    }

    public int getOrientation() {
        return this.mOrientation;
    }

    public void setMinimumPosition(int minimum) {
        this.mMinimumPosition = minimum;
    }

    @Override
    public ConstraintAnchor getAnchor(ConstraintAnchor.Type anchorType) {
        switch (anchorType) {
            case LEFT: 
            case RIGHT: {
                if (this.mOrientation != 1) break;
                return this.mAnchor;
            }
            case TOP: 
            case BOTTOM: {
                if (this.mOrientation != 0) break;
                return this.mAnchor;
            }
            case BASELINE: 
            case CENTER: 
            case CENTER_X: 
            case CENTER_Y: 
            case NONE: {
                return null;
            }
        }
        throw new AssertionError((Object)anchorType.name());
    }

    public void setGuidePercent(int value) {
        this.setGuidePercent((float)value / 100.0f);
    }

    public void setGuidePercent(float value) {
        if (value > -1.0f) {
            this.mRelativePercent = value;
            this.mRelativeBegin = -1;
            this.mRelativeEnd = -1;
        }
    }

    public void setGuideBegin(int value) {
        if (value > -1) {
            this.mRelativePercent = -1.0f;
            this.mRelativeBegin = value;
            this.mRelativeEnd = -1;
        }
    }

    public void setGuideEnd(int value) {
        if (value > -1) {
            this.mRelativePercent = -1.0f;
            this.mRelativeBegin = -1;
            this.mRelativeEnd = value;
        }
    }

    public float getRelativePercent() {
        return this.mRelativePercent;
    }

    public int getRelativeBegin() {
        return this.mRelativeBegin;
    }

    public int getRelativeEnd() {
        return this.mRelativeEnd;
    }

    public void setFinalValue(int position) {
        this.mAnchor.setFinalValue(position);
        this.resolved = true;
    }

    @Override
    public boolean isResolvedHorizontally() {
        return this.resolved;
    }

    @Override
    public boolean isResolvedVertically() {
        return this.resolved;
    }

    @Override
    public void addToSolver(LinearSystem system, boolean optimize) {
        boolean parentWrapContent;
        ConstraintWidgetContainer parent = (ConstraintWidgetContainer)this.getParent();
        if (parent == null) {
            return;
        }
        ConstraintAnchor begin = parent.getAnchor(ConstraintAnchor.Type.LEFT);
        ConstraintAnchor end = parent.getAnchor(ConstraintAnchor.Type.RIGHT);
        boolean bl = this.mParent != null ? this.mParent.mListDimensionBehaviors[0] == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT : (parentWrapContent = false);
        if (this.mOrientation == 0) {
            begin = parent.getAnchor(ConstraintAnchor.Type.TOP);
            end = parent.getAnchor(ConstraintAnchor.Type.BOTTOM);
            boolean bl2 = this.mParent != null ? this.mParent.mListDimensionBehaviors[1] == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT : (parentWrapContent = false);
        }
        if (this.resolved && this.mAnchor.hasFinalValue()) {
            SolverVariable guide = system.createObjectVariable(this.mAnchor);
            system.addEquality(guide, this.mAnchor.getFinalValue());
            if (this.mRelativeBegin != -1) {
                if (parentWrapContent) {
                    system.addGreaterThan(system.createObjectVariable(end), guide, 0, 5);
                }
            } else if (this.mRelativeEnd != -1 && parentWrapContent) {
                SolverVariable parentRight = system.createObjectVariable(end);
                system.addGreaterThan(guide, system.createObjectVariable(begin), 0, 5);
                system.addGreaterThan(parentRight, guide, 0, 5);
            }
            this.resolved = false;
            return;
        }
        if (this.mRelativeBegin != -1) {
            SolverVariable guide = system.createObjectVariable(this.mAnchor);
            SolverVariable parentLeft = system.createObjectVariable(begin);
            system.addEquality(guide, parentLeft, this.mRelativeBegin, 8);
            if (parentWrapContent) {
                system.addGreaterThan(system.createObjectVariable(end), guide, 0, 5);
            }
        } else if (this.mRelativeEnd != -1) {
            SolverVariable guide = system.createObjectVariable(this.mAnchor);
            SolverVariable parentRight = system.createObjectVariable(end);
            system.addEquality(guide, parentRight, -this.mRelativeEnd, 8);
            if (parentWrapContent) {
                system.addGreaterThan(guide, system.createObjectVariable(begin), 0, 5);
                system.addGreaterThan(parentRight, guide, 0, 5);
            }
        } else if (this.mRelativePercent != -1.0f) {
            SolverVariable guide = system.createObjectVariable(this.mAnchor);
            SolverVariable parentRight = system.createObjectVariable(end);
            system.addConstraint(LinearSystem.createRowDimensionPercent(system, guide, parentRight, this.mRelativePercent));
        }
    }

    @Override
    public void updateFromSolver(LinearSystem system, boolean optimize) {
        if (this.getParent() == null) {
            return;
        }
        int value = system.getObjectVariableValue(this.mAnchor);
        if (this.mOrientation == 1) {
            this.setX(value);
            this.setY(0);
            this.setHeight(this.getParent().getHeight());
            this.setWidth(0);
        } else {
            this.setX(0);
            this.setY(value);
            this.setWidth(this.getParent().getWidth());
            this.setHeight(0);
        }
    }

    void inferRelativePercentPosition() {
        float percent = (float)this.getX() / (float)this.getParent().getWidth();
        if (this.mOrientation == 0) {
            percent = (float)this.getY() / (float)this.getParent().getHeight();
        }
        this.setGuidePercent(percent);
    }

    void inferRelativeBeginPosition() {
        int position = this.getX();
        if (this.mOrientation == 0) {
            position = this.getY();
        }
        this.setGuideBegin(position);
    }

    void inferRelativeEndPosition() {
        int position = this.getParent().getWidth() - this.getX();
        if (this.mOrientation == 0) {
            position = this.getParent().getHeight() - this.getY();
        }
        this.setGuideEnd(position);
    }

    public void cyclePosition() {
        if (this.mRelativeBegin != -1) {
            this.inferRelativePercentPosition();
        } else if (this.mRelativePercent != -1.0f) {
            this.inferRelativeEndPosition();
        } else if (this.mRelativeEnd != -1) {
            this.inferRelativeBeginPosition();
        }
    }

    public boolean isPercent() {
        return this.mRelativePercent != -1.0f && this.mRelativeBegin == -1 && this.mRelativeEnd == -1;
    }
}

