/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.solver.widgets;

import androidx.constraintlayout.solver.LinearSystem;
import androidx.constraintlayout.solver.SolverVariable;
import androidx.constraintlayout.solver.widgets.ConstraintAnchor;
import androidx.constraintlayout.solver.widgets.ConstraintWidget;
import androidx.constraintlayout.solver.widgets.HelperWidget;
import java.util.HashMap;

public class Barrier
extends HelperWidget {
    public static final int LEFT = 0;
    public static final int RIGHT = 1;
    public static final int TOP = 2;
    public static final int BOTTOM = 3;
    private static final boolean USE_RESOLUTION = true;
    private int mBarrierType = 0;
    private boolean mAllowsGoneWidget = true;
    private int mMargin = 0;
    boolean resolved = false;

    public Barrier() {
    }

    public Barrier(String debugName) {
        this.setDebugName(debugName);
    }

    @Override
    public boolean allowedInBarrier() {
        return true;
    }

    public int getBarrierType() {
        return this.mBarrierType;
    }

    public void setBarrierType(int barrierType) {
        this.mBarrierType = barrierType;
    }

    public void setAllowsGoneWidget(boolean allowsGoneWidget) {
        this.mAllowsGoneWidget = allowsGoneWidget;
    }

    public boolean allowsGoneWidget() {
        return this.mAllowsGoneWidget;
    }

    @Override
    public boolean isResolvedHorizontally() {
        return this.resolved;
    }

    @Override
    public boolean isResolvedVertically() {
        return this.resolved;
    }

    @Override
    public void copy(ConstraintWidget src, HashMap<ConstraintWidget, ConstraintWidget> map) {
        super.copy(src, map);
        Barrier srcBarrier = (Barrier)src;
        this.mBarrierType = srcBarrier.mBarrierType;
        this.mAllowsGoneWidget = srcBarrier.mAllowsGoneWidget;
        this.mMargin = srcBarrier.mMargin;
    }

    @Override
    public String toString() {
        String debug = "[Barrier] " + this.getDebugName() + " {";
        for (int i = 0; i < this.mWidgetsCount; ++i) {
            ConstraintWidget widget = this.mWidgets[i];
            if (i > 0) {
                debug = debug + ", ";
            }
            debug = debug + widget.getDebugName();
        }
        debug = debug + "}";
        return debug;
    }

    protected void markWidgets() {
        for (int i = 0; i < this.mWidgetsCount; ++i) {
            ConstraintWidget widget = this.mWidgets[i];
            if (this.mBarrierType == 0 || this.mBarrierType == 1) {
                widget.setInBarrier(0, true);
                continue;
            }
            if (this.mBarrierType != 2 && this.mBarrierType != 3) continue;
            widget.setInBarrier(1, true);
        }
    }

    @Override
    public void addToSolver(LinearSystem system, boolean optimize) {
        this.mListAnchors[0] = this.mLeft;
        this.mListAnchors[2] = this.mTop;
        this.mListAnchors[1] = this.mRight;
        this.mListAnchors[3] = this.mBottom;
        for (int i = 0; i < this.mListAnchors.length; ++i) {
            this.mListAnchors[i].mSolverVariable = system.createObjectVariable(this.mListAnchors[i]);
        }
        if (this.mBarrierType < 0 || this.mBarrierType >= 4) {
            return;
        }
        ConstraintAnchor position = this.mListAnchors[this.mBarrierType];
        if (!this.resolved) {
            this.allSolved();
        }
        if (this.resolved) {
            this.resolved = false;
            if (this.mBarrierType == 0 || this.mBarrierType == 1) {
                system.addEquality(this.mLeft.mSolverVariable, this.mX);
                system.addEquality(this.mRight.mSolverVariable, this.mX);
            } else if (this.mBarrierType == 2 || this.mBarrierType == 3) {
                system.addEquality(this.mTop.mSolverVariable, this.mY);
                system.addEquality(this.mBottom.mSolverVariable, this.mY);
            }
            return;
        }
        boolean hasMatchConstraintWidgets = false;
        for (int i = 0; i < this.mWidgetsCount; ++i) {
            ConstraintWidget widget = this.mWidgets[i];
            if (!this.mAllowsGoneWidget && !widget.allowedInBarrier()) continue;
            if ((this.mBarrierType == 0 || this.mBarrierType == 1) && widget.getHorizontalDimensionBehaviour() == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT && widget.mLeft.mTarget != null && widget.mRight.mTarget != null) {
                hasMatchConstraintWidgets = true;
                break;
            }
            if (this.mBarrierType != 2 && this.mBarrierType != 3 || widget.getVerticalDimensionBehaviour() != ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT || widget.mTop.mTarget == null || widget.mBottom.mTarget == null) continue;
            hasMatchConstraintWidgets = true;
            break;
        }
        boolean mHasHorizontalCenteredDependents = this.mLeft.hasCenteredDependents() || this.mRight.hasCenteredDependents();
        boolean mHasVerticalCenteredDependents = this.mTop.hasCenteredDependents() || this.mBottom.hasCenteredDependents();
        boolean applyEqualityOnReferences = !hasMatchConstraintWidgets && (this.mBarrierType == 0 && mHasHorizontalCenteredDependents || this.mBarrierType == 2 && mHasVerticalCenteredDependents || this.mBarrierType == 1 && mHasHorizontalCenteredDependents || this.mBarrierType == 3 && mHasVerticalCenteredDependents);
        int equalityOnReferencesStrength = 5;
        if (!applyEqualityOnReferences) {
            equalityOnReferencesStrength = 4;
        }
        for (int i = 0; i < this.mWidgetsCount; ++i) {
            SolverVariable target;
            ConstraintWidget widget = this.mWidgets[i];
            if (!this.mAllowsGoneWidget && !widget.allowedInBarrier()) continue;
            widget.mListAnchors[this.mBarrierType].mSolverVariable = target = system.createObjectVariable(widget.mListAnchors[this.mBarrierType]);
            int margin = 0;
            if (widget.mListAnchors[this.mBarrierType].mTarget != null && widget.mListAnchors[this.mBarrierType].mTarget.mOwner == this) {
                margin += widget.mListAnchors[this.mBarrierType].mMargin;
            }
            if (this.mBarrierType == 0 || this.mBarrierType == 2) {
                system.addLowerBarrier(position.mSolverVariable, target, this.mMargin - margin, hasMatchConstraintWidgets);
            } else {
                system.addGreaterBarrier(position.mSolverVariable, target, this.mMargin + margin, hasMatchConstraintWidgets);
            }
            system.addEquality(position.mSolverVariable, target, this.mMargin + margin, equalityOnReferencesStrength);
        }
        int barrierParentStrength = 4;
        int barrierParentStrengthOpposite = 0;
        if (this.mBarrierType == 0) {
            system.addEquality(this.mRight.mSolverVariable, this.mLeft.mSolverVariable, 0, 8);
            system.addEquality(this.mLeft.mSolverVariable, this.mParent.mRight.mSolverVariable, 0, barrierParentStrength);
            system.addEquality(this.mLeft.mSolverVariable, this.mParent.mLeft.mSolverVariable, 0, barrierParentStrengthOpposite);
        } else if (this.mBarrierType == 1) {
            system.addEquality(this.mLeft.mSolverVariable, this.mRight.mSolverVariable, 0, 8);
            system.addEquality(this.mLeft.mSolverVariable, this.mParent.mLeft.mSolverVariable, 0, barrierParentStrength);
            system.addEquality(this.mLeft.mSolverVariable, this.mParent.mRight.mSolverVariable, 0, barrierParentStrengthOpposite);
        } else if (this.mBarrierType == 2) {
            system.addEquality(this.mBottom.mSolverVariable, this.mTop.mSolverVariable, 0, 8);
            system.addEquality(this.mTop.mSolverVariable, this.mParent.mBottom.mSolverVariable, 0, barrierParentStrength);
            system.addEquality(this.mTop.mSolverVariable, this.mParent.mTop.mSolverVariable, 0, barrierParentStrengthOpposite);
        } else if (this.mBarrierType == 3) {
            system.addEquality(this.mTop.mSolverVariable, this.mBottom.mSolverVariable, 0, 8);
            system.addEquality(this.mTop.mSolverVariable, this.mParent.mTop.mSolverVariable, 0, barrierParentStrength);
            system.addEquality(this.mTop.mSolverVariable, this.mParent.mBottom.mSolverVariable, 0, barrierParentStrengthOpposite);
        }
    }

    public void setMargin(int margin) {
        this.mMargin = margin;
    }

    public int getMargin() {
        return this.mMargin;
    }

    public int getOrientation() {
        switch (this.mBarrierType) {
            case 0: 
            case 1: {
                return 0;
            }
            case 2: 
            case 3: {
                return 1;
            }
        }
        return -1;
    }

    public boolean allSolved() {
        boolean hasAllWidgetsResolved = true;
        for (int i = 0; i < this.mWidgetsCount; ++i) {
            ConstraintWidget widget = this.mWidgets[i];
            if (!this.mAllowsGoneWidget && !widget.allowedInBarrier()) continue;
            if (!(this.mBarrierType != 0 && this.mBarrierType != 1 || widget.isResolvedHorizontally())) {
                hasAllWidgetsResolved = false;
                continue;
            }
            if (this.mBarrierType != 2 && this.mBarrierType != 3 || widget.isResolvedVertically()) continue;
            hasAllWidgetsResolved = false;
        }
        if (hasAllWidgetsResolved && this.mWidgetsCount > 0) {
            int barrierPosition = 0;
            boolean initialized = false;
            for (int i = 0; i < this.mWidgetsCount; ++i) {
                ConstraintWidget widget = this.mWidgets[i];
                if (!this.mAllowsGoneWidget && !widget.allowedInBarrier()) continue;
                if (!initialized) {
                    if (this.mBarrierType == 0) {
                        barrierPosition = widget.getAnchor(ConstraintAnchor.Type.LEFT).getFinalValue();
                    } else if (this.mBarrierType == 1) {
                        barrierPosition = widget.getAnchor(ConstraintAnchor.Type.RIGHT).getFinalValue();
                    } else if (this.mBarrierType == 2) {
                        barrierPosition = widget.getAnchor(ConstraintAnchor.Type.TOP).getFinalValue();
                    } else if (this.mBarrierType == 3) {
                        barrierPosition = widget.getAnchor(ConstraintAnchor.Type.BOTTOM).getFinalValue();
                    }
                    initialized = true;
                }
                if (this.mBarrierType == 0) {
                    barrierPosition = Math.min(barrierPosition, widget.getAnchor(ConstraintAnchor.Type.LEFT).getFinalValue());
                    continue;
                }
                if (this.mBarrierType == 1) {
                    barrierPosition = Math.max(barrierPosition, widget.getAnchor(ConstraintAnchor.Type.RIGHT).getFinalValue());
                    continue;
                }
                if (this.mBarrierType == 2) {
                    barrierPosition = Math.min(barrierPosition, widget.getAnchor(ConstraintAnchor.Type.TOP).getFinalValue());
                    continue;
                }
                if (this.mBarrierType != 3) continue;
                barrierPosition = Math.max(barrierPosition, widget.getAnchor(ConstraintAnchor.Type.BOTTOM).getFinalValue());
            }
            barrierPosition += this.mMargin;
            if (this.mBarrierType == 0 || this.mBarrierType == 1) {
                this.setFinalHorizontal(barrierPosition, barrierPosition);
            } else {
                this.setFinalVertical(barrierPosition, barrierPosition);
            }
            this.resolved = true;
            return true;
        }
        return false;
    }
}

