/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.solver.widgets;

import androidx.constraintlayout.solver.Cache;
import androidx.constraintlayout.solver.SolverVariable;
import androidx.constraintlayout.solver.widgets.ConstraintWidget;
import androidx.constraintlayout.solver.widgets.Guideline;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;

public class ConstraintAnchor {
    private static final boolean ALLOW_BINARY = false;
    private static final int UNSET_GONE_MARGIN = -1;
    public final ConstraintWidget mOwner;
    public final Type mType;
    public ConstraintAnchor mTarget;
    public int mMargin = 0;
    int mGoneMargin = -1;
    SolverVariable mSolverVariable;

    public void copyFrom(ConstraintAnchor source, HashMap<ConstraintWidget, ConstraintWidget> map) {
        if (source.mTarget != null) {
            Type type = source.mTarget.getType();
            ConstraintWidget owner = map.get(source.mTarget.mOwner);
            this.mTarget = owner.getAnchor(type);
        } else {
            this.mTarget = null;
        }
        this.mMargin = source.mMargin;
        this.mGoneMargin = source.mGoneMargin;
    }

    public ConstraintAnchor(ConstraintWidget owner, Type type) {
        this.mOwner = owner;
        this.mType = type;
    }

    public SolverVariable getSolverVariable() {
        return this.mSolverVariable;
    }

    public void resetSolverVariable(Cache cache) {
        if (this.mSolverVariable == null) {
            this.mSolverVariable = new SolverVariable(SolverVariable.Type.UNRESTRICTED, null);
        } else {
            this.mSolverVariable.reset();
        }
    }

    public ConstraintWidget getOwner() {
        return this.mOwner;
    }

    public Type getType() {
        return this.mType;
    }

    public int getMargin() {
        if (this.mOwner.getVisibility() == 8) {
            return 0;
        }
        if (this.mGoneMargin > -1 && this.mTarget != null && this.mTarget.mOwner.getVisibility() == 8) {
            return this.mGoneMargin;
        }
        return this.mMargin;
    }

    public ConstraintAnchor getTarget() {
        return this.mTarget;
    }

    public void reset() {
        this.mTarget = null;
        this.mMargin = 0;
        this.mGoneMargin = -1;
    }

    public boolean connect(ConstraintAnchor toAnchor, int margin, int goneMargin, boolean forceConnection) {
        if (toAnchor == null) {
            this.mTarget = null;
            this.mMargin = 0;
            this.mGoneMargin = -1;
            return true;
        }
        if (!forceConnection && !this.isValidConnection(toAnchor)) {
            return false;
        }
        this.mTarget = toAnchor;
        this.mMargin = margin > 0 ? margin : 0;
        this.mGoneMargin = goneMargin;
        return true;
    }

    public boolean connect(ConstraintAnchor toAnchor, int margin) {
        return this.connect(toAnchor, margin, -1, false);
    }

    public boolean isConnected() {
        return this.mTarget != null;
    }

    public boolean isValidConnection(ConstraintAnchor anchor) {
        if (anchor == null) {
            return false;
        }
        Type target = anchor.getType();
        if (target == this.mType) {
            return this.mType != Type.BASELINE || anchor.getOwner().hasBaseline() && this.getOwner().hasBaseline();
        }
        switch (this.mType) {
            case CENTER: {
                return target != Type.BASELINE && target != Type.CENTER_X && target != Type.CENTER_Y;
            }
            case LEFT: 
            case RIGHT: {
                boolean isCompatible;
                boolean bl = isCompatible = target == Type.LEFT || target == Type.RIGHT;
                if (anchor.getOwner() instanceof Guideline) {
                    isCompatible = isCompatible || target == Type.CENTER_X;
                }
                return isCompatible;
            }
            case TOP: 
            case BOTTOM: {
                boolean isCompatible;
                boolean bl = isCompatible = target == Type.TOP || target == Type.BOTTOM;
                if (anchor.getOwner() instanceof Guideline) {
                    isCompatible = isCompatible || target == Type.CENTER_Y;
                }
                return isCompatible;
            }
            case BASELINE: 
            case CENTER_X: 
            case CENTER_Y: 
            case NONE: {
                return false;
            }
        }
        throw new AssertionError((Object)this.mType.name());
    }

    public boolean isSideAnchor() {
        switch (this.mType) {
            case LEFT: 
            case RIGHT: 
            case TOP: 
            case BOTTOM: {
                return true;
            }
            case CENTER: 
            case BASELINE: 
            case CENTER_X: 
            case CENTER_Y: 
            case NONE: {
                return false;
            }
        }
        throw new AssertionError((Object)this.mType.name());
    }

    public boolean isSimilarDimensionConnection(ConstraintAnchor anchor) {
        Type target = anchor.getType();
        if (target == this.mType) {
            return true;
        }
        switch (this.mType) {
            case CENTER: {
                return target != Type.BASELINE;
            }
            case LEFT: 
            case RIGHT: 
            case CENTER_X: {
                return target == Type.LEFT || target == Type.RIGHT || target == Type.CENTER_X;
            }
            case TOP: 
            case BOTTOM: 
            case BASELINE: 
            case CENTER_Y: {
                return target == Type.TOP || target == Type.BOTTOM || target == Type.CENTER_Y || target == Type.BASELINE;
            }
            case NONE: {
                return false;
            }
        }
        throw new AssertionError((Object)this.mType.name());
    }

    public void setMargin(int margin) {
        if (this.isConnected()) {
            this.mMargin = margin;
        }
    }

    public void setGoneMargin(int margin) {
        if (this.isConnected()) {
            this.mGoneMargin = margin;
        }
    }

    public boolean isVerticalAnchor() {
        switch (this.mType) {
            case CENTER: 
            case LEFT: 
            case RIGHT: 
            case CENTER_X: {
                return false;
            }
            case TOP: 
            case BOTTOM: 
            case BASELINE: 
            case CENTER_Y: 
            case NONE: {
                return true;
            }
        }
        throw new AssertionError((Object)this.mType.name());
    }

    public String toString() {
        return this.mOwner.getDebugName() + ":" + this.mType.toString();
    }

    public boolean isConnectionAllowed(ConstraintWidget target, ConstraintAnchor anchor) {
        return this.isConnectionAllowed(target);
    }

    public boolean isConnectionAllowed(ConstraintWidget target) {
        HashSet<ConstraintWidget> checked = new HashSet<ConstraintWidget>();
        if (this.isConnectionToMe(target, checked)) {
            return false;
        }
        ConstraintWidget parent = this.getOwner().getParent();
        if (parent == target) {
            return true;
        }
        return target.getParent() == parent;
    }

    private boolean isConnectionToMe(ConstraintWidget target, HashSet<ConstraintWidget> checked) {
        if (checked.contains(target)) {
            return false;
        }
        checked.add(target);
        if (target == this.getOwner()) {
            return true;
        }
        ArrayList<ConstraintAnchor> targetAnchors = target.getAnchors();
        int targetAnchorsSize = targetAnchors.size();
        for (int i = 0; i < targetAnchorsSize; ++i) {
            ConstraintAnchor anchor = targetAnchors.get(i);
            if (!anchor.isSimilarDimensionConnection(this) || !anchor.isConnected() || !this.isConnectionToMe(anchor.getTarget().getOwner(), checked)) continue;
            return true;
        }
        return false;
    }

    public final ConstraintAnchor getOpposite() {
        switch (this.mType) {
            case LEFT: {
                return this.mOwner.mRight;
            }
            case RIGHT: {
                return this.mOwner.mLeft;
            }
            case TOP: {
                return this.mOwner.mBottom;
            }
            case BOTTOM: {
                return this.mOwner.mTop;
            }
            case CENTER: 
            case BASELINE: 
            case CENTER_X: 
            case CENTER_Y: 
            case NONE: {
                return null;
            }
        }
        throw new AssertionError((Object)this.mType.name());
    }

    public static enum Type {
        NONE,
        LEFT,
        TOP,
        RIGHT,
        BOTTOM,
        BASELINE,
        CENTER,
        CENTER_X,
        CENTER_Y;

    }
}

