/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.solver.widgets;

import androidx.constraintlayout.solver.widgets.ConstraintAnchor;
import androidx.constraintlayout.solver.widgets.ConstraintWidget;
import androidx.constraintlayout.solver.widgets.ConstraintWidgetContainer;
import androidx.constraintlayout.solver.widgets.Helper;

public class LinearGroup
extends ConstraintWidgetContainer
implements Helper {
    private boolean mConstraintsBuilt = false;
    private ContentAlignment mAlignment = ContentAlignment.MIDDLE;

    @Override
    public void removeAllIds() {
        this.removeAllChildren();
        this.mConstraintsBuilt = false;
    }

    @Override
    public void add(ConstraintWidget widget) {
        super.add(widget);
        this.mConstraintsBuilt = false;
    }

    public LinearGroup() {
    }

    public LinearGroup(int x, int y, int width, int height) {
        super(x, y, width, height);
    }

    public LinearGroup(int width, int height) {
        super(width, height);
    }

    public void buildConstraints() {
        if (this.mConstraintsBuilt) {
            return;
        }
        if (this.mChildren.size() != 0) {
            ConstraintWidget previous = this;
            int mChildrenSize = this.mChildren.size();
            for (int i = 0; i < mChildrenSize; ++i) {
                ConstraintWidget widget = (ConstraintWidget)this.mChildren.get(i);
                if (previous != this) {
                    widget.connect(ConstraintAnchor.Type.LEFT, previous, ConstraintAnchor.Type.RIGHT);
                    previous.connect(ConstraintAnchor.Type.RIGHT, widget, ConstraintAnchor.Type.LEFT);
                } else {
                    widget.connect(ConstraintAnchor.Type.LEFT, previous, ConstraintAnchor.Type.LEFT, 0);
                }
                widget.connect(ConstraintAnchor.Type.TOP, this, ConstraintAnchor.Type.TOP);
                widget.connect(ConstraintAnchor.Type.BOTTOM, this, ConstraintAnchor.Type.BOTTOM);
                previous = widget;
            }
            if (previous != this) {
                previous.connect(ConstraintAnchor.Type.RIGHT, this, ConstraintAnchor.Type.RIGHT, 0);
            }
        }
        this.mConstraintsBuilt = true;
    }

    @Override
    public void layout() {
        this.buildConstraints();
        super.layout();
    }

    public static enum ContentAlignment {
        BEGIN,
        MIDDLE,
        END,
        TOP,
        VERTICAL_MIDDLE,
        BOTTOM,
        LEFT,
        RIGHT;

    }
}

