/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.solver.widgets;

import androidx.constraintlayout.solver.LinearSystem;
import androidx.constraintlayout.solver.SolverVariable;
import androidx.constraintlayout.solver.widgets.ConstraintAnchor;
import androidx.constraintlayout.solver.widgets.ConstraintWidget;
import androidx.constraintlayout.solver.widgets.ConstraintWidgetContainer;
import androidx.constraintlayout.solver.widgets.Helper;
import androidx.constraintlayout.solver.widgets.ResolutionAnchor;
import java.util.ArrayList;

public class Barrier
extends Helper {
    public static final int LEFT = 0;
    public static final int RIGHT = 1;
    public static final int TOP = 2;
    public static final int BOTTOM = 3;
    private int mBarrierType = 0;
    private ArrayList<ResolutionAnchor> mNodes = new ArrayList(4);
    private boolean mAllowsGoneWidget = true;

    @Override
    public boolean allowedInBarrier() {
        return true;
    }

    public void setBarrierType(int barrierType) {
        this.mBarrierType = barrierType;
    }

    public void setAllowsGoneWidget(boolean allowsGoneWidget) {
        this.mAllowsGoneWidget = allowsGoneWidget;
    }

    @Override
    public void resetResolutionNodes() {
        super.resetResolutionNodes();
        this.mNodes.clear();
    }

    @Override
    public void analyze(int optimizationLevel) {
        ResolutionAnchor node;
        if (this.mParent == null) {
            return;
        }
        if (!((ConstraintWidgetContainer)this.mParent).optimizeFor(2)) {
            return;
        }
        switch (this.mBarrierType) {
            case 0: {
                node = this.mLeft.getResolutionNode();
                break;
            }
            case 1: {
                node = this.mRight.getResolutionNode();
                break;
            }
            case 2: {
                node = this.mTop.getResolutionNode();
                break;
            }
            case 3: {
                node = this.mBottom.getResolutionNode();
                break;
            }
            default: {
                return;
            }
        }
        node.setType(5);
        if (this.mBarrierType == 0 || this.mBarrierType == 1) {
            this.mTop.getResolutionNode().resolve(null, 0.0f);
            this.mBottom.getResolutionNode().resolve(null, 0.0f);
        } else {
            this.mLeft.getResolutionNode().resolve(null, 0.0f);
            this.mRight.getResolutionNode().resolve(null, 0.0f);
        }
        this.mNodes.clear();
        for (int i = 0; i < this.mWidgetsCount; ++i) {
            ConstraintWidget widget = this.mWidgets[i];
            if (!this.mAllowsGoneWidget && !widget.allowedInBarrier()) continue;
            ResolutionAnchor depends = null;
            switch (this.mBarrierType) {
                case 0: {
                    depends = widget.mLeft.getResolutionNode();
                    break;
                }
                case 1: {
                    depends = widget.mRight.getResolutionNode();
                    break;
                }
                case 2: {
                    depends = widget.mTop.getResolutionNode();
                    break;
                }
                case 3: {
                    depends = widget.mBottom.getResolutionNode();
                }
            }
            if (depends == null) continue;
            this.mNodes.add(depends);
            depends.addDependent(node);
        }
    }

    @Override
    public void resolve() {
        ResolutionAnchor node = null;
        float value = 0.0f;
        switch (this.mBarrierType) {
            case 0: {
                node = this.mLeft.getResolutionNode();
                value = Float.MAX_VALUE;
                break;
            }
            case 1: {
                node = this.mRight.getResolutionNode();
                break;
            }
            case 2: {
                node = this.mTop.getResolutionNode();
                value = Float.MAX_VALUE;
                break;
            }
            case 3: {
                node = this.mBottom.getResolutionNode();
                break;
            }
            default: {
                return;
            }
        }
        int count = this.mNodes.size();
        ResolutionAnchor resolvedTarget = null;
        for (int i = 0; i < count; ++i) {
            ResolutionAnchor n = this.mNodes.get(i);
            if (n.state != 1) {
                return;
            }
            if (this.mBarrierType == 0 || this.mBarrierType == 2) {
                if (!(n.resolvedOffset < value)) continue;
                value = n.resolvedOffset;
                resolvedTarget = n.resolvedTarget;
                continue;
            }
            if (!(n.resolvedOffset > value)) continue;
            value = n.resolvedOffset;
            resolvedTarget = n.resolvedTarget;
        }
        if (LinearSystem.getMetrics() != null) {
            ++LinearSystem.getMetrics().barrierConnectionResolved;
        }
        node.resolvedTarget = resolvedTarget;
        node.resolvedOffset = value;
        node.didResolve();
        switch (this.mBarrierType) {
            case 0: {
                this.mRight.getResolutionNode().resolve(resolvedTarget, value);
                break;
            }
            case 1: {
                this.mLeft.getResolutionNode().resolve(resolvedTarget, value);
                break;
            }
            case 2: {
                this.mBottom.getResolutionNode().resolve(resolvedTarget, value);
                break;
            }
            case 3: {
                this.mTop.getResolutionNode().resolve(resolvedTarget, value);
                break;
            }
            default: {
                return;
            }
        }
    }

    @Override
    public void addToSolver(LinearSystem system) {
        ConstraintWidget widget;
        int i;
        this.mListAnchors[0] = this.mLeft;
        this.mListAnchors[2] = this.mTop;
        this.mListAnchors[1] = this.mRight;
        this.mListAnchors[3] = this.mBottom;
        for (int i2 = 0; i2 < this.mListAnchors.length; ++i2) {
            this.mListAnchors[i2].mSolverVariable = system.createObjectVariable(this.mListAnchors[i2]);
        }
        if (this.mBarrierType < 0 || this.mBarrierType >= 4) {
            return;
        }
        ConstraintAnchor position = this.mListAnchors[this.mBarrierType];
        boolean hasMatchConstraintWidgets = false;
        for (i = 0; i < this.mWidgetsCount; ++i) {
            widget = this.mWidgets[i];
            if (!this.mAllowsGoneWidget && !widget.allowedInBarrier()) continue;
            if ((this.mBarrierType == 0 || this.mBarrierType == 1) && widget.getHorizontalDimensionBehaviour() == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT) {
                hasMatchConstraintWidgets = true;
                break;
            }
            if (this.mBarrierType != 2 && this.mBarrierType != 3 || widget.getVerticalDimensionBehaviour() != ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT) continue;
            hasMatchConstraintWidgets = true;
            break;
        }
        if (this.mBarrierType == 0 || this.mBarrierType == 1) {
            if (this.getParent().getHorizontalDimensionBehaviour() == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT) {
                hasMatchConstraintWidgets = false;
            }
        } else if (this.getParent().getVerticalDimensionBehaviour() == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT) {
            hasMatchConstraintWidgets = false;
        }
        for (i = 0; i < this.mWidgetsCount; ++i) {
            SolverVariable target;
            widget = this.mWidgets[i];
            if (!this.mAllowsGoneWidget && !widget.allowedInBarrier()) continue;
            widget.mListAnchors[this.mBarrierType].mSolverVariable = target = system.createObjectVariable(widget.mListAnchors[this.mBarrierType]);
            if (this.mBarrierType == 0 || this.mBarrierType == 2) {
                system.addLowerBarrier(position.mSolverVariable, target, hasMatchConstraintWidgets);
                continue;
            }
            system.addGreaterBarrier(position.mSolverVariable, target, hasMatchConstraintWidgets);
        }
        if (this.mBarrierType == 0) {
            system.addEquality(this.mRight.mSolverVariable, this.mLeft.mSolverVariable, 0, 6);
            if (!hasMatchConstraintWidgets) {
                system.addEquality(this.mLeft.mSolverVariable, this.mParent.mRight.mSolverVariable, 0, 5);
            }
        } else if (this.mBarrierType == 1) {
            system.addEquality(this.mLeft.mSolverVariable, this.mRight.mSolverVariable, 0, 6);
            if (!hasMatchConstraintWidgets) {
                system.addEquality(this.mLeft.mSolverVariable, this.mParent.mLeft.mSolverVariable, 0, 5);
            }
        } else if (this.mBarrierType == 2) {
            system.addEquality(this.mBottom.mSolverVariable, this.mTop.mSolverVariable, 0, 6);
            if (!hasMatchConstraintWidgets) {
                system.addEquality(this.mTop.mSolverVariable, this.mParent.mBottom.mSolverVariable, 0, 5);
            }
        } else if (this.mBarrierType == 3) {
            system.addEquality(this.mTop.mSolverVariable, this.mBottom.mSolverVariable, 0, 6);
            if (!hasMatchConstraintWidgets) {
                system.addEquality(this.mTop.mSolverVariable, this.mParent.mTop.mSolverVariable, 0, 5);
            }
        }
    }
}

