/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.utils;

import java.util.Arrays;

public class GridEngine {
    public static final int VERTICAL = 1;
    public static final int HORIZONTAL = 0;
    private static final int MAX_ROWS = 50;
    private static final int MAX_COLUMNS = 50;
    private static final int DEFAULT_SIZE = 3;
    private int mRows;
    private int mRowsSet;
    private int mNumWidgets;
    private int mColumns;
    private int mColumnsSet;
    private String mStrSpans;
    private String mStrSkips;
    private int mOrientation;
    private int mNextAvailableIndex = 0;
    private boolean[][] mPositionMatrix;
    private int[][] mConstraintMatrix;

    public GridEngine() {
    }

    public GridEngine(int rows, int columns) {
        this.mRowsSet = rows;
        this.mColumnsSet = columns;
        if (rows > 50) {
            this.mRowsSet = 3;
        }
        if (columns > 50) {
            this.mColumnsSet = 3;
        }
        this.updateActualRowsAndColumns();
        this.initVariables();
    }

    public GridEngine(int rows, int columns, int numWidgets) {
        this.mRowsSet = rows;
        this.mColumnsSet = columns;
        this.mNumWidgets = numWidgets;
        if (rows > 50) {
            this.mRowsSet = 3;
        }
        if (columns > 50) {
            this.mColumnsSet = 3;
        }
        this.updateActualRowsAndColumns();
        if (numWidgets > this.mRows * this.mColumns || numWidgets < 1) {
            this.mNumWidgets = this.mRows * this.mColumns;
        }
        this.initVariables();
        this.fillConstraintMatrix(false);
    }

    private void initVariables() {
        for (Object[] row : this.mPositionMatrix = new boolean[this.mRows][this.mColumns]) {
            Arrays.fill(row, true);
        }
        if (this.mNumWidgets > 0) {
            int[][] nArray = this.mConstraintMatrix = new int[this.mNumWidgets][4];
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                Object[] row;
                row = nArray[i];
                Arrays.fill((int[])row, -1);
            }
        }
    }

    private int getRowByIndex(int index) {
        if (this.mOrientation == 1) {
            return index % this.mRows;
        }
        return index / this.mColumns;
    }

    private int getColByIndex(int index) {
        if (this.mOrientation == 1) {
            return index / this.mRows;
        }
        return index % this.mColumns;
    }

    private boolean isSpansValid(CharSequence str) {
        return str != null;
    }

    private int[][] parseSpans(String str) {
        if (!this.isSpansValid(str)) {
            return null;
        }
        String[] spans = str.split(",");
        int[][] spanMatrix = new int[spans.length][3];
        for (int i = 0; i < spans.length; ++i) {
            String[] indexAndSpan = spans[i].trim().split(":");
            String[] rowAndCol = indexAndSpan[1].split("x");
            spanMatrix[i][0] = Integer.parseInt(indexAndSpan[0]);
            spanMatrix[i][1] = Integer.parseInt(rowAndCol[0]);
            spanMatrix[i][2] = Integer.parseInt(rowAndCol[1]);
        }
        return spanMatrix;
    }

    private void fillConstraintMatrix(boolean isUpdate) {
        int[][] mSpans;
        int[][] mSkips;
        if (isUpdate) {
            int j;
            int i;
            for (i = 0; i < this.mPositionMatrix.length; ++i) {
                for (j = 0; j < this.mPositionMatrix[0].length; ++j) {
                    this.mPositionMatrix[i][j] = true;
                }
            }
            for (i = 0; i < this.mConstraintMatrix.length; ++i) {
                for (j = 0; j < this.mConstraintMatrix[0].length; ++j) {
                    this.mConstraintMatrix[i][j] = -1;
                }
            }
        }
        this.mNextAvailableIndex = 0;
        if (this.mStrSkips != null && !this.mStrSkips.trim().isEmpty() && (mSkips = this.parseSpans(this.mStrSkips)) != null) {
            this.handleSkips(mSkips);
        }
        if (this.mStrSpans != null && !this.mStrSpans.trim().isEmpty() && (mSpans = this.parseSpans(this.mStrSpans)) != null) {
            this.handleSpans(mSpans);
        }
        this.addAllConstraintPositions();
    }

    private int getNextPosition() {
        int position = 0;
        boolean positionFound = false;
        while (!positionFound) {
            int col;
            if (this.mNextAvailableIndex >= this.mRows * this.mColumns) {
                return -1;
            }
            position = this.mNextAvailableIndex;
            int row = this.getRowByIndex(this.mNextAvailableIndex);
            if (this.mPositionMatrix[row][col = this.getColByIndex(this.mNextAvailableIndex)]) {
                this.mPositionMatrix[row][col] = false;
                positionFound = true;
            }
            ++this.mNextAvailableIndex;
        }
        return position;
    }

    private void addConstraintPosition(int widgetId, int row, int column, int rowSpan, int columnSpan) {
        this.mConstraintMatrix[widgetId][0] = column;
        this.mConstraintMatrix[widgetId][1] = row;
        this.mConstraintMatrix[widgetId][2] = column + columnSpan - 1;
        this.mConstraintMatrix[widgetId][3] = row + rowSpan - 1;
    }

    private void handleSpans(int[][] spansMatrix) {
        for (int i = 0; i < spansMatrix.length; ++i) {
            int col;
            int row = this.getRowByIndex(spansMatrix[i][0]);
            if (!this.invalidatePositions(row, col = this.getColByIndex(spansMatrix[i][0]), spansMatrix[i][1], spansMatrix[i][2])) {
                return;
            }
            this.addConstraintPosition(i, row, col, spansMatrix[i][1], spansMatrix[i][2]);
        }
    }

    private void handleSkips(int[][] skipsMatrix) {
        for (int i = 0; i < skipsMatrix.length; ++i) {
            int col;
            int row = this.getRowByIndex(skipsMatrix[i][0]);
            if (this.invalidatePositions(row, col = this.getColByIndex(skipsMatrix[i][0]), skipsMatrix[i][1], skipsMatrix[i][2])) continue;
            return;
        }
    }

    private boolean invalidatePositions(int startRow, int startColumn, int rowSpan, int columnSpan) {
        for (int i = startRow; i < startRow + rowSpan; ++i) {
            for (int j = startColumn; j < startColumn + columnSpan; ++j) {
                if (i >= this.mPositionMatrix.length || j >= this.mPositionMatrix[0].length || !this.mPositionMatrix[i][j]) {
                    return false;
                }
                this.mPositionMatrix[i][j] = false;
            }
        }
        return true;
    }

    private void addAllConstraintPositions() {
        for (int i = 0; i < this.mNumWidgets; ++i) {
            if (this.leftOfWidget(i) != -1) continue;
            int position = this.getNextPosition();
            int row = this.getRowByIndex(position);
            int col = this.getColByIndex(position);
            if (position == -1) {
                return;
            }
            this.addConstraintPosition(i, row, col, 1, 1);
        }
    }

    private void updateActualRowsAndColumns() {
        if (this.mRowsSet == 0 || this.mColumnsSet == 0) {
            if (this.mColumnsSet > 0) {
                this.mColumns = this.mColumnsSet;
                this.mRows = (this.mNumWidgets + this.mColumns - 1) / this.mColumnsSet;
            } else if (this.mRowsSet > 0) {
                this.mRows = this.mRowsSet;
                this.mColumns = (this.mNumWidgets + this.mRowsSet - 1) / this.mRowsSet;
            } else {
                this.mRows = (int)(1.5 + Math.sqrt(this.mNumWidgets));
                this.mColumns = (this.mNumWidgets + this.mRows - 1) / this.mRows;
            }
        } else {
            this.mRows = this.mRowsSet;
            this.mColumns = this.mColumnsSet;
        }
    }

    public void setup() {
        boolean isUpdate = true;
        if (this.mConstraintMatrix == null || this.mConstraintMatrix.length != this.mNumWidgets || this.mPositionMatrix == null || this.mPositionMatrix.length != this.mRows || this.mPositionMatrix[0].length != this.mColumns) {
            isUpdate = false;
        }
        if (!isUpdate) {
            this.initVariables();
        }
        this.fillConstraintMatrix(isUpdate);
    }

    public void setSpans(CharSequence spans) {
        if (this.mStrSpans != null && this.mStrSpans.equals(spans.toString())) {
            return;
        }
        this.mStrSpans = spans.toString();
    }

    public void setSkips(String skips) {
        if (this.mStrSkips != null && this.mStrSkips.equals(skips)) {
            return;
        }
        this.mStrSkips = skips;
    }

    public void setOrientation(int orientation) {
        if (orientation != 0 && orientation != 1) {
            return;
        }
        if (this.mOrientation == orientation) {
            return;
        }
        this.mOrientation = orientation;
    }

    public void setNumWidgets(int num) {
        if (num > this.mRows * this.mColumns) {
            return;
        }
        this.mNumWidgets = num;
    }

    public void setRows(int rows) {
        if (rows > 50) {
            return;
        }
        if (this.mRowsSet == rows) {
            return;
        }
        this.mRowsSet = rows;
        this.updateActualRowsAndColumns();
    }

    public void setColumns(int columns) {
        if (columns > 50) {
            return;
        }
        if (this.mColumnsSet == columns) {
            return;
        }
        this.mColumnsSet = columns;
        this.updateActualRowsAndColumns();
    }

    public int leftOfWidget(int i) {
        if (this.mConstraintMatrix == null || i >= this.mConstraintMatrix.length) {
            return 0;
        }
        return this.mConstraintMatrix[i][0];
    }

    public int topOfWidget(int i) {
        if (this.mConstraintMatrix == null || i >= this.mConstraintMatrix.length) {
            return 0;
        }
        return this.mConstraintMatrix[i][1];
    }

    public int rightOfWidget(int i) {
        if (this.mConstraintMatrix == null || i >= this.mConstraintMatrix.length) {
            return 0;
        }
        return this.mConstraintMatrix[i][2];
    }

    public int bottomOfWidget(int i) {
        if (this.mConstraintMatrix == null || i >= this.mConstraintMatrix.length) {
            return 0;
        }
        return this.mConstraintMatrix[i][3];
    }
}

