/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.motion.key;

import androidx.constraintlayout.core.motion.CustomVariable;
import androidx.constraintlayout.core.motion.MotionWidget;
import androidx.constraintlayout.core.motion.key.MotionKey;
import androidx.constraintlayout.core.motion.utils.FloatRect;
import androidx.constraintlayout.core.motion.utils.SplineSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;

public class MotionKeyTrigger
extends MotionKey {
    private static final String TAG = "KeyTrigger";
    public static final String VIEW_TRANSITION_ON_CROSS = "viewTransitionOnCross";
    public static final String VIEW_TRANSITION_ON_POSITIVE_CROSS = "viewTransitionOnPositiveCross";
    public static final String VIEW_TRANSITION_ON_NEGATIVE_CROSS = "viewTransitionOnNegativeCross";
    public static final String POST_LAYOUT = "postLayout";
    public static final String TRIGGER_SLACK = "triggerSlack";
    public static final String TRIGGER_COLLISION_VIEW = "triggerCollisionView";
    public static final String TRIGGER_COLLISION_ID = "triggerCollisionId";
    public static final String TRIGGER_ID = "triggerID";
    public static final String POSITIVE_CROSS = "positiveCross";
    public static final String NEGATIVE_CROSS = "negativeCross";
    public static final String TRIGGER_RECEIVER = "triggerReceiver";
    public static final String CROSS = "CROSS";
    private int mCurveFit = -1;
    private String mCross = null;
    private int mTriggerReceiver = UNSET;
    private String mNegativeCross = null;
    private String mPositiveCross = null;
    private int mTriggerID = UNSET;
    private int mTriggerCollisionId = UNSET;
    float mTriggerSlack = 0.1f;
    private boolean mFireCrossReset = true;
    private boolean mFireNegativeReset = true;
    private boolean mFirePositiveReset = true;
    private float mFireThreshold = Float.NaN;
    private float mFireLastPos;
    private boolean mPostLayout = false;
    int mViewTransitionOnNegativeCross = UNSET;
    int mViewTransitionOnPositiveCross = UNSET;
    int mViewTransitionOnCross = UNSET;
    public static final int TYPE_VIEW_TRANSITION_ON_CROSS = 301;
    public static final int TYPE_VIEW_TRANSITION_ON_POSITIVE_CROSS = 302;
    public static final int TYPE_VIEW_TRANSITION_ON_NEGATIVE_CROSS = 303;
    public static final int TYPE_POST_LAYOUT = 304;
    public static final int TYPE_TRIGGER_SLACK = 305;
    public static final int TYPE_TRIGGER_COLLISION_VIEW = 306;
    public static final int TYPE_TRIGGER_COLLISION_ID = 307;
    public static final int TYPE_TRIGGER_ID = 308;
    public static final int TYPE_POSITIVE_CROSS = 309;
    public static final int TYPE_NEGATIVE_CROSS = 310;
    public static final int TYPE_TRIGGER_RECEIVER = 311;
    public static final int TYPE_CROSS = 312;
    FloatRect mCollisionRect = new FloatRect();
    FloatRect mTargetRect = new FloatRect();
    public static final int KEY_TYPE = 5;

    public MotionKeyTrigger() {
        this.mType = 5;
        this.mCustom = new HashMap();
    }

    @Override
    public void getAttributeNames(HashSet<String> attributes) {
    }

    @Override
    public void addValues(HashMap<String, SplineSet> splines) {
    }

    @Override
    public int getId(String name) {
        switch (name) {
            case "viewTransitionOnCross": {
                return 301;
            }
            case "viewTransitionOnPositiveCross": {
                return 302;
            }
            case "viewTransitionOnNegativeCross": {
                return 303;
            }
            case "postLayout": {
                return 304;
            }
            case "triggerSlack": {
                return 305;
            }
            case "triggerCollisionView": {
                return 306;
            }
            case "triggerCollisionId": {
                return 307;
            }
            case "triggerID": {
                return 308;
            }
            case "positiveCross": {
                return 309;
            }
            case "negativeCross": {
                return 310;
            }
            case "triggerReceiver": {
                return 311;
            }
        }
        return -1;
    }

    @Override
    public MotionKeyTrigger copy(MotionKey src) {
        super.copy(src);
        MotionKeyTrigger k = (MotionKeyTrigger)src;
        this.mCurveFit = k.mCurveFit;
        this.mCross = k.mCross;
        this.mTriggerReceiver = k.mTriggerReceiver;
        this.mNegativeCross = k.mNegativeCross;
        this.mPositiveCross = k.mPositiveCross;
        this.mTriggerID = k.mTriggerID;
        this.mTriggerCollisionId = k.mTriggerCollisionId;
        this.mTriggerSlack = k.mTriggerSlack;
        this.mFireCrossReset = k.mFireCrossReset;
        this.mFireNegativeReset = k.mFireNegativeReset;
        this.mFirePositiveReset = k.mFirePositiveReset;
        this.mFireThreshold = k.mFireThreshold;
        this.mFireLastPos = k.mFireLastPos;
        this.mPostLayout = k.mPostLayout;
        this.mCollisionRect = k.mCollisionRect;
        this.mTargetRect = k.mTargetRect;
        return this;
    }

    @Override
    public MotionKey clone() {
        return new MotionKeyTrigger().copy(this);
    }

    private void fireCustom(String str, MotionWidget widget) {
        boolean callAll;
        boolean bl = callAll = str.length() == 1;
        if (!callAll) {
            str = str.substring(1).toLowerCase(Locale.ROOT);
        }
        for (String name : this.mCustom.keySet()) {
            CustomVariable custom;
            String lowerCase = name.toLowerCase(Locale.ROOT);
            if (!callAll && !lowerCase.matches(str) || (custom = (CustomVariable)this.mCustom.get(name)) == null) continue;
            custom.applyToWidget(widget);
        }
    }

    public void conditionallyFire(float position, MotionWidget child) {
    }

    @Override
    public boolean setValue(int type, int value) {
        switch (type) {
            case 311: {
                this.mTriggerReceiver = value;
                break;
            }
            case 308: {
                this.mTriggerID = this.toInt(value);
                break;
            }
            case 307: {
                this.mTriggerCollisionId = value;
                break;
            }
            case 303: {
                this.mViewTransitionOnNegativeCross = value;
                break;
            }
            case 302: {
                this.mViewTransitionOnPositiveCross = value;
                break;
            }
            case 301: {
                this.mViewTransitionOnCross = value;
                break;
            }
            default: {
                return super.setValue(type, value);
            }
        }
        return true;
    }

    @Override
    public boolean setValue(int type, float value) {
        switch (type) {
            case 305: {
                this.mTriggerSlack = value;
                break;
            }
            default: {
                return super.setValue(type, value);
            }
        }
        return true;
    }

    @Override
    public boolean setValue(int type, String value) {
        switch (type) {
            case 312: {
                this.mCross = value;
                break;
            }
            case 310: {
                this.mNegativeCross = value;
                break;
            }
            case 309: {
                this.mPositiveCross = value;
                break;
            }
            default: {
                return super.setValue(type, value);
            }
        }
        return true;
    }

    @Override
    public boolean setValue(int type, boolean value) {
        switch (type) {
            case 304: {
                this.mPostLayout = value;
                break;
            }
            default: {
                return super.setValue(type, value);
            }
        }
        return true;
    }
}

