/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.parser;

import androidx.constraintlayout.core.parser.CLElement;
import androidx.constraintlayout.core.parser.CLParser;
import androidx.constraintlayout.core.parser.CLParsingException;

public class CLToken
extends CLElement {
    int mIndex = 0;
    Type mType = Type.UNKNOWN;
    char[] mTokenTrue = "true".toCharArray();
    char[] mTokenFalse = "false".toCharArray();
    char[] mTokenNull = "null".toCharArray();

    public boolean getBoolean() throws CLParsingException {
        if (this.mType == Type.TRUE) {
            return true;
        }
        if (this.mType == Type.FALSE) {
            return false;
        }
        throw new CLParsingException("this token is not a boolean: <" + this.content() + ">", this);
    }

    public boolean isNull() throws CLParsingException {
        if (this.mType == Type.NULL) {
            return true;
        }
        throw new CLParsingException("this token is not a null: <" + this.content() + ">", this);
    }

    public CLToken(char[] content) {
        super(content);
    }

    public static CLElement allocate(char[] content) {
        return new CLToken(content);
    }

    @Override
    protected String toJSON() {
        if (CLParser.sDebug) {
            return "<" + this.content() + ">";
        }
        return this.content();
    }

    @Override
    protected String toFormattedJSON(int indent, int forceIndent) {
        StringBuilder json = new StringBuilder();
        this.addIndent(json, indent);
        json.append(this.content());
        return json.toString();
    }

    public Type getType() {
        return this.mType;
    }

    public boolean validate(char c, long position) {
        boolean isValid = false;
        switch (this.mType.ordinal()) {
            case 1: {
                boolean bl = isValid = this.mTokenTrue[this.mIndex] == c;
                if (!isValid || this.mIndex + 1 != this.mTokenTrue.length) break;
                this.setEnd(position);
                break;
            }
            case 2: {
                boolean bl = isValid = this.mTokenFalse[this.mIndex] == c;
                if (!isValid || this.mIndex + 1 != this.mTokenFalse.length) break;
                this.setEnd(position);
                break;
            }
            case 3: {
                boolean bl = isValid = this.mTokenNull[this.mIndex] == c;
                if (!isValid || this.mIndex + 1 != this.mTokenNull.length) break;
                this.setEnd(position);
                break;
            }
            case 0: {
                if (this.mTokenTrue[this.mIndex] == c) {
                    this.mType = Type.TRUE;
                    isValid = true;
                    break;
                }
                if (this.mTokenFalse[this.mIndex] == c) {
                    this.mType = Type.FALSE;
                    isValid = true;
                    break;
                }
                if (this.mTokenNull[this.mIndex] != c) break;
                this.mType = Type.NULL;
                isValid = true;
            }
        }
        ++this.mIndex;
        return isValid;
    }

    static enum Type {
        UNKNOWN,
        TRUE,
        FALSE,
        NULL;

    }
}

