/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core;

import androidx.constraintlayout.core.ArrayRow;
import androidx.constraintlayout.core.Cache;
import androidx.constraintlayout.core.LinearSystem;
import androidx.constraintlayout.core.SolverVariable;
import java.util.Arrays;
import java.util.Comparator;

public class PriorityGoalRow
extends ArrayRow {
    private static final float EPSILON = 1.0E-4f;
    private static final boolean DEBUG = false;
    private int mTableSize = 128;
    private SolverVariable[] mArrayGoals = new SolverVariable[this.mTableSize];
    private SolverVariable[] mSortArray = new SolverVariable[this.mTableSize];
    private int mNumGoals = 0;
    GoalVariableAccessor mAccessor = new GoalVariableAccessor(this);
    Cache mCache;
    static final int NOT_FOUND = -1;

    @Override
    public void clear() {
        this.mNumGoals = 0;
        this.mConstantValue = 0.0f;
    }

    public PriorityGoalRow(Cache cache) {
        super(cache);
        this.mCache = cache;
    }

    @Override
    public boolean isEmpty() {
        return this.mNumGoals == 0;
    }

    @Override
    public SolverVariable getPivotCandidate(LinearSystem system, boolean[] avoid) {
        int pivot = -1;
        for (int i = 0; i < this.mNumGoals; ++i) {
            SolverVariable variable = this.mArrayGoals[i];
            if (avoid[variable.id]) continue;
            this.mAccessor.init(variable);
            if (pivot == -1) {
                if (!this.mAccessor.isNegative()) continue;
                pivot = i;
                continue;
            }
            if (!this.mAccessor.isSmallerThan(this.mArrayGoals[pivot])) continue;
            pivot = i;
        }
        if (pivot == -1) {
            return null;
        }
        return this.mArrayGoals[pivot];
    }

    @Override
    public void addError(SolverVariable error) {
        this.mAccessor.init(error);
        this.mAccessor.reset();
        error.mGoalStrengthVector[error.strength] = 1.0f;
        this.addToGoal(error);
    }

    private void addToGoal(SolverVariable variable) {
        if (this.mNumGoals + 1 > this.mArrayGoals.length) {
            this.mArrayGoals = Arrays.copyOf(this.mArrayGoals, this.mArrayGoals.length * 2);
            this.mSortArray = Arrays.copyOf(this.mArrayGoals, this.mArrayGoals.length * 2);
        }
        this.mArrayGoals[this.mNumGoals] = variable;
        ++this.mNumGoals;
        if (this.mNumGoals > 1 && this.mArrayGoals[this.mNumGoals - 1].id > variable.id) {
            int i;
            for (i = 0; i < this.mNumGoals; ++i) {
                this.mSortArray[i] = this.mArrayGoals[i];
            }
            Arrays.sort(this.mSortArray, 0, this.mNumGoals, new Comparator<SolverVariable>(){

                @Override
                public int compare(SolverVariable variable1, SolverVariable variable2) {
                    return variable1.id - variable2.id;
                }
            });
            for (i = 0; i < this.mNumGoals; ++i) {
                this.mArrayGoals[i] = this.mSortArray[i];
            }
        }
        variable.inGoal = true;
        variable.addToRow(this);
    }

    private void removeGoal(SolverVariable variable) {
        for (int i = 0; i < this.mNumGoals; ++i) {
            if (this.mArrayGoals[i] != variable) continue;
            for (int j = i; j < this.mNumGoals - 1; ++j) {
                this.mArrayGoals[j] = this.mArrayGoals[j + 1];
            }
            --this.mNumGoals;
            variable.inGoal = false;
            return;
        }
    }

    @Override
    public void updateFromRow(LinearSystem system, ArrayRow definition, boolean removeFromDefinition) {
        SolverVariable goalVariable = definition.mVariable;
        if (goalVariable == null) {
            return;
        }
        ArrayRow.ArrayRowVariables rowVariables = definition.variables;
        int currentSize = rowVariables.getCurrentSize();
        for (int i = 0; i < currentSize; ++i) {
            SolverVariable solverVariable = rowVariables.getVariable(i);
            float value = rowVariables.getVariableValue(i);
            this.mAccessor.init(solverVariable);
            if (this.mAccessor.addToGoal(goalVariable, value)) {
                this.addToGoal(solverVariable);
            }
            this.mConstantValue += definition.mConstantValue * value;
        }
        this.removeGoal(goalVariable);
    }

    @Override
    public String toString() {
        String result = "";
        result = result + " goal -> (" + this.mConstantValue + ") : ";
        for (int i = 0; i < this.mNumGoals; ++i) {
            SolverVariable v = this.mArrayGoals[i];
            this.mAccessor.init(v);
            result = result + this.mAccessor + " ";
        }
        return result;
    }

    class GoalVariableAccessor {
        SolverVariable mVariable;
        PriorityGoalRow mRow;

        GoalVariableAccessor(PriorityGoalRow row) {
            this.mRow = row;
        }

        public void init(SolverVariable variable) {
            this.mVariable = variable;
        }

        public boolean addToGoal(SolverVariable other, float value) {
            if (this.mVariable.inGoal) {
                boolean empty = true;
                for (int i = 0; i < 9; ++i) {
                    int n = i;
                    this.mVariable.mGoalStrengthVector[n] = this.mVariable.mGoalStrengthVector[n] + other.mGoalStrengthVector[i] * value;
                    float v = this.mVariable.mGoalStrengthVector[i];
                    if (Math.abs(v) < 1.0E-4f) {
                        this.mVariable.mGoalStrengthVector[i] = 0.0f;
                        continue;
                    }
                    empty = false;
                }
                if (empty) {
                    PriorityGoalRow.this.removeGoal(this.mVariable);
                }
            } else {
                for (int i = 0; i < 9; ++i) {
                    float strength = other.mGoalStrengthVector[i];
                    if (strength != 0.0f) {
                        float v = value * strength;
                        if (Math.abs(v) < 1.0E-4f) {
                            v = 0.0f;
                        }
                        this.mVariable.mGoalStrengthVector[i] = v;
                        continue;
                    }
                    this.mVariable.mGoalStrengthVector[i] = 0.0f;
                }
                return true;
            }
            return false;
        }

        public void add(SolverVariable other) {
            for (int i = 0; i < 9; ++i) {
                int n = i;
                this.mVariable.mGoalStrengthVector[n] = this.mVariable.mGoalStrengthVector[n] + other.mGoalStrengthVector[i];
                float value = this.mVariable.mGoalStrengthVector[i];
                if (!(Math.abs(value) < 1.0E-4f)) continue;
                this.mVariable.mGoalStrengthVector[i] = 0.0f;
            }
        }

        public final boolean isNegative() {
            for (int i = 8; i >= 0; --i) {
                float value = this.mVariable.mGoalStrengthVector[i];
                if (value > 0.0f) {
                    return false;
                }
                if (!(value < 0.0f)) continue;
                return true;
            }
            return false;
        }

        public final boolean isSmallerThan(SolverVariable other) {
            for (int i = 8; i >= 0; --i) {
                float value = this.mVariable.mGoalStrengthVector[i];
                float comparedValue = other.mGoalStrengthVector[i];
                if (value == comparedValue) continue;
                return value < comparedValue;
            }
            return false;
        }

        public final boolean isNull() {
            for (int i = 0; i < 9; ++i) {
                if (this.mVariable.mGoalStrengthVector[i] == 0.0f) continue;
                return false;
            }
            return true;
        }

        public void reset() {
            Arrays.fill(this.mVariable.mGoalStrengthVector, 0.0f);
        }

        public String toString() {
            String result = "[ ";
            if (this.mVariable != null) {
                for (int i = 0; i < 9; ++i) {
                    result = result + this.mVariable.mGoalStrengthVector[i] + " ";
                }
            }
            result = result + "] " + this.mVariable;
            return result;
        }
    }
}

