/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.widgets.analyzer;

import androidx.constraintlayout.core.widgets.ConstraintAnchor;
import androidx.constraintlayout.core.widgets.ConstraintWidget;
import androidx.constraintlayout.core.widgets.analyzer.Dependency;
import androidx.constraintlayout.core.widgets.analyzer.DependencyNode;
import androidx.constraintlayout.core.widgets.analyzer.DimensionDependency;
import androidx.constraintlayout.core.widgets.analyzer.HorizontalWidgetRun;
import androidx.constraintlayout.core.widgets.analyzer.RunGroup;
import androidx.constraintlayout.core.widgets.analyzer.VerticalWidgetRun;

public abstract class WidgetRun
implements Dependency {
    public int matchConstraintsType;
    ConstraintWidget mWidget;
    RunGroup mRunGroup;
    protected ConstraintWidget.DimensionBehaviour mDimensionBehavior;
    DimensionDependency mDimension = new DimensionDependency(this);
    public int orientation = 0;
    boolean mResolved = false;
    public DependencyNode start = new DependencyNode(this);
    public DependencyNode end = new DependencyNode(this);
    protected RunType mRunType = RunType.NONE;

    public WidgetRun(ConstraintWidget widget) {
        this.mWidget = widget;
    }

    abstract void clear();

    abstract void apply();

    abstract void applyToWidget();

    abstract void reset();

    abstract boolean supportsWrapComputation();

    public boolean isDimensionResolved() {
        return this.mDimension.resolved;
    }

    public boolean isCenterConnection() {
        DependencyNode dependency;
        int i;
        int connections = 0;
        int count = this.start.mTargets.size();
        for (i = 0; i < count; ++i) {
            dependency = this.start.mTargets.get(i);
            if (dependency.mRun == this) continue;
            ++connections;
        }
        count = this.end.mTargets.size();
        for (i = 0; i < count; ++i) {
            dependency = this.end.mTargets.get(i);
            if (dependency.mRun == this) continue;
            ++connections;
        }
        return connections >= 2;
    }

    public long wrapSize(int direction) {
        if (this.mDimension.resolved) {
            long size = this.mDimension.value;
            size = this.isCenterConnection() ? (size += (long)(this.start.mMargin - this.end.mMargin)) : (direction == 0 ? (size += (long)this.start.mMargin) : (size -= (long)this.end.mMargin));
            return size;
        }
        return 0L;
    }

    protected final DependencyNode getTarget(ConstraintAnchor anchor) {
        if (anchor.mTarget == null) {
            return null;
        }
        DependencyNode target = null;
        ConstraintWidget targetWidget = anchor.mTarget.mOwner;
        ConstraintAnchor.Type targetType = anchor.mTarget.mType;
        switch (targetType) {
            case LEFT: {
                HorizontalWidgetRun run = targetWidget.mHorizontalRun;
                target = run.start;
                break;
            }
            case RIGHT: {
                HorizontalWidgetRun run = targetWidget.mHorizontalRun;
                target = run.end;
                break;
            }
            case TOP: {
                VerticalWidgetRun run = targetWidget.mVerticalRun;
                target = run.start;
                break;
            }
            case BASELINE: {
                VerticalWidgetRun run = targetWidget.mVerticalRun;
                target = run.baseline;
                break;
            }
            case BOTTOM: {
                VerticalWidgetRun run = targetWidget.mVerticalRun;
                target = run.end;
                break;
            }
        }
        return target;
    }

    protected void updateRunCenter(Dependency dependency, ConstraintAnchor startAnchor, ConstraintAnchor endAnchor, int orientation) {
        float bias;
        DependencyNode startTarget = this.getTarget(startAnchor);
        DependencyNode endTarget = this.getTarget(endAnchor);
        if (!startTarget.resolved || !endTarget.resolved) {
            return;
        }
        int startPos = startTarget.value + startAnchor.getMargin();
        int endPos = endTarget.value - endAnchor.getMargin();
        int distance = endPos - startPos;
        if (!this.mDimension.resolved && this.mDimensionBehavior == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT) {
            this.resolveDimension(orientation, distance);
        }
        if (!this.mDimension.resolved) {
            return;
        }
        if (this.mDimension.value == distance) {
            this.start.resolve(startPos);
            this.end.resolve(endPos);
            return;
        }
        float f = bias = orientation == 0 ? this.mWidget.getHorizontalBiasPercent() : this.mWidget.getVerticalBiasPercent();
        if (startTarget == endTarget) {
            startPos = startTarget.value;
            endPos = endTarget.value;
            bias = 0.5f;
        }
        int availableDistance = endPos - startPos - this.mDimension.value;
        this.start.resolve((int)(0.5f + (float)startPos + (float)availableDistance * bias));
        this.end.resolve(this.start.value + this.mDimension.value);
    }

    private void resolveDimension(int orientation, int distance) {
        switch (this.matchConstraintsType) {
            case 0: {
                this.mDimension.resolve(this.getLimitedDimension(distance, orientation));
                break;
            }
            case 2: {
                WidgetRun run;
                ConstraintWidget parent = this.mWidget.getParent();
                if (parent == null) break;
                WidgetRun widgetRun = run = orientation == 0 ? parent.mHorizontalRun : parent.mVerticalRun;
                if (!run.mDimension.resolved) break;
                float percent = orientation == 0 ? this.mWidget.mMatchConstraintPercentWidth : this.mWidget.mMatchConstraintPercentHeight;
                int targetDimensionValue = run.mDimension.value;
                int size = (int)(0.5f + (float)targetDimensionValue * percent);
                this.mDimension.resolve(this.getLimitedDimension(size, orientation));
                break;
            }
            case 1: {
                int wrapValue = this.getLimitedDimension(this.mDimension.wrapValue, orientation);
                this.mDimension.resolve(Math.min(wrapValue, distance));
                break;
            }
            case 3: {
                WidgetRun run;
                if (this.mWidget.mHorizontalRun.mDimensionBehavior == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT && this.mWidget.mHorizontalRun.matchConstraintsType == 3 && this.mWidget.mVerticalRun.mDimensionBehavior == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT && this.mWidget.mVerticalRun.matchConstraintsType == 3) break;
                WidgetRun widgetRun = run = orientation == 0 ? this.mWidget.mVerticalRun : this.mWidget.mHorizontalRun;
                if (!run.mDimension.resolved) break;
                float ratio = this.mWidget.getDimensionRatio();
                int value = orientation == 1 ? (int)(0.5f + (float)run.mDimension.value / ratio) : (int)(0.5f + ratio * (float)run.mDimension.value);
                this.mDimension.resolve(value);
                break;
            }
        }
    }

    protected void updateRunStart(Dependency dependency) {
    }

    protected void updateRunEnd(Dependency dependency) {
    }

    @Override
    public void update(Dependency dependency) {
    }

    protected final int getLimitedDimension(int dimension, int orientation) {
        if (orientation == 0) {
            int max = this.mWidget.mMatchConstraintMaxWidth;
            int min = this.mWidget.mMatchConstraintMinWidth;
            int value = Math.max(min, dimension);
            if (max > 0) {
                value = Math.min(max, dimension);
            }
            if (value != dimension) {
                dimension = value;
            }
        } else {
            int max = this.mWidget.mMatchConstraintMaxHeight;
            int min = this.mWidget.mMatchConstraintMinHeight;
            int value = Math.max(min, dimension);
            if (max > 0) {
                value = Math.min(max, dimension);
            }
            if (value != dimension) {
                dimension = value;
            }
        }
        return dimension;
    }

    protected final DependencyNode getTarget(ConstraintAnchor anchor, int orientation) {
        if (anchor.mTarget == null) {
            return null;
        }
        DependencyNode target = null;
        ConstraintWidget targetWidget = anchor.mTarget.mOwner;
        WidgetRun run = orientation == 0 ? targetWidget.mHorizontalRun : targetWidget.mVerticalRun;
        ConstraintAnchor.Type targetType = anchor.mTarget.mType;
        switch (targetType) {
            case LEFT: 
            case TOP: {
                target = run.start;
                break;
            }
            case RIGHT: 
            case BOTTOM: {
                target = run.end;
                break;
            }
        }
        return target;
    }

    protected final void addTarget(DependencyNode node, DependencyNode target, int margin) {
        node.mTargets.add(target);
        node.mMargin = margin;
        target.mDependencies.add(node);
    }

    protected final void addTarget(DependencyNode node, DependencyNode target, int marginFactor, DimensionDependency dimensionDependency) {
        node.mTargets.add(target);
        node.mTargets.add(this.mDimension);
        node.mMarginFactor = marginFactor;
        node.mMarginDependency = dimensionDependency;
        target.mDependencies.add(node);
        dimensionDependency.mDependencies.add(node);
    }

    public long getWrapDimension() {
        if (this.mDimension.resolved) {
            return this.mDimension.value;
        }
        return 0L;
    }

    public boolean isResolved() {
        return this.mResolved;
    }

    static enum RunType {
        NONE,
        START,
        END,
        CENTER;

    }
}

