/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.widgets.analyzer;

import androidx.constraintlayout.core.widgets.Barrier;
import androidx.constraintlayout.core.widgets.ConstraintWidget;
import androidx.constraintlayout.core.widgets.ConstraintWidgetContainer;
import androidx.constraintlayout.core.widgets.Guideline;
import androidx.constraintlayout.core.widgets.HelperWidget;
import androidx.constraintlayout.core.widgets.analyzer.BasicMeasure;
import androidx.constraintlayout.core.widgets.analyzer.ChainRun;
import androidx.constraintlayout.core.widgets.analyzer.Dependency;
import androidx.constraintlayout.core.widgets.analyzer.DependencyNode;
import androidx.constraintlayout.core.widgets.analyzer.GuidelineReference;
import androidx.constraintlayout.core.widgets.analyzer.HelperReferences;
import androidx.constraintlayout.core.widgets.analyzer.HorizontalWidgetRun;
import androidx.constraintlayout.core.widgets.analyzer.RunGroup;
import androidx.constraintlayout.core.widgets.analyzer.VerticalWidgetRun;
import androidx.constraintlayout.core.widgets.analyzer.WidgetRun;
import java.util.ArrayList;
import java.util.HashSet;

public class DependencyGraph {
    private static final boolean USE_GROUPS = true;
    private ConstraintWidgetContainer mWidgetcontainer;
    private boolean mNeedBuildGraph = true;
    private boolean mNeedRedoMeasures = true;
    private ConstraintWidgetContainer mContainer;
    private ArrayList<WidgetRun> mRuns = new ArrayList();
    private static final boolean DEBUG = false;
    private ArrayList<RunGroup> mRunGroups = new ArrayList();
    private BasicMeasure.Measurer mMeasurer = null;
    private BasicMeasure.Measure mMeasure = new BasicMeasure.Measure();
    ArrayList<RunGroup> mGroups = new ArrayList();

    public DependencyGraph(ConstraintWidgetContainer container) {
        this.mWidgetcontainer = container;
        this.mContainer = container;
    }

    public void setMeasurer(BasicMeasure.Measurer measurer) {
        this.mMeasurer = measurer;
    }

    private int computeWrap(ConstraintWidgetContainer container, int orientation) {
        int count = this.mGroups.size();
        long wrapSize = 0L;
        for (int i = 0; i < count; ++i) {
            RunGroup run = this.mGroups.get(i);
            long size = run.computeWrapSize(container, orientation);
            wrapSize = Math.max(wrapSize, size);
        }
        return (int)wrapSize;
    }

    public void defineTerminalWidgets(ConstraintWidget.DimensionBehaviour horizontalBehavior, ConstraintWidget.DimensionBehaviour verticalBehavior) {
        if (this.mNeedBuildGraph) {
            this.buildGraph();
            boolean hasBarrier = false;
            for (ConstraintWidget widget : this.mWidgetcontainer.mChildren) {
                widget.isTerminalWidget[0] = true;
                widget.isTerminalWidget[1] = true;
                if (!(widget instanceof Barrier)) continue;
                hasBarrier = true;
            }
            if (!hasBarrier) {
                for (RunGroup group : this.mGroups) {
                    group.defineTerminalWidgets(horizontalBehavior == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT, verticalBehavior == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT);
                }
            }
        }
    }

    public boolean directMeasure(boolean optimizeWrap) {
        boolean avoid;
        optimizeWrap &= true;
        if (this.mNeedBuildGraph || this.mNeedRedoMeasures) {
            for (ConstraintWidget widget : this.mWidgetcontainer.mChildren) {
                widget.ensureWidgetRuns();
                widget.measured = false;
                widget.mHorizontalRun.reset();
                widget.mVerticalRun.reset();
            }
            this.mWidgetcontainer.ensureWidgetRuns();
            this.mWidgetcontainer.measured = false;
            this.mWidgetcontainer.mHorizontalRun.reset();
            this.mWidgetcontainer.mVerticalRun.reset();
            this.mNeedRedoMeasures = false;
        }
        if (avoid = this.basicMeasureWidgets(this.mContainer)) {
            return false;
        }
        this.mWidgetcontainer.setX(0);
        this.mWidgetcontainer.setY(0);
        ConstraintWidget.DimensionBehaviour originalHorizontalDimension = this.mWidgetcontainer.getDimensionBehaviour(0);
        ConstraintWidget.DimensionBehaviour originalVerticalDimension = this.mWidgetcontainer.getDimensionBehaviour(1);
        if (this.mNeedBuildGraph) {
            this.buildGraph();
        }
        int x1 = this.mWidgetcontainer.getX();
        int y1 = this.mWidgetcontainer.getY();
        this.mWidgetcontainer.mHorizontalRun.start.resolve(x1);
        this.mWidgetcontainer.mVerticalRun.start.resolve(y1);
        this.measureWidgets();
        if (originalHorizontalDimension == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT || originalVerticalDimension == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT) {
            if (optimizeWrap) {
                for (WidgetRun run : this.mRuns) {
                    if (run.supportsWrapComputation()) continue;
                    optimizeWrap = false;
                    break;
                }
            }
            if (optimizeWrap && originalHorizontalDimension == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT) {
                this.mWidgetcontainer.setHorizontalDimensionBehaviour(ConstraintWidget.DimensionBehaviour.FIXED);
                this.mWidgetcontainer.setWidth(this.computeWrap(this.mWidgetcontainer, 0));
                this.mWidgetcontainer.mHorizontalRun.mDimension.resolve(this.mWidgetcontainer.getWidth());
            }
            if (optimizeWrap && originalVerticalDimension == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT) {
                this.mWidgetcontainer.setVerticalDimensionBehaviour(ConstraintWidget.DimensionBehaviour.FIXED);
                this.mWidgetcontainer.setHeight(this.computeWrap(this.mWidgetcontainer, 1));
                this.mWidgetcontainer.mVerticalRun.mDimension.resolve(this.mWidgetcontainer.getHeight());
            }
        }
        boolean checkRoot = false;
        if (this.mWidgetcontainer.mListDimensionBehaviors[0] == ConstraintWidget.DimensionBehaviour.FIXED || this.mWidgetcontainer.mListDimensionBehaviors[0] == ConstraintWidget.DimensionBehaviour.MATCH_PARENT) {
            int x2 = x1 + this.mWidgetcontainer.getWidth();
            this.mWidgetcontainer.mHorizontalRun.end.resolve(x2);
            this.mWidgetcontainer.mHorizontalRun.mDimension.resolve(x2 - x1);
            this.measureWidgets();
            if (this.mWidgetcontainer.mListDimensionBehaviors[1] == ConstraintWidget.DimensionBehaviour.FIXED || this.mWidgetcontainer.mListDimensionBehaviors[1] == ConstraintWidget.DimensionBehaviour.MATCH_PARENT) {
                int y2 = y1 + this.mWidgetcontainer.getHeight();
                this.mWidgetcontainer.mVerticalRun.end.resolve(y2);
                this.mWidgetcontainer.mVerticalRun.mDimension.resolve(y2 - y1);
            }
            this.measureWidgets();
            checkRoot = true;
        }
        for (WidgetRun run : this.mRuns) {
            if (run.mWidget == this.mWidgetcontainer && !run.mResolved) continue;
            run.applyToWidget();
        }
        boolean allResolved = true;
        for (WidgetRun run : this.mRuns) {
            if (!checkRoot && run.mWidget == this.mWidgetcontainer) continue;
            if (!run.start.resolved) {
                allResolved = false;
                break;
            }
            if (!run.end.resolved && !(run instanceof GuidelineReference)) {
                allResolved = false;
                break;
            }
            if (run.mDimension.resolved || run instanceof ChainRun || run instanceof GuidelineReference) continue;
            allResolved = false;
            break;
        }
        this.mWidgetcontainer.setHorizontalDimensionBehaviour(originalHorizontalDimension);
        this.mWidgetcontainer.setVerticalDimensionBehaviour(originalVerticalDimension);
        return allResolved;
    }

    public boolean directMeasureSetup(boolean optimizeWrap) {
        boolean avoid;
        if (this.mNeedBuildGraph) {
            for (ConstraintWidget widget : this.mWidgetcontainer.mChildren) {
                widget.ensureWidgetRuns();
                widget.measured = false;
                widget.mHorizontalRun.mDimension.resolved = false;
                widget.mHorizontalRun.mResolved = false;
                widget.mHorizontalRun.reset();
                widget.mVerticalRun.mDimension.resolved = false;
                widget.mVerticalRun.mResolved = false;
                widget.mVerticalRun.reset();
            }
            this.mWidgetcontainer.ensureWidgetRuns();
            this.mWidgetcontainer.measured = false;
            this.mWidgetcontainer.mHorizontalRun.mDimension.resolved = false;
            this.mWidgetcontainer.mHorizontalRun.mResolved = false;
            this.mWidgetcontainer.mHorizontalRun.reset();
            this.mWidgetcontainer.mVerticalRun.mDimension.resolved = false;
            this.mWidgetcontainer.mVerticalRun.mResolved = false;
            this.mWidgetcontainer.mVerticalRun.reset();
            this.buildGraph();
        }
        if (avoid = this.basicMeasureWidgets(this.mContainer)) {
            return false;
        }
        this.mWidgetcontainer.setX(0);
        this.mWidgetcontainer.setY(0);
        this.mWidgetcontainer.mHorizontalRun.start.resolve(0);
        this.mWidgetcontainer.mVerticalRun.start.resolve(0);
        return true;
    }

    public boolean directMeasureWithOrientation(boolean optimizeWrap, int orientation) {
        ConstraintWidget.DimensionBehaviour originalHorizontalDimension = this.mWidgetcontainer.getDimensionBehaviour(0);
        ConstraintWidget.DimensionBehaviour originalVerticalDimension = this.mWidgetcontainer.getDimensionBehaviour(1);
        int x1 = this.mWidgetcontainer.getX();
        int y1 = this.mWidgetcontainer.getY();
        if ((optimizeWrap &= true) && (originalHorizontalDimension == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT || originalVerticalDimension == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT)) {
            for (WidgetRun run : this.mRuns) {
                if (run.orientation != orientation || run.supportsWrapComputation()) continue;
                optimizeWrap = false;
                break;
            }
            if (orientation == 0) {
                if (optimizeWrap && originalHorizontalDimension == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT) {
                    this.mWidgetcontainer.setHorizontalDimensionBehaviour(ConstraintWidget.DimensionBehaviour.FIXED);
                    this.mWidgetcontainer.setWidth(this.computeWrap(this.mWidgetcontainer, 0));
                    this.mWidgetcontainer.mHorizontalRun.mDimension.resolve(this.mWidgetcontainer.getWidth());
                }
            } else if (optimizeWrap && originalVerticalDimension == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT) {
                this.mWidgetcontainer.setVerticalDimensionBehaviour(ConstraintWidget.DimensionBehaviour.FIXED);
                this.mWidgetcontainer.setHeight(this.computeWrap(this.mWidgetcontainer, 1));
                this.mWidgetcontainer.mVerticalRun.mDimension.resolve(this.mWidgetcontainer.getHeight());
            }
        }
        boolean checkRoot = false;
        if (orientation == 0) {
            if (this.mWidgetcontainer.mListDimensionBehaviors[0] == ConstraintWidget.DimensionBehaviour.FIXED || this.mWidgetcontainer.mListDimensionBehaviors[0] == ConstraintWidget.DimensionBehaviour.MATCH_PARENT) {
                int x2 = x1 + this.mWidgetcontainer.getWidth();
                this.mWidgetcontainer.mHorizontalRun.end.resolve(x2);
                this.mWidgetcontainer.mHorizontalRun.mDimension.resolve(x2 - x1);
                checkRoot = true;
            }
        } else if (this.mWidgetcontainer.mListDimensionBehaviors[1] == ConstraintWidget.DimensionBehaviour.FIXED || this.mWidgetcontainer.mListDimensionBehaviors[1] == ConstraintWidget.DimensionBehaviour.MATCH_PARENT) {
            int y2 = y1 + this.mWidgetcontainer.getHeight();
            this.mWidgetcontainer.mVerticalRun.end.resolve(y2);
            this.mWidgetcontainer.mVerticalRun.mDimension.resolve(y2 - y1);
            checkRoot = true;
        }
        this.measureWidgets();
        for (WidgetRun run : this.mRuns) {
            if (run.orientation != orientation || run.mWidget == this.mWidgetcontainer && !run.mResolved) continue;
            run.applyToWidget();
        }
        boolean allResolved = true;
        for (WidgetRun run : this.mRuns) {
            if (run.orientation != orientation || !checkRoot && run.mWidget == this.mWidgetcontainer) continue;
            if (!run.start.resolved) {
                allResolved = false;
                break;
            }
            if (!run.end.resolved) {
                allResolved = false;
                break;
            }
            if (run instanceof ChainRun || run.mDimension.resolved) continue;
            allResolved = false;
            break;
        }
        this.mWidgetcontainer.setHorizontalDimensionBehaviour(originalHorizontalDimension);
        this.mWidgetcontainer.setVerticalDimensionBehaviour(originalVerticalDimension);
        return allResolved;
    }

    private void measure(ConstraintWidget widget, ConstraintWidget.DimensionBehaviour horizontalBehavior, int horizontalDimension, ConstraintWidget.DimensionBehaviour verticalBehavior, int verticalDimension) {
        this.mMeasure.horizontalBehavior = horizontalBehavior;
        this.mMeasure.verticalBehavior = verticalBehavior;
        this.mMeasure.horizontalDimension = horizontalDimension;
        this.mMeasure.verticalDimension = verticalDimension;
        this.mMeasurer.measure(widget, this.mMeasure);
        widget.setWidth(this.mMeasure.measuredWidth);
        widget.setHeight(this.mMeasure.measuredHeight);
        widget.setHasBaseline(this.mMeasure.measuredHasBaseline);
        widget.setBaselineDistance(this.mMeasure.measuredBaseline);
    }

    private boolean basicMeasureWidgets(ConstraintWidgetContainer constraintWidgetContainer) {
        for (ConstraintWidget widget : constraintWidgetContainer.mChildren) {
            int height;
            ConstraintWidget.DimensionBehaviour horizontal = widget.mListDimensionBehaviors[0];
            ConstraintWidget.DimensionBehaviour vertical = widget.mListDimensionBehaviors[1];
            if (widget.getVisibility() == 8) {
                widget.measured = true;
                continue;
            }
            if (widget.mMatchConstraintPercentWidth < 1.0f && horizontal == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT) {
                widget.mMatchConstraintDefaultWidth = 2;
            }
            if (widget.mMatchConstraintPercentHeight < 1.0f && vertical == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT) {
                widget.mMatchConstraintDefaultHeight = 2;
            }
            if (widget.getDimensionRatio() > 0.0f) {
                if (horizontal == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT && (vertical == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT || vertical == ConstraintWidget.DimensionBehaviour.FIXED)) {
                    widget.mMatchConstraintDefaultWidth = 3;
                } else if (vertical == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT && (horizontal == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT || horizontal == ConstraintWidget.DimensionBehaviour.FIXED)) {
                    widget.mMatchConstraintDefaultHeight = 3;
                } else if (horizontal == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT && vertical == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT) {
                    if (widget.mMatchConstraintDefaultWidth == 0) {
                        widget.mMatchConstraintDefaultWidth = 3;
                    }
                    if (widget.mMatchConstraintDefaultHeight == 0) {
                        widget.mMatchConstraintDefaultHeight = 3;
                    }
                }
            }
            if (horizontal == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT && widget.mMatchConstraintDefaultWidth == 1 && (widget.mLeft.mTarget == null || widget.mRight.mTarget == null)) {
                horizontal = ConstraintWidget.DimensionBehaviour.WRAP_CONTENT;
            }
            if (vertical == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT && widget.mMatchConstraintDefaultHeight == 1 && (widget.mTop.mTarget == null || widget.mBottom.mTarget == null)) {
                vertical = ConstraintWidget.DimensionBehaviour.WRAP_CONTENT;
            }
            widget.mHorizontalRun.mDimensionBehavior = horizontal;
            widget.mHorizontalRun.matchConstraintsType = widget.mMatchConstraintDefaultWidth;
            widget.mVerticalRun.mDimensionBehavior = vertical;
            widget.mVerticalRun.matchConstraintsType = widget.mMatchConstraintDefaultHeight;
            if (!(horizontal != ConstraintWidget.DimensionBehaviour.MATCH_PARENT && horizontal != ConstraintWidget.DimensionBehaviour.FIXED && horizontal != ConstraintWidget.DimensionBehaviour.WRAP_CONTENT || vertical != ConstraintWidget.DimensionBehaviour.MATCH_PARENT && vertical != ConstraintWidget.DimensionBehaviour.FIXED && vertical != ConstraintWidget.DimensionBehaviour.WRAP_CONTENT)) {
                int width = widget.getWidth();
                if (horizontal == ConstraintWidget.DimensionBehaviour.MATCH_PARENT) {
                    width = constraintWidgetContainer.getWidth() - widget.mLeft.mMargin - widget.mRight.mMargin;
                    horizontal = ConstraintWidget.DimensionBehaviour.FIXED;
                }
                int height2 = widget.getHeight();
                if (vertical == ConstraintWidget.DimensionBehaviour.MATCH_PARENT) {
                    height2 = constraintWidgetContainer.getHeight() - widget.mTop.mMargin - widget.mBottom.mMargin;
                    vertical = ConstraintWidget.DimensionBehaviour.FIXED;
                }
                this.measure(widget, horizontal, width, vertical, height2);
                widget.mHorizontalRun.mDimension.resolve(widget.getWidth());
                widget.mVerticalRun.mDimension.resolve(widget.getHeight());
                widget.measured = true;
                continue;
            }
            if (horizontal == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT && (vertical == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT || vertical == ConstraintWidget.DimensionBehaviour.FIXED)) {
                if (widget.mMatchConstraintDefaultWidth == 3) {
                    if (vertical == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT) {
                        this.measure(widget, ConstraintWidget.DimensionBehaviour.WRAP_CONTENT, 0, ConstraintWidget.DimensionBehaviour.WRAP_CONTENT, 0);
                    }
                    int height3 = widget.getHeight();
                    int width = (int)((float)height3 * widget.mDimensionRatio + 0.5f);
                    this.measure(widget, ConstraintWidget.DimensionBehaviour.FIXED, width, ConstraintWidget.DimensionBehaviour.FIXED, height3);
                    widget.mHorizontalRun.mDimension.resolve(widget.getWidth());
                    widget.mVerticalRun.mDimension.resolve(widget.getHeight());
                    widget.measured = true;
                    continue;
                }
                if (widget.mMatchConstraintDefaultWidth == 1) {
                    this.measure(widget, ConstraintWidget.DimensionBehaviour.WRAP_CONTENT, 0, vertical, 0);
                    widget.mHorizontalRun.mDimension.wrapValue = widget.getWidth();
                    continue;
                }
                if (widget.mMatchConstraintDefaultWidth == 2) {
                    if (constraintWidgetContainer.mListDimensionBehaviors[0] == ConstraintWidget.DimensionBehaviour.FIXED || constraintWidgetContainer.mListDimensionBehaviors[0] == ConstraintWidget.DimensionBehaviour.MATCH_PARENT) {
                        float percent = widget.mMatchConstraintPercentWidth;
                        int width = (int)(0.5f + percent * (float)constraintWidgetContainer.getWidth());
                        height = widget.getHeight();
                        this.measure(widget, ConstraintWidget.DimensionBehaviour.FIXED, width, vertical, height);
                        widget.mHorizontalRun.mDimension.resolve(widget.getWidth());
                        widget.mVerticalRun.mDimension.resolve(widget.getHeight());
                        widget.measured = true;
                        continue;
                    }
                } else if (widget.mListAnchors[0].mTarget == null || widget.mListAnchors[1].mTarget == null) {
                    this.measure(widget, ConstraintWidget.DimensionBehaviour.WRAP_CONTENT, 0, vertical, 0);
                    widget.mHorizontalRun.mDimension.resolve(widget.getWidth());
                    widget.mVerticalRun.mDimension.resolve(widget.getHeight());
                    widget.measured = true;
                    continue;
                }
            }
            if (vertical == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT && (horizontal == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT || horizontal == ConstraintWidget.DimensionBehaviour.FIXED)) {
                if (widget.mMatchConstraintDefaultHeight == 3) {
                    if (horizontal == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT) {
                        this.measure(widget, ConstraintWidget.DimensionBehaviour.WRAP_CONTENT, 0, ConstraintWidget.DimensionBehaviour.WRAP_CONTENT, 0);
                    }
                    int width = widget.getWidth();
                    float ratio = widget.mDimensionRatio;
                    if (widget.getDimensionRatioSide() == -1) {
                        ratio = 1.0f / ratio;
                    }
                    height = (int)((float)width * ratio + 0.5f);
                    this.measure(widget, ConstraintWidget.DimensionBehaviour.FIXED, width, ConstraintWidget.DimensionBehaviour.FIXED, height);
                    widget.mHorizontalRun.mDimension.resolve(widget.getWidth());
                    widget.mVerticalRun.mDimension.resolve(widget.getHeight());
                    widget.measured = true;
                    continue;
                }
                if (widget.mMatchConstraintDefaultHeight == 1) {
                    this.measure(widget, horizontal, 0, ConstraintWidget.DimensionBehaviour.WRAP_CONTENT, 0);
                    widget.mVerticalRun.mDimension.wrapValue = widget.getHeight();
                    continue;
                }
                if (widget.mMatchConstraintDefaultHeight == 2) {
                    if (constraintWidgetContainer.mListDimensionBehaviors[1] == ConstraintWidget.DimensionBehaviour.FIXED || constraintWidgetContainer.mListDimensionBehaviors[1] == ConstraintWidget.DimensionBehaviour.MATCH_PARENT) {
                        float percent = widget.mMatchConstraintPercentHeight;
                        int width = widget.getWidth();
                        height = (int)(0.5f + percent * (float)constraintWidgetContainer.getHeight());
                        this.measure(widget, horizontal, width, ConstraintWidget.DimensionBehaviour.FIXED, height);
                        widget.mHorizontalRun.mDimension.resolve(widget.getWidth());
                        widget.mVerticalRun.mDimension.resolve(widget.getHeight());
                        widget.measured = true;
                        continue;
                    }
                } else if (widget.mListAnchors[2].mTarget == null || widget.mListAnchors[3].mTarget == null) {
                    this.measure(widget, ConstraintWidget.DimensionBehaviour.WRAP_CONTENT, 0, vertical, 0);
                    widget.mHorizontalRun.mDimension.resolve(widget.getWidth());
                    widget.mVerticalRun.mDimension.resolve(widget.getHeight());
                    widget.measured = true;
                    continue;
                }
            }
            if (horizontal != ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT || vertical != ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT) continue;
            if (widget.mMatchConstraintDefaultWidth == 1 || widget.mMatchConstraintDefaultHeight == 1) {
                this.measure(widget, ConstraintWidget.DimensionBehaviour.WRAP_CONTENT, 0, ConstraintWidget.DimensionBehaviour.WRAP_CONTENT, 0);
                widget.mHorizontalRun.mDimension.wrapValue = widget.getWidth();
                widget.mVerticalRun.mDimension.wrapValue = widget.getHeight();
                continue;
            }
            if (widget.mMatchConstraintDefaultHeight != 2 || widget.mMatchConstraintDefaultWidth != 2 || constraintWidgetContainer.mListDimensionBehaviors[0] != ConstraintWidget.DimensionBehaviour.FIXED || constraintWidgetContainer.mListDimensionBehaviors[1] != ConstraintWidget.DimensionBehaviour.FIXED) continue;
            float horizPercent = widget.mMatchConstraintPercentWidth;
            float vertPercent = widget.mMatchConstraintPercentHeight;
            int width = (int)(0.5f + horizPercent * (float)constraintWidgetContainer.getWidth());
            int height4 = (int)(0.5f + vertPercent * (float)constraintWidgetContainer.getHeight());
            this.measure(widget, ConstraintWidget.DimensionBehaviour.FIXED, width, ConstraintWidget.DimensionBehaviour.FIXED, height4);
            widget.mHorizontalRun.mDimension.resolve(widget.getWidth());
            widget.mVerticalRun.mDimension.resolve(widget.getHeight());
            widget.measured = true;
        }
        return false;
    }

    public void measureWidgets() {
        for (ConstraintWidget widget : this.mWidgetcontainer.mChildren) {
            if (widget.measured) continue;
            ConstraintWidget.DimensionBehaviour horiz = widget.mListDimensionBehaviors[0];
            ConstraintWidget.DimensionBehaviour vert = widget.mListDimensionBehaviors[1];
            int horizMatchConstraintsType = widget.mMatchConstraintDefaultWidth;
            int vertMatchConstraintsType = widget.mMatchConstraintDefaultHeight;
            boolean horizWrap = horiz == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT || horiz == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT && horizMatchConstraintsType == 1;
            boolean vertWrap = vert == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT || vert == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT && vertMatchConstraintsType == 1;
            boolean horizResolved = widget.mHorizontalRun.mDimension.resolved;
            boolean vertResolved = widget.mVerticalRun.mDimension.resolved;
            if (horizResolved && vertResolved) {
                this.measure(widget, ConstraintWidget.DimensionBehaviour.FIXED, widget.mHorizontalRun.mDimension.value, ConstraintWidget.DimensionBehaviour.FIXED, widget.mVerticalRun.mDimension.value);
                widget.measured = true;
            } else if (horizResolved && vertWrap) {
                this.measure(widget, ConstraintWidget.DimensionBehaviour.FIXED, widget.mHorizontalRun.mDimension.value, ConstraintWidget.DimensionBehaviour.WRAP_CONTENT, widget.mVerticalRun.mDimension.value);
                if (vert == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT) {
                    widget.mVerticalRun.mDimension.wrapValue = widget.getHeight();
                } else {
                    widget.mVerticalRun.mDimension.resolve(widget.getHeight());
                    widget.measured = true;
                }
            } else if (vertResolved && horizWrap) {
                this.measure(widget, ConstraintWidget.DimensionBehaviour.WRAP_CONTENT, widget.mHorizontalRun.mDimension.value, ConstraintWidget.DimensionBehaviour.FIXED, widget.mVerticalRun.mDimension.value);
                if (horiz == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT) {
                    widget.mHorizontalRun.mDimension.wrapValue = widget.getWidth();
                } else {
                    widget.mHorizontalRun.mDimension.resolve(widget.getWidth());
                    widget.measured = true;
                }
            }
            if (!widget.measured || widget.mVerticalRun.mBaselineDimension == null) continue;
            widget.mVerticalRun.mBaselineDimension.resolve(widget.getBaselineDistance());
        }
    }

    public void invalidateGraph() {
        this.mNeedBuildGraph = true;
    }

    public void invalidateMeasures() {
        this.mNeedRedoMeasures = true;
    }

    public void buildGraph() {
        this.buildGraph(this.mRuns);
        this.mGroups.clear();
        RunGroup.index = 0;
        this.findGroup(this.mWidgetcontainer.mHorizontalRun, 0, this.mGroups);
        this.findGroup(this.mWidgetcontainer.mVerticalRun, 1, this.mGroups);
        this.mNeedBuildGraph = false;
    }

    public void buildGraph(ArrayList<WidgetRun> runs) {
        runs.clear();
        this.mContainer.mHorizontalRun.clear();
        this.mContainer.mVerticalRun.clear();
        runs.add(this.mContainer.mHorizontalRun);
        runs.add(this.mContainer.mVerticalRun);
        HashSet<ChainRun> chainRuns = null;
        for (ConstraintWidget widget : this.mContainer.mChildren) {
            if (widget instanceof Guideline) {
                runs.add(new GuidelineReference(widget));
                continue;
            }
            if (widget.isInHorizontalChain()) {
                if (widget.horizontalChainRun == null) {
                    widget.horizontalChainRun = new ChainRun(widget, 0);
                }
                if (chainRuns == null) {
                    chainRuns = new HashSet<ChainRun>();
                }
                chainRuns.add(widget.horizontalChainRun);
            } else {
                runs.add(widget.mHorizontalRun);
            }
            if (widget.isInVerticalChain()) {
                if (widget.verticalChainRun == null) {
                    widget.verticalChainRun = new ChainRun(widget, 1);
                }
                if (chainRuns == null) {
                    chainRuns = new HashSet();
                }
                chainRuns.add(widget.verticalChainRun);
            } else {
                runs.add(widget.mVerticalRun);
            }
            if (!(widget instanceof HelperWidget)) continue;
            runs.add(new HelperReferences(widget));
        }
        if (chainRuns != null) {
            runs.addAll(chainRuns);
        }
        for (WidgetRun run : runs) {
            run.clear();
        }
        for (WidgetRun run : runs) {
            if (run.mWidget == this.mContainer) continue;
            run.apply();
        }
    }

    private void displayGraph() {
        String content = "digraph {\n";
        for (WidgetRun run : this.mRuns) {
            content = this.generateDisplayGraph(run, content);
        }
        content = content + "\n}\n";
        System.out.println("content:<<\n" + content + "\n>>");
    }

    private void applyGroup(DependencyNode node, int orientation, int direction, DependencyNode end, ArrayList<RunGroup> groups, RunGroup group) {
        WidgetRun run = node.mRun;
        if (run.mRunGroup != null || run == this.mWidgetcontainer.mHorizontalRun || run == this.mWidgetcontainer.mVerticalRun) {
            return;
        }
        if (group == null) {
            group = new RunGroup(run, direction);
            groups.add(group);
        }
        run.mRunGroup = group;
        group.add(run);
        for (Dependency dependent : run.start.mDependencies) {
            if (!(dependent instanceof DependencyNode)) continue;
            this.applyGroup((DependencyNode)dependent, orientation, 0, end, groups, group);
        }
        for (Dependency dependent : run.end.mDependencies) {
            if (!(dependent instanceof DependencyNode)) continue;
            this.applyGroup((DependencyNode)dependent, orientation, 1, end, groups, group);
        }
        if (orientation == 1 && run instanceof VerticalWidgetRun) {
            for (Dependency dependent : ((VerticalWidgetRun)run).baseline.mDependencies) {
                if (!(dependent instanceof DependencyNode)) continue;
                this.applyGroup((DependencyNode)dependent, orientation, 2, end, groups, group);
            }
        }
        for (DependencyNode target : run.start.mTargets) {
            if (target == end) {
                group.dual = true;
            }
            this.applyGroup(target, orientation, 0, end, groups, group);
        }
        for (DependencyNode target : run.end.mTargets) {
            if (target == end) {
                group.dual = true;
            }
            this.applyGroup(target, orientation, 1, end, groups, group);
        }
        if (orientation == 1 && run instanceof VerticalWidgetRun) {
            for (DependencyNode target : ((VerticalWidgetRun)run).baseline.mTargets) {
                this.applyGroup(target, orientation, 2, end, groups, group);
            }
        }
    }

    private void findGroup(WidgetRun run, int orientation, ArrayList<RunGroup> groups) {
        WidgetRun dependentRun;
        DependencyNode node;
        for (Dependency dependent : run.start.mDependencies) {
            if (dependent instanceof DependencyNode) {
                node = (DependencyNode)dependent;
                this.applyGroup(node, orientation, 0, run.end, groups, null);
                continue;
            }
            if (!(dependent instanceof WidgetRun)) continue;
            dependentRun = (WidgetRun)dependent;
            this.applyGroup(dependentRun.start, orientation, 0, run.end, groups, null);
        }
        for (Dependency dependent : run.end.mDependencies) {
            if (dependent instanceof DependencyNode) {
                node = (DependencyNode)dependent;
                this.applyGroup(node, orientation, 1, run.start, groups, null);
                continue;
            }
            if (!(dependent instanceof WidgetRun)) continue;
            dependentRun = (WidgetRun)dependent;
            this.applyGroup(dependentRun.end, orientation, 1, run.start, groups, null);
        }
        if (orientation == 1) {
            for (Dependency dependent : ((VerticalWidgetRun)run).baseline.mDependencies) {
                if (!(dependent instanceof DependencyNode)) continue;
                node = (DependencyNode)dependent;
                this.applyGroup(node, orientation, 2, null, groups, null);
            }
        }
    }

    private String generateDisplayNode(DependencyNode node, boolean centeredConnection, String content) {
        StringBuilder contentBuilder = new StringBuilder(content);
        for (DependencyNode target : node.mTargets) {
            String constraint = "\n" + node.name();
            constraint = constraint + " -> " + target.name();
            if (node.mMargin > 0 || centeredConnection || node.mRun instanceof HelperReferences) {
                constraint = constraint + "[";
                if (node.mMargin > 0) {
                    constraint = constraint + "label=\"" + node.mMargin + "\"";
                    if (centeredConnection) {
                        constraint = constraint + ",";
                    }
                }
                if (centeredConnection) {
                    constraint = constraint + " style=dashed ";
                }
                if (node.mRun instanceof HelperReferences) {
                    constraint = constraint + " style=bold,color=gray ";
                }
                constraint = constraint + "]";
            }
            constraint = constraint + "\n";
            contentBuilder.append(constraint);
        }
        content = contentBuilder.toString();
        return content;
    }

    private String nodeDefinition(WidgetRun run) {
        boolean orientation = run instanceof VerticalWidgetRun;
        String name = run.mWidget.getDebugName();
        StringBuilder definition = new StringBuilder(name);
        ConstraintWidget.DimensionBehaviour behaviour = !orientation ? run.mWidget.getHorizontalDimensionBehaviour() : run.mWidget.getVerticalDimensionBehaviour();
        RunGroup runGroup = run.mRunGroup;
        if (!orientation) {
            definition.append("_HORIZONTAL");
        } else {
            definition.append("_VERTICAL");
        }
        definition.append(" [shape=none, label=<");
        definition.append("<TABLE BORDER=\"0\" CELLSPACING=\"0\" CELLPADDING=\"2\">");
        definition.append("  <TR>");
        if (!orientation) {
            definition.append("    <TD ");
            if (run.start.resolved) {
                definition.append(" BGCOLOR=\"green\"");
            }
            definition.append(" PORT=\"LEFT\" BORDER=\"1\">L</TD>");
        } else {
            definition.append("    <TD ");
            if (run.start.resolved) {
                definition.append(" BGCOLOR=\"green\"");
            }
            definition.append(" PORT=\"TOP\" BORDER=\"1\">T</TD>");
        }
        definition.append("    <TD BORDER=\"1\" ");
        if (run.mDimension.resolved && !run.mWidget.measured) {
            definition.append(" BGCOLOR=\"green\" ");
        } else if (run.mDimension.resolved) {
            definition.append(" BGCOLOR=\"lightgray\" ");
        } else if (run.mWidget.measured) {
            definition.append(" BGCOLOR=\"yellow\" ");
        }
        if (behaviour == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT) {
            definition.append("style=\"dashed\"");
        }
        definition.append(">");
        definition.append(name);
        if (runGroup != null) {
            definition.append(" [");
            definition.append(runGroup.mGroupIndex + 1);
            definition.append("/");
            definition.append(RunGroup.index);
            definition.append("]");
        }
        definition.append(" </TD>");
        if (!orientation) {
            definition.append("    <TD ");
            if (run.end.resolved) {
                definition.append(" BGCOLOR=\"green\"");
            }
            definition.append(" PORT=\"RIGHT\" BORDER=\"1\">R</TD>");
        } else {
            definition.append("    <TD ");
            if (((VerticalWidgetRun)run).baseline.resolved) {
                definition.append(" BGCOLOR=\"green\"");
            }
            definition.append(" PORT=\"BASELINE\" BORDER=\"1\">b</TD>");
            definition.append("    <TD ");
            if (run.end.resolved) {
                definition.append(" BGCOLOR=\"green\"");
            }
            definition.append(" PORT=\"BOTTOM\" BORDER=\"1\">B</TD>");
        }
        definition.append("  </TR></TABLE>");
        definition.append(">];\n");
        return definition.toString();
    }

    private String generateChainDisplayGraph(ChainRun chain, String content) {
        int orientation = chain.orientation;
        StringBuilder subgroup = new StringBuilder("subgraph ");
        subgroup.append("cluster_");
        subgroup.append(chain.mWidget.getDebugName());
        if (orientation == 0) {
            subgroup.append("_h");
        } else {
            subgroup.append("_v");
        }
        subgroup.append(" {\n");
        String definitions = "";
        for (WidgetRun run : chain.mWidgets) {
            subgroup.append(run.mWidget.getDebugName());
            if (orientation == 0) {
                subgroup.append("_HORIZONTAL");
            } else {
                subgroup.append("_VERTICAL");
            }
            subgroup.append(";\n");
            definitions = this.generateDisplayGraph(run, definitions);
        }
        subgroup.append("}\n");
        return content + definitions + subgroup;
    }

    private boolean isCenteredConnection(DependencyNode start, DependencyNode end) {
        int startTargets = 0;
        int endTargets = 0;
        for (DependencyNode s : start.mTargets) {
            if (s == end) continue;
            ++startTargets;
        }
        for (DependencyNode e : end.mTargets) {
            if (e == start) continue;
            ++endTargets;
        }
        return startTargets > 0 && endTargets > 0;
    }

    private String generateDisplayGraph(WidgetRun root, String content) {
        ConstraintWidget.DimensionBehaviour behaviour;
        DependencyNode start = root.start;
        DependencyNode end = root.end;
        StringBuilder sb = new StringBuilder(content);
        if (!(root instanceof HelperReferences) && start.mDependencies.isEmpty() && end.mDependencies.isEmpty() && start.mTargets.isEmpty() && end.mTargets.isEmpty()) {
            return content;
        }
        sb.append(this.nodeDefinition(root));
        boolean centeredConnection = this.isCenteredConnection(start, end);
        content = this.generateDisplayNode(start, centeredConnection, content);
        content = this.generateDisplayNode(end, centeredConnection, content);
        if (root instanceof VerticalWidgetRun) {
            DependencyNode baseline = ((VerticalWidgetRun)root).baseline;
            content = this.generateDisplayNode(baseline, centeredConnection, content);
        }
        if (root instanceof HorizontalWidgetRun || root instanceof ChainRun && ((ChainRun)root).orientation == 0) {
            behaviour = root.mWidget.getHorizontalDimensionBehaviour();
            if (behaviour == ConstraintWidget.DimensionBehaviour.FIXED || behaviour == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT) {
                if (!start.mTargets.isEmpty() && end.mTargets.isEmpty()) {
                    sb.append("\n");
                    sb.append(end.name());
                    sb.append(" -> ");
                    sb.append(start.name());
                    sb.append("\n");
                } else if (start.mTargets.isEmpty() && !end.mTargets.isEmpty()) {
                    sb.append("\n");
                    sb.append(start.name());
                    sb.append(" -> ");
                    sb.append(end.name());
                    sb.append("\n");
                }
            } else if (behaviour == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT && root.mWidget.getDimensionRatio() > 0.0f) {
                sb.append("\n");
                sb.append(root.mWidget.getDebugName());
                sb.append("_HORIZONTAL -> ");
                sb.append(root.mWidget.getDebugName());
                sb.append("_VERTICAL;\n");
            }
        } else if (root instanceof VerticalWidgetRun || root instanceof ChainRun && ((ChainRun)root).orientation == 1) {
            behaviour = root.mWidget.getVerticalDimensionBehaviour();
            if (behaviour == ConstraintWidget.DimensionBehaviour.FIXED || behaviour == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT) {
                if (!start.mTargets.isEmpty() && end.mTargets.isEmpty()) {
                    sb.append("\n");
                    sb.append(end.name());
                    sb.append(" -> ");
                    sb.append(start.name());
                    sb.append("\n");
                } else if (start.mTargets.isEmpty() && !end.mTargets.isEmpty()) {
                    sb.append("\n");
                    sb.append(start.name());
                    sb.append(" -> ");
                    sb.append(end.name());
                    sb.append("\n");
                }
            } else if (behaviour == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT && root.mWidget.getDimensionRatio() > 0.0f) {
                sb.append("\n");
                sb.append(root.mWidget.getDebugName());
                sb.append("_VERTICAL -> ");
                sb.append(root.mWidget.getDebugName());
                sb.append("_HORIZONTAL;\n");
            }
        }
        if (root instanceof ChainRun) {
            return this.generateChainDisplayGraph((ChainRun)root, content);
        }
        return sb.toString();
    }
}

