/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.state.helpers;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.constraintlayout.core.state.HelperReference;
import androidx.constraintlayout.core.state.State;
import androidx.constraintlayout.core.utils.GridCore;
import androidx.constraintlayout.core.widgets.HelperWidget;
import java.util.ArrayList;
import java.util.Iterator;

public class GridReference
extends HelperReference {
    private static final String SPANS_RESPECT_WIDGET_ORDER = "spansrespectwidgetorder";
    private static final String SUB_GRID_BY_COL_ROW = "subgridbycolrow";
    private GridCore mGrid;
    private int mPaddingLeft = 0;
    private int mPaddingRight = 0;
    private int mPaddingTop = 0;
    private int mPaddingBottom = 0;
    private int mOrientation;
    private int mRowsSet;
    private int mColumnsSet;
    private float mHorizontalGaps;
    private float mVerticalGaps;
    private String mRowWeights;
    private String mColumnWeights;
    private String mSpans;
    private String mSkips;
    private int[] mFlags;

    public GridReference(@NonNull State state, @NonNull State.Helper type) {
        super(state, type);
        if (type == State.Helper.ROW) {
            this.mRowsSet = 1;
        } else if (type == State.Helper.COLUMN) {
            this.mColumnsSet = 1;
        }
    }

    public int getPaddingLeft() {
        return this.mPaddingLeft;
    }

    public void setPaddingLeft(int paddingLeft) {
        this.mPaddingLeft = paddingLeft;
    }

    public int getPaddingRight() {
        return this.mPaddingRight;
    }

    public void setPaddingRight(int paddingRight) {
        this.mPaddingRight = paddingRight;
    }

    public int getPaddingTop() {
        return this.mPaddingTop;
    }

    public void setPaddingTop(int paddingTop) {
        this.mPaddingTop = paddingTop;
    }

    public int getPaddingBottom() {
        return this.mPaddingBottom;
    }

    public void setPaddingBottom(int paddingBottom) {
        this.mPaddingBottom = paddingBottom;
    }

    @NonNull
    public int[] getFlags() {
        return this.mFlags;
    }

    public void setFlags(@NonNull int[] flags) {
        this.mFlags = flags;
    }

    public void setFlags(@NonNull String flags) {
        if (flags.length() == 0) {
            return;
        }
        String[] strArr = flags.split("\\|");
        ArrayList<Integer> flagList = new ArrayList<Integer>();
        block8: for (String flag : strArr) {
            switch (flag.toLowerCase()) {
                case "subgridbycolrow": {
                    flagList.add(0);
                    continue block8;
                }
                case "spansrespectwidgetorder": {
                    flagList.add(1);
                }
            }
        }
        int[] flagArr = new int[flagList.size()];
        int i = 0;
        Iterator iterator = flagList.iterator();
        while (iterator.hasNext()) {
            int flag = (Integer)iterator.next();
            flagArr[i++] = flag;
        }
        this.mFlags = flagArr;
    }

    public int getRowsSet() {
        return this.mRowsSet;
    }

    public void setRowsSet(int rowsSet) {
        if (super.getType() == State.Helper.COLUMN) {
            return;
        }
        this.mRowsSet = rowsSet;
    }

    public int getColumnsSet() {
        return this.mColumnsSet;
    }

    public void setColumnsSet(int columnsSet) {
        if (super.getType() == State.Helper.ROW) {
            return;
        }
        this.mColumnsSet = columnsSet;
    }

    public float getHorizontalGaps() {
        return this.mHorizontalGaps;
    }

    public void setHorizontalGaps(float horizontalGaps) {
        this.mHorizontalGaps = horizontalGaps;
    }

    public float getVerticalGaps() {
        return this.mVerticalGaps;
    }

    public void setVerticalGaps(float verticalGaps) {
        this.mVerticalGaps = verticalGaps;
    }

    @Nullable
    public String getRowWeights() {
        return this.mRowWeights;
    }

    public void setRowWeights(@NonNull String rowWeights) {
        this.mRowWeights = rowWeights;
    }

    @Nullable
    public String getColumnWeights() {
        return this.mColumnWeights;
    }

    public void setColumnWeights(@NonNull String columnWeights) {
        this.mColumnWeights = columnWeights;
    }

    @Nullable
    public String getSpans() {
        return this.mSpans;
    }

    public void setSpans(@NonNull String spans) {
        this.mSpans = spans;
    }

    @Nullable
    public String getSkips() {
        return this.mSkips;
    }

    public void setSkips(@NonNull String skips) {
        this.mSkips = skips;
    }

    @Override
    @NonNull
    public HelperWidget getHelperWidget() {
        if (this.mGrid == null) {
            this.mGrid = new GridCore();
        }
        return this.mGrid;
    }

    @Override
    public void setHelperWidget(@Nullable HelperWidget widget) {
        this.mGrid = widget instanceof GridCore ? (GridCore)widget : null;
    }

    public int getOrientation() {
        return this.mOrientation;
    }

    public void setOrientation(int orientation) {
        this.mOrientation = orientation;
    }

    @Override
    public void apply() {
        this.getHelperWidget();
        this.mGrid.setOrientation(this.mOrientation);
        if (this.mRowsSet != 0) {
            this.mGrid.setRows(this.mRowsSet);
        }
        if (this.mColumnsSet != 0) {
            this.mGrid.setColumns(this.mColumnsSet);
        }
        if (this.mHorizontalGaps != 0.0f) {
            this.mGrid.setHorizontalGaps(this.mHorizontalGaps);
        }
        if (this.mVerticalGaps != 0.0f) {
            this.mGrid.setVerticalGaps(this.mVerticalGaps);
        }
        if (this.mRowWeights != null && !this.mRowWeights.equals("")) {
            this.mGrid.setRowWeights(this.mRowWeights);
        }
        if (this.mColumnWeights != null && !this.mColumnWeights.equals("")) {
            this.mGrid.setColumnWeights(this.mColumnWeights);
        }
        if (this.mSpans != null && !this.mSpans.equals("")) {
            this.mGrid.setSpans(this.mSpans);
        }
        if (this.mSkips != null && !this.mSkips.equals("")) {
            this.mGrid.setSkips(this.mSkips);
        }
        if (this.mFlags != null && this.mFlags.length > 0) {
            this.mGrid.setFlags(this.mFlags);
        }
        this.applyBase();
    }
}

