/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.parser;

import androidx.constraintlayout.core.parser.CLContainer;
import androidx.constraintlayout.core.parser.CLElement;

public class CLArray
extends CLContainer {
    public CLArray(char[] content) {
        super(content);
    }

    public static CLElement allocate(char[] content) {
        return new CLArray(content);
    }

    @Override
    protected String toJSON() {
        StringBuilder content = new StringBuilder(this.getDebugName() + "[");
        boolean first = true;
        for (int i = 0; i < this.mElements.size(); ++i) {
            if (!first) {
                content.append(", ");
            } else {
                first = false;
            }
            content.append(((CLElement)this.mElements.get(i)).toJSON());
        }
        return content + "]";
    }

    @Override
    protected String toFormattedJSON(int indent, int forceIndent) {
        StringBuilder json = new StringBuilder();
        String val = this.toJSON();
        if (forceIndent <= 0 && val.length() + indent < sMaxLine) {
            json.append(val);
        } else {
            json.append("[\n");
            boolean first = true;
            for (CLElement element : this.mElements) {
                if (!first) {
                    json.append(",\n");
                } else {
                    first = false;
                }
                this.addIndent(json, indent + sBaseIndent);
                json.append(element.toFormattedJSON(indent + sBaseIndent, forceIndent - 1));
            }
            json.append("\n");
            this.addIndent(json, indent);
            json.append("]");
        }
        return json.toString();
    }
}

