/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.parser;

import androidx.annotation.NonNull;
import androidx.constraintlayout.core.parser.CLElement;

public class CLString
extends CLElement {
    public CLString(char[] content) {
        super(content);
    }

    public static CLElement allocate(char[] content) {
        return new CLString(content);
    }

    @NonNull
    public static CLString from(@NonNull String content) {
        CLString stringElement = new CLString(content.toCharArray());
        stringElement.setStart(0L);
        stringElement.setEnd(content.length() - 1);
        return stringElement;
    }

    @Override
    protected String toJSON() {
        return "'" + this.content() + "'";
    }

    @Override
    protected String toFormattedJSON(int indent, int forceIndent) {
        StringBuilder json = new StringBuilder();
        this.addIndent(json, indent);
        json.append("'");
        json.append(this.content());
        json.append("'");
        return json.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof CLString && this.content().equals(((CLString)obj).content())) {
            return true;
        }
        return super.equals(obj);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

