/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.motion;

import androidx.constraintlayout.core.motion.CustomVariable;
import androidx.constraintlayout.core.motion.MotionConstrainedPoint;
import androidx.constraintlayout.core.motion.MotionPaths;
import androidx.constraintlayout.core.motion.MotionWidget;
import androidx.constraintlayout.core.motion.key.MotionKey;
import androidx.constraintlayout.core.motion.key.MotionKeyAttributes;
import androidx.constraintlayout.core.motion.key.MotionKeyCycle;
import androidx.constraintlayout.core.motion.key.MotionKeyPosition;
import androidx.constraintlayout.core.motion.key.MotionKeyTimeCycle;
import androidx.constraintlayout.core.motion.key.MotionKeyTrigger;
import androidx.constraintlayout.core.motion.utils.CurveFit;
import androidx.constraintlayout.core.motion.utils.DifferentialInterpolator;
import androidx.constraintlayout.core.motion.utils.Easing;
import androidx.constraintlayout.core.motion.utils.FloatRect;
import androidx.constraintlayout.core.motion.utils.KeyCache;
import androidx.constraintlayout.core.motion.utils.KeyCycleOscillator;
import androidx.constraintlayout.core.motion.utils.KeyFrameArray;
import androidx.constraintlayout.core.motion.utils.Rect;
import androidx.constraintlayout.core.motion.utils.SplineSet;
import androidx.constraintlayout.core.motion.utils.TimeCycleSplineSet;
import androidx.constraintlayout.core.motion.utils.TypedBundle;
import androidx.constraintlayout.core.motion.utils.TypedValues;
import androidx.constraintlayout.core.motion.utils.Utils;
import androidx.constraintlayout.core.motion.utils.VelocityMatrix;
import androidx.constraintlayout.core.motion.utils.ViewState;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;

public class Motion
implements TypedValues {
    public static final int PATH_PERCENT = 0;
    public static final int PATH_PERPENDICULAR = 1;
    public static final int HORIZONTAL_PATH_X = 2;
    public static final int HORIZONTAL_PATH_Y = 3;
    public static final int VERTICAL_PATH_X = 4;
    public static final int VERTICAL_PATH_Y = 5;
    public static final int DRAW_PATH_NONE = 0;
    public static final int DRAW_PATH_BASIC = 1;
    public static final int DRAW_PATH_RELATIVE = 2;
    public static final int DRAW_PATH_CARTESIAN = 3;
    public static final int DRAW_PATH_AS_CONFIGURED = 4;
    public static final int DRAW_PATH_RECTANGLE = 5;
    public static final int DRAW_PATH_SCREEN = 6;
    public static final int ROTATION_RIGHT = 1;
    public static final int ROTATION_LEFT = 2;
    Rect mTempRect = new Rect();
    private static final String TAG = "MotionController";
    private static final boolean DEBUG = false;
    private static final boolean FAVOR_FIXED_SIZE_VIEWS = false;
    MotionWidget mView;
    public String mId;
    String mConstraintTag;
    private int mCurveFitType = 0;
    private MotionPaths mStartMotionPath = new MotionPaths();
    private MotionPaths mEndMotionPath = new MotionPaths();
    private MotionConstrainedPoint mStartPoint = new MotionConstrainedPoint();
    private MotionConstrainedPoint mEndPoint = new MotionConstrainedPoint();
    private CurveFit[] mSpline;
    private CurveFit mArcSpline;
    float mMotionStagger = Float.NaN;
    float mStaggerOffset = 0.0f;
    float mStaggerScale = 1.0f;
    float mCurrentCenterX;
    float mCurrentCenterY;
    private int[] mInterpolateVariables;
    private double[] mInterpolateData;
    private double[] mInterpolateVelocity;
    private String[] mAttributeNames;
    private int[] mAttributeInterpolatorCount;
    private int mMaxDimension = 4;
    private float[] mValuesBuff = new float[this.mMaxDimension];
    private ArrayList<MotionPaths> mMotionPaths = new ArrayList();
    private float[] mVelocity = new float[1];
    private ArrayList<MotionKey> mKeyList = new ArrayList();
    private HashMap<String, TimeCycleSplineSet> mTimeCycleAttributesMap;
    private HashMap<String, SplineSet> mAttributesMap;
    private HashMap<String, KeyCycleOscillator> mCycleMap;
    private MotionKeyTrigger[] mKeyTriggers;
    private int mPathMotionArc = -1;
    private int mTransformPivotTarget = -1;
    private MotionWidget mTransformPivotView = null;
    private int mQuantizeMotionSteps = -1;
    private float mQuantizeMotionPhase = Float.NaN;
    private DifferentialInterpolator mQuantizeMotionInterpolator = null;
    private boolean mNoMovement = false;
    Motion mRelativeMotion;
    String[] mAttributeTable;
    static final int EASE_IN_OUT = 0;
    static final int EASE_IN = 1;
    static final int EASE_OUT = 2;
    static final int LINEAR = 3;
    static final int BOUNCE = 4;
    static final int OVERSHOOT = 5;
    private static final int SPLINE_STRING = -1;
    private static final int INTERPOLATOR_REFERENCE_ID = -2;
    private static final int INTERPOLATOR_UNDEFINED = -3;

    public int getTransformPivotTarget() {
        return this.mTransformPivotTarget;
    }

    public void setTransformPivotTarget(int transformPivotTarget) {
        this.mTransformPivotTarget = transformPivotTarget;
        this.mTransformPivotView = null;
    }

    public MotionPaths getKeyFrame(int i) {
        return this.mMotionPaths.get(i);
    }

    public Motion(MotionWidget view) {
        this.setView(view);
    }

    public float getStartX() {
        return this.mStartMotionPath.mX;
    }

    public float getStartY() {
        return this.mStartMotionPath.mY;
    }

    public float getFinalX() {
        return this.mEndMotionPath.mX;
    }

    public float getFinalY() {
        return this.mEndMotionPath.mY;
    }

    public float getStartWidth() {
        return this.mStartMotionPath.mWidth;
    }

    public float getStartHeight() {
        return this.mStartMotionPath.mHeight;
    }

    public float getFinalWidth() {
        return this.mEndMotionPath.mWidth;
    }

    public float getFinalHeight() {
        return this.mEndMotionPath.mHeight;
    }

    public String getAnimateRelativeTo() {
        return this.mStartMotionPath.mAnimateRelativeTo;
    }

    public void setupRelative(Motion motionController) {
        this.mRelativeMotion = motionController;
    }

    private void setupRelative() {
        if (this.mRelativeMotion == null) {
            return;
        }
        this.mStartMotionPath.setupRelative(this.mRelativeMotion, this.mRelativeMotion.mStartMotionPath);
        this.mEndMotionPath.setupRelative(this.mRelativeMotion, this.mRelativeMotion.mEndMotionPath);
    }

    public float getCenterX() {
        return this.mCurrentCenterX;
    }

    public float getCenterY() {
        return this.mCurrentCenterY;
    }

    public void getCenter(double p, float[] pos, float[] vel) {
        double[] position = new double[4];
        double[] velocity = new double[4];
        this.mSpline[0].getPos(p, position);
        this.mSpline[0].getSlope(p, velocity);
        Arrays.fill(vel, 0.0f);
        this.mStartMotionPath.getCenter(p, this.mInterpolateVariables, position, pos, velocity, vel);
    }

    public void buildPath(float[] points, int pointCount) {
        float mils = 1.0f / (float)(pointCount - 1);
        SplineSet trans_x = this.mAttributesMap == null ? null : this.mAttributesMap.get("translationX");
        SplineSet trans_y = this.mAttributesMap == null ? null : this.mAttributesMap.get("translationY");
        KeyCycleOscillator osc_x = this.mCycleMap == null ? null : this.mCycleMap.get("translationX");
        KeyCycleOscillator osc_y = this.mCycleMap == null ? null : this.mCycleMap.get("translationY");
        for (int i = 0; i < pointCount; ++i) {
            float position = (float)i * mils;
            if (this.mStaggerScale != 1.0f) {
                if (position < this.mStaggerOffset) {
                    position = 0.0f;
                }
                if (position > this.mStaggerOffset && (double)position < 1.0) {
                    position -= this.mStaggerOffset;
                    position *= this.mStaggerScale;
                    position = Math.min(position, 1.0f);
                }
            }
            double p = position;
            Easing easing = this.mStartMotionPath.mKeyFrameEasing;
            float start = 0.0f;
            float end = Float.NaN;
            for (MotionPaths frame : this.mMotionPaths) {
                if (frame.mKeyFrameEasing == null) continue;
                if (frame.mTime < position) {
                    easing = frame.mKeyFrameEasing;
                    start = frame.mTime;
                    continue;
                }
                if (!Float.isNaN(end)) continue;
                end = frame.mTime;
            }
            if (easing != null) {
                if (Float.isNaN(end)) {
                    end = 1.0f;
                }
                float offset = (position - start) / (end - start);
                offset = (float)easing.get(offset);
                p = offset * (end - start) + start;
            }
            this.mSpline[0].getPos(p, this.mInterpolateData);
            if (this.mArcSpline != null && this.mInterpolateData.length > 0) {
                this.mArcSpline.getPos(p, this.mInterpolateData);
            }
            this.mStartMotionPath.getCenter(p, this.mInterpolateVariables, this.mInterpolateData, points, i * 2);
            if (osc_x != null) {
                int n = i * 2;
                points[n] = points[n] + osc_x.get(position);
            } else if (trans_x != null) {
                int n = i * 2;
                points[n] = points[n] + trans_x.get(position);
            }
            if (osc_y != null) {
                int n = i * 2 + 1;
                points[n] = points[n] + osc_y.get(position);
                continue;
            }
            if (trans_y == null) continue;
            int n = i * 2 + 1;
            points[n] = points[n] + trans_y.get(position);
        }
    }

    double[] getPos(double position) {
        this.mSpline[0].getPos(position, this.mInterpolateData);
        if (this.mArcSpline != null && this.mInterpolateData.length > 0) {
            this.mArcSpline.getPos(position, this.mInterpolateData);
        }
        return this.mInterpolateData;
    }

    void buildBounds(float[] bounds, int pointCount) {
        float mils = 1.0f / (float)(pointCount - 1);
        SplineSet trans_x = this.mAttributesMap == null ? null : this.mAttributesMap.get("translationX");
        SplineSet trans_y = this.mAttributesMap == null ? null : this.mAttributesMap.get("translationY");
        KeyCycleOscillator osc_x = this.mCycleMap == null ? null : this.mCycleMap.get("translationX");
        KeyCycleOscillator osc_y = this.mCycleMap == null ? null : this.mCycleMap.get("translationY");
        for (int i = 0; i < pointCount; ++i) {
            float position = (float)i * mils;
            if (this.mStaggerScale != 1.0f) {
                if (position < this.mStaggerOffset) {
                    position = 0.0f;
                }
                if (position > this.mStaggerOffset && (double)position < 1.0) {
                    position -= this.mStaggerOffset;
                    position *= this.mStaggerScale;
                    position = Math.min(position, 1.0f);
                }
            }
            double p = position;
            Easing easing = this.mStartMotionPath.mKeyFrameEasing;
            float start = 0.0f;
            float end = Float.NaN;
            for (MotionPaths frame : this.mMotionPaths) {
                if (frame.mKeyFrameEasing == null) continue;
                if (frame.mTime < position) {
                    easing = frame.mKeyFrameEasing;
                    start = frame.mTime;
                    continue;
                }
                if (!Float.isNaN(end)) continue;
                end = frame.mTime;
            }
            if (easing != null) {
                if (Float.isNaN(end)) {
                    end = 1.0f;
                }
                float offset = (position - start) / (end - start);
                offset = (float)easing.get(offset);
                p = offset * (end - start) + start;
            }
            this.mSpline[0].getPos(p, this.mInterpolateData);
            if (this.mArcSpline != null && this.mInterpolateData.length > 0) {
                this.mArcSpline.getPos(p, this.mInterpolateData);
            }
            this.mStartMotionPath.getBounds(this.mInterpolateVariables, this.mInterpolateData, bounds, i * 2);
        }
    }

    private float getPreCycleDistance() {
        int pointCount = 100;
        float[] points = new float[2];
        float sum = 0.0f;
        float mils = 1.0f / (float)(pointCount - 1);
        double x = 0.0;
        double y = 0.0;
        for (int i = 0; i < pointCount; ++i) {
            float position = (float)i * mils;
            double p = position;
            Easing easing = this.mStartMotionPath.mKeyFrameEasing;
            float start = 0.0f;
            float end = Float.NaN;
            for (MotionPaths frame : this.mMotionPaths) {
                if (frame.mKeyFrameEasing == null) continue;
                if (frame.mTime < position) {
                    easing = frame.mKeyFrameEasing;
                    start = frame.mTime;
                    continue;
                }
                if (!Float.isNaN(end)) continue;
                end = frame.mTime;
            }
            if (easing != null) {
                if (Float.isNaN(end)) {
                    end = 1.0f;
                }
                float offset = (position - start) / (end - start);
                offset = (float)easing.get(offset);
                p = offset * (end - start) + start;
            }
            this.mSpline[0].getPos(p, this.mInterpolateData);
            this.mStartMotionPath.getCenter(p, this.mInterpolateVariables, this.mInterpolateData, points, 0);
            if (i > 0) {
                sum += (float)Math.hypot(y - (double)points[1], x - (double)points[0]);
            }
            x = points[0];
            y = points[1];
        }
        return sum;
    }

    MotionKeyPosition getPositionKeyframe(int layoutWidth, int layoutHeight, float x, float y) {
        FloatRect start = new FloatRect();
        start.left = this.mStartMotionPath.mX;
        start.top = this.mStartMotionPath.mY;
        start.right = start.left + this.mStartMotionPath.mWidth;
        start.bottom = start.top + this.mStartMotionPath.mHeight;
        FloatRect end = new FloatRect();
        end.left = this.mEndMotionPath.mX;
        end.top = this.mEndMotionPath.mY;
        end.right = end.left + this.mEndMotionPath.mWidth;
        end.bottom = end.top + this.mEndMotionPath.mHeight;
        for (MotionKey key : this.mKeyList) {
            if (!(key instanceof MotionKeyPosition) || !((MotionKeyPosition)key).intersects(layoutWidth, layoutHeight, start, end, x, y)) continue;
            return (MotionKeyPosition)key;
        }
        return null;
    }

    public int buildKeyFrames(float[] keyFrames, int[] mode, int[] pos) {
        if (keyFrames != null) {
            int count = 0;
            double[] time = this.mSpline[0].getTimePoints();
            if (mode != null) {
                for (MotionPaths keyFrame : this.mMotionPaths) {
                    mode[count++] = keyFrame.mMode;
                }
                count = 0;
            }
            if (pos != null) {
                for (MotionPaths keyFrame : this.mMotionPaths) {
                    pos[count++] = (int)(100.0f * keyFrame.mPosition);
                }
                count = 0;
            }
            for (int i = 0; i < time.length; ++i) {
                this.mSpline[0].getPos(time[i], this.mInterpolateData);
                this.mStartMotionPath.getCenter(time[i], this.mInterpolateVariables, this.mInterpolateData, keyFrames, count);
                count += 2;
            }
            return count / 2;
        }
        return 0;
    }

    int buildKeyBounds(float[] keyBounds, int[] mode) {
        if (keyBounds != null) {
            int count = 0;
            double[] time = this.mSpline[0].getTimePoints();
            if (mode != null) {
                for (MotionPaths keyFrame : this.mMotionPaths) {
                    mode[count++] = keyFrame.mMode;
                }
                count = 0;
            }
            for (int i = 0; i < time.length; ++i) {
                this.mSpline[0].getPos(time[i], this.mInterpolateData);
                this.mStartMotionPath.getBounds(this.mInterpolateVariables, this.mInterpolateData, keyBounds, count);
                count += 2;
            }
            return count / 2;
        }
        return 0;
    }

    int getAttributeValues(String attributeType, float[] points, int pointCount) {
        float mils = 1.0f / (float)(pointCount - 1);
        SplineSet spline = this.mAttributesMap.get(attributeType);
        if (spline == null) {
            return -1;
        }
        for (int j = 0; j < points.length; ++j) {
            points[j] = spline.get(j / (points.length - 1));
        }
        return points.length;
    }

    public void buildRect(float p, float[] path, int offset) {
        p = this.getAdjustedPosition(p, null);
        this.mSpline[0].getPos((double)p, this.mInterpolateData);
        this.mStartMotionPath.getRect(this.mInterpolateVariables, this.mInterpolateData, path, offset);
    }

    void buildRectangles(float[] path, int pointCount) {
        float mils = 1.0f / (float)(pointCount - 1);
        for (int i = 0; i < pointCount; ++i) {
            float position = (float)i * mils;
            position = this.getAdjustedPosition(position, null);
            this.mSpline[0].getPos((double)position, this.mInterpolateData);
            this.mStartMotionPath.getRect(this.mInterpolateVariables, this.mInterpolateData, path, i * 8);
        }
    }

    float getKeyFrameParameter(int type, float x, float y) {
        float dx = this.mEndMotionPath.mX - this.mStartMotionPath.mX;
        float dy = this.mEndMotionPath.mY - this.mStartMotionPath.mY;
        float startCenterX = this.mStartMotionPath.mX + this.mStartMotionPath.mWidth / 2.0f;
        float startCenterY = this.mStartMotionPath.mY + this.mStartMotionPath.mHeight / 2.0f;
        float hypotenuse = (float)Math.hypot(dx, dy);
        if ((double)hypotenuse < 1.0E-7) {
            return Float.NaN;
        }
        float vx = x - startCenterX;
        float vy = y - startCenterY;
        float distFromStart = (float)Math.hypot(vx, vy);
        if (distFromStart == 0.0f) {
            return 0.0f;
        }
        float pathDistance = vx * dx + vy * dy;
        switch (type) {
            case 0: {
                return pathDistance / hypotenuse;
            }
            case 1: {
                return (float)Math.sqrt(hypotenuse * hypotenuse - pathDistance * pathDistance);
            }
            case 2: {
                return vx / dx;
            }
            case 3: {
                return vy / dx;
            }
            case 4: {
                return vx / dy;
            }
            case 5: {
                return vy / dy;
            }
        }
        return 0.0f;
    }

    private void insertKey(MotionPaths point) {
        int pos;
        MotionPaths redundant = null;
        for (MotionPaths p : this.mMotionPaths) {
            if (point.mPosition != p.mPosition) continue;
            redundant = p;
        }
        if (redundant != null) {
            this.mMotionPaths.remove(redundant);
        }
        if ((pos = Collections.binarySearch(this.mMotionPaths, point)) == 0) {
            Utils.loge(TAG, " KeyPath position \"" + point.mPosition + "\" outside of range");
        }
        this.mMotionPaths.add(-pos - 1, point);
    }

    void addKeys(ArrayList<MotionKey> list) {
        this.mKeyList.addAll(list);
    }

    public void addKey(MotionKey key) {
        this.mKeyList.add(key);
    }

    public void setPathMotionArc(int arc) {
        this.mPathMotionArc = arc;
    }

    public void setup(int parentWidth, int parentHeight, float transitionDuration, long currentTime) {
        int i;
        int i2;
        CustomVariable customAttribute;
        Object customAttributeName;
        KeyFrameArray.CustomVar attrList;
        HashSet springAttributes = new HashSet();
        HashSet<String> timeCycleAttributes = new HashSet<String>();
        HashSet<String> splineAttributes = new HashSet<String>();
        HashSet<String> cycleAttributes = new HashSet<String>();
        HashMap<String, Integer> interpolation = new HashMap<String, Integer>();
        ArrayList<MotionKeyTrigger> triggerList = null;
        this.setupRelative();
        if (this.mPathMotionArc != -1 && this.mStartMotionPath.mPathMotionArc == -1) {
            this.mStartMotionPath.mPathMotionArc = this.mPathMotionArc;
        }
        this.mStartPoint.different(this.mEndPoint, splineAttributes);
        if (this.mKeyList != null) {
            for (MotionKey key : this.mKeyList) {
                if (key instanceof MotionKeyPosition) {
                    MotionKeyPosition keyPath = (MotionKeyPosition)key;
                    this.insertKey(new MotionPaths(parentWidth, parentHeight, keyPath, this.mStartMotionPath, this.mEndMotionPath));
                    if (keyPath.mCurveFit == -1) continue;
                    this.mCurveFitType = keyPath.mCurveFit;
                    continue;
                }
                if (key instanceof MotionKeyCycle) {
                    key.getAttributeNames(cycleAttributes);
                    continue;
                }
                if (key instanceof MotionKeyTimeCycle) {
                    key.getAttributeNames(timeCycleAttributes);
                    continue;
                }
                if (key instanceof MotionKeyTrigger) {
                    if (triggerList == null) {
                        triggerList = new ArrayList<MotionKeyTrigger>();
                    }
                    triggerList.add((MotionKeyTrigger)key);
                    continue;
                }
                key.setInterpolation(interpolation);
                key.getAttributeNames(splineAttributes);
            }
        }
        if (triggerList != null) {
            this.mKeyTriggers = triggerList.toArray(new MotionKeyTrigger[0]);
        }
        if (!splineAttributes.isEmpty()) {
            this.mAttributesMap = new HashMap();
            for (String attribute : splineAttributes) {
                SplineSet splineSets;
                if (attribute.startsWith("CUSTOM,")) {
                    attrList = new KeyFrameArray.CustomVar();
                    customAttributeName = attribute.split(",")[1];
                    for (MotionKey key : this.mKeyList) {
                        if (key.mCustom == null || (customAttribute = key.mCustom.get(customAttributeName)) == null) continue;
                        attrList.append(key.mFramePosition, customAttribute);
                    }
                    splineSets = SplineSet.makeCustomSplineSet(attribute, attrList);
                } else {
                    splineSets = SplineSet.makeSpline(attribute, currentTime);
                }
                if (splineSets == null) continue;
                splineSets.setType(attribute);
                this.mAttributesMap.put(attribute, splineSets);
            }
            if (this.mKeyList != null) {
                for (MotionKey key : this.mKeyList) {
                    if (!(key instanceof MotionKeyAttributes)) continue;
                    key.addValues(this.mAttributesMap);
                }
            }
            this.mStartPoint.addValues(this.mAttributesMap, 0);
            this.mEndPoint.addValues(this.mAttributesMap, 100);
            for (String spline : this.mAttributesMap.keySet()) {
                SplineSet splineSet;
                Integer boxedCurve;
                int curve = 0;
                if (interpolation.containsKey(spline) && (boxedCurve = interpolation.get(spline)) != null) {
                    curve = boxedCurve;
                }
                if ((splineSet = this.mAttributesMap.get(spline)) == null) continue;
                splineSet.setup(curve);
            }
        }
        if (!timeCycleAttributes.isEmpty()) {
            if (this.mTimeCycleAttributesMap == null) {
                this.mTimeCycleAttributesMap = new HashMap();
            }
            for (String attribute : timeCycleAttributes) {
                if (this.mTimeCycleAttributesMap.containsKey(attribute)) continue;
                SplineSet splineSets = null;
                if (attribute.startsWith("CUSTOM,")) {
                    attrList = new KeyFrameArray.CustomVar();
                    customAttributeName = attribute.split(",")[1];
                    for (MotionKey key : this.mKeyList) {
                        if (key.mCustom == null || (customAttribute = key.mCustom.get(customAttributeName)) == null) continue;
                        attrList.append(key.mFramePosition, customAttribute);
                    }
                    splineSets = SplineSet.makeCustomSplineSet(attribute, attrList);
                } else {
                    splineSets = SplineSet.makeSpline(attribute, currentTime);
                }
                if (splineSets == null) continue;
                splineSets.setType(attribute);
            }
            if (this.mKeyList != null) {
                for (MotionKey key : this.mKeyList) {
                    if (!(key instanceof MotionKeyTimeCycle)) continue;
                    ((MotionKeyTimeCycle)key).addTimeValues(this.mTimeCycleAttributesMap);
                }
            }
            for (String spline : this.mTimeCycleAttributesMap.keySet()) {
                int curve = 0;
                if (interpolation.containsKey(spline)) {
                    curve = interpolation.get(spline);
                }
                this.mTimeCycleAttributesMap.get(spline).setup(curve);
            }
        }
        MotionPaths[] points = new MotionPaths[2 + this.mMotionPaths.size()];
        int count = 1;
        points[0] = this.mStartMotionPath;
        points[points.length - 1] = this.mEndMotionPath;
        if (this.mMotionPaths.size() > 0 && this.mCurveFitType == MotionKey.UNSET) {
            this.mCurveFitType = 0;
        }
        for (MotionPaths point : this.mMotionPaths) {
            points[count++] = point;
        }
        int variables = 18;
        HashSet<String> attributeNameSet = new HashSet<String>();
        for (String s : this.mEndMotionPath.mCustomAttributes.keySet()) {
            if (!this.mStartMotionPath.mCustomAttributes.containsKey(s) || splineAttributes.contains("CUSTOM," + s)) continue;
            attributeNameSet.add(s);
        }
        this.mAttributeNames = attributeNameSet.toArray(new String[0]);
        this.mAttributeInterpolatorCount = new int[this.mAttributeNames.length];
        block11: for (int i3 = 0; i3 < this.mAttributeNames.length; ++i3) {
            String attributeName = this.mAttributeNames[i3];
            this.mAttributeInterpolatorCount[i3] = 0;
            for (int j = 0; j < points.length; ++j) {
                CustomVariable attribute;
                if (!points[j].mCustomAttributes.containsKey(attributeName) || (attribute = points[j].mCustomAttributes.get(attributeName)) == null) continue;
                int n = i3;
                this.mAttributeInterpolatorCount[n] = this.mAttributeInterpolatorCount[n] + attribute.numberOfInterpolatedValues();
                continue block11;
            }
        }
        boolean arcMode = points[0].mPathMotionArc != -1;
        boolean[] mask = new boolean[variables + this.mAttributeNames.length];
        for (i2 = 1; i2 < points.length; ++i2) {
            points[i2].different(points[i2 - 1], mask, this.mAttributeNames, arcMode);
        }
        count = 0;
        for (i2 = 1; i2 < mask.length; ++i2) {
            if (!mask[i2]) continue;
            ++count;
        }
        this.mInterpolateVariables = new int[count];
        int varLen = Math.max(2, count);
        this.mInterpolateData = new double[varLen];
        this.mInterpolateVelocity = new double[varLen];
        count = 0;
        for (int i4 = 1; i4 < mask.length; ++i4) {
            if (!mask[i4]) continue;
            this.mInterpolateVariables[count++] = i4;
        }
        double[][] splineData = new double[points.length][this.mInterpolateVariables.length];
        double[] timePoint = new double[points.length];
        for (i = 0; i < points.length; ++i) {
            points[i].fillStandard(splineData[i], this.mInterpolateVariables);
            timePoint[i] = points[i].mTime;
        }
        for (int j = 0; j < this.mInterpolateVariables.length; ++j) {
            int interpolateVariable = this.mInterpolateVariables[j];
            if (interpolateVariable >= MotionPaths.sNames.length) continue;
            String s = MotionPaths.sNames[this.mInterpolateVariables[j]] + " [";
            for (int i5 = 0; i5 < points.length; ++i5) {
                s = s + splineData[i5][j];
            }
        }
        this.mSpline = new CurveFit[1 + this.mAttributeNames.length];
        for (i = 0; i < this.mAttributeNames.length; ++i) {
            int pointCount = 0;
            double[][] splinePoints = null;
            double[] timePoints = null;
            String name = this.mAttributeNames[i];
            for (int j = 0; j < points.length; ++j) {
                if (!points[j].hasCustomData(name)) continue;
                if (splinePoints == null) {
                    timePoints = new double[points.length];
                    splinePoints = new double[points.length][points[j].getCustomDataCount(name)];
                }
                timePoints[pointCount] = points[j].mTime;
                points[j].getCustomData(name, splinePoints[pointCount], 0);
                ++pointCount;
            }
            timePoints = Arrays.copyOf(timePoints, pointCount);
            splinePoints = (double[][])Arrays.copyOf(splinePoints, pointCount);
            this.mSpline[i + 1] = CurveFit.get(this.mCurveFitType, timePoints, splinePoints);
        }
        this.mSpline[0] = CurveFit.get(this.mCurveFitType, timePoint, splineData);
        if (points[0].mPathMotionArc != -1) {
            int size = points.length;
            int[] mode = new int[size];
            double[] time = new double[size];
            double[][] values = new double[size][2];
            for (int i6 = 0; i6 < size; ++i6) {
                mode[i6] = points[i6].mPathMotionArc;
                time[i6] = points[i6].mTime;
                values[i6][0] = points[i6].mX;
                values[i6][1] = points[i6].mY;
            }
            this.mArcSpline = CurveFit.getArc(mode, time, values);
        }
        float distance = Float.NaN;
        this.mCycleMap = new HashMap();
        if (this.mKeyList != null) {
            for (String attribute : cycleAttributes) {
                KeyCycleOscillator cycle = KeyCycleOscillator.makeWidgetCycle(attribute);
                if (cycle == null) continue;
                if (cycle.variesByPath() && Float.isNaN(distance)) {
                    distance = this.getPreCycleDistance();
                }
                cycle.setType(attribute);
                this.mCycleMap.put(attribute, cycle);
            }
            for (MotionKey key : this.mKeyList) {
                if (!(key instanceof MotionKeyCycle)) continue;
                ((MotionKeyCycle)key).addCycleValues(this.mCycleMap);
            }
            for (KeyCycleOscillator cycle : this.mCycleMap.values()) {
                cycle.setup(distance);
            }
        }
    }

    public String toString() {
        return " start: x: " + this.mStartMotionPath.mX + " y: " + this.mStartMotionPath.mY + " end: x: " + this.mEndMotionPath.mX + " y: " + this.mEndMotionPath.mY;
    }

    private void readView(MotionPaths motionPaths) {
        motionPaths.setBounds(this.mView.getX(), this.mView.getY(), this.mView.getWidth(), this.mView.getHeight());
    }

    public void setView(MotionWidget view) {
        this.mView = view;
    }

    public MotionWidget getView() {
        return this.mView;
    }

    public void setStart(MotionWidget mw) {
        this.mStartMotionPath.mTime = 0.0f;
        this.mStartMotionPath.mPosition = 0.0f;
        this.mStartMotionPath.setBounds(mw.getX(), mw.getY(), mw.getWidth(), mw.getHeight());
        this.mStartMotionPath.applyParameters(mw);
        this.mStartPoint.setState(mw);
        TypedBundle p = mw.getWidgetFrame().getMotionProperties();
        if (p != null) {
            p.applyDelta(this);
        }
    }

    public void setEnd(MotionWidget mw) {
        this.mEndMotionPath.mTime = 1.0f;
        this.mEndMotionPath.mPosition = 1.0f;
        this.readView(this.mEndMotionPath);
        this.mEndMotionPath.setBounds(mw.getLeft(), mw.getTop(), mw.getWidth(), mw.getHeight());
        this.mEndMotionPath.applyParameters(mw);
        this.mEndPoint.setState(mw);
    }

    public void setStartState(ViewState rect, MotionWidget v, int rotation, int preWidth, int preHeight) {
        this.mStartMotionPath.mTime = 0.0f;
        this.mStartMotionPath.mPosition = 0.0f;
        Rect r = new Rect();
        switch (rotation) {
            case 2: {
                int cx = rect.left + rect.right;
                int cy = rect.top + rect.bottom;
                r.left = preHeight - (cy + rect.width()) / 2;
                r.top = (cx - rect.height()) / 2;
                r.right = r.left + rect.width();
                r.bottom = r.top + rect.height();
                break;
            }
            case 1: {
                int cx = rect.left + rect.right;
                int cy = rect.top + rect.bottom;
                r.left = (cy - rect.width()) / 2;
                r.top = preWidth - (cx + rect.height()) / 2;
                r.right = r.left + rect.width();
                r.bottom = r.top + rect.height();
            }
        }
        this.mStartMotionPath.setBounds(r.left, r.top, r.width(), r.height());
        this.mStartPoint.setState(r, v, rotation, rect.rotation);
    }

    void rotate(Rect rect, Rect out, int rotation, int preHeight, int preWidth) {
        switch (rotation) {
            case 2: {
                int cx = rect.left + rect.right;
                int cy = rect.top + rect.bottom;
                out.left = preHeight - (cy + rect.width()) / 2;
                out.top = (cx - rect.height()) / 2;
                out.right = out.left + rect.width();
                out.bottom = out.top + rect.height();
                break;
            }
            case 1: {
                int cx = rect.left + rect.right;
                int cy = rect.top + rect.bottom;
                out.left = (cy - rect.width()) / 2;
                out.top = preWidth - (cx + rect.height()) / 2;
                out.right = out.left + rect.width();
                out.bottom = out.top + rect.height();
                break;
            }
            case 4: {
                int cx = rect.left + rect.right;
                int cy = rect.bottom + rect.top;
                out.left = preHeight - (cy + rect.width()) / 2;
                out.top = (cx - rect.height()) / 2;
                out.right = out.left + rect.width();
                out.bottom = out.top + rect.height();
                break;
            }
            case 3: {
                int cx = rect.left + rect.right;
                int cy = rect.top + rect.bottom;
                out.left = rect.height() / 2 + rect.top - cx / 2;
                out.top = preWidth - (cx + rect.height()) / 2;
                out.right = out.left + rect.width();
                out.bottom = out.top + rect.height();
            }
        }
    }

    private static DifferentialInterpolator getInterpolator(int type, String interpolatorString, int id) {
        switch (type) {
            case -1: {
                final Easing easing = Easing.getInterpolator(interpolatorString);
                return new DifferentialInterpolator(){
                    float mX;

                    @Override
                    public float getInterpolation(float x) {
                        this.mX = x;
                        return (float)easing.get(x);
                    }

                    @Override
                    public float getVelocity() {
                        return (float)easing.getDiff(this.mX);
                    }
                };
            }
        }
        return null;
    }

    void setBothStates(MotionWidget v) {
        this.mStartMotionPath.mTime = 0.0f;
        this.mStartMotionPath.mPosition = 0.0f;
        this.mNoMovement = true;
        this.mStartMotionPath.setBounds(v.getX(), v.getY(), v.getWidth(), v.getHeight());
        this.mEndMotionPath.setBounds(v.getX(), v.getY(), v.getWidth(), v.getHeight());
        this.mStartPoint.setState(v);
        this.mEndPoint.setState(v);
    }

    private float getAdjustedPosition(float position, float[] velocity) {
        if (velocity != null) {
            velocity[0] = 1.0f;
        } else if ((double)this.mStaggerScale != 1.0) {
            if (position < this.mStaggerOffset) {
                position = 0.0f;
            }
            if (position > this.mStaggerOffset && (double)position < 1.0) {
                position -= this.mStaggerOffset;
                position *= this.mStaggerScale;
                position = Math.min(position, 1.0f);
            }
        }
        float adjusted = position;
        Easing easing = this.mStartMotionPath.mKeyFrameEasing;
        float start = 0.0f;
        float end = Float.NaN;
        for (MotionPaths frame : this.mMotionPaths) {
            if (frame.mKeyFrameEasing == null) continue;
            if (frame.mTime < position) {
                easing = frame.mKeyFrameEasing;
                start = frame.mTime;
                continue;
            }
            if (!Float.isNaN(end)) continue;
            end = frame.mTime;
        }
        if (easing != null) {
            if (Float.isNaN(end)) {
                end = 1.0f;
            }
            float offset = (position - start) / (end - start);
            float new_offset = (float)easing.get(offset);
            adjusted = new_offset * (end - start) + start;
            if (velocity != null) {
                velocity[0] = (float)easing.getDiff(offset);
            }
        }
        return adjusted;
    }

    void endTrigger(boolean start) {
    }

    public boolean interpolate(MotionWidget child, float globalPosition, long time, KeyCache keyCache) {
        boolean timeAnimation = false;
        float position = this.getAdjustedPosition(globalPosition, null);
        if (this.mQuantizeMotionSteps != -1) {
            float pin = position;
            float steps = 1.0f / (float)this.mQuantizeMotionSteps;
            float jump = (float)Math.floor(position / steps) * steps;
            float section = position % steps / steps;
            if (!Float.isNaN(this.mQuantizeMotionPhase)) {
                section = (section + this.mQuantizeMotionPhase) % 1.0f;
            }
            section = this.mQuantizeMotionInterpolator != null ? this.mQuantizeMotionInterpolator.getInterpolation(section) : ((double)section > 0.5 ? 1.0f : 0.0f);
            position = section * steps + jump;
        }
        if (this.mAttributesMap != null) {
            for (SplineSet aSpline : this.mAttributesMap.values()) {
                aSpline.setProperty(child, position);
            }
        }
        if (this.mSpline != null) {
            int i;
            this.mSpline[0].getPos((double)position, this.mInterpolateData);
            this.mSpline[0].getSlope((double)position, this.mInterpolateVelocity);
            if (this.mArcSpline != null && this.mInterpolateData.length > 0) {
                this.mArcSpline.getPos((double)position, this.mInterpolateData);
                this.mArcSpline.getSlope((double)position, this.mInterpolateVelocity);
            }
            if (!this.mNoMovement) {
                this.mStartMotionPath.setView(position, child, this.mInterpolateVariables, this.mInterpolateData, this.mInterpolateVelocity, null);
            }
            if (this.mTransformPivotTarget != -1) {
                if (this.mTransformPivotView == null) {
                    MotionWidget layout = child.getParent();
                    this.mTransformPivotView = layout.findViewById(this.mTransformPivotTarget);
                }
                if (this.mTransformPivotView != null) {
                    float cy = (float)(this.mTransformPivotView.getTop() + this.mTransformPivotView.getBottom()) / 2.0f;
                    float cx = (float)(this.mTransformPivotView.getLeft() + this.mTransformPivotView.getRight()) / 2.0f;
                    if (child.getRight() - child.getLeft() > 0 && child.getBottom() - child.getTop() > 0) {
                        float px = cx - (float)child.getLeft();
                        float py = cy - (float)child.getTop();
                        child.setPivotX(px);
                        child.setPivotY(py);
                    }
                }
            }
            for (i = 1; i < this.mSpline.length; ++i) {
                CurveFit spline = this.mSpline[i];
                spline.getPos((double)position, this.mValuesBuff);
                this.mStartMotionPath.mCustomAttributes.get(this.mAttributeNames[i - 1]).setInterpolatedValue(child, this.mValuesBuff);
            }
            if (this.mStartPoint.mVisibilityMode == 0) {
                if (position <= 0.0f) {
                    child.setVisibility(this.mStartPoint.mVisibility);
                } else if (position >= 1.0f) {
                    child.setVisibility(this.mEndPoint.mVisibility);
                } else if (this.mEndPoint.mVisibility != this.mStartPoint.mVisibility) {
                    child.setVisibility(4);
                }
            }
            if (this.mKeyTriggers != null) {
                for (i = 0; i < this.mKeyTriggers.length; ++i) {
                    this.mKeyTriggers[i].conditionallyFire(position, child);
                }
            }
        } else {
            float float_l = this.mStartMotionPath.mX + (this.mEndMotionPath.mX - this.mStartMotionPath.mX) * position;
            float float_t = this.mStartMotionPath.mY + (this.mEndMotionPath.mY - this.mStartMotionPath.mY) * position;
            float float_width = this.mStartMotionPath.mWidth + (this.mEndMotionPath.mWidth - this.mStartMotionPath.mWidth) * position;
            float float_height = this.mStartMotionPath.mHeight + (this.mEndMotionPath.mHeight - this.mStartMotionPath.mHeight) * position;
            int l = (int)(0.5f + float_l);
            int t = (int)(0.5f + float_t);
            int r = (int)(0.5f + float_l + float_width);
            int b = (int)(0.5f + float_t + float_height);
            int width = r - l;
            int height = b - t;
            child.layout(l, t, r, b);
        }
        if (this.mCycleMap != null) {
            for (KeyCycleOscillator osc : this.mCycleMap.values()) {
                if (osc instanceof KeyCycleOscillator.PathRotateSet) {
                    ((KeyCycleOscillator.PathRotateSet)osc).setPathRotate(child, position, this.mInterpolateVelocity[0], this.mInterpolateVelocity[1]);
                    continue;
                }
                osc.setProperty(child, position);
            }
        }
        return false;
    }

    public void getDpDt(float position, float locationX, float locationY, float[] mAnchorDpDt) {
        position = this.getAdjustedPosition(position, this.mVelocity);
        if (this.mSpline != null) {
            this.mSpline[0].getSlope((double)position, this.mInterpolateVelocity);
            this.mSpline[0].getPos((double)position, this.mInterpolateData);
            float v = this.mVelocity[0];
            int i = 0;
            while (i < this.mInterpolateVelocity.length) {
                int n = i++;
                this.mInterpolateVelocity[n] = this.mInterpolateVelocity[n] * (double)v;
            }
            if (this.mArcSpline != null) {
                if (this.mInterpolateData.length > 0) {
                    this.mArcSpline.getPos((double)position, this.mInterpolateData);
                    this.mArcSpline.getSlope((double)position, this.mInterpolateVelocity);
                    this.mStartMotionPath.setDpDt(locationX, locationY, mAnchorDpDt, this.mInterpolateVariables, this.mInterpolateVelocity, this.mInterpolateData);
                }
                return;
            }
            this.mStartMotionPath.setDpDt(locationX, locationY, mAnchorDpDt, this.mInterpolateVariables, this.mInterpolateVelocity, this.mInterpolateData);
            return;
        }
        float dleft = this.mEndMotionPath.mX - this.mStartMotionPath.mX;
        float dTop = this.mEndMotionPath.mY - this.mStartMotionPath.mY;
        float dWidth = this.mEndMotionPath.mWidth - this.mStartMotionPath.mWidth;
        float dHeight = this.mEndMotionPath.mHeight - this.mStartMotionPath.mHeight;
        float dRight = dleft + dWidth;
        float dBottom = dTop + dHeight;
        mAnchorDpDt[0] = dleft * (1.0f - locationX) + dRight * locationX;
        mAnchorDpDt[1] = dTop * (1.0f - locationY) + dBottom * locationY;
    }

    void getPostLayoutDvDp(float position, int width, int height, float locationX, float locationY, float[] mAnchorDpDt) {
        position = this.getAdjustedPosition(position, this.mVelocity);
        SplineSet trans_x = this.mAttributesMap == null ? null : this.mAttributesMap.get("translationX");
        SplineSet trans_y = this.mAttributesMap == null ? null : this.mAttributesMap.get("translationY");
        SplineSet rotation = this.mAttributesMap == null ? null : this.mAttributesMap.get("rotationZ");
        SplineSet scale_x = this.mAttributesMap == null ? null : this.mAttributesMap.get("scaleX");
        SplineSet scale_y = this.mAttributesMap == null ? null : this.mAttributesMap.get("scaleY");
        KeyCycleOscillator osc_x = this.mCycleMap == null ? null : this.mCycleMap.get("translationX");
        KeyCycleOscillator osc_y = this.mCycleMap == null ? null : this.mCycleMap.get("translationY");
        KeyCycleOscillator osc_r = this.mCycleMap == null ? null : this.mCycleMap.get("rotationZ");
        KeyCycleOscillator osc_sx = this.mCycleMap == null ? null : this.mCycleMap.get("scaleX");
        KeyCycleOscillator osc_sy = this.mCycleMap == null ? null : this.mCycleMap.get("scaleY");
        VelocityMatrix vmat = new VelocityMatrix();
        vmat.clear();
        vmat.setRotationVelocity(rotation, position);
        vmat.setTranslationVelocity(trans_x, trans_y, position);
        vmat.setScaleVelocity(scale_x, scale_y, position);
        vmat.setRotationVelocity(osc_r, position);
        vmat.setTranslationVelocity(osc_x, osc_y, position);
        vmat.setScaleVelocity(osc_sx, osc_sy, position);
        if (this.mArcSpline != null) {
            if (this.mInterpolateData.length > 0) {
                this.mArcSpline.getPos((double)position, this.mInterpolateData);
                this.mArcSpline.getSlope((double)position, this.mInterpolateVelocity);
                this.mStartMotionPath.setDpDt(locationX, locationY, mAnchorDpDt, this.mInterpolateVariables, this.mInterpolateVelocity, this.mInterpolateData);
            }
            vmat.applyTransform(locationX, locationY, width, height, mAnchorDpDt);
            return;
        }
        if (this.mSpline != null) {
            position = this.getAdjustedPosition(position, this.mVelocity);
            this.mSpline[0].getSlope((double)position, this.mInterpolateVelocity);
            this.mSpline[0].getPos((double)position, this.mInterpolateData);
            float v = this.mVelocity[0];
            int i = 0;
            while (i < this.mInterpolateVelocity.length) {
                int n = i++;
                this.mInterpolateVelocity[n] = this.mInterpolateVelocity[n] * (double)v;
            }
            this.mStartMotionPath.setDpDt(locationX, locationY, mAnchorDpDt, this.mInterpolateVariables, this.mInterpolateVelocity, this.mInterpolateData);
            vmat.applyTransform(locationX, locationY, width, height, mAnchorDpDt);
            return;
        }
        float dleft = this.mEndMotionPath.mX - this.mStartMotionPath.mX;
        float dTop = this.mEndMotionPath.mY - this.mStartMotionPath.mY;
        float dWidth = this.mEndMotionPath.mWidth - this.mStartMotionPath.mWidth;
        float dHeight = this.mEndMotionPath.mHeight - this.mStartMotionPath.mHeight;
        float dRight = dleft + dWidth;
        float dBottom = dTop + dHeight;
        mAnchorDpDt[0] = dleft * (1.0f - locationX) + dRight * locationX;
        mAnchorDpDt[1] = dTop * (1.0f - locationY) + dBottom * locationY;
        vmat.clear();
        vmat.setRotationVelocity(rotation, position);
        vmat.setTranslationVelocity(trans_x, trans_y, position);
        vmat.setScaleVelocity(scale_x, scale_y, position);
        vmat.setRotationVelocity(osc_r, position);
        vmat.setTranslationVelocity(osc_x, osc_y, position);
        vmat.setScaleVelocity(osc_sx, osc_sy, position);
        vmat.applyTransform(locationX, locationY, width, height, mAnchorDpDt);
    }

    public int getDrawPath() {
        int mode = this.mStartMotionPath.mDrawPath;
        for (MotionPaths keyFrame : this.mMotionPaths) {
            mode = Math.max(mode, keyFrame.mDrawPath);
        }
        mode = Math.max(mode, this.mEndMotionPath.mDrawPath);
        return mode;
    }

    public void setDrawPath(int debugMode) {
        this.mStartMotionPath.mDrawPath = debugMode;
    }

    String name() {
        return this.mView.getName();
    }

    void positionKeyframe(MotionWidget view, MotionKeyPosition key, float x, float y, String[] attribute, float[] value) {
        FloatRect start = new FloatRect();
        start.left = this.mStartMotionPath.mX;
        start.top = this.mStartMotionPath.mY;
        start.right = start.left + this.mStartMotionPath.mWidth;
        start.bottom = start.top + this.mStartMotionPath.mHeight;
        FloatRect end = new FloatRect();
        end.left = this.mEndMotionPath.mX;
        end.top = this.mEndMotionPath.mY;
        end.right = end.left + this.mEndMotionPath.mWidth;
        end.bottom = end.top + this.mEndMotionPath.mHeight;
        key.positionAttributes(view, start, end, x, y, attribute, value);
    }

    public int getKeyFramePositions(int[] type, float[] pos) {
        int i = 0;
        int count = 0;
        for (MotionKey key : this.mKeyList) {
            type[i++] = key.mFramePosition + 1000 * key.mType;
            float time = (float)key.mFramePosition / 100.0f;
            this.mSpline[0].getPos((double)time, this.mInterpolateData);
            this.mStartMotionPath.getCenter(time, this.mInterpolateVariables, this.mInterpolateData, pos, count);
            count += 2;
        }
        return i;
    }

    public int getKeyFrameInfo(int type, int[] info) {
        int count = 0;
        int cursor = 0;
        float[] pos = new float[2];
        for (MotionKey key : this.mKeyList) {
            if (key.mType != type && type == -1) continue;
            int len = cursor;
            info[cursor] = 0;
            info[++cursor] = key.mType;
            info[++cursor] = key.mFramePosition;
            float time = (float)key.mFramePosition / 100.0f;
            this.mSpline[0].getPos((double)time, this.mInterpolateData);
            this.mStartMotionPath.getCenter(time, this.mInterpolateVariables, this.mInterpolateData, pos, 0);
            info[++cursor] = Float.floatToIntBits(pos[0]);
            info[++cursor] = Float.floatToIntBits(pos[1]);
            if (key instanceof MotionKeyPosition) {
                MotionKeyPosition kp = (MotionKeyPosition)key;
                info[++cursor] = kp.mPositionType;
                info[++cursor] = Float.floatToIntBits(kp.mPercentX);
                info[++cursor] = Float.floatToIntBits(kp.mPercentY);
            }
            info[len] = ++cursor - len;
            ++count;
        }
        return count;
    }

    @Override
    public boolean setValue(int id, int value) {
        switch (id) {
            case 509: {
                this.setPathMotionArc(value);
                return true;
            }
            case 610: {
                this.mQuantizeMotionSteps = value;
                return true;
            }
            case 704: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean setValue(int id, float value) {
        if (602 == id) {
            this.mQuantizeMotionPhase = value;
            return true;
        }
        if (600 == id) {
            this.mMotionStagger = value;
            return true;
        }
        return false;
    }

    @Override
    public boolean setValue(int id, String value) {
        if (705 == id || 611 == id) {
            this.mQuantizeMotionInterpolator = Motion.getInterpolator(-1, value, 0);
            return true;
        }
        if (605 == id) {
            this.mStartMotionPath.mAnimateRelativeTo = value;
            return true;
        }
        return false;
    }

    @Override
    public boolean setValue(int id, boolean value) {
        return false;
    }

    @Override
    public int getId(String name) {
        return 0;
    }

    public void setStaggerScale(float staggerScale) {
        this.mStaggerScale = staggerScale;
    }

    public void setStaggerOffset(float staggerOffset) {
        this.mStaggerOffset = staggerOffset;
    }

    public float getMotionStagger() {
        return this.mMotionStagger;
    }

    public void setIdString(String stringId) {
        this.mStartMotionPath.mId = this.mId = stringId;
    }
}

