/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.state.helpers;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.constraintlayout.core.state.HelperReference;
import androidx.constraintlayout.core.state.State;
import androidx.constraintlayout.core.utils.GridCore;
import androidx.constraintlayout.core.widgets.HelperWidget;

public class GridReference
extends HelperReference {
    private GridCore mGrid;
    private int mOrientation;
    private int mRowsSet;
    private int mColumnsSet;
    private float mHorizontalGaps;
    private float mVerticalGaps;
    private String mRowWeights;
    private String mColumnWeights;
    private String mSpans;
    private String mSkips;

    public GridReference(@NonNull State state, @NonNull State.Helper type) {
        super(state, type);
        if (type == State.Helper.ROW) {
            this.mColumnsSet = 1;
        } else if (type == State.Helper.COLUMN) {
            this.mRowsSet = 1;
        }
    }

    public int getRowsSet() {
        return this.mRowsSet;
    }

    public void setRowsSet(int rowsSet) {
        if (super.getType() == State.Helper.COLUMN) {
            return;
        }
        this.mRowsSet = rowsSet;
    }

    public int getColumnsSet() {
        return this.mColumnsSet;
    }

    public void setColumnsSet(int columnsSet) {
        if (super.getType() == State.Helper.ROW) {
            return;
        }
        this.mColumnsSet = columnsSet;
    }

    public float getHorizontalGaps() {
        return this.mHorizontalGaps;
    }

    public void setHorizontalGaps(float horizontalGaps) {
        this.mHorizontalGaps = horizontalGaps;
    }

    public float getVerticalGaps() {
        return this.mVerticalGaps;
    }

    public void setVerticalGaps(float verticalGaps) {
        this.mVerticalGaps = verticalGaps;
    }

    @Nullable
    public String getRowWeights() {
        return this.mRowWeights;
    }

    public void setRowWeights(@NonNull String rowWeights) {
        this.mRowWeights = rowWeights;
    }

    @Nullable
    public String getColumnWeights() {
        return this.mColumnWeights;
    }

    public void setColumnWeights(@NonNull String columnWeights) {
        this.mColumnWeights = columnWeights;
    }

    @Nullable
    public String getSpans() {
        return this.mSpans;
    }

    public void setSpans(@NonNull String spans) {
        this.mSpans = spans;
    }

    @Nullable
    public String getSkips() {
        return this.mSkips;
    }

    public void setSkips(@NonNull String skips) {
        this.mSkips = skips;
    }

    @Override
    @NonNull
    public HelperWidget getHelperWidget() {
        if (this.mGrid == null) {
            this.mGrid = new GridCore();
        }
        return this.mGrid;
    }

    @Override
    public void setHelperWidget(@Nullable HelperWidget widget) {
        this.mGrid = widget instanceof GridCore ? (GridCore)widget : null;
    }

    public int getOrientation() {
        return this.mOrientation;
    }

    public void setOrientation(int orientation) {
        this.mOrientation = orientation;
    }

    @Override
    public void apply() {
        this.getHelperWidget();
        this.mGrid.setOrientation(this.mOrientation);
        if (this.mRowsSet != 0) {
            this.mGrid.setRows(this.mRowsSet);
        }
        if (this.mColumnsSet != 0) {
            this.mGrid.setColumns(this.mColumnsSet);
        }
        if (this.mHorizontalGaps != 0.0f) {
            this.mGrid.setHorizontalGaps(this.mHorizontalGaps);
        }
        if (this.mVerticalGaps != 0.0f) {
            this.mGrid.setVerticalGaps(this.mVerticalGaps);
        }
        if (this.mRowWeights != null && !this.mRowWeights.equals("")) {
            this.mGrid.setRowWeights(this.mRowWeights);
        }
        if (this.mColumnWeights != null && !this.mColumnWeights.equals("")) {
            this.mGrid.setColumnWeights(this.mColumnWeights);
        }
        if (this.mSpans != null && !this.mSpans.equals("")) {
            this.mGrid.setSpans(this.mSpans);
        }
        if (this.mSkips != null && !this.mSkips.equals("")) {
            this.mGrid.setSkips(this.mSkips);
        }
        this.applyBase();
    }
}

