/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.state;

import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.constraintlayout.core.motion.CustomVariable;
import androidx.constraintlayout.core.motion.utils.TypedBundle;
import androidx.constraintlayout.core.parser.CLArray;
import androidx.constraintlayout.core.parser.CLContainer;
import androidx.constraintlayout.core.parser.CLElement;
import androidx.constraintlayout.core.parser.CLKey;
import androidx.constraintlayout.core.parser.CLNumber;
import androidx.constraintlayout.core.parser.CLObject;
import androidx.constraintlayout.core.parser.CLParsingException;
import androidx.constraintlayout.core.state.ConstraintSetParser;
import androidx.constraintlayout.core.state.CorePixelDp;
import androidx.constraintlayout.core.state.Transition;

public class TransitionParser {
    @Deprecated
    public static void parse(CLObject json, Transition transition, CorePixelDp dpToPixel) throws CLParsingException {
        TransitionParser.parse(json, transition);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static void parse(@NonNull CLObject json, @NonNull Transition transition) throws CLParsingException {
        CLObject onSwipe;
        float staggered;
        String interpolator;
        String pathMotionArc = json.getStringOrNull("pathMotionArc");
        TypedBundle bundle = new TypedBundle();
        boolean setBundle = false;
        if (pathMotionArc != null) {
            setBundle = true;
            switch (pathMotionArc) {
                case "none": {
                    bundle.add(509, 0);
                    break;
                }
                case "startVertical": {
                    bundle.add(509, 1);
                    break;
                }
                case "startHorizontal": {
                    bundle.add(509, 2);
                    break;
                }
                case "flip": {
                    bundle.add(509, 3);
                    break;
                }
                case "below": {
                    bundle.add(509, 4);
                    break;
                }
                case "above": {
                    bundle.add(509, 5);
                }
            }
        }
        if ((interpolator = json.getStringOrNull("interpolator")) != null) {
            setBundle = true;
            bundle.add(705, interpolator);
        }
        if (!Float.isNaN(staggered = json.getFloatOrNaN("staggered"))) {
            setBundle = true;
            bundle.add(706, staggered);
        }
        if (setBundle) {
            transition.setTransitionProperties(bundle);
        }
        if ((onSwipe = json.getObjectOrNull("onSwipe")) != null) {
            TransitionParser.parseOnSwipe(onSwipe, transition);
        }
        TransitionParser.parseKeyFrames(json, transition);
    }

    private static void parseOnSwipe(CLContainer onSwipe, Transition transition) {
        String anchor = onSwipe.getStringOrNull("anchor");
        int side = TransitionParser.map(onSwipe.getStringOrNull("side"), Transition.OnSwipe.SIDES);
        int direction = TransitionParser.map(onSwipe.getStringOrNull("direction"), Transition.OnSwipe.DIRECTIONS);
        float scale = onSwipe.getFloatOrNaN("scale");
        float threshold = onSwipe.getFloatOrNaN("threshold");
        float maxVelocity = onSwipe.getFloatOrNaN("maxVelocity");
        float maxAccel = onSwipe.getFloatOrNaN("maxAccel");
        String limitBounds = onSwipe.getStringOrNull("limitBounds");
        int autoCompleteMode = TransitionParser.map(onSwipe.getStringOrNull("mode"), Transition.OnSwipe.MODE);
        int touchUp = TransitionParser.map(onSwipe.getStringOrNull("touchUp"), Transition.OnSwipe.TOUCH_UP);
        float springMass = onSwipe.getFloatOrNaN("springMass");
        float springStiffness = onSwipe.getFloatOrNaN("springStiffness");
        float springDamping = onSwipe.getFloatOrNaN("springDamping");
        float stopThreshold = onSwipe.getFloatOrNaN("stopThreshold");
        int springBoundary = TransitionParser.map(onSwipe.getStringOrNull("springBoundary"), Transition.OnSwipe.BOUNDARY);
        String around = onSwipe.getStringOrNull("around");
        Transition.OnSwipe swipe = transition.createOnSwipe();
        swipe.setAnchorId(anchor);
        swipe.setAnchorSide(side);
        swipe.setDragDirection(direction);
        swipe.setDragScale(scale);
        swipe.setDragThreshold(threshold);
        swipe.setMaxVelocity(maxVelocity);
        swipe.setMaxAcceleration(maxAccel);
        swipe.setLimitBoundsTo(limitBounds);
        swipe.setAutoCompleteMode(autoCompleteMode);
        swipe.setOnTouchUp(touchUp);
        swipe.setSpringMass(springMass);
        swipe.setSpringStiffness(springStiffness);
        swipe.setSpringDamping(springDamping);
        swipe.setSpringStopThreshold(stopThreshold);
        swipe.setSpringBoundary(springBoundary);
        swipe.setRotationCenterId(around);
    }

    private static int map(String val, String ... types) {
        for (int i = 0; i < types.length; ++i) {
            if (!types[i].equals(val)) continue;
            return i;
        }
        return 0;
    }

    private static void map(TypedBundle bundle, int type, String val, String ... types) {
        for (int i = 0; i < types.length; ++i) {
            if (!types[i].equals(val)) continue;
            bundle.add(type, i);
        }
    }

    public static void parseKeyFrames(CLObject transitionCLObject, Transition transition) throws CLParsingException {
        CLArray keyCycles;
        CLArray keyAttributes;
        CLObject keyframes = transitionCLObject.getObjectOrNull("KeyFrames");
        if (keyframes == null) {
            return;
        }
        CLArray keyPositions = keyframes.getArrayOrNull("KeyPositions");
        if (keyPositions != null) {
            for (int i = 0; i < keyPositions.size(); ++i) {
                CLElement keyPosition = keyPositions.get(i);
                if (!(keyPosition instanceof CLObject)) continue;
                TransitionParser.parseKeyPosition((CLObject)keyPosition, transition);
            }
        }
        if ((keyAttributes = keyframes.getArrayOrNull("KeyAttributes")) != null) {
            for (int i = 0; i < keyAttributes.size(); ++i) {
                CLElement keyAttribute = keyAttributes.get(i);
                if (!(keyAttribute instanceof CLObject)) continue;
                TransitionParser.parseKeyAttribute((CLObject)keyAttribute, transition);
            }
        }
        if ((keyCycles = keyframes.getArrayOrNull("KeyCycles")) != null) {
            for (int i = 0; i < keyCycles.size(); ++i) {
                CLElement keyCycle = keyCycles.get(i);
                if (!(keyCycle instanceof CLObject)) continue;
                TransitionParser.parseKeyCycle((CLObject)keyCycle, transition);
            }
        }
    }

    private static void parseKeyPosition(CLObject keyPosition, Transition transition) throws CLParsingException {
        TypedBundle bundle = new TypedBundle();
        CLArray targets = keyPosition.getArray("target");
        CLArray frames = keyPosition.getArray("frames");
        CLArray percentX = keyPosition.getArrayOrNull("percentX");
        CLArray percentY = keyPosition.getArrayOrNull("percentY");
        CLArray percentWidth = keyPosition.getArrayOrNull("percentWidth");
        CLArray percentHeight = keyPosition.getArrayOrNull("percentHeight");
        String pathMotionArc = keyPosition.getStringOrNull("pathMotionArc");
        String transitionEasing = keyPosition.getStringOrNull("transitionEasing");
        String curveFit = keyPosition.getStringOrNull("curveFit");
        String type = keyPosition.getStringOrNull("type");
        if (type == null) {
            type = "parentRelative";
        }
        if (percentX != null && frames.size() != percentX.size()) {
            return;
        }
        if (percentY != null && frames.size() != percentY.size()) {
            return;
        }
        for (int i = 0; i < targets.size(); ++i) {
            String target = targets.getString(i);
            int pos_type = TransitionParser.map(type, "deltaRelative", "pathRelative", "parentRelative");
            bundle.clear();
            bundle.add(510, pos_type);
            if (curveFit != null) {
                TransitionParser.map(bundle, 508, curveFit, "spline", "linear");
            }
            bundle.addIfNotNull(501, transitionEasing);
            if (pathMotionArc != null) {
                TransitionParser.map(bundle, 509, pathMotionArc, "none", "startVertical", "startHorizontal", "flip", "below", "above");
            }
            for (int j = 0; j < frames.size(); ++j) {
                int frame = frames.getInt(j);
                bundle.add(100, frame);
                TransitionParser.set(bundle, 506, percentX, j);
                TransitionParser.set(bundle, 507, percentY, j);
                TransitionParser.set(bundle, 503, percentWidth, j);
                TransitionParser.set(bundle, 504, percentHeight, j);
                transition.addKeyPosition(target, bundle);
            }
        }
    }

    private static void set(TypedBundle bundle, int type, CLArray array, int index) throws CLParsingException {
        if (array != null) {
            bundle.add(type, array.getFloat(index));
        }
    }

    private static void parseKeyAttribute(CLObject keyAttribute, Transition transition) throws CLParsingException {
        CLArray targets = keyAttribute.getArrayOrNull("target");
        if (targets == null) {
            return;
        }
        CLArray frames = keyAttribute.getArrayOrNull("frames");
        if (frames == null) {
            return;
        }
        String transitionEasing = keyAttribute.getStringOrNull("transitionEasing");
        String[] attrNames = new String[]{"scaleX", "scaleY", "translationX", "translationY", "translationZ", "rotationX", "rotationY", "rotationZ", "alpha"};
        int[] attrIds = new int[]{311, 312, 304, 305, 306, 308, 309, 310, 303};
        boolean[] scaleTypes = new boolean[]{false, false, true, true, true, false, false, false, false};
        TypedBundle[] bundles = new TypedBundle[frames.size()];
        CustomVariable[][] customVars = null;
        for (int i = 0; i < frames.size(); ++i) {
            bundles[i] = new TypedBundle();
        }
        for (int k = 0; k < attrNames.length; ++k) {
            String attrName = attrNames[k];
            int attrId = attrIds[k];
            boolean scale = scaleTypes[k];
            CLArray arrayValues = keyAttribute.getArrayOrNull(attrName);
            if (arrayValues != null && arrayValues.size() != bundles.length) {
                throw new CLParsingException("incorrect size for " + attrName + " array, not matching targets array!", keyAttribute);
            }
            if (arrayValues != null) {
                for (int i = 0; i < bundles.length; ++i) {
                    float value = arrayValues.getFloat(i);
                    if (scale) {
                        value = transition.mToPixel.toPixels(value);
                    }
                    bundles[i].add(attrId, value);
                }
                continue;
            }
            float value = keyAttribute.getFloatOrNaN(attrName);
            if (Float.isNaN(value)) continue;
            if (scale) {
                value = transition.mToPixel.toPixels(value);
            }
            for (int i = 0; i < bundles.length; ++i) {
                bundles[i].add(attrId, value);
            }
        }
        CLElement customElement = keyAttribute.getOrNull("custom");
        if (customElement != null && customElement instanceof CLObject) {
            CLObject customObj = (CLObject)customElement;
            int n = customObj.size();
            customVars = new CustomVariable[frames.size()][n];
            for (int i = 0; i < n; ++i) {
                int j;
                CLKey key = (CLKey)customObj.get(i);
                String customName = key.content();
                if (key.getValue() instanceof CLArray) {
                    CLArray arrayValues = (CLArray)key.getValue();
                    int vSize = arrayValues.size();
                    if (vSize != bundles.length || vSize <= 0) continue;
                    if (arrayValues.get(0) instanceof CLNumber) {
                        for (j = 0; j < bundles.length; ++j) {
                            customVars[j][i] = new CustomVariable(customName, 901, arrayValues.get(j).getFloat());
                        }
                        continue;
                    }
                    for (j = 0; j < bundles.length; ++j) {
                        long color = ConstraintSetParser.parseColorString(arrayValues.get(j).content());
                        if (color == -1L) continue;
                        customVars[j][i] = new CustomVariable(customName, 902, (int)color);
                    }
                    continue;
                }
                CLElement value = key.getValue();
                if (value instanceof CLNumber) {
                    float fValue = value.getFloat();
                    for (j = 0; j < bundles.length; ++j) {
                        customVars[j][i] = new CustomVariable(customName, 901, fValue);
                    }
                    continue;
                }
                long cValue = ConstraintSetParser.parseColorString(value.content());
                if (cValue == -1L) continue;
                for (int j2 = 0; j2 < bundles.length; ++j2) {
                    customVars[j2][i] = new CustomVariable(customName, 902, (int)cValue);
                }
            }
        }
        String curveFit = keyAttribute.getStringOrNull("curveFit");
        for (int i = 0; i < targets.size(); ++i) {
            for (int j = 0; j < bundles.length; ++j) {
                String target = targets.getString(i);
                TypedBundle bundle = bundles[j];
                if (curveFit != null) {
                    bundle.add(508, TransitionParser.map(curveFit, "spline", "linear"));
                }
                bundle.addIfNotNull(501, transitionEasing);
                int frame = frames.getInt(j);
                bundle.add(100, frame);
                transition.addKeyAttribute(target, bundle, customVars != null ? customVars[j] : null);
            }
        }
    }

    private static void parseKeyCycle(CLObject keyCycleData, Transition transition) throws CLParsingException {
        int k;
        CLArray targets = keyCycleData.getArray("target");
        CLArray frames = keyCycleData.getArray("frames");
        String transitionEasing = keyCycleData.getStringOrNull("transitionEasing");
        String[] attrNames = new String[]{"scaleX", "scaleY", "translationX", "translationY", "translationZ", "rotationX", "rotationY", "rotationZ", "alpha", "period", "offset", "phase"};
        int[] attrIds = new int[]{311, 312, 304, 305, 306, 308, 309, 310, 403, 423, 424, 425};
        int[] scaleTypes = new int[]{0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 2, 0};
        TypedBundle[] bundles = new TypedBundle[frames.size()];
        for (int i = 0; i < bundles.length; ++i) {
            bundles[i] = new TypedBundle();
        }
        boolean scaleOffset = false;
        for (k = 0; k < attrNames.length; ++k) {
            if (!keyCycleData.has(attrNames[k]) || scaleTypes[k] != 1) continue;
            scaleOffset = true;
        }
        for (k = 0; k < attrNames.length; ++k) {
            String attrName = attrNames[k];
            int attrId = attrIds[k];
            int scale = scaleTypes[k];
            CLArray arrayValues = keyCycleData.getArrayOrNull(attrName);
            if (arrayValues != null && arrayValues.size() != bundles.length) {
                throw new CLParsingException("incorrect size for $attrName array, not matching targets array!", keyCycleData);
            }
            if (arrayValues != null) {
                for (int i = 0; i < bundles.length; ++i) {
                    float value = arrayValues.getFloat(i);
                    if (scale == 1) {
                        value = transition.mToPixel.toPixels(value);
                    } else if (scale == 2 && scaleOffset) {
                        value = transition.mToPixel.toPixels(value);
                    }
                    bundles[i].add(attrId, value);
                }
                continue;
            }
            float value = keyCycleData.getFloatOrNaN(attrName);
            if (Float.isNaN(value)) continue;
            if (scale == 1) {
                value = transition.mToPixel.toPixels(value);
            } else if (scale == 2 && scaleOffset) {
                value = transition.mToPixel.toPixels(value);
            }
            for (int i = 0; i < bundles.length; ++i) {
                bundles[i].add(attrId, value);
            }
        }
        String curveFit = keyCycleData.getStringOrNull("curveFit");
        String easing = keyCycleData.getStringOrNull("easing");
        String waveShape = keyCycleData.getStringOrNull("waveShape");
        String customWave = keyCycleData.getStringOrNull("customWave");
        for (int i = 0; i < targets.size(); ++i) {
            for (int j = 0; j < bundles.length; ++j) {
                String target = targets.getString(i);
                TypedBundle bundle = bundles[j];
                if (curveFit != null) {
                    switch (curveFit) {
                        case "spline": {
                            bundle.add(401, 0);
                            break;
                        }
                        case "linear": {
                            bundle.add(401, 1);
                        }
                    }
                }
                bundle.addIfNotNull(501, transitionEasing);
                if (easing != null) {
                    bundle.add(420, easing);
                }
                if (waveShape != null) {
                    bundle.add(421, waveShape);
                }
                if (customWave != null) {
                    bundle.add(422, customWave);
                }
                int frame = frames.getInt(j);
                bundle.add(100, frame);
                transition.addKeyCycle(target, bundle);
            }
        }
    }
}

