/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.dsl;

import androidx.constraintlayout.core.dsl.Constraint;
import androidx.constraintlayout.core.dsl.Helper;
import androidx.constraintlayout.core.dsl.Ref;
import java.util.ArrayList;

public class Barrier
extends Helper {
    private Constraint.Side mDirection = null;
    private int mMargin = Integer.MIN_VALUE;
    private ArrayList<Ref> references = new ArrayList();

    public Barrier(String name) {
        super(name, new Helper.HelperType((String)typeMap.get((Object)Helper.Type.BARRIER)));
    }

    public Barrier(String name, String config) {
        super(name, new Helper.HelperType((String)typeMap.get((Object)Helper.Type.BARRIER)), config);
        this.configMap = this.convertConfigToMap();
        if (this.configMap.containsKey("contains")) {
            Ref.addStringToReferences((String)this.configMap.get("contains"), this.references);
        }
    }

    public Constraint.Side getDirection() {
        return this.mDirection;
    }

    public void setDirection(Constraint.Side direction) {
        this.mDirection = direction;
        this.configMap.put("direction", (String)sideMap.get((Object)direction));
    }

    public int getMargin() {
        return this.mMargin;
    }

    public void setMargin(int margin) {
        this.mMargin = margin;
        this.configMap.put("margin", String.valueOf(margin));
    }

    public String referencesToString() {
        if (this.references.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder("[");
        for (Ref ref : this.references) {
            builder.append(ref.toString());
        }
        builder.append("]");
        return builder.toString();
    }

    public Barrier addReference(Ref ref) {
        this.references.add(ref);
        this.configMap.put("contains", this.referencesToString());
        return this;
    }

    public Barrier addReference(String ref) {
        return this.addReference(Ref.parseStringToRef(ref));
    }
}

