/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.motion;

import androidx.constraintlayout.core.motion.CustomAttribute;
import androidx.constraintlayout.core.motion.CustomVariable;
import androidx.constraintlayout.core.motion.utils.TypedValues;
import androidx.constraintlayout.core.state.WidgetFrame;
import androidx.constraintlayout.core.widgets.ConstraintWidget;
import java.util.Set;

public class MotionWidget
implements TypedValues {
    WidgetFrame mWidgetFrame = new WidgetFrame();
    Motion mMotion = new Motion();
    PropertySet mPropertySet = new PropertySet();
    private float mProgress;
    float mTransitionPathRotate;
    public static final int VISIBILITY_MODE_NORMAL = 0;
    public static final int VISIBILITY_MODE_IGNORE = 1;
    private static final int INTERNAL_MATCH_PARENT = -1;
    private static final int INTERNAL_WRAP_CONTENT = -2;
    public static final int INVISIBLE = 0;
    public static final int VISIBLE = 4;
    private static final int INTERNAL_MATCH_CONSTRAINT = -3;
    private static final int INTERNAL_WRAP_CONTENT_CONSTRAINED = -4;
    public static final int ROTATE_NONE = 0;
    public static final int ROTATE_PORTRATE_OF_RIGHT = 1;
    public static final int ROTATE_PORTRATE_OF_LEFT = 2;
    public static final int ROTATE_RIGHT_OF_PORTRATE = 3;
    public static final int ROTATE_LEFT_OF_PORTRATE = 4;
    public static final int UNSET = -1;
    public static final int MATCH_CONSTRAINT = 0;
    public static final int PARENT_ID = 0;
    public static final int FILL_PARENT = -1;
    public static final int MATCH_PARENT = -1;
    public static final int WRAP_CONTENT = -2;
    public static final int GONE_UNSET = Integer.MIN_VALUE;
    public static final int MATCH_CONSTRAINT_WRAP = 1;

    public MotionWidget() {
    }

    public MotionWidget getParent() {
        return null;
    }

    public MotionWidget findViewById(int mTransformPivotTarget) {
        return null;
    }

    public void setVisibility(int visibility) {
        this.mPropertySet.visibility = visibility;
    }

    public String getName() {
        return this.mWidgetFrame.getId();
    }

    public void layout(int l, int t, int r, int b) {
        this.setBounds(l, t, r, b);
    }

    public String toString() {
        return this.mWidgetFrame.left + ", " + this.mWidgetFrame.top + ", " + this.mWidgetFrame.right + ", " + this.mWidgetFrame.bottom;
    }

    public void setBounds(int left, int top, int right, int bottom) {
        if (this.mWidgetFrame == null) {
            this.mWidgetFrame = new WidgetFrame((ConstraintWidget)null);
        }
        this.mWidgetFrame.top = top;
        this.mWidgetFrame.left = left;
        this.mWidgetFrame.right = right;
        this.mWidgetFrame.bottom = bottom;
    }

    public MotionWidget(WidgetFrame f) {
        this.mWidgetFrame = f;
    }

    public void updateMotion(TypedValues toUpdate) {
        if (this.mWidgetFrame.getMotionProperties() != null) {
            this.mWidgetFrame.getMotionProperties().applyDelta(toUpdate);
        }
    }

    @Override
    public boolean setValue(int id, int value) {
        boolean set = this.setValueAttributes(id, value);
        if (set) {
            return true;
        }
        return this.setValueMotion(id, value);
    }

    @Override
    public boolean setValue(int id, float value) {
        boolean set = this.setValueAttributes(id, value);
        if (set) {
            return true;
        }
        return this.setValueMotion(id, value);
    }

    @Override
    public boolean setValue(int id, String value) {
        if (id == 605) {
            this.mMotion.mAnimateRelativeTo = value;
            return true;
        }
        return this.setValueMotion(id, value);
    }

    @Override
    public boolean setValue(int id, boolean value) {
        return false;
    }

    public boolean setValueMotion(int id, int value) {
        switch (id) {
            case 606: {
                this.mMotion.mAnimateCircleAngleTo = value;
                break;
            }
            case 607: {
                this.mMotion.mPathMotionArc = value;
                break;
            }
            case 608: {
                this.mMotion.mDrawPath = value;
                break;
            }
            case 609: {
                this.mMotion.mPolarRelativeTo = value;
                break;
            }
            case 610: {
                this.mMotion.mQuantizeMotionSteps = value;
                break;
            }
            case 611: {
                this.mMotion.mQuantizeInterpolatorType = value;
                break;
            }
            case 612: {
                this.mMotion.mQuantizeInterpolatorID = value;
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    public boolean setValueMotion(int id, String value) {
        switch (id) {
            case 603: {
                this.mMotion.mTransitionEasing = value;
                break;
            }
            case 604: {
                this.mMotion.mQuantizeInterpolatorString = value;
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    public boolean setValueMotion(int id, float value) {
        switch (id) {
            case 600: {
                this.mMotion.mMotionStagger = value;
                break;
            }
            case 601: {
                this.mMotion.mPathRotate = value;
                break;
            }
            case 602: {
                this.mMotion.mQuantizeMotionPhase = value;
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    public boolean setValueAttributes(int id, float value) {
        switch (id) {
            case 303: {
                this.mWidgetFrame.alpha = value;
                break;
            }
            case 304: {
                this.mWidgetFrame.translationX = value;
                break;
            }
            case 305: {
                this.mWidgetFrame.translationY = value;
                break;
            }
            case 306: {
                this.mWidgetFrame.translationZ = value;
                break;
            }
            case 308: {
                this.mWidgetFrame.rotationX = value;
                break;
            }
            case 309: {
                this.mWidgetFrame.rotationY = value;
                break;
            }
            case 310: {
                this.mWidgetFrame.rotationZ = value;
                break;
            }
            case 311: {
                this.mWidgetFrame.scaleX = value;
                break;
            }
            case 312: {
                this.mWidgetFrame.scaleY = value;
                break;
            }
            case 313: {
                this.mWidgetFrame.pivotX = value;
                break;
            }
            case 314: {
                this.mWidgetFrame.pivotY = value;
                break;
            }
            case 315: {
                this.mProgress = value;
                break;
            }
            case 316: {
                this.mTransitionPathRotate = value;
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    public float getValueAttributes(int id) {
        switch (id) {
            case 303: {
                return this.mWidgetFrame.alpha;
            }
            case 304: {
                return this.mWidgetFrame.translationX;
            }
            case 305: {
                return this.mWidgetFrame.translationY;
            }
            case 306: {
                return this.mWidgetFrame.translationZ;
            }
            case 308: {
                return this.mWidgetFrame.rotationX;
            }
            case 309: {
                return this.mWidgetFrame.rotationY;
            }
            case 310: {
                return this.mWidgetFrame.rotationZ;
            }
            case 311: {
                return this.mWidgetFrame.scaleX;
            }
            case 312: {
                return this.mWidgetFrame.scaleY;
            }
            case 313: {
                return this.mWidgetFrame.pivotX;
            }
            case 314: {
                return this.mWidgetFrame.pivotY;
            }
            case 315: {
                return this.mProgress;
            }
            case 316: {
                return this.mTransitionPathRotate;
            }
        }
        return Float.NaN;
    }

    @Override
    public int getId(String name) {
        int ret = TypedValues.AttributesType.getId(name);
        if (ret != -1) {
            return ret;
        }
        return TypedValues.MotionType.getId(name);
    }

    public int getTop() {
        return this.mWidgetFrame.top;
    }

    public int getLeft() {
        return this.mWidgetFrame.left;
    }

    public int getBottom() {
        return this.mWidgetFrame.bottom;
    }

    public int getRight() {
        return this.mWidgetFrame.right;
    }

    public void setPivotX(float px) {
        this.mWidgetFrame.pivotX = px;
    }

    public void setPivotY(float py) {
        this.mWidgetFrame.pivotY = py;
    }

    public float getRotationX() {
        return this.mWidgetFrame.rotationX;
    }

    public void setRotationX(float rotationX) {
        this.mWidgetFrame.rotationX = rotationX;
    }

    public float getRotationY() {
        return this.mWidgetFrame.rotationY;
    }

    public void setRotationY(float rotationY) {
        this.mWidgetFrame.rotationY = rotationY;
    }

    public float getRotationZ() {
        return this.mWidgetFrame.rotationZ;
    }

    public void setRotationZ(float rotationZ) {
        this.mWidgetFrame.rotationZ = rotationZ;
    }

    public float getTranslationX() {
        return this.mWidgetFrame.translationX;
    }

    public void setTranslationX(float translationX) {
        this.mWidgetFrame.translationX = translationX;
    }

    public float getTranslationY() {
        return this.mWidgetFrame.translationY;
    }

    public void setTranslationY(float translationY) {
        this.mWidgetFrame.translationY = translationY;
    }

    public void setTranslationZ(float tz) {
        this.mWidgetFrame.translationZ = tz;
    }

    public float getTranslationZ() {
        return this.mWidgetFrame.translationZ;
    }

    public float getScaleX() {
        return this.mWidgetFrame.scaleX;
    }

    public void setScaleX(float scaleX) {
        this.mWidgetFrame.scaleX = scaleX;
    }

    public float getScaleY() {
        return this.mWidgetFrame.scaleY;
    }

    public void setScaleY(float scaleY) {
        this.mWidgetFrame.scaleY = scaleY;
    }

    public int getVisibility() {
        return this.mPropertySet.visibility;
    }

    public float getPivotX() {
        return this.mWidgetFrame.pivotX;
    }

    public float getPivotY() {
        return this.mWidgetFrame.pivotY;
    }

    public float getAlpha() {
        return this.mWidgetFrame.alpha;
    }

    public int getX() {
        return this.mWidgetFrame.left;
    }

    public int getY() {
        return this.mWidgetFrame.top;
    }

    public int getWidth() {
        return this.mWidgetFrame.right - this.mWidgetFrame.left;
    }

    public int getHeight() {
        return this.mWidgetFrame.bottom - this.mWidgetFrame.top;
    }

    public WidgetFrame getWidgetFrame() {
        return this.mWidgetFrame;
    }

    public Set<String> getCustomAttributeNames() {
        return this.mWidgetFrame.getCustomAttributeNames();
    }

    public void setCustomAttribute(String name, int type, float value) {
        this.mWidgetFrame.setCustomAttribute(name, type, value);
    }

    public void setCustomAttribute(String name, int type, int value) {
        this.mWidgetFrame.setCustomAttribute(name, type, value);
    }

    public void setCustomAttribute(String name, int type, boolean value) {
        this.mWidgetFrame.setCustomAttribute(name, type, value);
    }

    public void setCustomAttribute(String name, int type, String value) {
        this.mWidgetFrame.setCustomAttribute(name, type, value);
    }

    public CustomVariable getCustomAttribute(String name) {
        return this.mWidgetFrame.getCustomAttribute(name);
    }

    public void setInterpolatedValue(CustomAttribute attribute, float[] mCache) {
        this.mWidgetFrame.setCustomAttribute(attribute.mName, 901, mCache[0]);
    }

    public static class Motion {
        public String mAnimateRelativeTo = null;
        public int mAnimateCircleAngleTo = 0;
        public String mTransitionEasing = null;
        public int mPathMotionArc = -1;
        public int mDrawPath = 0;
        public float mMotionStagger = Float.NaN;
        public int mPolarRelativeTo = -1;
        public float mPathRotate = Float.NaN;
        public float mQuantizeMotionPhase = Float.NaN;
        public int mQuantizeMotionSteps = -1;
        public String mQuantizeInterpolatorString = null;
        public int mQuantizeInterpolatorType = -3;
        public int mQuantizeInterpolatorID = -1;
        private static final int INTERPOLATOR_REFERENCE_ID = -2;
        private static final int SPLINE_STRING = -1;
        private static final int INTERPOLATOR_UNDEFINED = -3;
    }

    public static class PropertySet {
        public int visibility = 4;
        public int mVisibilityMode = 0;
        public float alpha = 1.0f;
        public float mProgress = Float.NaN;
    }
}

