/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.state;

import androidx.constraintlayout.core.motion.CustomVariable;
import androidx.constraintlayout.core.motion.Motion;
import androidx.constraintlayout.core.motion.MotionWidget;
import androidx.constraintlayout.core.motion.key.MotionKeyAttributes;
import androidx.constraintlayout.core.motion.key.MotionKeyCycle;
import androidx.constraintlayout.core.motion.key.MotionKeyPosition;
import androidx.constraintlayout.core.motion.utils.Easing;
import androidx.constraintlayout.core.motion.utils.KeyCache;
import androidx.constraintlayout.core.motion.utils.SpringStopEngine;
import androidx.constraintlayout.core.motion.utils.StopEngine;
import androidx.constraintlayout.core.motion.utils.StopLogicEngine;
import androidx.constraintlayout.core.motion.utils.TypedBundle;
import androidx.constraintlayout.core.motion.utils.TypedValues;
import androidx.constraintlayout.core.state.CorePixelDp;
import androidx.constraintlayout.core.state.Interpolator;
import androidx.constraintlayout.core.state.WidgetFrame;
import androidx.constraintlayout.core.widgets.ConstraintWidget;
import androidx.constraintlayout.core.widgets.ConstraintWidgetContainer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;

public class Transition
implements TypedValues {
    private static final boolean DEBUG = false;
    public static final int START = 0;
    public static final int END = 1;
    public static final int INTERPOLATED = 2;
    static final int EASE_IN_OUT = 0;
    static final int EASE_IN = 1;
    static final int EASE_OUT = 2;
    static final int LINEAR = 3;
    static final int BOUNCE = 4;
    static final int OVERSHOOT = 5;
    static final int ANTICIPATE = 6;
    private static final int SPLINE_STRING = -1;
    private static final int INTERPOLATOR_REFERENCE_ID = -2;
    private HashMap<Integer, HashMap<String, KeyPosition>> mKeyPositions = new HashMap();
    private HashMap<String, WidgetState> mState = new HashMap();
    private TypedBundle mBundle = new TypedBundle();
    private int mDefaultInterpolator = 0;
    private String mDefaultInterpolatorString = null;
    private Easing mEasing = null;
    private int mAutoTransition = 0;
    private int mDuration = 400;
    private float mStagger = 0.0f;
    private OnSwipe mOnSwipe = null;
    CorePixelDp mToPixel;
    int mParentStartWidth;
    int mParentStartHeight;
    int mParentEndWidth;
    int mParentEndHeight;
    int mParentInterpolatedWidth;
    int mParentInterpolateHeight;
    boolean mWrap;

    OnSwipe createOnSwipe() {
        this.mOnSwipe = new OnSwipe();
        return this.mOnSwipe;
    }

    public boolean hasOnSwipe() {
        return this.mOnSwipe != null;
    }

    public float dragToProgress(float currentProgress, int baseW, int baseH, float dx, float dy) {
        Collection<WidgetState> widgets = this.mState.values();
        WidgetState childWidget = null;
        Iterator<WidgetState> iterator = widgets.iterator();
        if (iterator.hasNext()) {
            WidgetState widget;
            childWidget = widget = iterator.next();
        }
        if (this.mOnSwipe == null || childWidget == null) {
            if (childWidget != null) {
                return -dy / (float)childWidget.mParentHeight;
            }
            return 1.0f;
        }
        if (this.mOnSwipe.mAnchorId == null) {
            float[] dir = this.mOnSwipe.getDirection();
            float motionDpDtX = childWidget.mParentHeight;
            float motionDpDtY = childWidget.mParentHeight;
            float drag = dir[0] != 0.0f ? dx * Math.abs(dir[0]) / motionDpDtX : dy * Math.abs(dir[1]) / motionDpDtY;
            return drag * this.mOnSwipe.getScale();
        }
        WidgetState base = this.mState.get(this.mOnSwipe.mAnchorId);
        float[] dir = this.mOnSwipe.getDirection();
        float[] side = this.mOnSwipe.getSide();
        float[] motionDpDt = new float[2];
        base.interpolate(baseW, baseH, currentProgress, this);
        base.mMotionControl.getDpDt(currentProgress, side[0], side[1], motionDpDt);
        float drag = dir[0] != 0.0f ? dx * Math.abs(dir[0]) / motionDpDt[0] : dy * Math.abs(dir[1]) / motionDpDt[1];
        return drag * this.mOnSwipe.getScale();
    }

    public void setTouchUp(float currentProgress, long currentTime, float velocityX, float velocityY) {
        if (this.mOnSwipe != null) {
            WidgetState base = this.mState.get(this.mOnSwipe.mAnchorId);
            float[] motionDpDt = new float[2];
            float[] dir = this.mOnSwipe.getDirection();
            float[] side = this.mOnSwipe.getSide();
            base.mMotionControl.getDpDt(currentProgress, side[0], side[1], motionDpDt);
            float movementInDir = dir[0] * motionDpDt[0] + dir[1] * motionDpDt[1];
            if ((double)Math.abs(movementInDir) < 0.01) {
                motionDpDt[0] = 0.01f;
                motionDpDt[1] = 0.01f;
            }
            float drag = dir[0] != 0.0f ? velocityX / motionDpDt[0] : velocityY / motionDpDt[1];
            this.mOnSwipe.config(currentProgress, drag *= this.mOnSwipe.getScale(), currentTime, (float)this.mDuration * 0.001f);
        }
    }

    public float getTouchUpProgress(long currentTime) {
        if (this.mOnSwipe != null) {
            return this.mOnSwipe.getTouchUpProgress(currentTime);
        }
        return 0.0f;
    }

    public boolean isTouchNotDone(float currentProgress) {
        return this.mOnSwipe.isNotDone(currentProgress);
    }

    public static Interpolator getInterpolator(int interpolator, String interpolatorString) {
        switch (interpolator) {
            case -1: {
                return v -> (float)Easing.getInterpolator(interpolatorString).get(v);
            }
            case 0: {
                return v -> (float)Easing.getInterpolator("standard").get(v);
            }
            case 1: {
                return v -> (float)Easing.getInterpolator("accelerate").get(v);
            }
            case 2: {
                return v -> (float)Easing.getInterpolator("decelerate").get(v);
            }
            case 3: {
                return v -> (float)Easing.getInterpolator("linear").get(v);
            }
            case 6: {
                return v -> (float)Easing.getInterpolator("anticipate").get(v);
            }
            case 5: {
                return v -> (float)Easing.getInterpolator("overshoot").get(v);
            }
            case 4: {
                return v -> (float)Easing.getInterpolator("spline(0.0, 0.2, 0.4, 0.6, 0.8 ,1.0, 0.8, 1.0, 0.9, 1.0)").get(v);
            }
        }
        return null;
    }

    public KeyPosition findPreviousPosition(String target, int frameNumber) {
        while (frameNumber >= 0) {
            KeyPosition keyPosition;
            HashMap<String, KeyPosition> map = this.mKeyPositions.get(frameNumber);
            if (map != null && (keyPosition = map.get(target)) != null) {
                return keyPosition;
            }
            --frameNumber;
        }
        return null;
    }

    public KeyPosition findNextPosition(String target, int frameNumber) {
        while (frameNumber <= 100) {
            KeyPosition keyPosition;
            HashMap<String, KeyPosition> map = this.mKeyPositions.get(frameNumber);
            if (map != null && (keyPosition = map.get(target)) != null) {
                return keyPosition;
            }
            ++frameNumber;
        }
        return null;
    }

    public int getNumberKeyPositions(WidgetFrame frame) {
        int numKeyPositions = 0;
        for (int frameNumber = 0; frameNumber <= 100; ++frameNumber) {
            KeyPosition keyPosition;
            HashMap<String, KeyPosition> map = this.mKeyPositions.get(frameNumber);
            if (map == null || (keyPosition = map.get(frame.widget.stringId)) == null) continue;
            ++numKeyPositions;
        }
        return numKeyPositions;
    }

    public Motion getMotion(String id) {
        return this.getWidgetState((String)id, null, (int)0).mMotionControl;
    }

    public void fillKeyPositions(WidgetFrame frame, float[] x, float[] y, float[] pos) {
        int numKeyPositions = 0;
        for (int frameNumber = 0; frameNumber <= 100; ++frameNumber) {
            KeyPosition keyPosition;
            HashMap<String, KeyPosition> map = this.mKeyPositions.get(frameNumber);
            if (map == null || (keyPosition = map.get(frame.widget.stringId)) == null) continue;
            x[numKeyPositions] = keyPosition.mX;
            y[numKeyPositions] = keyPosition.mY;
            pos[numKeyPositions] = keyPosition.mFrame;
            ++numKeyPositions;
        }
    }

    public boolean hasPositionKeyframes() {
        return this.mKeyPositions.size() > 0;
    }

    public void setTransitionProperties(TypedBundle bundle) {
        bundle.applyDelta(this.mBundle);
        bundle.applyDelta(this);
    }

    @Override
    public boolean setValue(int id, int value) {
        return false;
    }

    @Override
    public boolean setValue(int id, float value) {
        if (id == 706) {
            this.mStagger = value;
        }
        return false;
    }

    @Override
    public boolean setValue(int id, String value) {
        if (id == 705) {
            this.mDefaultInterpolatorString = value;
            this.mEasing = Easing.getInterpolator(this.mDefaultInterpolatorString);
        }
        return false;
    }

    @Override
    public boolean setValue(int id, boolean value) {
        return false;
    }

    @Override
    public int getId(String name) {
        return 0;
    }

    public boolean isEmpty() {
        return this.mState.isEmpty();
    }

    public void clear() {
        this.mState.clear();
    }

    public boolean contains(String key) {
        return this.mState.containsKey(key);
    }

    public void addKeyPosition(String target, TypedBundle bundle) {
        this.getWidgetState(target, null, 0).setKeyPosition(bundle);
    }

    public void addKeyAttribute(String target, TypedBundle bundle) {
        this.getWidgetState(target, null, 0).setKeyAttribute(bundle);
    }

    public void addKeyAttribute(String target, TypedBundle bundle, CustomVariable[] custom) {
        this.getWidgetState(target, null, 0).setKeyAttribute(bundle, custom);
    }

    public void addKeyCycle(String target, TypedBundle bundle) {
        this.getWidgetState(target, null, 0).setKeyCycle(bundle);
    }

    public void addKeyPosition(String target, int frame, int type, float x, float y) {
        TypedBundle bundle = new TypedBundle();
        bundle.add(510, 2);
        bundle.add(100, frame);
        bundle.add(506, x);
        bundle.add(507, y);
        this.getWidgetState(target, null, 0).setKeyPosition(bundle);
        KeyPosition keyPosition = new KeyPosition(target, frame, type, x, y);
        HashMap<String, KeyPosition> map = this.mKeyPositions.get(frame);
        if (map == null) {
            map = new HashMap();
            this.mKeyPositions.put(frame, map);
        }
        map.put(target, keyPosition);
    }

    public void addCustomFloat(int state, String widgetId, String property, float value) {
        WidgetState widgetState = this.getWidgetState(widgetId, null, state);
        WidgetFrame frame = widgetState.getFrame(state);
        frame.addCustomFloat(property, value);
    }

    public void addCustomColor(int state, String widgetId, String property, int color) {
        WidgetState widgetState = this.getWidgetState(widgetId, null, state);
        WidgetFrame frame = widgetState.getFrame(state);
        frame.addCustomColor(property, color);
    }

    private void calculateParentDimensions(float progress) {
        this.mParentInterpolatedWidth = (int)(0.5f + (float)this.mParentStartWidth + (float)(this.mParentEndWidth - this.mParentStartWidth) * progress);
        this.mParentInterpolateHeight = (int)(0.5f + (float)this.mParentStartHeight + (float)(this.mParentEndHeight - this.mParentStartHeight) * progress);
    }

    public int getInterpolatedWidth() {
        return this.mParentInterpolatedWidth;
    }

    public int getInterpolatedHeight() {
        return this.mParentInterpolateHeight;
    }

    public void updateFrom(ConstraintWidgetContainer container, int state) {
        this.mWrap = container.mListDimensionBehaviors[0] == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT;
        this.mWrap |= container.mListDimensionBehaviors[1] == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT;
        if (state == 0) {
            this.mParentInterpolatedWidth = this.mParentStartWidth = container.getWidth();
            this.mParentInterpolateHeight = this.mParentStartHeight = container.getHeight();
        } else {
            this.mParentEndWidth = container.getWidth();
            this.mParentEndHeight = container.getHeight();
        }
        ArrayList<ConstraintWidget> children = container.getChildren();
        int count = children.size();
        WidgetState[] states = new WidgetState[count];
        for (int i = 0; i < count; ++i) {
            WidgetState widgetState;
            ConstraintWidget child = children.get(i);
            states[i] = widgetState = this.getWidgetState(child.stringId, null, state);
            widgetState.update(child, state);
            String id = widgetState.getPathRelativeId();
            if (id == null) continue;
            widgetState.setPathRelative(this.getWidgetState(id, null, state));
        }
        this.calcStagger();
    }

    public void interpolate(int parentWidth, int parentHeight, float progress) {
        if (this.mWrap) {
            this.calculateParentDimensions(progress);
        }
        if (this.mEasing != null) {
            progress = (float)this.mEasing.get(progress);
        }
        for (String key : this.mState.keySet()) {
            WidgetState widget = this.mState.get(key);
            widget.interpolate(parentWidth, parentHeight, progress, this);
        }
    }

    public WidgetFrame getStart(String id) {
        WidgetState widgetState = this.mState.get(id);
        if (widgetState == null) {
            return null;
        }
        return widgetState.mStart;
    }

    public WidgetFrame getEnd(String id) {
        WidgetState widgetState = this.mState.get(id);
        if (widgetState == null) {
            return null;
        }
        return widgetState.mEnd;
    }

    public WidgetFrame getInterpolated(String id) {
        WidgetState widgetState = this.mState.get(id);
        if (widgetState == null) {
            return null;
        }
        return widgetState.mInterpolated;
    }

    public float[] getPath(String id) {
        WidgetState widgetState = this.mState.get(id);
        int duration = 1000;
        int frames = duration / 16;
        float[] mPoints = new float[frames * 2];
        widgetState.mMotionControl.buildPath(mPoints, frames);
        return mPoints;
    }

    public int getKeyFrames(String id, float[] rectangles, int[] pathMode, int[] position) {
        WidgetState widgetState = this.mState.get(id);
        return widgetState.mMotionControl.buildKeyFrames(rectangles, pathMode, position);
    }

    private WidgetState getWidgetState(String widgetId) {
        return this.mState.get(widgetId);
    }

    public WidgetState getWidgetState(String widgetId, ConstraintWidget child, int transitionState) {
        WidgetState widgetState = this.mState.get(widgetId);
        if (widgetState == null) {
            widgetState = new WidgetState();
            this.mBundle.applyDelta(widgetState.mMotionControl);
            widgetState.mMotionWidgetStart.updateMotion(widgetState.mMotionControl);
            this.mState.put(widgetId, widgetState);
            if (child != null) {
                widgetState.update(child, transitionState);
            }
        }
        return widgetState;
    }

    public WidgetFrame getStart(ConstraintWidget child) {
        return this.getWidgetState((String)child.stringId, null, (int)0).mStart;
    }

    public WidgetFrame getEnd(ConstraintWidget child) {
        return this.getWidgetState((String)child.stringId, null, (int)1).mEnd;
    }

    public WidgetFrame getInterpolated(ConstraintWidget child) {
        return this.getWidgetState((String)child.stringId, null, (int)2).mInterpolated;
    }

    public Interpolator getInterpolator() {
        return Transition.getInterpolator(this.mDefaultInterpolator, this.mDefaultInterpolatorString);
    }

    public int getAutoTransition() {
        return this.mAutoTransition;
    }

    public void calcStagger() {
        Motion f;
        WidgetState widgetState;
        if (this.mStagger == 0.0f) {
            return;
        }
        boolean flip = (double)this.mStagger < 0.0;
        float stagger = Math.abs(this.mStagger);
        float min = Float.MAX_VALUE;
        float max = -3.4028235E38f;
        boolean useMotionStagger = false;
        for (String widgetId : this.mState.keySet()) {
            widgetState = this.mState.get(widgetId);
            f = widgetState.mMotionControl;
            if (Float.isNaN(f.getMotionStagger())) continue;
            useMotionStagger = true;
            break;
        }
        if (useMotionStagger) {
            float widgetStagger;
            for (String widgetId : this.mState.keySet()) {
                widgetState = this.mState.get(widgetId);
                f = widgetState.mMotionControl;
                widgetStagger = f.getMotionStagger();
                if (Float.isNaN(widgetStagger)) continue;
                min = Math.min(min, widgetStagger);
                max = Math.max(max, widgetStagger);
            }
            for (String widgetId : this.mState.keySet()) {
                widgetState = this.mState.get(widgetId);
                f = widgetState.mMotionControl;
                widgetStagger = f.getMotionStagger();
                if (Float.isNaN(widgetStagger)) continue;
                float scale = 1.0f / (1.0f - stagger);
                float offset = stagger - stagger * (widgetStagger - min) / (max - min);
                if (flip) {
                    offset = stagger - stagger * ((max - widgetStagger) / (max - min));
                }
                f.setStaggerScale(scale);
                f.setStaggerOffset(offset);
            }
        } else {
            float widgetStagger;
            float y;
            float x;
            for (String widgetId : this.mState.keySet()) {
                widgetState = this.mState.get(widgetId);
                f = widgetState.mMotionControl;
                x = f.getFinalX();
                y = f.getFinalY();
                widgetStagger = x + y;
                min = Math.min(min, widgetStagger);
                max = Math.max(max, widgetStagger);
            }
            for (String widgetId : this.mState.keySet()) {
                widgetState = this.mState.get(widgetId);
                f = widgetState.mMotionControl;
                x = f.getFinalX();
                y = f.getFinalY();
                widgetStagger = x + y;
                float offset = stagger - stagger * (widgetStagger - min) / (max - min);
                if (flip) {
                    offset = stagger - stagger * ((max - widgetStagger) / (max - min));
                }
                float scale = 1.0f / (1.0f - stagger);
                f.setStaggerScale(scale);
                f.setStaggerOffset(offset);
            }
        }
    }

    static class KeyPosition {
        int mFrame;
        String mTarget;
        int mType;
        float mX;
        float mY;

        KeyPosition(String target, int frame, int type, float x, float y) {
            this.mTarget = target;
            this.mFrame = frame;
            this.mType = type;
            this.mX = x;
            this.mY = y;
        }
    }

    public static class WidgetState {
        WidgetFrame mStart;
        WidgetFrame mEnd;
        WidgetFrame mInterpolated;
        Motion mMotionControl;
        boolean mNeedSetup = true;
        MotionWidget mMotionWidgetStart;
        MotionWidget mMotionWidgetEnd;
        MotionWidget mMotionWidgetInterpolated;
        KeyCache mKeyCache = new KeyCache();
        int mParentHeight = -1;
        int mParentWidth = -1;

        public WidgetState() {
            this.mStart = new WidgetFrame();
            this.mEnd = new WidgetFrame();
            this.mInterpolated = new WidgetFrame();
            this.mMotionWidgetStart = new MotionWidget(this.mStart);
            this.mMotionWidgetEnd = new MotionWidget(this.mEnd);
            this.mMotionWidgetInterpolated = new MotionWidget(this.mInterpolated);
            this.mMotionControl = new Motion(this.mMotionWidgetStart);
            this.mMotionControl.setStart(this.mMotionWidgetStart);
            this.mMotionControl.setEnd(this.mMotionWidgetEnd);
        }

        public void setKeyPosition(TypedBundle prop) {
            MotionKeyPosition keyPosition = new MotionKeyPosition();
            prop.applyDelta(keyPosition);
            this.mMotionControl.addKey(keyPosition);
        }

        public void setKeyAttribute(TypedBundle prop) {
            MotionKeyAttributes keyAttributes = new MotionKeyAttributes();
            prop.applyDelta(keyAttributes);
            this.mMotionControl.addKey(keyAttributes);
        }

        public void setKeyAttribute(TypedBundle prop, CustomVariable[] custom) {
            MotionKeyAttributes keyAttributes = new MotionKeyAttributes();
            prop.applyDelta(keyAttributes);
            if (custom != null) {
                for (int i = 0; i < custom.length; ++i) {
                    keyAttributes.mCustom.put(custom[i].getName(), custom[i]);
                }
            }
            this.mMotionControl.addKey(keyAttributes);
        }

        public void setKeyCycle(TypedBundle prop) {
            MotionKeyCycle keyAttributes = new MotionKeyCycle();
            prop.applyDelta(keyAttributes);
            this.mMotionControl.addKey(keyAttributes);
        }

        public void update(ConstraintWidget child, int state) {
            if (state == 0) {
                this.mStart.update(child);
                this.mMotionWidgetStart.updateMotion(this.mMotionWidgetStart);
                this.mMotionControl.setStart(this.mMotionWidgetStart);
                this.mNeedSetup = true;
            } else if (state == 1) {
                this.mEnd.update(child);
                this.mMotionControl.setEnd(this.mMotionWidgetEnd);
                this.mNeedSetup = true;
            }
            this.mParentWidth = -1;
        }

        String getPathRelativeId() {
            return this.mMotionControl.getAnimateRelativeTo();
        }

        public WidgetFrame getFrame(int type) {
            if (type == 0) {
                return this.mStart;
            }
            if (type == 1) {
                return this.mEnd;
            }
            return this.mInterpolated;
        }

        public void interpolate(int parentWidth, int parentHeight, float progress, Transition transition) {
            this.mParentHeight = parentHeight;
            this.mParentWidth = parentWidth;
            if (this.mNeedSetup) {
                this.mMotionControl.setup(parentWidth, parentHeight, 1.0f, System.nanoTime());
                this.mNeedSetup = false;
            }
            WidgetFrame.interpolate(parentWidth, parentHeight, this.mInterpolated, this.mStart, this.mEnd, transition, progress);
            this.mInterpolated.interpolatedPos = progress;
            this.mMotionControl.interpolate(this.mMotionWidgetInterpolated, progress, System.nanoTime(), this.mKeyCache);
        }

        public void setPathRelative(WidgetState widgetState) {
            this.mMotionControl.setupRelative(widgetState.mMotionControl);
        }
    }

    static class OnSwipe {
        String mAnchorId;
        private int mAnchorSide;
        private StopEngine mEngine;
        public static final int ANCHOR_SIDE_TOP = 0;
        public static final int ANCHOR_SIDE_LEFT = 1;
        public static final int ANCHOR_SIDE_RIGHT = 2;
        public static final int ANCHOR_SIDE_BOTTOM = 3;
        public static final int ANCHOR_SIDE_MIDDLE = 4;
        public static final int ANCHOR_SIDE_START = 5;
        public static final int ANCHOR_SIDE_END = 6;
        public static final String[] SIDES = new String[]{"top", "left", "right", "bottom", "middle", "start", "end"};
        private static final float[][] TOUCH_SIDES = new float[][]{{0.5f, 0.0f}, {0.0f, 0.5f}, {1.0f, 0.5f}, {0.5f, 1.0f}, {0.5f, 0.5f}, {0.0f, 0.5f}, {1.0f, 0.5f}};
        private String mRotationCenterId;
        private String mLimitBoundsTo;
        private boolean mDragVertical = true;
        private int mDragDirection = 0;
        public static final int DRAG_UP = 0;
        public static final int DRAG_DOWN = 1;
        public static final int DRAG_LEFT = 2;
        public static final int DRAG_RIGHT = 3;
        public static final int DRAG_START = 4;
        public static final int DRAG_END = 5;
        public static final int DRAG_CLOCKWISE = 6;
        public static final int DRAG_ANTICLOCKWISE = 7;
        public static final String[] DIRECTIONS = new String[]{"up", "down", "left", "right", "start", "end", "clockwise", "anticlockwise"};
        private float mDragScale = 1.0f;
        private float mDragThreshold = 10.0f;
        private int mAutoCompleteMode = 0;
        public static final int MODE_CONTINUOUS_VELOCITY = 0;
        public static final int MODE_SPRING = 1;
        public static final String[] MODE = new String[]{"velocity", "spring"};
        private float mMaxVelocity = 4.0f;
        private float mMaxAcceleration = 1.2f;
        private int mOnTouchUp = 0;
        public static final int ON_UP_AUTOCOMPLETE = 0;
        public static final int ON_UP_AUTOCOMPLETE_TO_START = 1;
        public static final int ON_UP_AUTOCOMPLETE_TO_END = 2;
        public static final int ON_UP_STOP = 3;
        public static final int ON_UP_DECELERATE = 4;
        public static final int ON_UP_DECELERATE_AND_COMPLETE = 5;
        public static final int ON_UP_NEVER_COMPLETE_TO_START = 6;
        public static final int ON_UP_NEVER_COMPLETE_TO_END = 7;
        public static final String[] TOUCH_UP = new String[]{"autocomplete", "toStart", "toEnd", "stop", "decelerate", "decelerateComplete", "neverCompleteStart", "neverCompleteEnd"};
        private float mSpringMass = 1.0f;
        private float mSpringStiffness = 400.0f;
        private float mSpringDamping = 10.0f;
        private float mSpringStopThreshold = 0.01f;
        private float mDestination = 0.0f;
        private int mSpringBoundary = 0;
        public static final int BOUNDARY_OVERSHOOT = 0;
        public static final int BOUNDARY_BOUNCE_START = 1;
        public static final int BOUNDARY_BOUNCE_END = 2;
        public static final int BOUNDARY_BOUNCE_BOTH = 3;
        public static final String[] BOUNDARY = new String[]{"overshoot", "bounceStart", "bounceEnd", "bounceBoth"};
        private static final float[][] TOUCH_DIRECTION = new float[][]{{0.0f, -1.0f}, {0.0f, 1.0f}, {-1.0f, 0.0f}, {1.0f, 0.0f}, {-1.0f, 0.0f}, {1.0f, 0.0f}};
        private long mStart;

        OnSwipe() {
        }

        float getScale() {
            return this.mDragScale;
        }

        float[] getDirection() {
            return TOUCH_DIRECTION[this.mDragDirection];
        }

        float[] getSide() {
            return TOUCH_SIDES[this.mAnchorSide];
        }

        void setAnchorId(String anchorId) {
            this.mAnchorId = anchorId;
        }

        void setAnchorSide(int anchorSide) {
            this.mAnchorSide = anchorSide;
        }

        void setRotationCenterId(String rotationCenterId) {
            this.mRotationCenterId = rotationCenterId;
        }

        void setLimitBoundsTo(String limitBoundsTo) {
            this.mLimitBoundsTo = limitBoundsTo;
        }

        void setDragDirection(int dragDirection) {
            this.mDragDirection = dragDirection;
            this.mDragVertical = this.mDragDirection < 2;
        }

        void setDragScale(float dragScale) {
            if (Float.isNaN(dragScale)) {
                return;
            }
            this.mDragScale = dragScale;
        }

        void setDragThreshold(float dragThreshold) {
            if (Float.isNaN(dragThreshold)) {
                return;
            }
            this.mDragThreshold = dragThreshold;
        }

        void setAutoCompleteMode(int mAutoCompleteMode) {
            this.mAutoCompleteMode = mAutoCompleteMode;
        }

        void setMaxVelocity(float maxVelocity) {
            if (Float.isNaN(maxVelocity)) {
                return;
            }
            this.mMaxVelocity = maxVelocity;
        }

        void setMaxAcceleration(float maxAcceleration) {
            if (Float.isNaN(maxAcceleration)) {
                return;
            }
            this.mMaxAcceleration = maxAcceleration;
        }

        void setOnTouchUp(int onTouchUp) {
            this.mOnTouchUp = onTouchUp;
        }

        void setSpringMass(float mSpringMass) {
            if (Float.isNaN(mSpringMass)) {
                return;
            }
            this.mSpringMass = mSpringMass;
        }

        void setSpringStiffness(float mSpringStiffness) {
            if (Float.isNaN(mSpringStiffness)) {
                return;
            }
            this.mSpringStiffness = mSpringStiffness;
        }

        void setSpringDamping(float mSpringDamping) {
            if (Float.isNaN(mSpringDamping)) {
                return;
            }
            this.mSpringDamping = mSpringDamping;
        }

        void setSpringStopThreshold(float mSpringStopThreshold) {
            if (Float.isNaN(mSpringStopThreshold)) {
                return;
            }
            this.mSpringStopThreshold = mSpringStopThreshold;
        }

        void setSpringBoundary(int mSpringBoundary) {
            this.mSpringBoundary = mSpringBoundary;
        }

        float getDestinationPosition(float currentPosition, float velocity, float duration) {
            float rest = currentPosition + 0.5f * Math.abs(velocity) * velocity / this.mMaxAcceleration;
            switch (this.mOnTouchUp) {
                case 1: 
                case 7: {
                    return 0.0f;
                }
                case 2: 
                case 6: {
                    return 1.0f;
                }
                case 3: {
                    return Float.NaN;
                }
                case 4: {
                    return Math.max(0.0f, Math.min(1.0f, rest));
                }
                case 5: {
                    if (rest > 0.2f && rest < 0.8f) {
                        return rest;
                    }
                    return rest > 0.5f ? 1.0f : 0.0f;
                }
            }
            return (double)rest > 0.5 ? 1.0f : 0.0f;
        }

        void config(float position, float velocity, long start, float duration) {
            SpringStopEngine sl;
            this.mStart = start;
            this.mDestination = this.getDestinationPosition(position, velocity, duration);
            if (this.mOnTouchUp == 4 && this.mAutoCompleteMode == 0) {
                StopLogicEngine.Decelerate sld;
                if (this.mEngine instanceof StopLogicEngine.Decelerate) {
                    sld = (StopLogicEngine.Decelerate)this.mEngine;
                } else {
                    sld = new StopLogicEngine.Decelerate();
                    this.mEngine = sld;
                }
                sld.config(position, this.mDestination, velocity);
                return;
            }
            if (this.mAutoCompleteMode == 0) {
                StopLogicEngine sl2;
                if (this.mEngine instanceof StopLogicEngine) {
                    sl2 = (StopLogicEngine)this.mEngine;
                } else {
                    sl2 = new StopLogicEngine();
                    this.mEngine = sl2;
                }
                sl2.config(position, this.mDestination, velocity, duration, this.mMaxAcceleration, this.mMaxVelocity);
                return;
            }
            if (this.mEngine instanceof SpringStopEngine) {
                sl = (SpringStopEngine)this.mEngine;
            } else {
                sl = new SpringStopEngine();
                this.mEngine = sl;
            }
            sl.springConfig(position, this.mDestination, velocity, this.mSpringMass, this.mSpringStiffness, this.mSpringDamping, this.mSpringStopThreshold, this.mSpringBoundary);
        }

        public float getTouchUpProgress(long currentTime) {
            float time = (float)(currentTime - this.mStart) * 1.0E-9f;
            float pos = this.mEngine.getInterpolation(time);
            if (this.mEngine.isStopped()) {
                pos = this.mDestination;
            }
            return pos;
        }

        public void printInfo() {
            if (this.mAutoCompleteMode == 0) {
                System.out.println("velocity = " + this.mEngine.getVelocity());
                System.out.println("mMaxAcceleration = " + this.mMaxAcceleration);
                System.out.println("mMaxVelocity = " + this.mMaxVelocity);
            } else {
                System.out.println("mSpringMass          = " + this.mSpringMass);
                System.out.println("mSpringStiffness     = " + this.mSpringStiffness);
                System.out.println("mSpringDamping       = " + this.mSpringDamping);
                System.out.println("mSpringStopThreshold = " + this.mSpringStopThreshold);
                System.out.println("mSpringBoundary      = " + this.mSpringBoundary);
            }
        }

        public boolean isNotDone(float progress) {
            if (this.mOnTouchUp == 3) {
                return false;
            }
            return !this.mEngine.isStopped();
        }
    }
}

