/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.motion.utils;

import androidx.constraintlayout.core.motion.CustomAttribute;
import androidx.constraintlayout.core.motion.CustomVariable;
import java.util.Arrays;

public class KeyFrameArray {

    static class FloatArray {
        int[] keys = new int[101];
        float[][] values = new float[101][];
        int count;
        private static final int EMPTY = 999;

        public FloatArray() {
            this.clear();
        }

        public void clear() {
            Arrays.fill(this.keys, 999);
            Arrays.fill((Object[])this.values, null);
            this.count = 0;
        }

        public void dump() {
            System.out.println("V: " + Arrays.toString(Arrays.copyOf(this.keys, this.count)));
            System.out.print("K: [");
            for (int i = 0; i < this.count; ++i) {
                System.out.print((i == 0 ? "" : ", ") + Arrays.toString(this.valueAt(i)));
            }
            System.out.println("]");
        }

        public int size() {
            return this.count;
        }

        public float[] valueAt(int i) {
            return this.values[this.keys[i]];
        }

        public int keyAt(int i) {
            return this.keys[i];
        }

        public void append(int position, float[] value) {
            if (this.values[position] != null) {
                this.remove(position);
            }
            this.values[position] = value;
            this.keys[this.count++] = position;
            Arrays.sort(this.keys);
        }

        public void remove(int position) {
            this.values[position] = null;
            int j = 0;
            for (int i = 0; i < this.count; ++i) {
                if (position == this.keys[i]) {
                    this.keys[i] = 999;
                    ++j;
                }
                if (i != j) {
                    this.keys[i] = this.keys[j];
                }
                ++j;
            }
            --this.count;
        }
    }

    public static class CustomVar {
        int[] keys = new int[101];
        CustomVariable[] values = new CustomVariable[101];
        int count;
        private static final int EMPTY = 999;

        public CustomVar() {
            this.clear();
        }

        public void clear() {
            Arrays.fill(this.keys, 999);
            Arrays.fill(this.values, null);
            this.count = 0;
        }

        public void dump() {
            System.out.println("V: " + Arrays.toString(Arrays.copyOf(this.keys, this.count)));
            System.out.print("K: [");
            for (int i = 0; i < this.count; ++i) {
                System.out.print((i == 0 ? "" : ", ") + this.valueAt(i));
            }
            System.out.println("]");
        }

        public int size() {
            return this.count;
        }

        public CustomVariable valueAt(int i) {
            return this.values[this.keys[i]];
        }

        public int keyAt(int i) {
            return this.keys[i];
        }

        public void append(int position, CustomVariable value) {
            if (this.values[position] != null) {
                this.remove(position);
            }
            this.values[position] = value;
            this.keys[this.count++] = position;
            Arrays.sort(this.keys);
        }

        public void remove(int position) {
            this.values[position] = null;
            int j = 0;
            for (int i = 0; i < this.count; ++i) {
                if (position == this.keys[i]) {
                    this.keys[i] = 999;
                    ++j;
                }
                if (i != j) {
                    this.keys[i] = this.keys[j];
                }
                ++j;
            }
            --this.count;
        }
    }

    public static class CustomArray {
        int[] keys = new int[101];
        CustomAttribute[] values = new CustomAttribute[101];
        int count;
        private static final int EMPTY = 999;

        public CustomArray() {
            this.clear();
        }

        public void clear() {
            Arrays.fill(this.keys, 999);
            Arrays.fill(this.values, null);
            this.count = 0;
        }

        public void dump() {
            System.out.println("V: " + Arrays.toString(Arrays.copyOf(this.keys, this.count)));
            System.out.print("K: [");
            for (int i = 0; i < this.count; ++i) {
                System.out.print((i == 0 ? "" : ", ") + this.valueAt(i));
            }
            System.out.println("]");
        }

        public int size() {
            return this.count;
        }

        public CustomAttribute valueAt(int i) {
            return this.values[this.keys[i]];
        }

        public int keyAt(int i) {
            return this.keys[i];
        }

        public void append(int position, CustomAttribute value) {
            if (this.values[position] != null) {
                this.remove(position);
            }
            this.values[position] = value;
            this.keys[this.count++] = position;
            Arrays.sort(this.keys);
        }

        public void remove(int position) {
            this.values[position] = null;
            int j = 0;
            for (int i = 0; i < this.count; ++i) {
                if (position == this.keys[i]) {
                    this.keys[i] = 999;
                    ++j;
                }
                if (i != j) {
                    this.keys[i] = this.keys[j];
                }
                ++j;
            }
            --this.count;
        }
    }
}

