/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core;

import androidx.constraintlayout.core.ArrayRow;
import androidx.constraintlayout.core.Cache;
import androidx.constraintlayout.core.LinearSystem;
import androidx.constraintlayout.core.SolverVariable;
import java.util.Arrays;
import java.util.Comparator;

public class PriorityGoalRow
extends ArrayRow {
    private static final float epsilon = 1.0E-4f;
    private static final boolean DEBUG = false;
    private int TABLE_SIZE = 128;
    private SolverVariable[] arrayGoals = new SolverVariable[this.TABLE_SIZE];
    private SolverVariable[] sortArray = new SolverVariable[this.TABLE_SIZE];
    private int numGoals = 0;
    GoalVariableAccessor accessor = new GoalVariableAccessor(this);
    Cache mCache;
    static final int NOT_FOUND = -1;

    @Override
    public void clear() {
        this.numGoals = 0;
        this.constantValue = 0.0f;
    }

    public PriorityGoalRow(Cache cache) {
        super(cache);
        this.mCache = cache;
    }

    @Override
    public boolean isEmpty() {
        return this.numGoals == 0;
    }

    @Override
    public SolverVariable getPivotCandidate(LinearSystem system, boolean[] avoid) {
        int pivot = -1;
        for (int i = 0; i < this.numGoals; ++i) {
            SolverVariable variable = this.arrayGoals[i];
            if (avoid[variable.id]) continue;
            this.accessor.init(variable);
            if (pivot == -1) {
                if (!this.accessor.isNegative()) continue;
                pivot = i;
                continue;
            }
            if (!this.accessor.isSmallerThan(this.arrayGoals[pivot])) continue;
            pivot = i;
        }
        if (pivot == -1) {
            return null;
        }
        return this.arrayGoals[pivot];
    }

    @Override
    public void addError(SolverVariable error) {
        this.accessor.init(error);
        this.accessor.reset();
        error.goalStrengthVector[error.strength] = 1.0f;
        this.addToGoal(error);
    }

    private final void addToGoal(SolverVariable variable) {
        if (this.numGoals + 1 > this.arrayGoals.length) {
            this.arrayGoals = Arrays.copyOf(this.arrayGoals, this.arrayGoals.length * 2);
            this.sortArray = Arrays.copyOf(this.arrayGoals, this.arrayGoals.length * 2);
        }
        this.arrayGoals[this.numGoals] = variable;
        ++this.numGoals;
        if (this.numGoals > 1 && this.arrayGoals[this.numGoals - 1].id > variable.id) {
            int i;
            for (i = 0; i < this.numGoals; ++i) {
                this.sortArray[i] = this.arrayGoals[i];
            }
            Arrays.sort(this.sortArray, 0, this.numGoals, new Comparator<SolverVariable>(){

                @Override
                public int compare(SolverVariable variable1, SolverVariable variable2) {
                    return variable1.id - variable2.id;
                }
            });
            for (i = 0; i < this.numGoals; ++i) {
                this.arrayGoals[i] = this.sortArray[i];
            }
        }
        variable.inGoal = true;
        variable.addToRow(this);
    }

    private final void removeGoal(SolverVariable variable) {
        for (int i = 0; i < this.numGoals; ++i) {
            if (this.arrayGoals[i] != variable) continue;
            for (int j = i; j < this.numGoals - 1; ++j) {
                this.arrayGoals[j] = this.arrayGoals[j + 1];
            }
            --this.numGoals;
            variable.inGoal = false;
            return;
        }
    }

    @Override
    public void updateFromRow(LinearSystem system, ArrayRow definition, boolean removeFromDefinition) {
        SolverVariable goalVariable = definition.variable;
        if (goalVariable == null) {
            return;
        }
        ArrayRow.ArrayRowVariables rowVariables = definition.variables;
        int currentSize = rowVariables.getCurrentSize();
        for (int i = 0; i < currentSize; ++i) {
            SolverVariable solverVariable = rowVariables.getVariable(i);
            float value = rowVariables.getVariableValue(i);
            this.accessor.init(solverVariable);
            if (this.accessor.addToGoal(goalVariable, value)) {
                this.addToGoal(solverVariable);
            }
            this.constantValue += definition.constantValue * value;
        }
        this.removeGoal(goalVariable);
    }

    @Override
    public String toString() {
        String result = "";
        result = result + " goal -> (" + this.constantValue + ") : ";
        for (int i = 0; i < this.numGoals; ++i) {
            SolverVariable v = this.arrayGoals[i];
            this.accessor.init(v);
            result = result + this.accessor + " ";
        }
        return result;
    }

    class GoalVariableAccessor {
        SolverVariable variable;
        PriorityGoalRow row;

        public GoalVariableAccessor(PriorityGoalRow row) {
            this.row = row;
        }

        public void init(SolverVariable variable) {
            this.variable = variable;
        }

        public boolean addToGoal(SolverVariable other, float value) {
            if (this.variable.inGoal) {
                boolean empty = true;
                for (int i = 0; i < 9; ++i) {
                    int n = i;
                    this.variable.goalStrengthVector[n] = this.variable.goalStrengthVector[n] + other.goalStrengthVector[i] * value;
                    float v = this.variable.goalStrengthVector[i];
                    if (Math.abs(v) < 1.0E-4f) {
                        this.variable.goalStrengthVector[i] = 0.0f;
                        continue;
                    }
                    empty = false;
                }
                if (empty) {
                    PriorityGoalRow.this.removeGoal(this.variable);
                }
            } else {
                for (int i = 0; i < 9; ++i) {
                    float strength = other.goalStrengthVector[i];
                    if (strength != 0.0f) {
                        float v = value * strength;
                        if (Math.abs(v) < 1.0E-4f) {
                            v = 0.0f;
                        }
                        this.variable.goalStrengthVector[i] = v;
                        continue;
                    }
                    this.variable.goalStrengthVector[i] = 0.0f;
                }
                return true;
            }
            return false;
        }

        public void add(SolverVariable other) {
            for (int i = 0; i < 9; ++i) {
                int n = i;
                this.variable.goalStrengthVector[n] = this.variable.goalStrengthVector[n] + other.goalStrengthVector[i];
                float value = this.variable.goalStrengthVector[i];
                if (!(Math.abs(value) < 1.0E-4f)) continue;
                this.variable.goalStrengthVector[i] = 0.0f;
            }
        }

        public final boolean isNegative() {
            for (int i = 8; i >= 0; --i) {
                float value = this.variable.goalStrengthVector[i];
                if (value > 0.0f) {
                    return false;
                }
                if (!(value < 0.0f)) continue;
                return true;
            }
            return false;
        }

        public final boolean isSmallerThan(SolverVariable other) {
            for (int i = 8; i >= 0; --i) {
                float value = this.variable.goalStrengthVector[i];
                float comparedValue = other.goalStrengthVector[i];
                if (value == comparedValue) continue;
                return value < comparedValue;
            }
            return false;
        }

        public final boolean isNull() {
            for (int i = 0; i < 9; ++i) {
                if (this.variable.goalStrengthVector[i] == 0.0f) continue;
                return false;
            }
            return true;
        }

        public void reset() {
            Arrays.fill(this.variable.goalStrengthVector, 0.0f);
        }

        public String toString() {
            String result = "[ ";
            if (this.variable != null) {
                for (int i = 0; i < 9; ++i) {
                    result = result + this.variable.goalStrengthVector[i] + " ";
                }
            }
            result = result + "] " + this.variable;
            return result;
        }
    }
}

