/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.state;

import androidx.constraintlayout.core.widgets.ConstraintWidget;
import java.util.HashMap;

public class WidgetFrame {
    public ConstraintWidget widget = null;
    public int left = 0;
    public int top = 0;
    public int right = 0;
    public int bottom = 0;
    public float pivotX = Float.NaN;
    public float pivotY = Float.NaN;
    public float rotationX = Float.NaN;
    public float rotationY = Float.NaN;
    public float rotationZ = Float.NaN;
    public float translationX = Float.NaN;
    public float translationY = Float.NaN;
    public float scaleX = Float.NaN;
    public float scaleY = Float.NaN;
    public float alpha = Float.NaN;
    public HashMap<String, Color> mCustomColors = null;
    public HashMap<String, Float> mCustomFloats = null;

    public int width() {
        return this.right - this.left;
    }

    public int height() {
        return this.bottom - this.top;
    }

    public WidgetFrame() {
    }

    public WidgetFrame(ConstraintWidget widget) {
        this.widget = widget;
    }

    public WidgetFrame(WidgetFrame frame) {
        this.widget = frame.widget;
        this.left = frame.left;
        this.top = frame.top;
        this.right = frame.right;
        this.bottom = frame.bottom;
        this.pivotX = frame.pivotX;
        this.pivotY = frame.pivotY;
        this.rotationX = frame.rotationX;
        this.rotationY = frame.rotationY;
        this.rotationZ = frame.rotationZ;
        this.translationX = frame.translationX;
        this.translationY = frame.translationY;
        this.scaleX = frame.scaleX;
        this.scaleY = frame.scaleY;
        this.alpha = frame.alpha;
        if (frame.mCustomColors != null) {
            this.mCustomColors = new HashMap();
            this.mCustomColors.putAll(frame.mCustomColors);
        }
        if (frame.mCustomFloats != null) {
            this.mCustomFloats = new HashMap();
            this.mCustomFloats.putAll(frame.mCustomFloats);
        }
    }

    public boolean isDefaultTransform() {
        return Float.isNaN(this.rotationX) && Float.isNaN(this.rotationY) && Float.isNaN(this.rotationZ) && Float.isNaN(this.translationX) && Float.isNaN(this.translationY) && Float.isNaN(this.scaleX) && Float.isNaN(this.scaleY) && Float.isNaN(this.alpha);
    }

    public static void interpolate(WidgetFrame frame, WidgetFrame start, WidgetFrame end, float progress) {
        frame.widget = start.widget;
        frame.left = (int)((float)start.left + progress * (float)(end.left - start.left));
        frame.top = (int)((float)start.top + progress * (float)(end.top - start.top));
        frame.right = (int)((float)start.right + progress * (float)(end.right - start.right));
        frame.bottom = (int)((float)start.bottom + progress * (float)(end.bottom - start.bottom));
        frame.pivotX = WidgetFrame.interpolate(start.pivotX, end.pivotX, 0.0f, progress);
        frame.pivotY = WidgetFrame.interpolate(start.pivotY, end.pivotY, 0.0f, progress);
        frame.rotationX = WidgetFrame.interpolate(start.rotationX, end.rotationX, 0.0f, progress);
        frame.rotationY = WidgetFrame.interpolate(start.rotationY, end.rotationY, 0.0f, progress);
        frame.rotationZ = WidgetFrame.interpolate(start.rotationZ, end.rotationZ, 0.0f, progress);
        frame.scaleX = WidgetFrame.interpolate(start.scaleX, end.scaleX, 0.0f, progress);
        frame.scaleY = WidgetFrame.interpolate(start.scaleY, end.scaleY, 0.0f, progress);
        frame.translationX = WidgetFrame.interpolate(start.translationX, end.translationX, 0.0f, progress);
        frame.translationY = WidgetFrame.interpolate(start.translationY, end.translationY, 0.0f, progress);
        frame.alpha = WidgetFrame.interpolate(start.alpha, end.alpha, 0.0f, progress);
    }

    private static float interpolate(float start, float end, float defaultValue, float progress) {
        boolean isStartUnset = Float.isNaN(start);
        boolean isEndUnset = Float.isNaN(end);
        if (isStartUnset && isEndUnset) {
            return Float.NaN;
        }
        if (isStartUnset) {
            start = defaultValue;
        }
        if (isEndUnset) {
            end = defaultValue;
        }
        return start + progress * (end - start);
    }

    public static void interpolateColor(Color result, Color start, Color end, float progress) {
        if (progress < 0.0f) {
            result.copy(start);
        } else if (progress > 1.0f) {
            result.copy(end);
        } else {
            result.r = (1.0f - progress) * start.r + progress * end.r;
            result.g = (1.0f - progress) * start.g + progress * end.g;
            result.b = (1.0f - progress) * start.b + progress * end.b;
            result.a = (1.0f - progress) * start.a + progress * end.a;
        }
    }

    public float centerX() {
        return (float)this.left + (float)(this.right - this.left) / 2.0f;
    }

    public float centerY() {
        return (float)this.top + (float)(this.bottom - this.top) / 2.0f;
    }

    public WidgetFrame update() {
        if (this.widget != null) {
            this.left = this.widget.getLeft();
            this.top = this.widget.getTop();
            this.right = this.widget.getRight();
            this.bottom = this.widget.getBottom();
            WidgetFrame frame = this.widget.frame;
            this.pivotX = frame.pivotX;
            this.pivotY = frame.pivotY;
            this.rotationX = frame.rotationX;
            this.rotationY = frame.rotationY;
            this.rotationZ = frame.rotationZ;
            this.translationX = frame.translationX;
            this.translationY = frame.translationY;
            this.scaleX = frame.scaleX;
            this.scaleY = frame.scaleY;
            this.alpha = frame.alpha;
            if (frame.mCustomColors != null) {
                this.mCustomColors = new HashMap();
                this.mCustomColors.putAll(frame.mCustomColors);
            }
            if (frame.mCustomFloats != null) {
                this.mCustomFloats = new HashMap();
                this.mCustomFloats.putAll(frame.mCustomFloats);
            }
        }
        return this;
    }

    public WidgetFrame update(ConstraintWidget widget) {
        if (widget == null) {
            return this;
        }
        this.widget = widget;
        this.update();
        return this;
    }

    public void addCustomColor(String name, float r, float g, float b, float a) {
        Color color = new Color(r, g, b, a);
        if (this.mCustomColors == null) {
            this.mCustomColors = new HashMap();
        }
        this.mCustomColors.put(name, color);
    }

    public Color getCustomColor(String name) {
        if (this.mCustomColors == null) {
            return null;
        }
        return this.mCustomColors.get(name);
    }

    public void addCustomFloat(String name, float value) {
        if (this.mCustomFloats == null) {
            this.mCustomFloats = new HashMap();
        }
        this.mCustomFloats.put(name, Float.valueOf(value));
    }

    public float getCustomFloat(String name) {
        if (this.mCustomFloats == null) {
            return 0.0f;
        }
        return this.mCustomFloats.get(name).floatValue();
    }

    public static class Color {
        public float r;
        public float g;
        public float b;
        public float a;

        public Color(float r, float g, float b, float a) {
            this.r = r;
            this.g = g;
            this.b = b;
            this.a = a;
        }

        public void copy(Color start) {
            this.r = start.r;
            this.g = start.g;
            this.b = start.b;
            this.a = start.a;
        }
    }
}

