/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.state.helpers;

import androidx.constraintlayout.core.state.Reference;
import androidx.constraintlayout.core.state.State;
import androidx.constraintlayout.core.widgets.ConstraintWidget;
import androidx.constraintlayout.core.widgets.Guideline;

public class GuidelineReference
implements Reference {
    final State mState;
    private int mOrientation;
    private Guideline mGuidelineWidget;
    private int mStart = -1;
    private int mEnd = -1;
    private float mPercent = 0.0f;
    private Object key;

    @Override
    public void setKey(Object key) {
        this.key = key;
    }

    @Override
    public Object getKey() {
        return this.key;
    }

    public GuidelineReference(State state) {
        this.mState = state;
    }

    public void start(Object margin) {
        this.mStart = this.mState.convertDimension(margin);
        this.mEnd = -1;
        this.mPercent = 0.0f;
    }

    public void end(Object margin) {
        this.mStart = -1;
        this.mEnd = this.mState.convertDimension(margin);
        this.mPercent = 0.0f;
    }

    public void percent(float percent) {
        this.mStart = -1;
        this.mEnd = -1;
        this.mPercent = percent;
    }

    public void setOrientation(int orientation) {
        this.mOrientation = orientation;
    }

    public int getOrientation() {
        return this.mOrientation;
    }

    @Override
    public void apply() {
        this.mGuidelineWidget.setOrientation(this.mOrientation);
        if (this.mStart != -1) {
            this.mGuidelineWidget.setGuideBegin(this.mStart);
        } else if (this.mEnd != -1) {
            this.mGuidelineWidget.setGuideEnd(this.mEnd);
        } else {
            this.mGuidelineWidget.setGuidePercent(this.mPercent);
        }
    }

    @Override
    public ConstraintWidget getConstraintWidget() {
        if (this.mGuidelineWidget == null) {
            this.mGuidelineWidget = new Guideline();
        }
        return this.mGuidelineWidget;
    }

    @Override
    public void setConstraintWidget(ConstraintWidget widget) {
        this.mGuidelineWidget = widget instanceof Guideline ? (Guideline)widget : null;
    }
}

