/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text.platform;

import android.content.Context;
import android.graphics.Typeface;
import android.os.Build;
import android.util.TypedValue;
import androidx.collection.LruCache;
import androidx.compose.ui.text.font.AndroidFont;
import androidx.compose.ui.text.font.AndroidPreloadedFont;
import androidx.compose.ui.text.font.Font;
import androidx.compose.ui.text.font.ResourceFont;
import androidx.compose.ui.text.platform.AndroidResourceFontLoaderHelper;
import androidx.core.content.res.ResourcesCompat;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated(message="Duplicate cache")
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c1\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0007\u001a\u0004\u0018\u00010\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0016\u0010\f\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bR\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Landroidx/compose/ui/text/platform/AndroidTypefaceCache;", "", "()V", "cache", "Landroidx/collection/LruCache;", "", "Landroid/graphics/Typeface;", "getKey", "context", "Landroid/content/Context;", "font", "Landroidx/compose/ui/text/font/Font;", "getOrCreate", "ui-text_release"})
@SourceDebugExtension(value={"SMAP\nAndroidFontListTypeface.android.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AndroidFontListTypeface.android.kt\nandroidx/compose/ui/text/platform/AndroidTypefaceCache\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,174:1\n1#2:175\n*E\n"})
public final class AndroidTypefaceCache {
    @NotNull
    public static final AndroidTypefaceCache INSTANCE = new AndroidTypefaceCache();
    @NotNull
    private static final LruCache<String, Typeface> cache = new LruCache(16);

    private AndroidTypefaceCache() {
    }

    @NotNull
    public final Typeface getOrCreate(@NotNull Context context, @NotNull Font font) {
        Typeface typeface2;
        block9: {
            Typeface typeface3;
            String key;
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)font, (String)"font");
            String string = key = this.getKey(context, font);
            if (string != null) {
                String it = string;
                boolean bl = false;
                Typeface typeface4 = (Typeface)cache.get((Object)key);
                if (typeface4 != null) {
                    Typeface it2 = typeface4;
                    boolean bl2 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)it2, (String)"it");
                    return it2;
                }
            }
            Font bl = font;
            if (bl instanceof ResourceFont) {
                if (Build.VERSION.SDK_INT >= 26) {
                    typeface3 = AndroidResourceFontLoaderHelper.INSTANCE.create(context, ((ResourceFont)font).getResId());
                } else {
                    Typeface typeface5 = ResourcesCompat.getFont((Context)context, (int)((ResourceFont)font).getResId());
                    Intrinsics.checkNotNull((Object)typeface5);
                    Typeface it2 = typeface5;
                    Intrinsics.checkNotNullExpressionValue((Object)it2, (String)"{\n                    Re\u2026esId)!!\n                }");
                    typeface3 = it2;
                }
            } else if (bl instanceof AndroidFont) {
                typeface3 = ((AndroidFont)font).getTypefaceLoader().loadBlocking(context, (AndroidFont)font);
            } else {
                throw new IllegalArgumentException("Unknown font type: " + font);
            }
            if (typeface3 == null) {
                throw new IllegalArgumentException("Unable to load font " + font);
            }
            typeface2 = typeface3;
            String string2 = key;
            if (string2 == null) break block9;
            String it = string2;
            boolean bl3 = false;
            Typeface cfr_ignored_0 = (Typeface)cache.put((Object)key, (Object)typeface2);
        }
        return typeface2;
    }

    @Nullable
    public final String getKey(@NotNull Context context, @NotNull Font font) {
        String string;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)font, (String)"font");
        Font font2 = font;
        if (font2 instanceof ResourceFont) {
            TypedValue value = new TypedValue();
            context.getResources().getValue(((ResourceFont)font).getResId(), value, true);
            StringBuilder stringBuilder = new StringBuilder().append("res:");
            CharSequence charSequence = value.string;
            String string2 = charSequence != null ? ((Object)charSequence).toString() : null;
            Intrinsics.checkNotNull((Object)string2);
            string = stringBuilder.append(string2).toString();
        } else if (font2 instanceof AndroidPreloadedFont) {
            string = ((AndroidPreloadedFont)font).getCacheKey();
        } else {
            throw new IllegalArgumentException("Unknown font type: " + font);
        }
        return string;
    }
}

