/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text.android.style;

import android.graphics.Paint;
import android.text.style.LineHeightSpan;
import androidx.annotation.IntRange;
import androidx.compose.ui.text.android.InternalPlatformTextApi;
import androidx.compose.ui.text.android.style.LineHeightStyleSpanKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@InternalPlatformTextApi
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0010\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\b\b\u0001\u0010\n\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J8\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00052\u0006\u0010 \u001a\u00020\u00052\u0006\u0010!\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u001bH\u0016R\u000e\u0010\f\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0005@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0005@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Landroidx/compose/ui/text/android/style/LineHeightStyleSpan;", "Landroid/text/style/LineHeightSpan;", "lineHeight", "", "startIndex", "", "endIndex", "trimFirstLineTop", "", "trimLastLineBottom", "topPercentage", "(FIIZZI)V", "ascent", "descent", "firstAscent", "<set-?>", "firstAscentDiff", "getFirstAscentDiff", "()I", "lastDescent", "lastDescentDiff", "getLastDescentDiff", "getLineHeight", "()F", "calculateTargetMetrics", "", "fontMetricsInt", "Landroid/graphics/Paint$FontMetricsInt;", "chooseHeight", "text", "", "start", "end", "spanStartVertical", "ui-text_release"})
public final class LineHeightStyleSpan
implements LineHeightSpan {
    private final float lineHeight;
    private final int startIndex;
    private final int endIndex;
    private final boolean trimFirstLineTop;
    private final boolean trimLastLineBottom;
    private final int topPercentage;
    private int firstAscent;
    private int ascent;
    private int descent;
    private int lastDescent;
    private int firstAscentDiff;
    private int lastDescentDiff;

    public LineHeightStyleSpan(float lineHeight, int startIndex, int endIndex, boolean trimFirstLineTop, boolean trimLastLineBottom, @IntRange(from=0L, to=100L) int topPercentage) {
        this.lineHeight = lineHeight;
        this.startIndex = startIndex;
        this.endIndex = endIndex;
        this.trimFirstLineTop = trimFirstLineTop;
        this.trimLastLineBottom = trimLastLineBottom;
        this.topPercentage = topPercentage;
        int n = this.topPercentage;
        if (!((0 <= n ? n < 101 : false) || this.topPercentage == -1)) {
            boolean bl = false;
            String string = "topRatio should be in [0..100] range or -1";
            throw new IllegalStateException(string.toString());
        }
    }

    public final float getLineHeight() {
        return this.lineHeight;
    }

    public final int getFirstAscentDiff() {
        return this.firstAscentDiff;
    }

    public final int getLastDescentDiff() {
        return this.lastDescentDiff;
    }

    public void chooseHeight(@NotNull CharSequence text, int start, int end, int spanStartVertical, int lineHeight, @NotNull Paint.FontMetricsInt fontMetricsInt) {
        boolean isLastLine;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)fontMetricsInt, (String)"fontMetricsInt");
        int currentHeight = LineHeightStyleSpanKt.lineHeight(fontMetricsInt);
        if (currentHeight <= 0) {
            return;
        }
        boolean isFirstLine = start == this.startIndex;
        boolean bl = isLastLine = end == this.endIndex;
        if (isFirstLine && isLastLine && this.trimFirstLineTop && this.trimLastLineBottom) {
            return;
        }
        if (isFirstLine) {
            this.calculateTargetMetrics(fontMetricsInt);
        }
        fontMetricsInt.ascent = isFirstLine ? this.firstAscent : this.ascent;
        fontMetricsInt.descent = isLastLine ? this.lastDescent : this.descent;
    }

    private final void calculateTargetMetrics(Paint.FontMetricsInt fontMetricsInt) {
        int currentHeight = LineHeightStyleSpanKt.lineHeight(fontMetricsInt);
        int ceiledLineHeight = (int)Math.ceil(this.lineHeight);
        int diff = ceiledLineHeight - currentHeight;
        int ascentRatio = this.topPercentage == -1 ? (int)(Math.abs((float)fontMetricsInt.ascent) / (float)LineHeightStyleSpanKt.lineHeight(fontMetricsInt) * 100.0f) : this.topPercentage;
        int descentDiff = diff <= 0 ? (int)Math.ceil((float)(diff * ascentRatio) / 100.0f) : (int)Math.ceil((float)(diff * (100 - ascentRatio)) / 100.0f);
        this.descent = fontMetricsInt.descent + descentDiff;
        this.ascent = this.descent - ceiledLineHeight;
        this.firstAscent = this.trimFirstLineTop ? fontMetricsInt.ascent : this.ascent;
        this.lastDescent = this.trimLastLineBottom ? fontMetricsInt.descent : this.descent;
        this.firstAscentDiff = fontMetricsInt.ascent - this.firstAscent;
        this.lastDescentDiff = this.lastDescent - fontMetricsInt.descent;
    }
}

