/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text.platform;

import android.content.Context;
import android.graphics.Typeface;
import android.os.Build;
import android.util.TypedValue;
import androidx.collection.LruCache;
import androidx.compose.ui.text.font.AndroidAssetFont;
import androidx.compose.ui.text.font.AndroidFileDescriptorFont;
import androidx.compose.ui.text.font.AndroidFileFont;
import androidx.compose.ui.text.font.AndroidFont;
import androidx.compose.ui.text.font.Font;
import androidx.compose.ui.text.font.ResourceFont;
import androidx.compose.ui.text.platform.AndroidResourceFontLoaderHelper;
import androidx.core.content.res.ResourcesCompat;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0007\u001a\u0004\u0018\u00010\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0016\u0010\f\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bR\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Landroidx/compose/ui/text/platform/AndroidTypefaceCache;", "", "()V", "cache", "Landroidx/collection/LruCache;", "", "Landroid/graphics/Typeface;", "getKey", "context", "Landroid/content/Context;", "font", "Landroidx/compose/ui/text/font/Font;", "getOrCreate", "ui-text_release"})
public final class AndroidTypefaceCache {
    @NotNull
    public static final AndroidTypefaceCache INSTANCE = new AndroidTypefaceCache();
    @NotNull
    private static final LruCache<String, Typeface> cache = new LruCache(16);

    private AndroidTypefaceCache() {
    }

    @NotNull
    public final Typeface getOrCreate(@NotNull Context context, @NotNull Font font) {
        Typeface typeface;
        String key;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)font, (String)"font");
        String string = key = this.getKey(context, font);
        if (string != null) {
            String it = string;
            boolean bl = false;
            Typeface typeface2 = (Typeface)cache.get((Object)key);
            if (typeface2 != null) {
                Typeface it2 = typeface2;
                boolean bl2 = false;
                return it2;
            }
        }
        Font font2 = font;
        if (font2 instanceof ResourceFont) {
            if (Build.VERSION.SDK_INT >= 26) {
                typeface = AndroidResourceFontLoaderHelper.INSTANCE.create(context, ((ResourceFont)font).getResId());
            } else {
                Typeface typeface3 = ResourcesCompat.getFont((Context)context, (int)((ResourceFont)font).getResId());
                Intrinsics.checkNotNull((Object)typeface3);
                Typeface typeface4 = typeface3;
                Intrinsics.checkNotNullExpressionValue((Object)typeface4, (String)"{\n                    Re\u2026esId)!!\n                }");
                typeface = typeface4;
            }
        } else if (font2 instanceof AndroidFont) {
            typeface = ((AndroidFont)font).getTypeface();
        } else {
            throw new IllegalArgumentException(Intrinsics.stringPlus((String)"Unknown font type: ", (Object)font));
        }
        Typeface typeface5 = typeface;
        String string2 = key;
        if (string2 != null) {
            String it = string2;
            boolean bl = false;
            Typeface cfr_ignored_1 = (Typeface)cache.put((Object)key, (Object)typeface5);
        }
        return typeface5;
    }

    @Nullable
    public final String getKey(@NotNull Context context, @NotNull Font font) {
        String string;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)font, (String)"font");
        Font font2 = font;
        if (font2 instanceof ResourceFont) {
            TypedValue value = new TypedValue();
            context.getResources().getValue(((ResourceFont)font).getResId(), value, true);
            CharSequence charSequence = value.string;
            String string2 = charSequence == null ? null : ((Object)charSequence).toString();
            Intrinsics.checkNotNull((Object)string2);
            string = Intrinsics.stringPlus((String)"res:", (Object)string2);
        } else if (font2 instanceof AndroidAssetFont) {
            string = Intrinsics.stringPlus((String)"asset:", (Object)((AndroidAssetFont)font).getPath());
        } else if (font2 instanceof AndroidFileFont) {
            string = null;
        } else if (font2 instanceof AndroidFileDescriptorFont) {
            string = null;
        } else {
            throw new IllegalArgumentException(Intrinsics.stringPlus((String)"Unknown font type: ", (Object)font));
        }
        return string;
    }
}

